/*
 * Decompiled with CFR 0.152.
 */
package jalview.math;

import jalview.math.SameLengthException;
import jalview.util.Format;

public class MiscMath {
    public static void print(double[] m, String format) {
        System.out.print("[ ");
        for (double a : m) {
            Format.print(System.out, format + " ", a);
        }
        System.out.println("]");
    }

    public static double mean(double[] m) {
        double sum = 0.0;
        int nanCount = 0;
        for (int i = 0; i < m.length; ++i) {
            if (!Double.isNaN(m[i])) {
                sum += m[i];
                continue;
            }
            ++nanCount;
        }
        return sum / (double)(m.length - nanCount);
    }

    public static double sum(double[] m) {
        double sum = 0.0;
        for (int i = 0; i < m.length; ++i) {
            if (Double.isNaN(m[i])) continue;
            sum += m[i];
        }
        return sum;
    }

    public static double[] sqrt(double[] m) {
        double[] sqrts = new double[m.length];
        for (int i = 0; i < m.length; ++i) {
            sqrts[i] = Math.sqrt(m[i]);
        }
        return sqrts;
    }

    public static double[] elementwiseMultiply(byte[] a, double[] b) throws RuntimeException {
        if (a.length != b.length) {
            throw new SameLengthException(a.length, b.length);
        }
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = (double)a[i] * b[i];
        }
        return result;
    }

    public static double[] elementwiseMultiply(double[] a, double[] b) throws RuntimeException {
        if (a.length != b.length) {
            throw new SameLengthException(a.length, b.length);
        }
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * b[i];
        }
        return result;
    }

    public static byte[] elementwiseMultiply(byte[] a, byte[] b) throws RuntimeException {
        if (a.length != b.length) {
            throw new SameLengthException(a.length, b.length);
        }
        byte[] result = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = (byte)(a[i] * b[i]);
        }
        return result;
    }

    public static double[] elementwiseMultiply(double[] a, double b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * b;
        }
        return result;
    }

    public static double[] elementwiseDivide(double[] a, double[] b) throws RuntimeException {
        if (a.length != b.length) {
            throw new SameLengthException(a.length, b.length);
        }
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] / b[i];
        }
        return result;
    }

    public static double[] elementwiseAdd(double[] a, double[] b) throws RuntimeException {
        if (a.length != b.length) {
            throw new SameLengthException(a.length, b.length);
        }
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            result[n] = result[n] + (a[i] + b[i]);
        }
        return result;
    }

    public static double[] elementwiseAdd(double[] a, double b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b;
        }
        return result;
    }

    public static boolean allClose(double[] a, double[] b, double rtol, double atol, boolean equalNAN) {
        boolean areEqual = true;
        for (int i = 0; i < a.length; ++i) {
            if (equalNAN && Double.isNaN(a[i]) && Double.isNaN(b[i]) || !(Math.abs(a[i] - b[i]) > atol + rtol * Math.abs(b[i]))) continue;
            areEqual = false;
            break;
        }
        return areEqual;
    }

    public static int[] findMax(int[] a) {
        int max = 0;
        int maxIndex = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
            maxIndex = i;
        }
        return new int[]{maxIndex, max};
    }

    public static double dot(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException(String.format("Vectors do not have the same length (%d, %d)!", a.length, b.length));
        }
        double aibi = 0.0;
        for (int i = 0; i < a.length; ++i) {
            aibi += a[i] * b[i];
        }
        return aibi;
    }

    public static double norm(double[] v) {
        double result = 0.0;
        for (double i : v) {
            result += Math.pow(i, 2.0);
        }
        return Math.sqrt(result);
    }

    public static int countNaN(double[] v) {
        int cnt = 0;
        for (double i : v) {
            if (!Double.isNaN(i)) continue;
            ++cnt;
        }
        return cnt;
    }

    public static long permutations(int n, int r) {
        if (n < r) {
            return MiscMath.permutations(r, n);
        }
        long result = 1L;
        for (int i = 0; i < r; ++i) {
            result *= (long)(n - i);
        }
        return result;
    }

    public static int combinations(int n, int r) {
        int result = 1;
        for (int i = 0; i < r; ++i) {
            result *= n - 1;
        }
        return result / MiscMath.factorial(r);
    }

    public static int factorial(int n) {
        int result = 1;
        for (int i = 0; i < n; ++i) {
            result *= n - i;
        }
        return result;
    }
}

