/*
 * Decompiled with CFR 0.152.
 */
package jalview.log;

import jalview.bin.Console;
import jalview.log.JLoggerI;
import jalview.util.Platform;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class JLogger
implements JLoggerI {
    protected String name;
    protected JLoggerI.LogLevel level;
    private Object logger = null;
    private static Map<String, JLogger> registry = new HashMap<String, JLogger>();

    protected abstract void loggerSetup();

    public abstract boolean loggerExists();

    protected abstract void loggerSetLevel(JLoggerI.LogLevel var1);

    protected abstract void loggerLogMessage(JLoggerI.LogLevel var1, String var2, Throwable var3);

    public static boolean isLevel(String levelString) {
        for (JLoggerI.LogLevel l : EnumSet.allOf(JLoggerI.LogLevel.class)) {
            if (!l.name().equals(levelString)) continue;
            return true;
        }
        return false;
    }

    public static JLoggerI.LogLevel toLevel(String levelString) {
        try {
            return JLoggerI.LogLevel.valueOf(levelString);
        }
        catch (IllegalArgumentException e) {
            Console.error("Could not parse LogLevel '" + levelString + "'", e);
            return JLoggerI.LogLevel.INFO;
        }
    }

    public static JLogger getLogger(Class c) {
        return JLogger.getLogger(c, JLoggerI.LogLevel.INFO);
    }

    public static JLogger getLogger(Class c, JLoggerI.LogLevel loglevel) {
        return JLogger.getLogger(c.getCanonicalName(), loglevel);
    }

    public static JLogger getLogger(String name) {
        return JLogger.getLogger(name, JLoggerI.LogLevel.INFO);
    }

    public static JLogger getLogger(String name, JLoggerI.LogLevel loglevel) {
        return registry.containsKey(name) ? registry.get(name) : null;
    }

    protected JLogger() {
    }

    protected JLogger(String name, JLoggerI.LogLevel level) {
        this.name = name;
        this.level = level;
        this.loggerSetup();
        this.registryStore();
    }

    protected void registryStore() {
        registry.put(this.name, this);
    }

    protected static boolean registryContainsKey(String name) {
        return registry.containsKey(name);
    }

    protected static JLogger registryGet(String name) {
        return registry.get(name);
    }

    @Override
    public JLoggerI.LogLevel getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(JLoggerI.LogLevel level) {
        this.level = level;
        if (this.loggerExists()) {
            this.loggerSetLevel(level);
        }
    }

    private boolean println(JLoggerI.LogLevel loglevel, String message, Throwable t) {
        if (loglevel.compareTo(this.level) < 0) {
            return false;
        }
        if (!this.loggerExists() || Platform.isJS()) {
            String logLine = String.format("%s: %s", loglevel.toString(), message);
            Console.outPrintln(logLine);
            if (t != null) {
                if (loglevel.compareTo(JLoggerI.LogLevel.DEBUG) <= 0) {
                    t.printStackTrace(System.err);
                } else {
                    Console.errPrintln(t.getMessage());
                }
            }
            return false;
        }
        this.loggerLogMessage(loglevel, message, t);
        return true;
    }

    @Override
    public void trace(String message) {
        this.trace(message, null);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.println(JLoggerI.LogLevel.TRACE, message, t);
    }

    @Override
    public void debug(String message) {
        this.debug(message, null);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.println(JLoggerI.LogLevel.DEBUG, message, t);
    }

    @Override
    public void info(String message) {
        this.info(message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.println(JLoggerI.LogLevel.INFO, message, t);
    }

    @Override
    public void warn(String message) {
        this.warn(message, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.println(JLoggerI.LogLevel.WARN, message, t);
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.println(JLoggerI.LogLevel.ERROR, message, t);
    }

    @Override
    public void fatal(String message) {
        this.fatal(message, null);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.println(JLoggerI.LogLevel.FATAL, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.level.compareTo(JLoggerI.LogLevel.DEBUG) <= 0;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.level.compareTo(JLoggerI.LogLevel.TRACE) <= 0;
    }
}

