/*
 * Decompiled with CFR 0.152.
 */
package jalview.javascript.web;

import jalview.javascript.web.ClientResponse;
import jalview.util.Platform;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class WebResource {
    private String endpoint;
    private String params = "";

    public WebResource(String endpoint) {
        this.endpoint = endpoint;
    }

    public WebResource queryParam(String key, String value) {
        this.params = this.params + (this.params == "" ? "?" : "&") + key + "=" + Platform.encodeURI(value);
        return this;
    }

    public URI getURI() {
        try {
            return new URI(this.endpoint + this.params);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Builder accept(String ... encoding) {
        return new Builder(this.getURI(), encoding);
    }

    public static class Builder {
        private URI uri;
        private String[] encoding;

        public Builder(URI uri, String ... encoding) {
            this.uri = uri;
            this.encoding = encoding;
        }

        public ClientResponse get(Class<?> c) {
            try {
                return new ClientResponse(new URL(this.uri.toString()), this.encoding);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
    }
}

