/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.gff;

import jalview.bin.Console;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.MappingType;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.gff.Gff2Helper;
import jalview.util.MapList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ExonerateHelper
extends Gff2Helper {
    private static final String SIMILARITY = "similarity";
    private static final String GENOME2GENOME = "genome2genome";
    private static final String CDNA2GENOME = "cdna2genome";
    private static final String CODING2GENOME = "coding2genome";
    private static final String CODING2CODING = "coding2coding";
    private static final String PROTEIN2GENOME = "protein2genome";
    private static final String PROTEIN2DNA = "protein2dna";
    private static final String ALIGN = "Align";
    private static final String QUERY = "Query";
    private static final String TARGET = "Target";

    @Override
    public SequenceFeature processGff(SequenceI seq, String[] gffColumns, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) {
        String attr = gffColumns[8];
        Map<String, List<String>> set = ExonerateHelper.parseNameValuePairs(attr);
        try {
            this.processGffSimilarity(set, seq, gffColumns, align, newseqs, relaxedIdMatching);
        }
        catch (IOException ivfe) {
            Console.errPrintln(ivfe);
        }
        return null;
    }

    protected void processGffSimilarity(Map<String, List<String>> set, SequenceI seq, String[] gff, AlignmentI align, List<SequenceI> newseqs, boolean relaxedIdMatching) throws IOException {
        MappingType type;
        boolean featureIsOnTarget = true;
        List<String> mapTo = set.get(QUERY);
        if (mapTo == null) {
            mapTo = set.get(TARGET);
            featureIsOnTarget = false;
        }
        if ((type = ExonerateHelper.getMappingType(gff[1])) == null) {
            throw new IOException("Sorry, I don't handle " + gff[1]);
        }
        if (mapTo == null || mapTo.size() != 1) {
            throw new IOException("Expecting exactly one sequence in Query or Target field (got " + mapTo + ")");
        }
        SequenceI mappedSequence = this.findSequence(mapTo.get(0), align, newseqs, relaxedIdMatching);
        SequenceI mapFromSequence = seq;
        SequenceI mapToSequence = mappedSequence;
        if (type == MappingType.NucleotideToPeptide && featureIsOnTarget || type == MappingType.PeptideToNucleotide && !featureIsOnTarget) {
            mapFromSequence = mappedSequence;
            mapToSequence = seq;
        }
        AlignedCodonFrame acf = this.getMapping(align, mapFromSequence, mapToSequence);
        String strand = gff[6];
        boolean forwardStrand = true;
        if ("-".equals(strand)) {
            forwardStrand = false;
        } else if (!"+".equals(strand)) {
            Console.errPrintln("Strand must be specified for alignment");
            return;
        }
        List<String> alignedRegions = set.get(ALIGN);
        for (String region : alignedRegions) {
            MapList mapping = this.buildMapping(region, type, forwardStrand, featureIsOnTarget, gff);
            if (mapping == null) continue;
            acf.addMap(mapFromSequence, mapToSequence, mapping);
        }
        align.addCodonFrame(acf);
    }

    protected MapList buildMapping(String region, MappingType type, boolean forwardStrand, boolean featureIsOnTarget, String[] gff) {
        int fromEnd;
        int toEnd;
        int toStart;
        int fromStart;
        int alignCount;
        int alignToStart;
        int alignFromStart;
        String[] tokens = region.split(" ");
        if (tokens.length != 3) {
            Console.errPrintln("Malformed Align descriptor: " + region);
            return null;
        }
        try {
            alignFromStart = Integer.parseInt(tokens[0]);
            alignToStart = Integer.parseInt(tokens[1]);
            alignCount = Integer.parseInt(tokens[2]);
        }
        catch (NumberFormatException nfe) {
            Console.errPrintln(nfe.toString());
            return null;
        }
        if (featureIsOnTarget) {
            fromStart = alignToStart;
            toStart = alignFromStart;
            toEnd = forwardStrand ? toStart + alignCount - 1 : toStart - (alignCount - 1);
            int toLength = Math.abs(toEnd - toStart) + 1;
            int fromLength = toLength * type.getFromRatio() / type.getToRatio();
            fromEnd = fromStart + fromLength - 1;
        } else {
            fromStart = alignFromStart;
            fromEnd = alignFromStart + alignCount - 1;
            int fromLength = fromEnd - fromStart + 1;
            int toLength = fromLength * type.getToRatio() / type.getFromRatio();
            toStart = alignToStart;
            toEnd = forwardStrand ? toStart + toLength - 1 : toStart - (toLength - 1);
        }
        MapList codonmapping = this.constructMappingFromAlign(fromStart, fromEnd, toStart, toEnd, type);
        return codonmapping;
    }

    protected static MappingType getMappingType(String model) {
        MappingType result = null;
        if (model.contains(PROTEIN2DNA) || model.contains(PROTEIN2GENOME)) {
            result = MappingType.PeptideToNucleotide;
        } else if (model.contains(CODING2CODING) || model.contains(CODING2GENOME) || model.contains(CDNA2GENOME) || model.contains(GENOME2GENOME)) {
            result = MappingType.NucleotideToNucleotide;
        }
        return result;
    }

    public static boolean recognises(String[] columns) {
        String mdl;
        if (!SIMILARITY.equalsIgnoreCase(columns[2])) {
            return false;
        }
        String model = columns[1];
        if (model != null && ((mdl = model.toLowerCase(Locale.ROOT)).contains(PROTEIN2DNA) || mdl.contains(PROTEIN2GENOME) || mdl.contains(CODING2CODING) || mdl.contains(CODING2GENOME) || mdl.contains(CDNA2GENOME) || mdl.contains(GENOME2GENOME))) {
            return true;
        }
        Console.errPrintln("Sorry, I don't handle exonerate model " + model);
        return false;
    }

    @Override
    protected SequenceFeature buildSequenceFeature(String[] gff, Map<String, List<String>> set) {
        SequenceFeature sf = super.buildSequenceFeature(gff, 2, "exonerate", set);
        return sf;
    }
}

