/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import java.io.IOException;

public class FastaFile
extends AlignFile {
    int len = 72;
    StringBuffer out;

    public FastaFile() {
    }

    public FastaFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public FastaFile(FileParse source) throws IOException {
        this(source, true);
    }

    public FastaFile(FileParse source, boolean closeData) throws IOException {
        super(true, source, closeData);
    }

    public FastaFile(SequenceI[] seqs) {
        super(seqs);
    }

    @Override
    public void parse() throws IOException {
        String uline;
        StringBuffer sb = new StringBuffer();
        boolean firstLine = true;
        Sequence seq = null;
        boolean annotation = false;
        while ((uline = this.nextLine()) != null) {
            String line = uline.trim();
            if (line.length() <= 0) continue;
            if (line.charAt(0) == '>') {
                if (line.startsWith(">#_")) {
                    if (annotation) {
                        this.annotations.addElement(this.makeAnnotation(seq, sb));
                    }
                } else {
                    annotation = false;
                }
                if (!firstLine) {
                    seq.setSequence(sb.toString());
                    if (!annotation) {
                        this.seqs.addElement(seq);
                    }
                }
                seq = this.parseId(line.substring(1));
                firstLine = false;
                sb = new StringBuffer();
                if (!line.startsWith(">#_")) continue;
                annotation = true;
                continue;
            }
            sb.append(annotation ? uline : line);
        }
        if (annotation) {
            this.annotations.addElement(this.makeAnnotation(seq, sb));
        } else if (!firstLine) {
            seq.setSequence(sb.toString());
            this.seqs.addElement(seq);
        }
    }

    private AlignmentAnnotation makeAnnotation(SequenceI seq, StringBuffer sb) {
        Annotation[] anots = new Annotation[sb.length()];
        for (int i = 0; i < anots.length; ++i) {
            char cn = sb.charAt(i);
            if (cn == ' ') continue;
            anots[i] = new Annotation("" + cn, null, ' ', Float.NaN);
        }
        AlignmentAnnotation aa = new AlignmentAnnotation(seq.getName().substring(2), seq.getDescription(), anots);
        return aa;
    }

    public void addAnnotations(Alignment al) {
        this.addProperties(al);
        for (int i = 0; i < this.annotations.size(); ++i) {
            AlignmentAnnotation aa = (AlignmentAnnotation)this.annotations.elementAt(i);
            aa.setPadGaps(true, al.getGapCharacter());
            al.addAnnotation(aa);
        }
    }

    @Override
    public String print(SequenceI[] s, boolean jvsuffix) {
        this.out = new StringBuffer();
        for (int i = 0; i < s.length && s[i] != null; ++i) {
            this.out.append(">" + this.printId(s[i], jvsuffix));
            if (s[i].getDescription() != null) {
                this.out.append(" " + s[i].getDescription());
            }
            this.out.append(this.newline);
            int nochunks = s[i].getLength() / this.len + (s[i].getLength() % this.len > 0 ? 1 : 0);
            for (int j = 0; j < nochunks; ++j) {
                int start = j * this.len;
                int end = start + this.len;
                if (end < s[i].getLength()) {
                    this.out.append(s[i].getSequenceAsString(start, end) + this.newline);
                    continue;
                }
                if (start >= s[i].getLength()) continue;
                this.out.append(s[i].getSequenceAsString(start, s[i].getLength()) + this.newline);
            }
        }
        return this.out.toString();
    }
}

