/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.gui.AlignmentPanel;
import jalview.gui.OOMWarning;
import jalview.io.HTMLOutput;
import jalview.json.binding.biojs.BioJSReleasePojo;
import jalview.json.binding.biojs.BioJSRepositoryPojo;
import jalview.util.HttpUtils;
import jalview.util.MessageManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.TreeMap;

public class BioJsHTMLOutput
extends HTMLOutput {
    private static File currentBJSTemplateFile;
    private static TreeMap<String, File> bioJsMSAVersions;
    public static final String DEFAULT_DIR;
    public static final String BJS_TEMPLATES_LOCAL_DIRECTORY;
    public static final String BJS_TEMPLATE_GIT_REPO;

    public BioJsHTMLOutput(AlignmentPanel ap) {
        super(ap, "BioJS MSA");
    }

    public static void refreshVersionInfo(String dirName) throws URISyntaxException {
        File directory = new File(BJS_TEMPLATES_LOCAL_DIRECTORY);
        Objects.requireNonNull(dirName, "dirName MUST not be null!");
        Objects.requireNonNull(directory, "directory MUST not be null!");
        TreeMap<String, File> versionFileMap = new TreeMap<String, File>();
        for (File file : directory.listFiles()) {
            if (!file.isFile()) continue;
            String fileName = file.getName().substring(0, file.getName().lastIndexOf("."));
            String[] fileMeta = fileName.split("_");
            if (fileMeta.length > 2) {
                BioJsHTMLOutput.setCurrentBJSTemplateFile(file);
                versionFileMap.put(fileMeta[2], file);
                continue;
            }
            if (fileMeta.length <= 1) continue;
            versionFileMap.put(fileMeta[1], file);
        }
        if (BioJsHTMLOutput.getCurrentBJSTemplateFile() == null && versionFileMap.size() > 0) {
            BioJsHTMLOutput.setCurrentBJSTemplateFile(versionFileMap.lastEntry().getValue());
        }
        BioJsHTMLOutput.setBioJsMSAVersions(versionFileMap);
    }

    public static void updateBioJS() {
        Thread updateThread = new Thread(){

            @Override
            public void run() {
                try {
                    String gitRepoPkgJson = BioJsHTMLOutput.getURLContentAsString(BJS_TEMPLATE_GIT_REPO);
                    if (gitRepoPkgJson != null) {
                        BioJSRepositoryPojo release = new BioJSRepositoryPojo(gitRepoPkgJson);
                        BioJsHTMLOutput.syncUpdates(BJS_TEMPLATES_LOCAL_DIRECTORY, release);
                        BioJsHTMLOutput.refreshVersionInfo(BJS_TEMPLATES_LOCAL_DIRECTORY);
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        };
        updateThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncUpdates(String localDir, BioJSRepositoryPojo repo) {
        for (BioJSReleasePojo bjsRelease : repo.getReleases()) {
            File biojsDirectory;
            String releaseUrl = bjsRelease.getUrl();
            String releaseVersion = bjsRelease.getVersion();
            String releaseFile = "BioJsMSA_" + releaseVersion + ".txt";
            if (releaseVersion.equals(repo.getLatestReleaseVersion())) {
                releaseFile = "Latest_BioJsMSA_" + releaseVersion + ".txt";
            }
            if (!(biojsDirectory = new File(BJS_TEMPLATES_LOCAL_DIRECTORY)).exists() && !biojsDirectory.mkdirs()) {
                Console.outPrintln("Couldn't create local directory : " + BJS_TEMPLATES_LOCAL_DIRECTORY);
                return;
            }
            File file = new File(BJS_TEMPLATES_LOCAL_DIRECTORY + releaseFile);
            if (file.exists()) continue;
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(file));
                out.print(BioJsHTMLOutput.getURLContentAsString(releaseUrl));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (out == null) continue;
                out.flush();
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURLContentAsString(String url) throws OutOfMemoryError {
        StringBuilder responseStrBuilder = null;
        InputStream is = null;
        try {
            String lineContent;
            URL resourceUrl = new URL(url);
            is = new BufferedInputStream(HttpUtils.openStream(resourceUrl));
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            responseStrBuilder = new StringBuilder();
            while ((lineContent = br.readLine()) != null) {
                responseStrBuilder.append(lineContent).append("\n");
            }
        }
        catch (OutOfMemoryError er) {
            er.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return responseStrBuilder == null ? null : responseStrBuilder.toString();
    }

    public static File getCurrentBJSTemplateFile() {
        return currentBJSTemplateFile;
    }

    public static void setCurrentBJSTemplateFile(File currentBJSTemplateFile) {
        BioJsHTMLOutput.currentBJSTemplateFile = currentBJSTemplateFile;
    }

    public static TreeMap<String, File> getBioJsMSAVersions() {
        return bioJsMSAVersions;
    }

    public static void setBioJsMSAVersions(TreeMap<String, File> bioJsMSAVersions) {
        BioJsHTMLOutput.bioJsMSAVersions = bioJsMSAVersions;
    }

    @Override
    public boolean isEmbedData() {
        return true;
    }

    @Override
    public boolean isLaunchInBrowserAfterExport() {
        return true;
    }

    @Override
    public void run() {
        try {
            String bioJSON = this.getBioJSONData();
            String bioJSTemplateString = HTMLOutput.readFileAsString(BioJsHTMLOutput.getCurrentBJSTemplateFile());
            String generatedBioJsWithJalviewAlignmentAsJson = bioJSTemplateString.replaceAll("#sequenceData#", bioJSON).toString();
            PrintWriter out = new PrintWriter(new FileWriter(this.generatedFile));
            out.print(generatedBioJsWithJalviewAlignmentAsJson);
            out.flush();
            out.close();
            this.setProgressMessage(MessageManager.formatMessage("status.export_complete", this.getDescription()));
            this.exportCompleted();
        }
        catch (OutOfMemoryError err) {
            Console.outPrintln("########################\nOUT OF MEMORY " + this.generatedFile + "\n########################");
            new OOMWarning("Creating Image for " + this.generatedFile, err);
        }
        catch (Exception e) {
            this.setProgressMessage(MessageManager.formatMessage("info.error_creating_file", this.getDescription()));
            e.printStackTrace();
        }
    }

    @Override
    public void run(String s) {
        this.run();
    }

    static {
        DEFAULT_DIR = System.getProperty("user.home") + File.separatorChar + ".biojs_templates" + File.separatorChar;
        BJS_TEMPLATES_LOCAL_DIRECTORY = Cache.getDefault("biojs_template_directory", DEFAULT_DIR);
        BJS_TEMPLATE_GIT_REPO = Cache.getDefault("biojs_template_git_repo", "https://raw.githubusercontent.com/jalview/exporter-templates/master/biojs/package.json");
    }
}

