/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class AlignmentProperties {
    AlignmentI alignment;

    public AlignmentProperties(AlignmentI alignment) {
        this.alignment = alignment;
    }

    public void writeProperties(PrintWriter pw, boolean html) {
        String nl = html ? "<br>" : System.getProperty("line.separator");
        float avg = 0.0f;
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int i = 0; i < this.alignment.getHeight(); ++i) {
            int size = 1 + this.alignment.getSequenceAt(i).getEnd() - this.alignment.getSequenceAt(i).getStart();
            avg += (float)size;
            if (size > max) {
                max = size;
            }
            if (size >= min) continue;
            min = size;
        }
        avg /= (float)this.alignment.getHeight();
        pw.print(nl);
        pw.print("Sequences: " + this.alignment.getHeight());
        pw.print(nl);
        pw.print("Minimum Sequence Length: " + min);
        pw.print(nl);
        pw.print("Maximum Sequence Length: " + max);
        pw.print(nl);
        pw.print("Average Length: " + (int)avg);
        if (((Alignment)this.alignment).alignmentProperties != null) {
            pw.print(nl);
            pw.print(nl);
            if (html) {
                pw.print("<table border=\"1\">");
            }
            Hashtable props = ((Alignment)this.alignment).alignmentProperties;
            Enumeration en = props.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement().toString();
                String vals = props.get(key).toString();
                if (html) {
                    int npos;
                    StringBuffer val = new StringBuffer();
                    int pos = 0;
                    do {
                        if ((npos = vals.indexOf("\n", pos)) == -1) {
                            val.append(vals.substring(pos));
                        } else {
                            val.append(vals.substring(pos, npos));
                            val.append("<br>");
                        }
                        pos = npos + 1;
                    } while (npos != -1);
                    pw.print("<tr><td>" + key + "</td><td>" + val + "</td></tr>");
                    continue;
                }
                pw.print(nl + key + "\t" + vals);
            }
            if (html) {
                pw.print("</table>");
            }
        }
    }

    public StringBuffer formatAsString() {
        return this.formatReport(false);
    }

    protected StringBuffer formatReport(boolean html) {
        StringWriter content = new StringWriter();
        this.writeProperties(new PrintWriter(content), html);
        return content.getBuffer();
    }

    public StringBuffer formatAsHtml() {
        return this.formatReport(true);
    }
}

