/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.RotatableCanvasI;
import jalview.datamodel.Point;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequencePoint;
import jalview.gui.AlignmentPanel;
import jalview.gui.PaintRefresher;
import jalview.math.RotatableMatrix;
import jalview.util.ColorUtils;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class RotatableCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener,
RotatableCanvasI,
MouseWheelListener {
    private static final float ZOOM_OUT = 0.9f;
    private static final float ZOOM_IN = 1.1f;
    private static final int NEARBY = 3;
    private static final List<String> AXES = Arrays.asList("x", "y", "z");
    private static final Color AXIS_COLOUR = Color.yellow;
    private static final int DIMS = 3;
    boolean drawAxes = true;
    int mouseX;
    int mouseY;
    Image img;
    Graphics ig;
    Dimension prefSize;
    float[] seqMin;
    float[] seqMax;
    private float scaleFactor;
    int npoint;
    List<SequencePoint> sequencePoints;
    private Point[] axisEndPoints;
    int rectx1;
    int recty1;
    int rectx2;
    int recty2;
    AlignmentViewport av;
    AlignmentPanel ap;
    private boolean showLabels;
    private Color bgColour;
    private boolean applyToAllViews;

    public RotatableCanvas(AlignmentPanel panel) {
        this.av = panel.av;
        this.ap = panel;
        this.setAxisEndPoints(new Point[3]);
        this.setShowLabels(false);
        this.setApplyToAllViews(false);
        this.setBgColour(Color.BLACK);
        this.resetAxes();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public void showLabels(boolean show) {
        this.setShowLabels(show);
        this.repaint();
    }

    @Override
    public void setPoints(List<SequencePoint> points, int np) {
        this.sequencePoints = points;
        this.npoint = np;
        this.prefSize = this.getPreferredSize();
        this.findWidths();
        this.setScaleFactor(1.0f);
    }

    protected void resetAxes() {
        this.getAxisEndPoints()[0] = new Point(1.0f, 0.0f, 0.0f);
        this.getAxisEndPoints()[1] = new Point(0.0f, 1.0f, 0.0f);
        this.getAxisEndPoints()[2] = new Point(0.0f, 0.0f, 1.0f);
    }

    protected void findWidths() {
        float[] max = new float[3];
        float[] min = new float[3];
        max[0] = -3.4028235E38f;
        max[1] = -3.4028235E38f;
        max[2] = -3.4028235E38f;
        min[0] = Float.MAX_VALUE;
        min[1] = Float.MAX_VALUE;
        min[2] = Float.MAX_VALUE;
        for (SequencePoint sp : this.sequencePoints) {
            max[0] = Math.max(max[0], sp.coord.x);
            max[1] = Math.max(max[1], sp.coord.y);
            max[2] = Math.max(max[2], sp.coord.z);
            min[0] = Math.min(min[0], sp.coord.x);
            min[1] = Math.min(min[1], sp.coord.y);
            min[2] = Math.min(min[2], sp.coord.z);
        }
        this.seqMin = min;
        this.seqMax = max;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize != null) {
            return this.prefSize;
        }
        return new Dimension(400, 400);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.sequencePoints == null) {
            g.setFont(new Font("Verdana", 0, 18));
            g.drawString(MessageManager.getString("label.calculating_pca") + "....", 20, this.getHeight() / 2);
        } else {
            boolean resized;
            boolean bl = resized = this.prefSize.width != this.getWidth() || this.prefSize.height != this.getHeight();
            if (this.img == null || resized) {
                this.prefSize.width = this.getWidth();
                this.prefSize.height = this.getHeight();
                this.img = this.createImage(this.getWidth(), this.getHeight());
                this.ig = this.img.getGraphics();
            }
            this.drawBackground(this.ig);
            this.drawScene(this.ig);
            if (this.drawAxes) {
                this.drawAxes(this.ig);
            }
            g.drawImage(this.img, 0, 0, this);
        }
    }

    public void resetView() {
        this.img = null;
        this.findWidths();
        this.resetAxes();
        this.repaint();
    }

    public void drawAxes(Graphics g) {
        g.setColor(AXIS_COLOUR);
        int midX = this.getWidth() / 2;
        int midY = this.getHeight() / 2;
        int pix = Math.min(this.getWidth(), this.getHeight());
        float scaleBy = (float)pix * this.getScaleFactor() / 2.0f;
        for (int i = 0; i < 3; ++i) {
            g.drawLine(midX, midY, midX + (int)((double)(this.getAxisEndPoints()[i].x * scaleBy) * 0.25), midY + (int)((double)(this.getAxisEndPoints()[i].y * scaleBy) * 0.25));
        }
    }

    public void drawBackground(Graphics g) {
        g.setColor(this.getBgColour());
        g.fillRect(0, 0, this.prefSize.width, this.prefSize.height);
    }

    public void drawScene(Graphics g1) {
        Graphics2D g = (Graphics2D)g1;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int pix = Math.min(this.getWidth(), this.getHeight());
        float xWidth = Math.abs(this.seqMax[0] - this.seqMin[0]);
        float yWidth = Math.abs(this.seqMax[1] - this.seqMin[1]);
        float maxWidth = Math.max(xWidth, yWidth);
        float scaleBy = (float)pix * this.getScaleFactor() / (2.0f * maxWidth);
        float[] centre = this.getCentre();
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.sequencePoints.get(i);
            Color sequenceColour = this.getSequencePointColour(sp);
            g.setColor(sequenceColour);
            int halfwidth = this.getWidth() / 2;
            int halfheight = this.getHeight() / 2;
            int x = (int)((sp.coord.x - centre[0]) * scaleBy) + halfwidth;
            int y = (int)((sp.coord.y - centre[1]) * scaleBy) + halfheight;
            g.fillRect(x - 3, y - 3, 6, 6);
            if (!this.isShowLabels()) continue;
            g.setColor(Color.red);
            g.drawString(sp.getSequence().getName(), x - 3, y - 4);
        }
        if (this.isShowLabels()) {
            g.setColor(AXIS_COLOUR);
            int midX = this.getWidth() / 2;
            int midY = this.getHeight() / 2;
            Iterator<String> axes = AXES.iterator();
            for (Point p : this.getAxisEndPoints()) {
                int x = midX + (int)(p.x * scaleBy * this.seqMax[0]);
                int y = midY + (int)(p.y * scaleBy * this.seqMax[1]);
                g.drawString(axes.next(), x - 3, y - 4);
            }
        }
        if (this.rectx2 != -1 && this.recty2 != -1) {
            g.setColor(Color.white);
            g.drawRect(this.rectx1, this.recty1, this.rectx2 - this.rectx1, this.recty2 - this.recty1);
        }
    }

    protected Color getSequencePointColour(SequencePoint sp) {
        float zCentre;
        SequenceI sequence = sp.getSequence();
        Color sequenceColour = this.av.getSequenceColour(sequence);
        if (sequenceColour == Color.black) {
            sequenceColour = Color.white;
        }
        if (this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSequences(null).contains(sequence)) {
            sequenceColour = Color.gray;
        }
        if (sp.coord.z > (zCentre = (this.seqMin[2] + this.seqMax[2]) / 2.0f)) {
            sequenceColour = ColorUtils.getGraduatedColour(sp.coord.z, 0.0f, sequenceColour, this.seqMax[2], sequenceColour.brighter());
        } else if (sp.coord.z < zCentre) {
            sequenceColour = ColorUtils.getGraduatedColour(sp.coord.z, this.seqMin[2], sequenceColour.darker(), 0.0f, sequenceColour);
        }
        return sequenceColour;
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        int keyCode = evt.getKeyCode();
        boolean shiftDown = evt.isShiftDown();
        if (keyCode == 38) {
            if (shiftDown) {
                this.rotate(0.0f, -1.0f);
            } else {
                this.zoom(1.1f);
            }
        } else if (keyCode == 40) {
            if (shiftDown) {
                this.rotate(0.0f, 1.0f);
            } else {
                this.zoom(0.9f);
            }
        } else if (shiftDown && keyCode == 37) {
            this.rotate(1.0f, 0.0f);
        } else if (shiftDown && keyCode == 39) {
            this.rotate(-1.0f, 0.0f);
        }
        this.repaint();
    }

    @Override
    public void zoom(float factor) {
        if (factor > 0.0f) {
            this.setScaleFactor(this.getScaleFactor() * factor);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        this.mouseX = x;
        this.mouseY = y;
        this.rectx1 = x;
        this.recty1 = y;
        this.rectx2 = -1;
        this.recty2 = -1;
        SequenceI found = this.findSequenceAtPoint(x, y);
        if (found != null) {
            AlignmentPanel[] aps = this.getAssociatedPanels();
            for (int a = 0; a < aps.length; ++a) {
                if (aps[a].av.getSelectionGroup() != null) {
                    aps[a].av.getSelectionGroup().addOrRemove(found, true);
                    continue;
                }
                aps[a].av.setSelectionGroup(new SequenceGroup());
                aps[a].av.getSelectionGroup().addOrRemove(found, true);
                aps[a].av.getSelectionGroup().setEndRes(aps[a].av.getAlignment().getWidth() - 1);
            }
            PaintRefresher.Refresh(this, this.av.getSequenceSetId());
            this.av.sendSelection();
        }
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        SequenceI found = this.findSequenceAtPoint(evt.getX(), evt.getY());
        this.setToolTipText(found == null ? null : found.getName());
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int xPos = evt.getX();
        int yPos = evt.getY();
        if (xPos == this.mouseX && yPos == this.mouseY) {
            return;
        }
        int xDelta = xPos - this.mouseX;
        int yDelta = yPos - this.mouseY;
        if ((evt.getModifiersEx() & 0x1000) != 0) {
            this.rectx2 = evt.getX();
            this.recty2 = evt.getY();
            if (this.rectx2 != -1 && this.recty2 != -1) {
                this.rectSelect(this.rectx1, this.recty1, this.rectx2, this.recty2);
            }
        } else {
            this.rotate(xDelta, yDelta);
            this.mouseX = xPos;
            this.mouseY = yPos;
        }
        this.repaint();
    }

    @Override
    public void rotate(float x, float y) {
        int i;
        if (x == 0.0f && y == 0.0f) {
            return;
        }
        RotatableMatrix rotmat = new RotatableMatrix();
        if (y != 0.0f) {
            rotmat.rotate(y, RotatableMatrix.Axis.X);
        }
        if (x != 0.0f) {
            rotmat.rotate(x, RotatableMatrix.Axis.Y);
        }
        float[] centre = this.getCentre();
        float zMin = Float.MAX_VALUE;
        float zMax = -3.4028235E38f;
        for (i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.sequencePoints.get(i);
            sp.translate(-centre[0], -centre[1], -centre[2]);
            sp.coord = rotmat.vectorMultiply(sp.coord);
            sp.translate(centre[0], centre[1], centre[2]);
            zMin = Math.min(zMin, sp.coord.z);
            zMax = Math.max(zMax, sp.coord.z);
        }
        this.seqMin[2] = zMin;
        this.seqMax[2] = zMax;
        for (i = 0; i < 3; ++i) {
            this.getAxisEndPoints()[i] = rotmat.vectorMultiply(this.getAxisEndPoints()[i]);
        }
    }

    private float[] getCentre() {
        float xCentre = (this.seqMin[0] + this.seqMax[0]) / 2.0f;
        float yCentre = (this.seqMin[1] + this.seqMax[1]) / 2.0f;
        float zCentre = (this.seqMin[2] + this.seqMax[2]) / 2.0f;
        return new float[]{xCentre, yCentre, zCentre};
    }

    protected void rectSelect(int x1, int y1, int x2, int y2) {
        float[] centre = this.getCentre();
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.sequencePoints.get(i);
            int tmp1 = (int)((double)((sp.coord.x - centre[0]) * this.getScaleFactor()) * ((double)this.getWidth() / 3.15) + (double)this.getWidth() / 2.0);
            float pre1 = (sp.coord.x - centre[0]) * this.getScaleFactor();
            int tmp2 = (int)((double)((sp.coord.y - centre[1]) * this.getScaleFactor()) * ((double)this.getHeight() / 1.7) + (double)this.getHeight() / 2.0);
            float pre2 = (sp.coord.y - centre[1]) * this.getScaleFactor();
            if (tmp1 <= x1 || tmp1 >= x2 || tmp2 <= y1 || tmp2 >= y2 || this.av == null) continue;
            SequenceI sequence = sp.getSequence();
            if (this.av.getSelectionGroup() == null) {
                SequenceGroup sg = new SequenceGroup();
                sg.setEndRes(this.av.getAlignment().getWidth() - 1);
                this.av.setSelectionGroup(sg);
            }
            if (this.av.getSelectionGroup().getSequences(null).contains(sequence)) continue;
            this.av.getSelectionGroup().addSequence(sequence, true);
        }
    }

    protected SequenceI findSequenceAtPoint(int x, int y) {
        int halfwidth = this.getWidth() / 2;
        int halfheight = this.getHeight() / 2;
        int found = -1;
        int pix = Math.min(this.getWidth(), this.getHeight());
        float xWidth = Math.abs(this.seqMax[0] - this.seqMin[0]);
        float yWidth = Math.abs(this.seqMax[1] - this.seqMin[1]);
        float maxWidth = Math.max(xWidth, yWidth);
        float scaleBy = (float)pix * this.getScaleFactor() / (2.0f * maxWidth);
        float[] centre = this.getCentre();
        for (int i = 0; i < this.npoint; ++i) {
            SequencePoint sp = this.sequencePoints.get(i);
            int px = (int)((sp.coord.x - centre[0]) * scaleBy) + halfwidth;
            int py = (int)((sp.coord.y - centre[1]) * scaleBy) + halfheight;
            if (Math.abs(px - x) >= 3 || Math.abs(py - y) >= 3) continue;
            found = i;
            break;
        }
        if (found != -1) {
            return this.sequencePoints.get(found).getSequence();
        }
        return null;
    }

    AlignmentPanel[] getAssociatedPanels() {
        if (this.isApplyToAllViews()) {
            return PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        }
        return new AlignmentPanel[]{this.ap};
    }

    public Color getBackgroundColour() {
        return this.getBgColour();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        double wheelRotation = e.getPreciseWheelRotation();
        if (wheelRotation > 0.0) {
            this.zoom(1.1f);
            this.repaint();
        } else if (wheelRotation < 0.0) {
            this.zoom(0.9f);
            this.repaint();
        }
    }

    public float[] getSeqMin() {
        return this.seqMin;
    }

    public float[] getSeqMax() {
        return this.seqMax;
    }

    public void setSeqMinMax(float[] min, float[] max) {
        this.seqMin = min;
        this.seqMax = max;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    public boolean isApplyToAllViews() {
        return this.applyToAllViews;
    }

    public void setApplyToAllViews(boolean applyToAllViews) {
        this.applyToAllViews = applyToAllViews;
    }

    public Point[] getAxisEndPoints() {
        return this.axisEndPoints;
    }

    public void setAxisEndPoints(Point[] axisEndPoints) {
        this.axisEndPoints = axisEndPoints;
    }

    public Color getBgColour() {
        return this.bgColour;
    }

    public void setBgColour(Color bgColour) {
        this.bgColour = bgColour;
    }
}

