/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignSeq;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.jbgui.GPairwiseAlignPanel;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.event.ActionEvent;
import java.util.Vector;

public class PairwiseAlignPanel
extends GPairwiseAlignPanel {
    private static final String DASHES = "---------------------\n";
    private float[][] scores;
    private float[][] alignmentScores;
    private int GAP_OPEN_COST;
    private int GAP_EXTEND_COST;
    AlignmentViewport av;
    Vector<SequenceI> sequences;
    private String alignmentOutput;
    private boolean quiet;
    private boolean discardAlignments;
    private boolean endGaps;
    public static final String TOTAL = "total";
    public static final String PROGRESS = "progress";
    protected static final String ETA = "eta_in_minutes";
    public static final String PROGRESSCOMPLETE = "finished_stop_progress";
    public static final String PROGRESSMESSAGE = "message_in_progress";
    private volatile boolean cancelled;
    private long total;
    private long progress;
    private SequenceGroup selection;
    private SequenceI[] seqs = null;
    private ScoreMatrix scoreMatrix;
    private double etime = Double.NaN;

    public PairwiseAlignPanel(AlignmentViewport viewport) {
        this(viewport, null, false, 120, 20, true, null);
    }

    public PairwiseAlignPanel(AlignmentViewport viewport, ScoreMatrix params) {
        this(viewport, null, false, 120, 20, true, params);
    }

    public PairwiseAlignPanel(AlignmentViewport viewport, boolean endGaps, int gapOpenCost, int gapExtendCost) {
        this(viewport, null, endGaps, gapOpenCost, gapExtendCost, true, null);
    }

    public PairwiseAlignPanel(AlignmentViewport viewport, SequenceGroup selection, boolean endGaps, int gapOpenCost, int gapExtendCost, boolean run, ScoreMatrix scoreMatrix) {
        this.av = viewport;
        this.GAP_OPEN_COST = gapOpenCost;
        this.GAP_EXTEND_COST = gapExtendCost;
        this.endGaps = endGaps;
        this.selection = selection;
        this.total = this.av.getAlignment().getHeight();
        this.total = (this.total * this.total - this.total) / 2L;
        this.scoreMatrix = scoreMatrix;
        if (run) {
            this.calculate();
        }
    }

    public void calculate() {
        this.calculate(this.scoreMatrix);
    }

    public void calculate(ScoreMatrix sm) {
        String[] seqStrings;
        this.cancelled = false;
        StringBuilder sb = new StringBuilder(1024);
        this.sequences = new Vector();
        this.seqs = null;
        if (this.selection != null) {
            this.seqs = this.selection.getSelectionAsNewSequences(this.av.getAlignment());
            seqStrings = new String[this.seqs.length];
            int s = 0;
            for (SequenceI seq : this.seqs) {
                seqStrings[s++] = seq.getSequenceAsString();
            }
        } else {
            SequenceGroup selectionGroup = this.av.getSelectionGroup();
            boolean isSelection = selectionGroup != null && selectionGroup.getSize() > 0;
            AlignmentView view = this.av.getAlignmentView(isSelection);
            seqStrings = view.getSequenceStrings(this.av.getGapCharacter());
            this.seqs = isSelection ? (SequenceI[])view.getAlignmentAndHiddenColumns(this.av.getGapCharacter())[0] : this.av.getAlignment().getSequencesArray();
        }
        String type = this.av.getAlignment().isNucleotide() ? "dna" : "pep";
        float[][] scores = new float[this.seqs.length][this.seqs.length];
        float[][] alignmentScores = new float[this.seqs.length][this.seqs.length];
        double totscore = 0.0;
        int count = this.seqs.length;
        int fracprogress = 0;
        boolean first = true;
        long time = System.currentTimeMillis();
        long fprogress = 0L;
        this.firePropertyChange(TOTAL, 0, 500);
        for (int i = 1; i < count; ++i) {
            alignmentScores[i - 1][i - 1] = Float.NaN;
            for (int j = 0; j < i; ++j) {
                if (this.cancelled) {
                    this.alignmentOutput = "Alignment was cancelled.";
                    return;
                }
                AlignSeq as = new AlignSeq(this.seqs[i], seqStrings[i], this.seqs[j], seqStrings[j], type, this.GAP_OPEN_COST, this.GAP_EXTEND_COST);
                if (sm != null) {
                    as.setScoreMatrix(sm);
                }
                if (as.s1str.length() == 0 || as.s2str.length() == 0) continue;
                as.calcScoreMatrix();
                if (this.endGaps) {
                    as.traceAlignmentWithEndGaps();
                } else {
                    as.traceAlignment();
                }
                as.scoreAlignment();
                if (!first && !this.quiet) {
                    Console.outPrintln(DASHES);
                    this.textarea.append(DASHES);
                    sb.append(DASHES);
                }
                first = false;
                if (!this.discardAlignments) {
                    as.printAlignment(System.out);
                }
                scores[i][j] = as.getMaxScore() / (float)as.getASeq1().length;
                alignmentScores[i][j] = as.getAlignmentScore();
                totscore += (double)scores[i][j];
                if (!this.quiet) {
                    this.textarea.append(as.getOutput());
                    sb.append(as.getOutput());
                }
                if (!this.discardAlignments) {
                    this.sequences.add(as.getAlignedSeq1());
                    this.sequences.add(as.getAlignedSeq2());
                }
                ++fprogress;
            }
            if (i >= count) continue;
            int newfracprogress = (int)Math.floor(500.0 * (double)fprogress / (double)this.total);
            this.firePropertyChange(PROGRESS, fracprogress, newfracprogress);
            fracprogress = newfracprogress;
            this.progress = fprogress;
            double lasteta = this.etime;
            double rate = (double)(System.currentTimeMillis() - time) / (double)this.progress;
            this.etime = rate * (double)(this.total - this.progress) / 60000.0;
            this.firePropertyChange(ETA, lasteta, this.etime);
        }
        alignmentScores[count - 1][count - 1] = Float.NaN;
        this.firePropertyChange(TOTAL, -1, -2);
        this.scores = scores;
        this.alignmentScores = alignmentScores;
        if (count > 2 && !this.quiet) {
            this.printScoreMatrix(this.seqs, scores, totscore);
        }
        this.alignmentOutput = sb.toString();
    }

    public boolean hasEta() {
        return this.etime > 0.0;
    }

    public double getEta() {
        return this.etime;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public float[][] getScores() {
        return this.scores;
    }

    public float[][] getAlignmentScores() {
        return this.alignmentScores;
    }

    public String getAlignmentOutput() {
        return this.alignmentOutput;
    }

    protected void printScoreMatrix(SequenceI[] seqs, float[][] scores, double totscore) {
        int i;
        System.out.println("Pairwise alignment scaled similarity score matrix " + this.getPairwiseSimscoresAsString() + "\n");
        for (i = 0; i < seqs.length; ++i) {
            Console.outPrintln(String.format("%3d %s", i + 1, seqs[i].getDisplayId(true)));
        }
        System.out.print("\n ");
        for (i = 0; i < seqs.length; ++i) {
            System.out.print(String.format("%7d", i + 1));
        }
        Console.outPrintln();
        for (i = 0; i < seqs.length; ++i) {
            System.out.print(String.format("%3d", i + 1));
            for (int j = 0; j < i; ++j) {
                System.out.print(String.format("%7.3f", (double)scores[i][j] / totscore));
            }
            Console.outPrintln();
        }
        Console.outPrintln("\n");
    }

    public String getPairwiseSimscoresAsString() {
        return this.scoreMatrix != null ? " (" + this.scoreMatrix.getName() + ", open=" + this.GAP_OPEN_COST + ", extend=" + this.GAP_EXTEND_COST + (this.endGaps ? ", with endGaps" : ", no endGaps") + ")" : "";
    }

    @Override
    protected void viewInEditorButton_actionPerformed(ActionEvent e) {
        SequenceI[] seq = new SequenceI[this.sequences.size()];
        for (int i = 0; i < this.sequences.size(); ++i) {
            seq[i] = this.sequences.elementAt(i);
        }
        AlignFrame af = new AlignFrame(new Alignment(seq), 700, 500);
        Desktop.addInternalFrame(af, MessageManager.getString("label.pairwise_aligned_sequences") + " " + this.getPairwiseSimscoresAsString(), 700, 500);
    }

    public long getTotal() {
        return this.total;
    }

    public long getProgress() {
        return this.progress;
    }

    public SequenceI[] getInputSequences() {
        return this.seqs;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setDiscardAlignments(boolean discard) {
        this.discardAlignments = discard;
    }

    public boolean isDiscardAlignments() {
        return this.discardAlignments;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void updateProgress(String type, String message) {
        this.firePropertyChange(type, "", MessageManager.getStringOrReturn(PROGRESS, message));
    }
}

