/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JalviewJmolBinding;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.OOMWarning;
import jalview.gui.SeqPanel;
import jalview.gui.SequenceRenderer;
import jalview.gui.StructureViewerBase;
import jalview.io.DataSourceType;
import jalview.structure.StructureSelectionManager;
import jalview.util.BrowserLauncher;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javajs.util.BS;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolViewer;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;

public class AppJmolBinding
extends JalviewJmolBinding {
    public AppJmolBinding(AppJmol appJmol, StructureSelectionManager sSm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(sSm, pdbentry, sequenceIs, protocol);
        this.setViewer(appJmol);
    }

    @Override
    public SequenceRenderer getSequenceRenderer(AlignmentViewPanel alignment) {
        return new SequenceRenderer(((AlignmentPanel)alignment).av);
    }

    @Override
    public void sendConsoleEcho(String strEcho) {
        if (this.console != null) {
            this.console.sendConsoleEcho(strEcho);
        }
    }

    @Override
    public void sendConsoleMessage(String strStatus) {
        if (this.console != null && strStatus != null) {
            this.console.sendConsoleMessage(strStatus);
        }
    }

    @Override
    public void showUrl(String url, String target) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            Console.error("Failed to launch Jmol-associated url " + url, e);
        }
    }

    @Override
    public void refreshGUI() {
        if (this.getMappedStructureCount() == 0) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JalviewStructureDisplayI theViewer = AppJmolBinding.this.getViewer();
                theViewer.updateTitleAndMenus();
                ((JComponent)((Object)theViewer)).revalidate();
            }
        });
    }

    @Override
    public void notifyScriptTermination(String strStatus, int msWalltime) {
    }

    public void showUrl(String url) {
        this.showUrl(url, "jmol");
    }

    public void newJmolPopup(String menuName) {
    }

    @Override
    public void selectionChanged(BS arg0) {
    }

    @Override
    public void showConsole(boolean b) {
        this.getViewer().showConsole(b);
    }

    @Override
    protected JmolAppConsoleInterface createJmolConsole(Container consolePanel, String buttonsToShow) {
        this.jmolViewer.setJmolCallbackListener((JmolCallbackListener)this);
        return Platform.isJS() || Jalview.isHeadlessMode() ? null : new AppConsole((JmolViewer)this.jmolViewer, consolePanel, buttonsToShow);
    }

    @Override
    protected void releaseUIResources() {
        this.setViewer(null);
        this.closeConsole();
    }

    @Override
    public void releaseReferences(Object svl) {
        if (svl instanceof SeqPanel) {
            this.getViewer().removeAlignmentPanel(((SeqPanel)svl).ap);
        }
    }

    public Map<String, Object> getJSpecViewProperty(String arg0) {
        return null;
    }

    public void cacheFiles(List<File> files) {
        if (files == null) {
            return;
        }
        for (File f : files) {
            Platform.cacheFileData(f);
        }
    }

    public List<String> fetchPdbFiles(StructureViewerBase structureViewer) {
        StringBuilder errormsgs = new StringBuilder();
        ArrayList<String> files = new ArrayList<String>();
        String pdbid = "";
        try {
            String[] filesInViewer = this.getStructureFiles();
            for (int pi = 0; pi < this.getPdbCount(); ++pi) {
                PDBEntry strucEntry = this.getPdbEntry(pi);
                String file = strucEntry.getFile();
                if (file == null) {
                    pdbid = strucEntry.getId();
                    try {
                        file = structureViewer.fetchPdbFile(strucEntry);
                    }
                    catch (OutOfMemoryError oomerror) {
                        new OOMWarning("Retrieving PDB id " + pdbid, oomerror);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        errormsgs.append("'").append(pdbid).append("'");
                    }
                    if (file != null) {
                        files.add(file);
                        continue;
                    }
                    errormsgs.append("'").append(pdbid).append("' ");
                    continue;
                }
                if (filesInViewer != null && filesInViewer.length > 0) {
                    structureViewer.setAddingStructures(true);
                    for (int c = 0; c < filesInViewer.length; ++c) {
                        if (!Platform.pathEquals(filesInViewer[c], file)) continue;
                        file = null;
                        break;
                    }
                }
                if (file == null) continue;
                files.add(file);
            }
        }
        catch (OutOfMemoryError oomerror) {
            new OOMWarning("Retrieving PDB files: " + pdbid, oomerror);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errormsgs.append("When retrieving pdbfiles : current was: '").append(pdbid).append("'");
        }
        if (errormsgs.length() > 0) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.pdb_entries_couldnt_be_retrieved", new String[]{errormsgs.toString()}), MessageManager.getString("label.couldnt_load_file"), 0);
        }
        return files;
    }
}

