/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.CigarBase;
import jalview.datamodel.CigarCigar;
import jalview.datamodel.CigarSimple;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import java.util.Iterator;
import java.util.Vector;

public class CigarArray
extends CigarBase {
    public CigarSimple[] refCigars = null;
    private boolean seqcigararray = false;

    private CigarArray() {
    }

    public boolean isSeqCigarArray() {
        return this.seqcigararray;
    }

    public CigarArray(CigarSimple[] cigars) {
        this.seqcigararray = true;
        if (cigars != null && cigars.length > 0) {
            this.refCigars = new CigarSimple[cigars.length];
            for (int c = 0; c < cigars.length; ++c) {
                this.refCigars[c] = cigars[c];
                if (cigars[c] instanceof SeqCigar || cigars[c] instanceof CigarCigar) continue;
                this.seqcigararray = false;
            }
        }
    }

    public CigarArray(AlignmentI alignment, HiddenColumns hidden, SequenceGroup selectionGroup) {
        this(CigarArray.constructSeqCigarArray(alignment, selectionGroup));
        this.constructFromAlignment(alignment, hidden, selectionGroup);
    }

    private static int[] _calcStartEndBounds(AlignmentI alignment, SequenceGroup selectionGroup) {
        int[] startend = new int[]{0, 0, 0};
        if (selectionGroup != null) {
            startend[0] = selectionGroup.getSize();
            startend[1] = selectionGroup.getStartRes();
            startend[2] = selectionGroup.getEndRes();
        } else {
            startend[0] = alignment.getHeight();
            startend[2] = alignment.getWidth() - 1;
        }
        return startend;
    }

    public static SeqCigar[] constructSeqCigarArray(AlignmentI alignment, SequenceGroup selectionGroup) {
        int iSize;
        SequenceI[] seqs = null;
        int[] _startend = CigarArray._calcStartEndBounds(alignment, selectionGroup);
        int start = _startend[1];
        int end = _startend[2];
        if (selectionGroup != null) {
            iSize = selectionGroup.getSize();
            seqs = selectionGroup.getSequencesInOrder(alignment);
            start = selectionGroup.getStartRes();
            end = selectionGroup.getEndRes();
        } else {
            iSize = alignment.getHeight();
            seqs = alignment.getSequencesArray();
            end = alignment.getWidth() - 1;
        }
        SeqCigar[] selseqs = new SeqCigar[iSize];
        for (int i = 0; i < iSize; ++i) {
            selseqs[i] = new SeqCigar(seqs[i], start, end);
        }
        return selseqs;
    }

    private void constructFromAlignment(AlignmentI alignment, HiddenColumns hidden, SequenceGroup selectionGroup) {
        int[] _startend = CigarArray._calcStartEndBounds(alignment, selectionGroup);
        int start = _startend[1];
        int end = _startend[2];
        if (hidden != null) {
            int last = start;
            Iterator<int[]> regions = hidden.getBoundedIterator(start, end);
            while (regions.hasNext()) {
                int[] region = regions.next();
                int hideStart = region[0];
                int hideEnd = region[1];
                if (hideStart < last && hideEnd >= last) {
                    hideStart = last;
                }
                if (hideEnd > end) {
                    hideEnd = end;
                }
                if (last < hideStart) {
                    this.addOperation('M', hideStart - last);
                }
                this.addOperation('D', 1 + hideEnd - hideStart);
                last = hideEnd + 1;
            }
            if (last <= end) {
                this.addOperation('M', end - last + 1);
            }
        } else {
            this.addOperation('M', end - start + 1);
        }
    }

    protected Object[][] getArrayofSequenceAndDeletions(char GapChar) {
        if (this.refCigars == null || this.refCigars.length == 0 || this.length == 0) {
            return null;
        }
        Object[][] sqanddels = new Object[this.refCigars.length][];
        for (int c = 0; c < this.refCigars.length; ++c) {
            String refString = this.refCigars[c].getSequenceString(GapChar);
            sqanddels[c] = refString != null ? this.getSequenceAndDeletions(refString, GapChar) : null;
        }
        return sqanddels;
    }

    public String getSequenceString(char GapChar) {
        if (this.length == 0 || this.refCigars == null) {
            return "";
        }
        StringBuffer seqStrings = new StringBuffer();
        Object[][] sqanddels = this.getArrayofSequenceAndDeletions(GapChar);
        for (int c = 0; c < this.refCigars.length; ++c) {
            if (sqanddels[c] != null) {
                seqStrings.append((String)sqanddels[c][0]);
                sqanddels[c][0] = null;
            }
            seqStrings.append('\n');
        }
        return seqStrings.toString();
    }

    public String[] getSequenceStrings(char GapChar) {
        if (this.length == 0 || this.refCigars == null || this.refCigars.length == 0) {
            return null;
        }
        Object[][] sqanddels = this.getArrayofSequenceAndDeletions(GapChar);
        String[] seqs = new String[sqanddels.length];
        for (int c = 0; c < this.refCigars.length; ++c) {
            seqs[c] = (String)sqanddels[c][0];
        }
        return seqs;
    }

    public int[] applyDeletions() {
        Vector<int[]> delpos = null;
        if (this.length == 0) {
            return null;
        }
        int cursor = 0;
        int vcursor = 0;
        int offset = 0;
        int i = 0;
        while (i < this.length) {
            if (this.operation[i] != 'D') {
                if (this.operation[i] == 'M') {
                    cursor += this.range[i];
                }
                vcursor += this.range[i++];
                continue;
            }
            if (delpos == null) {
                delpos = new Vector<int[]>();
            }
            int delstart = cursor;
            int delend = cursor + this.range[i] - 1;
            delpos.addElement(new int[]{vcursor + offset, this.range[i]});
            offset += this.range[i] - 1;
            System.arraycopy(this.operation, i + 1, this.operation, i, this.length - i);
            System.arraycopy(this.range, i + 1, this.range, i, this.length - i);
            --this.length;
            for (int s = 0; s < this.refCigars.length; ++s) {
                int n = this.refCigars[s].deleteRange(delstart, delend);
            }
        }
        if (delpos != null) {
            int[] pos = new int[delpos.size() * 2];
            int l = delpos.size();
            for (int k = 0; k < l; ++k) {
                int[] dr = (int[])delpos.elementAt(k);
                pos[k * 2] = dr[0];
                pos[k * 2 + 1] = dr[1];
                delpos.setElementAt(null, k);
            }
            delpos = null;
            return pos;
        }
        return null;
    }

    public SeqCigar[] getSeqCigarArray() {
        if (!this.isSeqCigarArray()) {
            return null;
        }
        SeqCigar[] sa = new SeqCigar[this.refCigars.length];
        for (int i = 0; i < this.refCigars.length; ++i) {
            sa[i] = (SeqCigar)this.refCigars[i];
        }
        return sa;
    }
}

