/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceGroup;
import jalview.renderer.ScaleRenderer;
import jalview.util.MessageManager;
import jalview.viewmodel.ViewportListenerI;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;

public class ScalePanel
extends Panel
implements MouseMotionListener,
MouseListener,
ViewportListenerI {
    protected int offy = 4;
    public int width;
    protected AlignViewport av;
    AlignmentPanel ap;
    boolean stretchingGroup = false;
    int min;
    int max;
    boolean mouseDragging = false;
    int[] reveal;

    public ScalePanel(AlignViewport av, AlignmentPanel ap) {
        this.setLayout(null);
        this.av = av;
        this.ap = ap;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        av.getRanges().addPropertyChangeListener(this);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int x = evt.getX() / this.av.getCharWidth() + this.av.getRanges().getStartRes();
        int res = this.av.hasHiddenColumns() ? this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(x) : x;
        this.min = res;
        this.max = res;
        if ((evt.getModifiersEx() & 0x1000) == 4096) {
            this.rightMouseButtonPressed(evt, res);
        } else {
            this.leftMouseButtonPressed(evt, res);
        }
    }

    protected void leftMouseButtonPressed(MouseEvent evt, int res) {
        if (!evt.isControlDown() && !evt.isShiftDown()) {
            this.av.getColumnSelection().clear();
        }
        this.av.getColumnSelection().addElement(res);
        SequenceGroup sg = new SequenceGroup();
        for (int i = 0; i < this.av.getAlignment().getSequences().size(); ++i) {
            sg.addSequence(this.av.getAlignment().getSequenceAt(i), false);
        }
        sg.setStartRes(res);
        sg.setEndRes(res);
        this.av.setSelectionGroup(sg);
        if (evt.isShiftDown()) {
            int min = Math.min(this.av.getColumnSelection().getMin(), res);
            int max = Math.max(this.av.getColumnSelection().getMax(), res);
            for (int i = min; i < max; ++i) {
                this.av.getColumnSelection().addElement(i);
            }
            sg.setStartRes(min);
            sg.setEndRes(max);
        }
        this.ap.paintAlignment(false, false);
        this.av.sendSelection();
    }

    protected void rightMouseButtonPressed(MouseEvent evt, final int res) {
        PopupMenu pop = new PopupMenu();
        if (this.reveal != null) {
            MenuItem item = new MenuItem(MessageManager.getString("label.reveal"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePanel.this.av.showColumn(ScalePanel.this.reveal[0]);
                    ScalePanel.this.reveal = null;
                    ScalePanel.this.ap.paintAlignment(true, true);
                    ScalePanel.this.av.sendSelection();
                }
            });
            pop.add(item);
            if (this.av.getAlignment().getHiddenColumns().hasMultiHiddenColumnRegions()) {
                item = new MenuItem(MessageManager.getString("action.reveal_all"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ScalePanel.this.av.showAllHiddenColumns();
                        ScalePanel.this.reveal = null;
                        ScalePanel.this.ap.paintAlignment(true, true);
                        ScalePanel.this.av.sendSelection();
                    }
                });
                pop.add(item);
            }
            this.add(pop);
            pop.show(this, evt.getX(), evt.getY());
        } else if (this.av.getColumnSelection().contains(res)) {
            MenuItem item = new MenuItem(MessageManager.getString("label.hide_columns"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScalePanel.this.av.hideColumns(res, res);
                    if (ScalePanel.this.av.getSelectionGroup() != null && ScalePanel.this.av.getSelectionGroup().getSize() == ScalePanel.this.av.getAlignment().getHeight()) {
                        ScalePanel.this.av.setSelectionGroup(null);
                    }
                    ScalePanel.this.ap.paintAlignment(true, true);
                    ScalePanel.this.av.sendSelection();
                }
            });
            pop.add(item);
            this.add(pop);
            pop.show(this, evt.getX(), evt.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.mouseDragging = false;
        int res = evt.getX() / this.av.getCharWidth() + this.av.getRanges().getStartRes();
        if (res > this.av.getAlignment().getWidth()) {
            res = this.av.getAlignment().getWidth() - 1;
        }
        if (this.av.hasHiddenColumns()) {
            res = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(res);
        }
        if (!this.stretchingGroup) {
            this.ap.paintAlignment(false, false);
            return;
        }
        SequenceGroup sg = this.av.getSelectionGroup();
        if (res > sg.getStartRes()) {
            sg.setEndRes(res);
        } else if (res < sg.getStartRes()) {
            sg.setStartRes(res);
        }
        this.stretchingGroup = false;
        this.ap.paintAlignment(false, false);
        this.av.sendSelection();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.mouseDragging = true;
        ColumnSelection cs = this.av.getColumnSelection();
        int res = evt.getX() / this.av.getCharWidth() + this.av.getRanges().getStartRes();
        res = Math.max(0, res);
        res = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(res);
        res = Math.min(res, this.av.getAlignment().getWidth() - 1);
        this.min = Math.min(res, this.min);
        this.max = Math.max(res, this.max);
        SequenceGroup sg = this.av.getSelectionGroup();
        if (sg != null) {
            this.stretchingGroup = true;
            cs.stretchGroup(res, sg, this.min, this.max);
            this.ap.paintAlignment(false, false);
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        if (this.mouseDragging) {
            this.ap.seqPanel.scrollCanvas(null);
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        if (this.mouseDragging) {
            this.ap.seqPanel.scrollCanvas(evt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        if (!this.av.hasHiddenColumns()) {
            return;
        }
        int res = evt.getX() / this.av.getCharWidth() + this.av.getRanges().getStartRes();
        this.reveal = this.av.getAlignment().getHiddenColumns().getRegionWithEdgeAtRes(res);
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (!this.av.getWrapAlignment()) {
            this.drawScale(g, this.av.getRanges().getStartRes(), this.av.getRanges().getEndRes(), this.getSize().width, this.getSize().height);
        }
    }

    public void drawScale(Graphics gg, int startx, int endx, int width, int height) {
        gg.setFont(this.av.getFont());
        gg.setColor(Color.white);
        gg.fillRect(0, 0, width, height);
        gg.setColor(Color.black);
        ColumnSelection cs = this.av.getColumnSelection();
        HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
        int avCharWidth = this.av.getCharWidth();
        int avcharHeight = this.av.getCharHeight();
        if (cs != null) {
            gg.setColor(new Color(220, 0, 0));
            boolean hasHiddenColumns = hidden.hasHiddenColumns();
            for (int sel : cs.getSelected()) {
                if (hasHiddenColumns) {
                    if (!hidden.isVisible(sel)) continue;
                    sel = hidden.absoluteToVisibleColumn(sel);
                }
                if (sel < startx || sel > endx) continue;
                gg.fillRect((sel - startx) * avCharWidth, 0, avCharWidth, this.getSize().height);
            }
        }
        gg.setColor(Color.black);
        int maxX = 0;
        List<ScaleRenderer.ScaleMark> marks = new ScaleRenderer().calculateMarks(this.av, startx, endx);
        FontMetrics fm = gg.getFontMetrics(this.av.getFont());
        int y = avcharHeight;
        int yOf = fm.getDescent();
        y -= yOf;
        for (ScaleRenderer.ScaleMark mark : marks) {
            boolean major = mark.major;
            int mpos = mark.column;
            String mstring = mark.text;
            if (mstring != null && mpos * avCharWidth > maxX) {
                gg.drawString(mstring, mpos * avCharWidth, y);
                maxX = (mpos + 2) * avCharWidth + fm.stringWidth(mstring);
            }
            if (major) {
                gg.drawLine(mpos * avCharWidth + avCharWidth / 2, y + 2, mpos * avCharWidth + avCharWidth / 2, y + yOf * 2);
                continue;
            }
            gg.drawLine(mpos * avCharWidth + avCharWidth / 2, y + yOf, mpos * avCharWidth + avCharWidth / 2, y + yOf * 2);
        }
        if (this.av.hasHiddenColumns()) {
            gg.setColor(Color.blue);
            if (this.av.getShowHiddenMarkers()) {
                int widthx = 1 + endx - startx;
                Iterator<Integer> it = hidden.getStartRegionIterator(startx, startx + widthx + 1);
                while (it.hasNext()) {
                    int res = it.next() - startx;
                    gg.fillPolygon(new int[]{-1 + res * avCharWidth - avcharHeight / 4, -1 + res * avCharWidth + avcharHeight / 4, -1 + res * avCharWidth}, new int[]{y, y, y + 2 * yOf}, 3);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("startres") || evt.getPropertyName().equals("startresandseq") || evt.getPropertyName().equals("move_viewport")) {
            this.repaint();
        }
    }
}

