/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.util.Util;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ValueConstrain {
    @XmlElement(required=true)
    Type type;
    String max;
    String min;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Number getMax() {
        if (Util.isEmpty(this.max)) {
            return null;
        }
        switch (this.type) {
            case Float: {
                return Double.parseDouble(this.max);
            }
            case Integer: {
                return Integer.parseInt(this.max);
            }
        }
        throw new RuntimeException("Type is undefined! ");
    }

    public void setMax(String max) {
        this.max = max;
    }

    public Number getMin() {
        if (Util.isEmpty(this.min)) {
            return null;
        }
        switch (this.type) {
            case Float: {
                return Double.parseDouble(this.min);
            }
            case Integer: {
                return Integer.parseInt(this.min);
            }
        }
        throw new RuntimeException("Type is undefined! ");
    }

    public void setMin(String min) {
        this.min = min;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ValueConstrain constr = null;
        if (!(obj instanceof ValueConstrain)) {
            return false;
        }
        constr = (ValueConstrain)obj;
        if (this.type != constr.type) {
            return false;
        }
        if (this.max != null && constr.max != null) {
            if (!this.max.equals(constr.max)) {
                return false;
            }
        } else {
            return false;
        }
        if (this.min != null && constr.min != null) {
            return this.min.equals(constr.min);
        }
        return false;
    }

    public String toString() {
        String value = "Type: " + (Object)((Object)this.type) + "\n";
        if (this.min != null) {
            value = value + "Minimal value: " + this.min + "\n";
        }
        if (this.max != null) {
            value = value + "Maximal value: " + this.max + "\n";
        }
        return value;
    }

    public int hashCode() {
        int code = this.type.hashCode();
        if (this.max != null) {
            code *= this.max.hashCode();
        }
        if (this.min != null) {
            code *= this.min.hashCode();
        }
        return code;
    }

    boolean hasMinValue() {
        return !Util.isEmpty(this.min);
    }

    boolean hasMaxValue() {
        return !Util.isEmpty(this.max);
    }

    void checkValue(String value) {
        switch (this.type) {
            case Float: {
                float val = Float.parseFloat(value);
                if (this.getMin() != null && new Float(this.getMin().floatValue()).compareTo(Float.valueOf(val)) == 1) {
                    throw new IndexOutOfBoundsException("Value '" + value + "' is lower that minumim value '" + this.getMin() + "'");
                }
                if (this.getMax() == null || new Float(this.getMax().floatValue()).compareTo(Float.valueOf(val)) != -1) break;
                throw new IndexOutOfBoundsException("Value '" + value + "' is greater that maximum value '" + this.getMax() + "'");
            }
            case Integer: {
                int ival = Integer.parseInt(value);
                if (this.getMin() != null && new Integer(this.getMin().intValue()).compareTo(ival) == 1) {
                    throw new IndexOutOfBoundsException("Value '" + value + "' is lower that minumim value '" + this.getMin() + "'");
                }
                if (this.getMax() == null || new Integer(this.getMax().intValue()).compareTo(ival) != -1) break;
                throw new IndexOutOfBoundsException("Value '" + value + "' is greater that maximum value '" + this.getMax() + "'");
            }
        }
    }

    void validate() throws ValidationException {
        if (this.type == null) {
            throw new ValidationException("Type is not defined for ValueConstrain: " + this);
        }
        if (Util.isEmpty(this.min) && Util.isEmpty(this.max)) {
            throw new ValidationException("Both boundaries (min and max) is undefined for ValueConstrain: " + this);
        }
    }

    public static enum Type {
        Integer,
        Float;

    }
}

