/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.engine.conf.RunnerConfigMarshaller;
import compbio.metadata.AllTestSuit;
import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.metadata.RunnerConfig;
import compbio.metadata.ValueConstrain;
import compbio.metadata.WrongParameterException;
import compbio.runner.msa.Mafft;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationException;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RunnerConfigTester {
    public static String test_input = AllTestSuit.TEST_DATA_PATH_ABSOLUTE + "MafftParameters.xml";
    RunnerConfig<Mafft> rconfig = null;

    @BeforeMethod
    public void setup() {
        try {
            this.rconfig = new RunnerConfig();
            this.rconfig.setRunnerClassName(Mafft.class.getName());
            ArrayList prms = new ArrayList();
            RunnerConfigMarshaller runnerConfigMarshaller = new RunnerConfigMarshaller(RunnerConfig.class, new Class[]{Parameter.class, Option.class, ValueConstrain.class});
        }
        catch (JAXBException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void testValidate() {
        try {
            this.rconfig.validate();
        }
        catch (ValidationException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test(expectedExceptions={WrongParameterException.class})
    public void testCreateParameter() throws WrongParameterException {
        Parameter p3 = new Parameter("Matrix1", "Protein weight matrix");
        p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
        p3.addPossibleValues("BLOSUM", "PAM", "GONNET", "ID");
        p3.setOptionName("--AAMATRIX");
        p3.setRequired(true);
        p3.setDefaultValue("pam22");
        String com = p3.toCommand(" ");
        System.out.println("AAAAAAAAAAAAAA!" + com);
    }

    @Test
    public void testParameterToCommand() throws WrongParameterException {
        Parameter p3 = new Parameter("Matrix1", "Protein weight matrix");
        p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
        p3.addPossibleValues("BLOSUM", "PAM", "GONNET", "ID");
        p3.setOptionName("--AAMATRIX");
        p3.setRequired(true);
        p3.setDefaultValue("PAM");
        String com = p3.toCommand("=");
        AssertJUnit.assertTrue((boolean)com.startsWith("--AAMATRIX"));
        AssertJUnit.assertTrue((boolean)com.endsWith("PAM"));
        AssertJUnit.assertTrue((boolean)com.contains("="));
        p3.setDefaultValue("ID");
        com = p3.toCommand("=");
        AssertJUnit.assertFalse((boolean)com.endsWith("PAM"));
        AssertJUnit.assertFalse((boolean)com.contains("PAM"));
    }

    @Test(expectedExceptions={ValidationException.class})
    public void testOptionNoDefaultValidate() throws ValidationException {
        Option p3 = new Option("Matrix1", "Protein weight matrix");
        p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
        p3.setOptionNames(new HashSet<String>(Arrays.asList("--AAMATRIX", "--ABMAT", "--BBBB")));
        p3.setRequired(true);
        p3.validate();
    }

    @Test(expectedExceptions={WrongParameterException.class})
    public void testOptionSetInvalidValue() throws WrongParameterException {
        Option p3 = new Option("Matrix1", "Protein weight matrix");
        p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
        p3.setOptionNames(new HashSet<String>(Arrays.asList("--AAMATRIX", "--ABMAT", "--BBBB")));
        p3.setRequired(true);
        p3.setDefaultValue("AAA");
    }

    @Test
    public void testOptionToCommand() {
        try {
            Option p3 = new Option("Matrix1", "Protein weight matrix");
            p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
            p3.setOptionNames(new HashSet<String>(Arrays.asList("--AAMATRIX", "--ABMAT", "--BBBB")));
            p3.setRequired(true);
            p3.setDefaultValue("--BBBB");
            p3.validate();
            String com = p3.toCommand("=");
            AssertJUnit.assertEquals((String)"--BBBB", (String)com);
            p3.setDefaultValue("--ABMAT");
            com = p3.toCommand("=");
            AssertJUnit.assertEquals((String)"--ABMAT", (String)com);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testCreateNumParameterWithoutValidValue() throws MalformedURLException {
        try {
            Parameter p4 = new Parameter("Matrix", "DNA weight matrix");
            p4.setDefaultValue("5");
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test
    public void testCreateParameterWithValidValueConstrain() throws MalformedURLException {
        Parameter p4 = new Parameter("Matrix", "DNA weight matrix");
        ValueConstrain vc = new ValueConstrain();
        vc.setType(ValueConstrain.Type.Float);
        vc.setMin("0");
        vc.setMax("10");
        p4.setValidValue(vc);
        try {
            p4.setDefaultValue("5");
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getLocalizedMessage());
        }
    }

    @Test(expectedExceptions={WrongParameterException.class})
    public void testValidateLowerBoundaryConstrainCheck() throws WrongParameterException {
        Parameter p3 = new Parameter("Matrix1", "Protein weight matrix");
        p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
        p3.setOptionName("--AAMATRIX");
        p3.setRequired(true);
        ValueConstrain vc = new ValueConstrain();
        vc.setType(ValueConstrain.Type.Float);
        vc.setMin("-10.12");
        vc.setMax("0");
        p3.setValidValue(vc);
        p3.setDefaultValue("-11.0");
    }

    @Test(expectedExceptions={WrongParameterException.class})
    public void testValidateUpperBoundaryConstrainCheck() throws WrongParameterException {
        Parameter p3 = new Parameter("Matrix1", "Protein weight matrix");
        p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
        p3.setOptionName("--AAMATRIX");
        p3.setRequired(true);
        ValueConstrain vc = new ValueConstrain();
        vc.setType(ValueConstrain.Type.Float);
        vc.setMin("-10.12");
        vc.setMax("0");
        p3.setValidValue(vc);
        p3.setDefaultValue("1");
    }

    @Test
    public void testValidateBoundaryConstrainCheck() {
        try {
            Parameter p3 = new Parameter("Matrix1", "Protein weight matrix");
            p3.setFurtherDetails("http://www.compbio.dundee.ac.uk/users/pvtroshin/ws/Index.html");
            p3.setOptionName("--AAMATRIX");
            p3.setRequired(true);
            ValueConstrain vc = new ValueConstrain();
            vc.setType(ValueConstrain.Type.Float);
            vc.setMin("-10.12");
            p3.setValidValue(vc);
            p3.setDefaultValue("1");
            p3.validate();
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
        catch (ValidationException e) {
            e.printStackTrace();
            AssertJUnit.fail((String)e.getMessage());
        }
    }

    @Test(expectedExceptions={ValidationException.class})
    public void testValidateValueConstrain() throws ValidationException {
        ValueConstrain vc = new ValueConstrain();
        vc.setType(ValueConstrain.Type.Float);
        vc.validate();
    }
}

