/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Argument;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.RunnerConfig;
import compbio.util.Util;
import java.util.List;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="presets")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PresetManager<T> {
    @XmlElement(required=true)
    String runnerClassName;
    @XmlElement(required=true)
    List<Preset<T>> preset;
    public static final String LOCAL_ENGINE_LIMIT_PRESET = "# LocalEngineExecutionLimit #";

    public List<Preset<T>> getPresets() {
        return this.preset;
    }

    public void setPresets(List<Preset<T>> presets) {
        this.preset = presets;
    }

    public String getRunnerClassName() {
        return this.runnerClassName;
    }

    public void setRunnerClassName(String runnerClassName) {
        this.runnerClassName = runnerClassName;
    }

    public Preset<T> getPresetByName(String presetName) {
        for (Preset<T> p : this.preset) {
            if (!p.getName().equalsIgnoreCase(presetName)) continue;
            return p;
        }
        return null;
    }

    boolean isComposite(String value) {
        assert (value != null);
        return value.contains(" ");
    }

    boolean containsValue(List<String> values, String value) {
        assert (!Util.isEmpty(value));
        for (String v : values) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    boolean isNumeric(String value) {
        assert (value != null);
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void validate(RunnerConfig<T> options) throws ValidationException {
        for (Preset<T> p : this.preset) {
            if (Util.isEmpty(p.name)) {
                throw new ValidationException("Preset name must not be empty!");
            }
            List<String> optionNames = p.getOptions();
            if (optionNames == null || optionNames.size() == 0) {
                throw new ValidationException("At lease one option must be defined for a preset!");
            }
            for (String oName : optionNames) {
                if (this.isComposite(oName)) {
                    String name = oName.split(" ")[0];
                    Argument<T> arg = this.getArgument(options, name);
                    String value = oName.split(" ")[1];
                    if (this.isNumeric(value) || this.containsValue(arg.getPossibleValues(), value)) continue;
                    throw new ValidationException("Value " + value + " is not found in the option " + name);
                }
                this.getArgument(options, oName);
            }
        }
    }

    Argument<T> getArgument(RunnerConfig<T> options, String optionName) throws ValidationException {
        Option<T> arg = options.getArgumentByOptionName(optionName);
        if (arg == null) {
            throw new ValidationException("Option " + optionName + " is not found in the option list (<RunnerName>Parameter.xml file)");
        }
        return arg;
    }

    public String toString() {
        String value = "Runner: " + this.runnerClassName + "\n";
        for (Preset<T> p : this.preset) {
            value = value + "##############################################################################\n" + p.toString() + "\n";
        }
        return value;
    }
}

