/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VueHighlightRegionEdit
implements ChangeListener,
ActionListener {
    private VARNAPanel _vp;
    private JSlider _fromSlider;
    private JSlider _toSlider;
    private JPanel panel;
    private HighlightRegionAnnotation _an;
    private static int CONTROL_HEIGHT = 50;
    private static int TITLE_WIDTH = 70;
    private static int CONTROL_WIDTH = 200;
    private JButton fillShow = new JButton();
    private JButton outlineShow = new JButton();
    JSpinner rad;
    HighlightRegionAnnotation _backup = null;

    public VueHighlightRegionEdit(VARNAPanel vARNAPanel, HighlightRegionAnnotation highlightRegionAnnotation) {
        this._an = highlightRegionAnnotation;
        this._vp = vARNAPanel;
        this._toSlider = new JSlider(0, 0, vARNAPanel.getRNA().getSize() - 1, 0);
        this._toSlider.setMajorTickSpacing(10);
        this._toSlider.setPaintTicks(true);
        this._toSlider.setPaintLabels(true);
        this._toSlider.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this._fromSlider = new JSlider(0, 0, vARNAPanel.getRNA().getSize() - 1, 0);
        this._fromSlider.setMajorTickSpacing(10);
        this._fromSlider.setPaintTicks(true);
        this._fromSlider.setPaintLabels(true);
        this._fromSlider.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this._fromSlider.addChangeListener(this);
        this._toSlider.addChangeListener(this);
        this.panel = new JPanel();
        this.panel.setLayout(new FlowLayout(0));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("From: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        jPanel.add(jLabel);
        jPanel.add(this._fromSlider);
        JPanel jPanel2 = new JPanel();
        jLabel = new JLabel("To: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        jPanel2.add(jLabel);
        jPanel2.add(this._toSlider);
        JPanel jPanel3 = new JPanel();
        jLabel = new JLabel("Outline color: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.outlineShow.setContentAreaFilled(false);
        this.outlineShow.setOpaque(true);
        this.outlineShow.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this.outlineShow.setBackground(highlightRegionAnnotation.getOutlineColor());
        this.outlineShow.addActionListener(this);
        this.outlineShow.setActionCommand("outline");
        jPanel3.add(jLabel);
        jPanel3.add(this.outlineShow);
        JPanel jPanel4 = new JPanel();
        jLabel = new JLabel("Fill color: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.fillShow.setContentAreaFilled(false);
        this.fillShow.setOpaque(true);
        this.fillShow.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this.fillShow.setBackground(highlightRegionAnnotation.getFillColor());
        this.fillShow.addActionListener(this);
        this.fillShow.setActionCommand("fill");
        jPanel4.add(jLabel);
        jPanel4.add(this.fillShow);
        JPanel jPanel5 = new JPanel();
        jLabel = new JLabel("Radius: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this._an.getRadius(), 1.0, 50.0, 0.1);
        this.rad = new JSpinner(spinnerNumberModel);
        this.rad.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        jPanel5.add(jLabel);
        jPanel5.add(this.rad);
        this.rad.addChangeListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(5, 1));
        jPanel6.add(jPanel);
        jPanel6.add(jPanel2);
        jPanel6.add(jPanel3);
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        this.panel.add(jPanel6);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public double getAngle() {
        return this._toSlider.getValue();
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public boolean show() {
        boolean bl = false;
        int n = this._an.getMinIndex();
        int n2 = this._an.getMaxIndex();
        this._fromSlider.setValue(n);
        this._toSlider.setValue(n2);
        if (JOptionPane.showConfirmDialog(this._vp, this.getPanel(), "Edit region annotation", 2, -1) == 0) {
            bl = true;
        }
        this._vp.repaint();
        return bl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object;
        if (changeEvent.getSource() == this._toSlider || changeEvent.getSource() == this._fromSlider) {
            int n;
            int n2 = this._fromSlider.getValue();
            if (n2 > (n = this._toSlider.getValue())) {
                if (changeEvent.getSource().equals(this._fromSlider)) {
                    this._toSlider.setValue(n2);
                } else if (changeEvent.getSource().equals(this._toSlider)) {
                    this._fromSlider.setValue(n);
                }
            }
            n2 = this._fromSlider.getValue();
            n = this._toSlider.getValue();
            this._an.setBases(this._vp.getRNA().getBasesBetween(n2, n));
            this._vp.repaint();
        } else if (changeEvent.getSource().equals(this.rad) && (object = this.rad.getValue()) instanceof Double) {
            this._an.setRadius((Double)object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getActionCommand().equals("outline")) {
            Color color2 = JColorChooser.showDialog(this.getPanel(), "Choose new outline color", this._an.getOutlineColor());
            if (color2 != null) {
                this._an.setOutlineColor(color2);
            }
        } else if (actionEvent.getActionCommand().equals("fill") && (color = JColorChooser.showDialog(this.getPanel(), "Choose new fill color", this._an.getFillColor())) != null) {
            this._an.setFillColor(color);
        }
        this.outlineShow.setBackground(this._an.getOutlineColor());
        this.fillShow.setBackground(this._an.getFillColor());
        this._vp.repaint();
    }
}

