/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.geom;

import fr.orsay.lri.varna.models.geom.MiscGeom;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class HalfEllipse {
    private double a;
    private double b;
    private int n;
    private Point2D.Double[] points;
    private double[] lengths;
    private Point2D.Double[] unitVectors;

    public int getN() {
        return this.n;
    }

    public double getApproxCurveLength() {
        return this.lengths[this.n - 1];
    }

    public Point2D.Double standardParam(double d) {
        double d2 = this.a * Math.cos(d * Math.PI);
        double d3 = this.b * Math.sin(d * Math.PI);
        return new Point2D.Double(d2, d3);
    }

    public Point2D.Double[] uniformParam(double[] dArray) {
        int n = dArray.length;
        Point2D.Double[] doubleArray = new Point2D.Double[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            while (n2 < this.n && this.lengths[n2] < dArray[i]) {
                ++n2;
            }
            if (n2 >= this.n) {
                n2 = this.n - 1;
            }
            if (dArray[i] < 0.0) {
                throw new IllegalArgumentException("t[" + i + "] < 0");
            }
            double d = dArray[i] - (n2 != 0 ? this.lengths[n2 - 1] : 0.0);
            double d2 = this.points[n2].x + this.unitVectors[n2].x * d;
            double d3 = this.points[n2].y + this.unitVectors[n2].y * d;
            doubleArray[i] = new Point2D.Double(d2, d3);
        }
        return doubleArray;
    }

    public HalfEllipse(double d, double d2, int n) {
        this.a = d;
        this.b = d2;
        this.n = n;
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1");
        }
        this.computeData();
    }

    public static AffineTransform matchAxisA(Point2D.Double double_, Point2D.Double double_2) {
        double d = MiscGeom.angleFromVector(double_.x - double_2.x, double_.y - double_2.y);
        Point2D.Double double_3 = new Point2D.Double((double_.x + double_2.x) / 2.0, (double_.y + double_2.y) / 2.0);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(double_3.x, double_3.y);
        affineTransform.rotate(d);
        return affineTransform;
    }

    private void computeData() {
        this.points = new Point2D.Double[this.n + 1];
        for (int i = 0; i <= this.n; ++i) {
            this.points[i] = this.standardParam((double)i / (double)this.n);
        }
        this.lengths = new double[this.n];
        this.unitVectors = new Point2D.Double[this.n];
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double d2 = this.lineLength(this.points[i], this.points[i + 1]);
            double d3 = (this.points[i + 1].x - this.points[i].x) / d2;
            double d4 = (this.points[i + 1].y - this.points[i].y) / d2;
            this.unitVectors[i] = new Point2D.Double(d3, d4);
            this.lengths[i] = d += d2;
        }
    }

    private double lineLength(Point2D.Double double_, Point2D.Double double_2) {
        return double_2.distance(double_);
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }
}

