/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.applications.VARNAGUI;
import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionJPEGEncoding;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.ExceptionWritingForbidden;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.interfaces.InterfaceParameterLoader;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.VARNAConfigLoader;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JFrame;

public class VARNAcmd
implements InterfaceParameterLoader {
    private Hashtable<String, String> _optsValues = new Hashtable();
    private Hashtable<String, String> _basicOptsInv = new Hashtable();
    private String _inFile = "";
    private String _outFile = "";
    int _baseWidth = 400;
    double _scale = 1.0;
    float _quality = 0.9f;
    private String[] _basicOptions = new String[]{VARNAConfigLoader.algoOpt, VARNAConfigLoader.bpStyleOpt, VARNAConfigLoader.bondColorOpt, VARNAConfigLoader.backboneColorOpt, VARNAConfigLoader.periodNumOpt, VARNAConfigLoader.baseInnerColorOpt, VARNAConfigLoader.baseOutlineColorOpt};
    Vector<String[]> matrix = new Vector();
    private static int MAX_WIDTH = 100;

    public VARNAcmd(Vector<String> vector) throws ExitCode {
        int n;
        for (n = 0; n < this._basicOptions.length; ++n) {
            this._basicOptsInv.put(this._basicOptions[n], this._basicOptions[n]);
        }
        for (n = 0; n < vector.size(); n += 2) {
            String string = vector.elementAt(n);
            if (string.charAt(0) != '-') {
                this.errorExit("Missing or unknown option \"" + string + "\"");
            }
            if (string.equals("-h")) {
                this.displayLightHelpExit();
            }
            if (string.equals("-x")) {
                this.displayDetailledHelpExit();
                continue;
            }
            if (n + 1 >= vector.size()) {
                this.errorExit("Missing argument for option \"" + string + "\"");
            }
            String string2 = vector.get(n + 1);
            if (string.equals("-i")) {
                this._inFile = string2;
                continue;
            }
            if (string.equals("-o")) {
                this._outFile = string2;
                continue;
            }
            if (string.equals("-quality")) {
                this._quality = Float.parseFloat(string2);
                continue;
            }
            if (string.equals("-resolution")) {
                this._scale = Float.parseFloat(string2);
                continue;
            }
            this.addOption(string, string2);
        }
    }

    public void addOption(String string, String string2) {
        if (string.equals("-i")) {
            this._inFile = string2;
        } else if (string.equals("-o")) {
            this._outFile = string2;
        } else {
            this._optsValues.put(string.substring(1), string2);
        }
    }

    private String getDescription() {
        return "VARNA v3.9 Assisted drawing of RNA secondary structure (Command Line version)";
    }

    private String indent(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        return string;
    }

    private String complete(String string, int n) {
        String string2 = string;
        while (string2.length() < n) {
            string2 = string2 + " ";
        }
        return string2;
    }

    private void addLine(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        this.matrix.add(stringArray);
    }

    private void printMatrix(int n) {
        String[] stringArray;
        int n2;
        String[][] stringArrayArray = new String[this.matrix.size()][];
        this.matrix.toArray((T[])stringArrayArray);
        Arrays.sort(stringArrayArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String[] stringArray = (String[])object;
                String[] stringArray2 = (String[])object2;
                return stringArray[0].compareTo(stringArray2[0]);
            }
        });
        int n3 = 0;
        for (n2 = 0; n2 < stringArrayArray.length; ++n2) {
            stringArray = stringArrayArray[n2];
            n3 = Math.max(n3, stringArray[0].length());
        }
        n3 += n + 2;
        for (n2 = 0; n2 < stringArrayArray.length; ++n2) {
            stringArray = stringArrayArray[n2];
            String string = stringArray[0];
            String string2 = stringArray[1];
            string = this.complete("", n) + "-" + this.complete(string, n3 - n);
            System.out.println(string + string2.substring(0, Math.min(MAX_WIDTH - string.length(), string2.length())));
            if (string.length() + string2.length() < MAX_WIDTH) continue;
            for (int i = MAX_WIDTH - string.length(); i < string2.length(); i += MAX_WIDTH - string.length()) {
                String string3 = string2.substring(i, Math.min(i + MAX_WIDTH - string.length(), string2.length()));
                System.out.println(this.complete("", string.length()) + string3);
            }
        }
        this.matrix = new Vector();
    }

    private void printUsage() {
        System.out.println("Usage: java -cp . [-i InFile|-sequenceDBN XXX -structureDBN YYY] -o OutFile [Options]");
        System.out.println("Where:");
        System.out.println(this.indent(1) + "OutFile\tSupported formats: {JPEG,PNG,EPS,XFIG,SVG}");
        System.out.println(this.indent(1) + "InFile\tSecondary structure file: Supported formats: {BPSEQ,CT,RNAML,DBN}");
    }

    private void printHelpOptions() {
        System.out.println("\nMain options:");
        this.addLine("h", "Displays a short description of main options and exits");
        this.addLine("x", "Displays a detailled description of all options");
        this.printMatrix(2);
    }

    private void printMainOptions(String[][] stringArray) {
        System.out.println("\nMain options:");
        this.addLine("h", "Displays a short description of main options and exits");
        this.addLine("x", "Displays a detailled description of all options");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            if (!this._basicOptsInv.containsKey(string)) continue;
            this.addLine(string, stringArray[i][2]);
        }
        this.printMatrix(2);
    }

    private void printAdvancedOptions(String[][] stringArray) {
        System.out.println("\nAdvanced options:");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i][0];
            if (this._basicOptsInv.containsKey(string)) continue;
            this.addLine(string, stringArray[i][2]);
        }
        this.addLine("quality", "Sets quality (non-vector file formats only)");
        this.addLine("resolution", "Sets resolution (non-vector file formats only)");
        this.printMatrix(2);
    }

    private void displayLightHelpExit() throws ExitCode {
        String[][] stringArray = VARNAConfigLoader.getParameterInfo();
        System.out.println(this.getDescription());
        this.printUsage();
        this.printMainOptions(stringArray);
        throw new ExitCode(1, "");
    }

    private void displayDetailledHelpExit() throws ExitCode {
        String[][] stringArray = VARNAConfigLoader.getParameterInfo();
        System.out.println(this.getDescription());
        this.printUsage();
        this.printMainOptions(stringArray);
        this.printAdvancedOptions(stringArray);
        throw new ExitCode(1, "");
    }

    private void errorExit(String string) throws ExitCode {
        System.out.println(this.getDescription());
        System.out.println("Error: " + string + "\n");
        this.printUsage();
        this.printHelpOptions();
        throw new ExitCode(1, "");
    }

    @Override
    public String getParameterValue(String string, String string2) {
        if (this._optsValues.containsKey(string)) {
            return this._optsValues.get(string);
        }
        return string2;
    }

    public String formatOutputPath(String string, int n, int n2) {
        String string2 = string;
        if (n2 > 1) {
            String string3;
            String string4;
            int n3 = string.lastIndexOf(46);
            if (n3 != -1) {
                string4 = string.substring(0, n3);
                string3 = string.substring(n3);
            } else {
                string4 = string;
                string3 = "";
            }
            string2 = string4 + "-" + n + string3;
        }
        System.err.println("Output file: " + string2);
        return string2;
    }

    public void run() throws IOException, ExitCode {
        VARNAConfigLoader vARNAConfigLoader = new VARNAConfigLoader(this);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Serializable serializable;
            if (!this._inFile.equals("")) {
                Iterator iterator;
                serializable = RNAFactory.loadSecStr(this._inFile);
                if (serializable.isEmpty()) {
                    iterator = null;
                    try {
                        iterator = VARNAPanel.importSession(new FileInputStream(this._inFile), this._inFile);
                        arrayList.add(iterator);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (iterator == null) {
                        throw new ExceptionFileFormatOrSyntax("No RNA could be parsed from file '" + this._inFile + "'.");
                    }
                } else {
                    iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        RNA serializable2 = (RNA)iterator.next();
                        arrayList.add(new FullBackup(serializable2, this._inFile));
                    }
                }
            } else {
                serializable = new RNA();
                ((RNA)serializable).setRNA(this.getParameterValue("sequenceDBN", ""), this.getParameterValue("structureDBN", ""));
                arrayList.add(new FullBackup((RNA)serializable, "From Params"));
            }
            if (!this._outFile.equals("")) {
                int n = 1;
                for (FullBackup fullBackup : arrayList) {
                    vARNAConfigLoader.setRNA(fullBackup.rna);
                    ArrayList<VARNAPanel> arrayList2 = vARNAConfigLoader.createVARNAPanels();
                    if (arrayList2.size() > 0) {
                        VARNAPanel vARNAPanel = arrayList2.get(0);
                        if (fullBackup.hasConfig()) {
                            vARNAPanel.setConfig(fullBackup.config);
                        }
                        RNA rNA = vARNAPanel.getRNA();
                        Rectangle2D.Double double_ = vARNAPanel.getRNA().getBBox();
                        if (this._outFile.toLowerCase().endsWith(".jpeg") || this._outFile.toLowerCase().endsWith(".jpg") || this._outFile.toLowerCase().endsWith(".png")) {
                            vARNAPanel.setTitleFontSize((int)(this._scale * (double)vARNAPanel.getTitleFont().getSize()));
                            vARNAPanel.setSize((int)((double)this._baseWidth * this._scale), (int)(this._scale * (double)this._baseWidth * double_.height / double_.width));
                        }
                        if (this._outFile.toLowerCase().endsWith(".eps")) {
                            rNA.saveRNAEPS(this.formatOutputPath(this._outFile, n, arrayList.size()), vARNAPanel.getConfig());
                        } else if (this._outFile.toLowerCase().endsWith(".xfig") || this._outFile.toLowerCase().endsWith(".fig")) {
                            rNA.saveRNAXFIG(this.formatOutputPath(this._outFile, n, arrayList.size()), vARNAPanel.getConfig());
                        } else if (this._outFile.toLowerCase().endsWith(".svg")) {
                            rNA.saveRNASVG(this.formatOutputPath(this._outFile, n, arrayList.size()), vARNAPanel.getConfig());
                        } else if (this._outFile.toLowerCase().endsWith(".jpeg") || this._outFile.toLowerCase().endsWith(".jpg")) {
                            this.saveToJPEG(this.formatOutputPath(this._outFile, n, arrayList.size()), vARNAPanel);
                        } else if (this._outFile.toLowerCase().endsWith(".png")) {
                            this.saveToPNG(this.formatOutputPath(this._outFile, n, arrayList.size()), vARNAPanel);
                        } else if (this._outFile.toLowerCase().endsWith(".varna")) {
                            vARNAPanel.saveSession(this.formatOutputPath(this._outFile, n, arrayList.size()));
                        } else {
                            this.errorExit("Unknown extension for output file \"" + this._outFile + "\"");
                        }
                    }
                    ++n;
                }
            } else {
                serializable = new VARNAGUI();
                ((JFrame)serializable).setDefaultCloseOperation(3);
                ((Window)serializable).pack();
                ((Window)serializable).setVisible(true);
                for (FullBackup fullBackup : arrayList) {
                    RNA rNA = fullBackup.rna;
                    vARNAConfigLoader.setRNA(rNA);
                    ArrayList<VARNAPanel> arrayList3 = vARNAConfigLoader.createVARNAPanels();
                    if (arrayList3.size() <= 0) continue;
                    VARNAPanel vARNAPanel = arrayList3.get(0);
                    VARNAConfig vARNAConfig = vARNAPanel.getConfig();
                    if (fullBackup.hasConfig()) {
                        vARNAConfig = fullBackup.config;
                    }
                    RNA rNA2 = vARNAPanel.getRNA();
                    ((VARNAGUI)serializable).addRNA(rNA2, vARNAConfig);
                }
            }
        }
        catch (ExceptionWritingForbidden exceptionWritingForbidden) {
            exceptionWritingForbidden.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionJPEGEncoding exceptionJPEGEncoding) {
            exceptionJPEGEncoding.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionParameterError exceptionParameterError) {
            exceptionParameterError.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionModeleStyleBaseSyntaxError exceptionModeleStyleBaseSyntaxError) {
            exceptionModeleStyleBaseSyntaxError.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            exceptionNonEqualLength.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
            exceptionUnmatchedClosingParentheses.printStackTrace();
            System.exit(1);
        }
        catch (ExceptionExportFailed exceptionExportFailed) {
            exceptionExportFailed.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionPermissionDenied exceptionPermissionDenied) {
            exceptionPermissionDenied.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionLoadingFailed exceptionLoadingFailed) {
            exceptionLoadingFailed.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            exceptionFileFormatOrSyntax.setPath(this._inFile);
            exceptionFileFormatOrSyntax.printStackTrace();
            throw new ExitCode(1, "");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ExitCode(1, "Error: Missing input file \"" + this._inFile + "\".");
        }
        if (!this._outFile.equals("")) {
            throw new ExitCode(0, "");
        }
    }

    public void saveToJPEG(String string, VARNAPanel vARNAPanel) throws ExceptionJPEGEncoding, ExceptionExportFailed {
        BufferedImage bufferedImage = new BufferedImage(Math.round(vARNAPanel.getWidth()), Math.round(vARNAPanel.getHeight()), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        vARNAPanel.paintComponent(graphics2D);
        try {
            FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(new File(string));
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("jpeg").next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            imageWriteParam.setCompressionMode(2);
            imageWriteParam.setCompressionQuality(this._quality);
            imageWriter.setOutput(fileImageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
            imageWriter.write(null, iIOImage, imageWriteParam);
            fileImageOutputStream.close();
        }
        catch (IOException iOException) {
            throw new ExceptionExportFailed(iOException.getMessage(), string);
        }
    }

    public void saveToPNG(String string, VARNAPanel vARNAPanel) throws ExceptionExportFailed {
        BufferedImage bufferedImage = new BufferedImage(Math.round(vARNAPanel.getWidth()), Math.round(vARNAPanel.getHeight()), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        vARNAPanel.paintComponent(graphics2D);
        graphics2D.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        try {
            VARNAcmd vARNAcmd = new VARNAcmd(vector);
            vARNAcmd.run();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ExitCode exitCode) {
            System.err.println(exitCode.getExitMessage());
            System.exit(exitCode.getExitCode());
        }
    }

    public class ExitCode
    extends Exception {
        private static final long serialVersionUID = -3011196062868355584L;
        private int _c;
        private String _msg;

        public ExitCode(int n, String string) {
            this._c = n;
            this._msg = string;
        }

        public int getExitCode() {
            return this._c;
        }

        public String getExitMessage() {
            return this._msg;
        }
    }
}

