/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.SessionFileWatcherElement;
import uk.ac.vamsas.client.simpleclient.SimpleClient;
import uk.ac.vamsas.client.simpleclient.VamsasFileWatcherElement;
import uk.ac.vamsas.client.simpleclient.VamsasFileWatcherThread;
import uk.ac.vamsas.client.simpleclient.VamsasSession;
import uk.ac.vamsas.client.simpleclient.WatcherCallBack;
import uk.ac.vamsas.client.simpleclient.WatcherElement;

public class EventGeneratorThread {
    private static Log log = LogFactory.getLog((Class)EventGeneratorThread.class);
    private SimpleClient client;
    private Hashtable handlers;
    private VamsasSession session;
    protected VamsasFileWatcherThread watchThread = null;
    protected SessionFileWatcherElement clientfile = null;
    protected VamsasFileWatcherElement vamsasfile = null;
    protected SessionFileWatcherElement storeFile = null;
    boolean ownsf = false;
    long POLL_UNIT = 20L;
    private boolean block_document_updates = false;
    int STORE_WAIT = 5;
    private boolean in_want_to_store_phase = false;

    EventGeneratorThread(VamsasSession s, SimpleClient _client, Hashtable eventhandlers) {
        if (eventhandlers == null || s == null || _client == null) {
            throw new Error("Null arguments to EventGeneratorThread constructor.");
        }
        this.handlers = eventhandlers;
        this.session = s;
        this.client = _client;
        log.debug((Object)"Creating VamsasFileWatcherThread.");
        this.watchThread = new VamsasFileWatcherThread(this);
        this.initWatchers();
    }

    private void initWatchers() {
        if (this.clientfile == null) {
            log.debug((Object)"Initializing clientfile Watcher");
            this.clientfile = this.session.getClientWatcherElement();
            this.watchThread.addElement(this.clientfile);
        }
        final EventGeneratorThread evgen = this;
        if (this.vamsasfile == null) {
            log.debug((Object)"Initializing VamsasFileWatcher");
            this.vamsasfile = new VamsasFileWatcherElement(this.session.vamArchive, new WatcherCallBack(){

                public boolean handleWatchEvent(WatcherElement watcher, Lock lock) {
                    return evgen.documentChanged(lock);
                }
            });
            this.watchThread.addElement(this.vamsasfile);
        }
        if (this.storeFile == null) {
            this.storeFile = new SessionFileWatcherElement(this.session.getStoreDocFile(), new WatcherCallBack(){

                public boolean handleWatchEvent(WatcherElement watcher, Lock lock) {
                    return evgen.storeDocRequest(lock);
                }
            });
            log.debug((Object)"Initializing storeDocFile flag watcher");
        }
        log.debug((Object)"Watchers inited.");
    }

    boolean _raise(String handlerEvent, String property, Object oldval, Object newval) {
        PropertyChangeSupport h = (PropertyChangeSupport)this.handlers.get(handlerEvent);
        if (h != null) {
            log.debug((Object)("Triggering:" + handlerEvent));
            try {
                h.firePropertyChange(property, oldval, newval);
            }
            catch (Exception e) {
                log.warn((Object)("Client Exception during handling of " + handlerEvent), (Throwable)e);
                return false;
            }
            catch (Error e) {
                log.error((Object)("Serious! Client Error during handling of " + handlerEvent), (Throwable)e);
                return false;
            }
            log.debug((Object)("Finished  :" + handlerEvent));
        } else {
            log.debug((Object)("No handlers for raised " + handlerEvent));
        }
        return true;
    }

    protected boolean storeDocRequest(Lock lock) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("StoreDocRequest on " + (lock == null ? (lock.isLocked() ? "" : "Invalid ") : "Non-") + "Existing lock"));
        }
        if (this.storeFile.getWatcher().exists) {
            this._raise("uk.ac.vamsas.client.events.DocumentFinalizeAppData", this.client.getSessionUrn(), null, this.client);
            this.vamsasfile.getWatcher().setState();
            lock.release();
        }
        return true;
    }

    protected boolean documentChanged(Lock doclock) {
        boolean continueWatching = true;
        if (!this.block_document_updates) {
            this.session.vamArchive.fileLock = doclock;
            if (this.client.pickmanager != null) {
                this.client.pickmanager.setPassThru(false);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initiating a documentChanged event. Document is " + (this.client.cdocument == null ? "closed" : "open")));
            }
            if (!this._raise("uk.ac.vamsas.client.events.documentUpdateEvent", this.client.getSessionUrn(), null, this.client)) {
                log.info((Object)"Recovering from errors or exceptions generated by client application");
                if (this.client.cdocument != null) {
                    try {
                        this.client.tidyAwaySessionDocumentState();
                    }
                    catch (Exception e) {
                        log.warn((Object)"Exception generated by vamsas library - when tidying away session document:", (Throwable)e);
                    }
                    catch (Error e) {
                        log.error((Object)"LIBRARY Implementation error - when tidying away session document:", (Throwable)e);
                    }
                }
            }
            if (this.client.pickmanager != null) {
                this.client.pickmanager.setPassThru(true);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished handling a documentChanged event. Document is " + (this.client.cdocument == null ? "closed" : "open")));
            }
            if (this.client.cdocument != null) {
                log.warn((Object)"Implementation Error ?  ClientDocument instance has not been closed or updated by handler!");
            }
        } else {
            log.debug((Object)("Ignoring documentChanged event for " + this.client.getSessionUrn()));
        }
        return continueWatching;
    }

    private boolean clientListChanged(WatcherElement clientfile, Lock watchlock) {
        log.debug((Object)("ClientListChanged handler called for " + clientfile.getWatcher().getSubject()));
        if (watchlock != null) {
            watchlock.release();
        }
        return true;
    }

    protected void wait(int u) {
        if (u <= 0) {
            u = 1;
        }
        long l = System.currentTimeMillis() + this.POLL_UNIT * (long)u;
        while (System.currentTimeMillis() < l) {
        }
    }

    protected Lock want_to_store() {
        if (this.in_want_to_store_phase) {
            log.error((Object)"client error: want_to_store called again before first call has completed.");
            return null;
        }
        this.in_want_to_store_phase = true;
        log.debug((Object)"Stopping document_update watcher");
        this.vamsasfile.haltWatch();
        log.debug((Object)"Cleared flag for ignoring document_update requests");
        log.debug((Object)"Sending Store Document Request");
        try {
            this.session.addStoreDocumentRequest(this.client.getClientHandle(), this.client.getUserHandle());
        }
        catch (Exception e) {
            log.warn((Object)("Whilst writing StoreDocumentRequest for " + this.client.getClientHandle().getClientUrn() + " " + this.client.getUserHandle()), (Throwable)e);
            log.info((Object)"trying to continue after storeDocumentRequest exception.");
        }
        log.debug((Object)"Waiting for other apps to do FinalizeApp handling.");
        FileWatcher sfwatcher = this.session.getStoreWatcher();
        FileWatcher vfwatcher = this.session.getDocWatcher();
        int units = 0;
        while (units < this.STORE_WAIT) {
            try {
                Thread.sleep(this.watchThread.WATCH_SLEEP);
            }
            catch (InterruptedException e) {
                log.debug((Object)"interrupted.");
            }
            if (sfwatcher.hasChanged() || vfwatcher.hasChanged()) {
                units = 0;
                continue;
            }
            ++units;
        }
        this.block_document_updates = false;
        this.vamsasfile.enableWatch();
        log.debug((Object)"Cleared flag for ignoring document_update requests");
        while (units < this.STORE_WAIT) {
            try {
                Thread.sleep(this.watchThread.WATCH_SLEEP);
            }
            catch (InterruptedException e) {
                log.debug((Object)"interrupted.");
            }
            if (sfwatcher.hasChanged() || vfwatcher.hasChanged()) {
                units = 0;
                continue;
            }
            ++units;
        }
        log.debug((Object)"finished waiting.");
        this.in_want_to_store_phase = false;
        return this.session.vamArchive.getLock();
    }

    protected int countHandlersFor(String event) {
        PropertyChangeSupport handler;
        if (this.handlers.containsKey(event) && (handler = (PropertyChangeSupport)this.handlers.get(event)) != null) {
            PropertyChangeListener[] listeners = handler.getPropertyChangeListeners();
            return listeners == null ? -1 : listeners.length;
        }
        return -1;
    }

    public void disableDocumentWatch() {
        this.vamsasfile.haltWatch();
    }

    public boolean isDocumentWatchEnabled() {
        return this.vamsasfile != null && this.vamsasfile.isWatchEnabled();
    }

    public void enableDocumentWatch() {
        this.vamsasfile.enableWatch();
    }

    public boolean isWatcherAlive() {
        return this.watchThread != null && this.watchThread.running && this.watchThread.isAlive();
    }

    public void interruptWatching() {
        if (this.watchThread != null && this.watchThread.isAlive()) {
            this.watchThread.interrupt();
        }
    }

    public void startWatching() {
        this.enableDocumentWatch();
        this.watchThread.start();
        while (!this.watchThread.running && this.watchThread.isAlive()) {
            log.debug((Object)"Waiting until watcher is really started.");
        }
    }

    public void stopWatching() {
        this.interruptWatching();
        this.watchThread.haltWatchers();
    }
}

