/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.seqfetcher;

import jalview.api.FeatureSettingsModelI;
import jalview.datamodel.AlignmentI;
import jalview.io.DataSourceType;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.io.IdentifyFile;
import jalview.ws.seqfetcher.DbSourceProxy;

public abstract class DbSourceProxyImpl
implements DbSourceProxy {
    boolean queryInProgress = false;
    protected StringBuffer results = null;

    @Override
    public StringBuffer getRawRecords() {
        return this.results;
    }

    @Override
    public boolean queryInProgress() {
        return this.queryInProgress;
    }

    protected void startQuery() {
        this.queryInProgress = true;
    }

    protected void stopQuery() {
        this.queryInProgress = false;
    }

    protected AlignmentI parseResult(String result) throws Exception {
        AlignmentI sequences = null;
        FileFormatI format = new IdentifyFile().identify(result, DataSourceType.PASTE);
        if (format != null) {
            sequences = new FormatAdapter().readFile(result.toString(), DataSourceType.PASTE, format);
        }
        return sequences;
    }

    @Override
    public String getAccessionIdFromQuery(String query) {
        String sep = this.getAccessionSeparator();
        if (sep == null) {
            return query;
        }
        int sepPos = query.indexOf(sep);
        return sepPos == -1 ? query : query.substring(0, sepPos);
    }

    @Override
    public int getMaximumQueryCount() {
        return 1;
    }

    @Override
    public boolean isDnaCoding() {
        return false;
    }

    @Override
    public boolean isAlignmentSource() {
        return false;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return null;
    }
}

