/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import uk.ac.vamsas.client.simpleclient.Lock;

public class VamsasArchiveReader {
    private static final int JARFILE_OPEN_RETRIES = 50;
    private static final int JARFILE_OPEN_RETRYWAIT = 1;
    private static Log log = LogFactory.getLog((Class)VamsasArchiveReader.class);
    ZipFile jfile = null;
    String jfileName = "randomAccessFile";
    boolean stream = false;
    RandomAccessFile rfile;
    Hashtable strmentries = null;
    public static final String DOCUMENT_VERSION = "beta";
    public static final String VAMSASDOC = "vamsasDocument.xml";
    public static final String VAMSASXML = "vamsas.xml";

    private void streamInit() {
        if (!this.stream) {
            log.debug((Object)"Skipping init for Jar Stream input.");
            return;
        }
        throw new Error("Implementation error - we don't do streams - only files or RA files");
    }

    public VamsasArchiveReader(File vamsasfile) {
        int retries = 50;
        Exception ex = null;
        if (vamsasfile.exists()) {
            while (this.jfile == null && --retries > 0) {
                try {
                    this.jfile = new ZipFile(vamsasfile);
                    this.jfileName = vamsasfile.toString();
                }
                catch (Exception e) {
                    ex = e;
                    this.jfile = null;
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception w) {}
                }
            }
            if (this.jfile == null && ex != null) {
                log.debug((Object)("non-serious? Exceptions when opening JarFile at " + vamsasfile), (Throwable)ex);
            }
        }
    }

    public VamsasArchiveReader(Lock vamsaslock) {
        if (vamsaslock == null || !vamsaslock.isLocked()) {
            throw new Error("IMPLEMENTATION ERROR: Cannot create a VamsasArchiveReader without a valid lock.");
        }
        try {
            this.rfile = vamsaslock.getRaFile();
            this.jfile = new ZipFile(this.rfile);
            if (vamsaslock.target != null) {
                this.jfileName = vamsaslock.target.toString();
            }
        }
        catch (Exception e) {
            this.rfile = null;
            this.jfile = null;
            log.warn((Object)("Unexpected IO Exception when accessing locked vamsas archive stream " + vamsaslock.target), (Throwable)e);
        }
    }

    protected ZipEntry getVamsasDocumentEntry() {
        return this.getJarEntry(VAMSASDOC);
    }

    protected ZipEntry getVamsasXmlEntry() {
        return this.getJarEntry(VAMSASXML);
    }

    public boolean isValid() {
        if (this.jfile != null) {
            return this.getVamsasDocumentEntry() != null;
        }
        return false;
    }

    protected ZipEntry getAppdataEntry(String AppdataRef) {
        ZipEntry entry;
        if (this.jfile == null || !this.isValid() || (entry = this.getJarEntry(AppdataRef)) == null) {
            return null;
        }
        return entry;
    }

    public InputStream getAppdataStream(String AppdataRef) {
        ZipEntry entry = this.getAppdataEntry(AppdataRef);
        try {
            if (entry != null) {
                return this.getInputStream(entry);
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed when opening AppdataStream for " + AppdataRef), (Throwable)e);
        }
        return null;
    }

    public InputStream getVamsasDocumentStream() {
        InputStream vdoc;
        if (this.jfile == null || !this.isValid()) {
            return null;
        }
        try {
            vdoc = this.getInputStream(this.getVamsasDocumentEntry());
        }
        catch (IOException e) {
            log.error((Object)"Whilst geting document stream", (Throwable)e);
            vdoc = null;
        }
        return vdoc;
    }

    public InputStream getVamsasXmlStream() {
        InputStream vdoc;
        ZipEntry xmle = this.getVamsasXmlEntry();
        if (xmle == null) {
            return null;
        }
        try {
            vdoc = this.getInputStream(xmle);
        }
        catch (IOException e) {
            log.error((Object)"Whilst getting VamsasXmlStream", (Throwable)e);
            vdoc = null;
        }
        return vdoc;
    }

    public void close() {
        if (this.jfile != null) {
            try {
                this.jfile.close();
                this.rfile = null;
            }
            catch (Exception e) {
                log.error((Object)("Whilst closing JarFile " + this.jfileName), (Throwable)e);
            }
        }
    }

    public Vector getExtraEntries() {
        if (this.jfile == null || !this.isValid()) {
            return null;
        }
        Vector<String> e = new Vector<String>();
        Enumeration entries = this.jfile.getEntries();
        if (entries != null && entries.hasMoreElements()) {
            do {
                ZipEntry el;
                if ((el = (ZipEntry)entries.nextElement()).getName().equals(VAMSASDOC) || el.getName().equals(VAMSASXML)) continue;
                e.add(new String(el.getName()));
            } while (entries.hasMoreElements());
        }
        return e;
    }

    private InputStream getInputStream(ZipEntry ze) throws IOException {
        if (this.jfile != null) {
            return this.jfile.getInputStream(ze);
        }
        return null;
    }

    private ZipEntry getJarEntry(String name) {
        if (this.jfile != null) {
            return this.jfile.getEntry(name);
        }
        return null;
    }
}

