/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws1;

import ext.vamsas.Jpred;
import ext.vamsas.JpredServiceLocator;
import ext.vamsas.JpredSoapBindingStub;
import ext.vamsas.ServiceHandle;
import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.bin.Console;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.WebserviceInfo;
import jalview.util.MessageManager;
import jalview.ws.jws1.JPredThread;
import jalview.ws.jws1.WS1Client;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class JPredClient
extends WS1Client {
    public JPredClient(ServiceHandle sh, String title, boolean msa, AlignmentView alview, AlignFrame parentFrame, boolean viewonly) {
        this.wsInfo = this.setWebService(sh);
        this.startJPredClient(title, msa, alview, parentFrame, viewonly);
    }

    private void startJPredClient(String title, boolean msa, AlignmentView alview, AlignFrame parentFrame, boolean viewonly) {
        Jpred server;
        AlignmentView input = alview;
        if (this.wsInfo == null) {
            this.wsInfo = this.setWebService();
        }
        if ((server = this.locateWebService()) == null) {
            Console.warn("Couldn't find a Jpred webservice to invoke!");
            return;
        }
        SeqCigar[] msf = null;
        SequenceI seq = null;
        int[] delMap = null;
        msf = input.getSequences();
        seq = msf[0].getSeq('-');
        if (viewonly) {
            delMap = alview.getVisibleContigMapFor(seq.gapMap());
        }
        if (msa && msf.length > 1) {
            String altitle = this.getPredictionName(this.WebServiceName) + " on " + (viewonly ? "visible " : "") + seq.getName() + " using alignment from " + title;
            SequenceI[] aln = new SequenceI[msf.length];
            int j = msf.length;
            for (int i = 0; i < j; ++i) {
                aln[i] = msf[i].getSeq('-');
            }
            Hashtable SequenceInfo = SeqsetUtils.uniquify(aln, true);
            if (viewonly) {
                String[] seqs = alview.getSequenceStrings('-');
                int j2 = msf.length;
                for (int i = 0; i < j2; ++i) {
                    aln[i].setSequence(seqs[i]);
                }
                seq.setSequence(seqs[0]);
            }
            this.wsInfo.setProgressText("Job details for " + (viewonly ? "visible " : "") + "MSA based prediction (" + title + ") on sequence :\n>" + seq.getName() + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
            JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, SequenceInfo, aln, delMap, alview, parentFrame, this.WsURL);
            this.wsInfo.setthisService(jthread);
            jthread.start();
        } else {
            if (!msa && msf.length > 1) {
                throw new Error(MessageManager.getString("error.implementation_error_multiple_single_sequence_prediction_jobs_not_supported"));
            }
            String altitle = this.getPredictionName(this.WebServiceName) + " for " + (viewonly ? "visible " : "") + "sequence " + seq.getName() + " from " + title;
            String seqname = seq.getName();
            Hashtable SequenceInfo = SeqsetUtils.SeqCharacterHash(seq);
            if (viewonly) {
                String[] seqs = alview.getSequenceStrings('-');
                seq.setSequence(seqs[0]);
            }
            this.wsInfo.setProgressText("Job details for prediction on " + (viewonly ? "visible " : "") + "sequence :\n>" + seqname + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
            JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, this.WsURL, SequenceInfo, seq, delMap, alview, parentFrame);
            this.wsInfo.setthisService(jthread);
            jthread.start();
        }
    }

    private String getPredictionName(String webServiceName) {
        if (webServiceName.toLowerCase(Locale.ROOT).indexOf("secondary structure prediction") > -1) {
            return webServiceName;
        }
        return webServiceName + "secondary structure prediction";
    }

    public JPredClient(ServiceHandle sh, String title, SequenceI seq, AlignFrame parentFrame) {
        this.wsInfo = this.setWebService(sh);
        this.startJPredClient(title, seq, parentFrame);
    }

    public JPredClient(ServiceHandle sh, String title, SequenceI[] msa, AlignFrame parentFrame) {
        this.wsInfo = this.setWebService(sh);
        this.startJPredClient(title, msa, parentFrame);
    }

    public JPredClient(String title, SequenceI[] msf) {
        this.startJPredClient(title, msf, null);
    }

    public JPredClient(String title, SequenceI seq) {
        this.startJPredClient(title, seq, null);
    }

    public JPredClient() {
    }

    private void startJPredClient(String title, SequenceI[] msf, AlignFrame parentFrame) {
        if (this.wsInfo == null) {
            this.wsInfo = this.setWebService();
        }
        SequenceI seq = msf[0];
        String altitle = "JPred prediction on " + seq.getName() + " using alignment from " + title;
        this.wsInfo.setProgressText("Job details for MSA based prediction (" + title + ") on sequence :\n>" + seq.getName() + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
        SequenceI[] aln = new SequenceI[msf.length];
        int j = msf.length;
        for (int i = 0; i < j; ++i) {
            aln[i] = new Sequence(msf[i]);
        }
        Hashtable SequenceInfo = SeqsetUtils.uniquify(aln, true);
        Jpred server = this.locateWebService();
        if (server == null) {
            return;
        }
        JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, SequenceInfo, aln, null, null, parentFrame, this.WsURL);
        this.wsInfo.setthisService(jthread);
        jthread.start();
    }

    public void startJPredClient(String title, SequenceI seq, AlignFrame parentFrame) {
        if (this.wsInfo == null) {
            this.wsInfo = this.setWebService();
        }
        this.wsInfo.setProgressText("Job details for prediction on sequence :\n>" + seq.getName() + "\n" + AlignSeq.extractGaps("-. ", seq.getSequenceAsString()) + "\n");
        String altitle = "JPred prediction for sequence " + seq.getName() + " from " + title;
        Hashtable SequenceInfo = SeqsetUtils.SeqCharacterHash(seq);
        Jpred server = this.locateWebService();
        if (server == null) {
            return;
        }
        JPredThread jthread = new JPredThread(this.wsInfo, altitle, server, this.WsURL, SequenceInfo, seq, null, null, parentFrame);
        this.wsInfo.setthisService(jthread);
        jthread.start();
    }

    private WebserviceInfo setWebService() {
        this.WebServiceName = "JNetWS";
        this.WebServiceJobTitle = MessageManager.getString("label.jnet_secondary_structure_prediction");
        this.WebServiceReference = "\"Cuff J. A and Barton G.J (2000) Application of multiple sequence alignment profiles to improve protein secondary structure prediction, Proteins 40:502-511\".";
        this.WsURL = "http://www.compbio.dundee.ac.uk/JalviewWS/services/jpred";
        WebserviceInfo wsInfo = new WebserviceInfo(this.WebServiceJobTitle, this.WebServiceReference, true);
        return wsInfo;
    }

    private Jpred locateWebService() {
        JpredServiceLocator loc = new JpredServiceLocator();
        Jpred server = null;
        try {
            server = loc.getjpred(new URL(this.WsURL));
            ((JpredSoapBindingStub)server).setTimeout(60000);
        }
        catch (Exception ex) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.secondary_structure_prediction_service_couldnt_be_located", new String[]{this.WebServiceName, this.WsURL}), MessageManager.getString("label.internal_jalview_error"), 2);
            this.wsInfo.setProgressText(MessageManager.formatMessage("label.secondary_structure_prediction_service_couldnt_be_located", new String[]{this.WebServiceName, this.WsURL}) + "\n" + ex.getMessage());
            this.wsInfo.setStatus(5);
        }
        return server;
    }

    @Override
    public void attachWSMenuEntry(JMenu wsmenu, final ServiceHandle sh, final AlignFrame af) {
        JMenuItem method = new JMenuItem(sh.getName());
        method.setToolTipText(sh.getEndpointURL());
        method.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignmentView msa = af.gatherSeqOrMsaForSecStrPrediction();
                if (msa.getSequences().length == 1) {
                    new JPredClient(sh, af.getTitle(), false, msa, af, true);
                } else if (msa.getSequences().length > 1) {
                    new JPredClient(sh, af.getTitle(), true, msa, af, true);
                }
            }
        });
        wsmenu.add(method);
    }
}

