/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.StockholmFile;
import jalview.util.Format;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClustalFile
extends AlignFile {
    public ClustalFile() {
    }

    public ClustalFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public ClustalFile(FileParse source) throws IOException {
        super(source);
    }

    @Override
    public void initData() {
        super.initData();
    }

    @Override
    public void parse() throws IOException {
        int i = 0;
        boolean flag = false;
        boolean top = false;
        StringBuffer pssecstr = new StringBuffer();
        StringBuffer consstr = new StringBuffer();
        Vector<String> headers = new Vector<String>();
        HashMap<String, StringBuffer> seqhash = new HashMap<String, StringBuffer>();
        try {
            String line;
            while ((line = this.nextLine()) != null) {
                boolean isConservation;
                if (line.length() == 0) {
                    top = true;
                }
                boolean bl = isConservation = line.startsWith(" ") || line.startsWith("\t");
                if (!isConservation) {
                    StringTokenizer str = new StringTokenizer(line);
                    if (str.hasMoreTokens()) {
                        StringBuffer tempseq;
                        String id = str.nextToken();
                        if (id.equalsIgnoreCase("CLUSTAL")) {
                            flag = true;
                            continue;
                        }
                        if (!flag) continue;
                        if (seqhash.containsKey(id)) {
                            tempseq = (StringBuffer)seqhash.get(id);
                        } else {
                            tempseq = new StringBuffer();
                            seqhash.put(id, tempseq);
                        }
                        if (!headers.contains(id)) {
                            headers.addElement(id);
                        }
                        if (str.hasMoreTokens()) {
                            tempseq.append(str.nextToken());
                        }
                        top = false;
                        continue;
                    }
                    flag = true;
                    continue;
                }
                if (!line.matches("\\s+(-|\\.|\\(|\\[|\\]|\\))+")) continue;
                if (top) {
                    pssecstr.append(line.trim());
                    continue;
                }
                consstr.append(line.trim());
            }
        }
        catch (IOException e) {
            Console.errPrintln("Exception parsing clustal file " + e);
            e.printStackTrace();
        }
        if (flag) {
            AlignmentAnnotation ssa;
            Vector<AlignmentAnnotation> ss;
            this.noSeqs = headers.size();
            for (i = 0; i < headers.size(); ++i) {
                if (seqhash.get(headers.elementAt(i)) != null) {
                    if (this.maxLength < ((StringBuffer)seqhash.get(headers.elementAt(i))).toString().length()) {
                        this.maxLength = ((StringBuffer)seqhash.get(headers.elementAt(i))).toString().length();
                    }
                    Sequence newSeq = this.parseId(((String)headers.elementAt(i)).toString());
                    newSeq.setSequence(((StringBuffer)seqhash.get(((String)headers.elementAt(i)).toString())).toString());
                    this.seqs.addElement(newSeq);
                    continue;
                }
                Console.errPrintln("Clustal File Reader: Can't find sequence for " + (String)headers.elementAt(i));
            }
            AlignmentAnnotation lastssa = null;
            if (pssecstr.length() == this.maxLength) {
                ss = new Vector<AlignmentAnnotation>();
                ssa = lastssa = StockholmFile.parseAnnotationRow(ss, "secondary structure", pssecstr.toString());
                ssa.label = "Secondary Structure";
                this.annotations.addElement(ssa);
            }
            if (consstr.length() == this.maxLength) {
                ss = new Vector();
                ssa = StockholmFile.parseAnnotationRow(ss, "secondary structure", consstr.toString());
                ssa.label = "Consensus Secondary Structure";
                if (lastssa == null || !lastssa.getRNAStruc().equals(ssa.getRNAStruc().replace('-', '.'))) {
                    this.annotations.addElement(ssa);
                }
            }
        }
    }

    @Override
    public String print(SequenceI[] s, boolean jvsuffix) {
        int i;
        StringBuffer out = new StringBuffer("CLUSTAL" + this.newline + this.newline);
        int max = 0;
        int maxid = 0;
        for (i = 0; i < s.length && s[i] != null; ++i) {
            String tmp = this.printId(s[i], jvsuffix);
            max = Math.max(max, s[i].getLength());
            if (tmp.length() <= maxid) continue;
            maxid = tmp.length();
        }
        if (maxid < 15) {
            maxid = 15;
        }
        ++maxid;
        int len = 60;
        int nochunks = max / len + (max % len > 0 ? 1 : 0);
        for (i = 0; i < nochunks; ++i) {
            for (int j = 0; j < s.length && s[j] != null; ++j) {
                out.append(new Format("%-" + maxid + "s").form(this.printId(s[j], jvsuffix) + " "));
                int chunkStart = i * len;
                int chunkEnd = chunkStart + len;
                int length = s[j].getLength();
                if (chunkEnd < length && chunkStart < length) {
                    out.append(s[j].getSequenceAsString(chunkStart, chunkEnd));
                } else if (chunkStart < length) {
                    out.append(s[j].getSequenceAsString().substring(chunkStart));
                }
                out.append(this.newline);
            }
            out.append(this.newline);
        }
        return out.toString();
    }
}

