/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.JvSwingUtils;
import java.awt.Font;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class JalviewBooleanRadioButtons
extends AbstractButton {
    private static final Font LABEL_FONT = JvSwingUtils.getLabelFont();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton buttonTrue = new JRadioButton();
    private JRadioButton buttonFalse = new JRadioButton();

    public JalviewBooleanRadioButtons(boolean value, String trueLabel, String falseLabel) {
        this.init();
        this.setLabels(trueLabel, falseLabel);
    }

    public JalviewBooleanRadioButtons(boolean value) {
        this.init();
        this.setSelected(value);
    }

    public JalviewBooleanRadioButtons() {
        this.init();
    }

    protected void init() {
        this.buttonTrue.setFont(LABEL_FONT);
        this.buttonFalse.setFont(LABEL_FONT);
        this.buttonGroup.add(this.buttonTrue);
        this.buttonGroup.add(this.buttonFalse);
    }

    public void setLabels(String trueLabel, String falseLabel) {
        this.buttonTrue.setText(trueLabel);
        this.buttonFalse.setText(falseLabel);
    }

    @Override
    public void setSelected(boolean b) {
        this.buttonFalse.setSelected(!b);
        this.buttonTrue.setSelected(b);
    }

    @Override
    public boolean isSelected() {
        return this.buttonTrue.isSelected() && !this.buttonFalse.isSelected();
    }

    @Override
    public void setEnabled(boolean b) {
        this.buttonTrue.setEnabled(b);
        this.buttonFalse.setEnabled(b);
    }

    @Override
    public boolean isEnabled() {
        return this.buttonTrue.isEnabled() && this.buttonFalse.isEnabled();
    }

    public JRadioButton getTrueButton() {
        return this.buttonTrue;
    }

    public JRadioButton getFalseButton() {
        return this.buttonFalse;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.buttonTrue.addActionListener(l);
        this.buttonFalse.addActionListener(l);
    }

    public void addTrueActionListener(ActionListener l) {
        this.buttonTrue.addActionListener(l);
    }

    public void addFalseActionListener(ActionListener l) {
        this.buttonFalse.addActionListener(l);
    }
}

