/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.LineartOptions;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.exceptions.ImageOutputException;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.StringUtils;
import jalview.util.imagemaker.BitmapImageSizing;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class ImageExporter {
    private IProgressIndicator messageBoard;
    private ImageWriterI imageWriter;
    ImageMaker.TYPE imageType;
    private String title;

    public ImageExporter(ImageWriterI writer, IProgressIndicator statusBar, ImageMaker.TYPE type, String fileTitle) {
        this.imageWriter = writer;
        this.messageBoard = statusBar;
        this.imageType = type;
        this.title = fileTitle;
    }

    public void doExport(File file, Component parent, int width, int height, String imageSource) throws ImageOutputException {
        this.doExport(file, parent, width, height, imageSource, null, BitmapImageSizing.defaultBitmapImageSizing());
    }

    public void doExport(File file, Component parent, int width, int height, String imageSource, String renderer, BitmapImageSizing userBis) throws ImageOutputException {
        String renderStyle;
        long messageId = System.currentTimeMillis();
        this.setStatus(MessageManager.formatMessage("status.exporting_alignment_as_x_file", new Object[]{this.imageType}), messageId);
        if (file == null && !Jalview.isHeadlessMode()) {
            if (Desktop.instance.isInBatchMode()) {
                throw new ImageOutputException("Need an output file to render to when exporting images in batch mode!");
            }
            JalviewFileChooser chooser = this.imageType.getFileChooser();
            chooser.setFileView(new JalviewFileView());
            MessageManager.formatMessage("label.create_image_of", this.imageType.getName(), imageSource);
            String title = "Create " + this.imageType.getName() + " image from alignment";
            chooser.setDialogTitle(title);
            chooser.setToolTipText(MessageManager.getString("action.save"));
            int value = chooser.showSaveDialog(parent);
            if (value != 0) {
                String msg = MessageManager.formatMessage("status.cancelled_image_export_operation", this.imageType.name);
                this.setStatus(msg, messageId);
                return;
            }
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            file = chooser.getSelectedFile();
        }
        String string = renderStyle = renderer == null ? Cache.getDefault(this.imageType.getName() + "_RENDERING", "Prompt each time") : renderer;
        if (Platform.isJS()) {
            renderStyle = "Text";
        }
        AtomicBoolean textSelected = new AtomicBoolean(!StringUtils.equalsIgnoreCase("lineart", renderStyle));
        if ((this.imageType == ImageMaker.TYPE.EPS || this.imageType == ImageMaker.TYPE.SVG) && StringUtils.equalsIgnoreCase("Prompt each time", renderStyle) && !Jalview.isHeadlessMode()) {
            File chosenFile = file;
            Runnable okAction = () -> this.exportImage(chosenFile, !textSelected.get(), width, height, messageId, userBis);
            LineartOptions epsOption = new LineartOptions(ImageMaker.TYPE.EPS.getName(), textSelected);
            epsOption.setResponseAction(1, () -> this.setStatus(MessageManager.formatMessage("status.cancelled_image_export_operation", this.imageType.getName()), messageId));
            epsOption.setResponseAction(0, okAction);
            epsOption.showDialog();
        } else {
            this.exportImage(file, !textSelected.get(), width, height, messageId, userBis);
        }
    }

    protected void exportImage(File chosenFile, boolean asLineart, int width, int height, long messageId, BitmapImageSizing userBis) {
        String type = this.imageType.getName();
        try {
            ImageMaker im = new ImageMaker(this.imageType, width, height, chosenFile, this.title, asLineart, userBis);
            this.imageWriter.exportImage(im.getGraphics());
            im.writeImage();
            this.setStatus(MessageManager.formatMessage("status.export_complete", type), messageId);
        }
        catch (Exception e) {
            Console.error(String.format("Error creating %s file: %s", type, e.toString()), e);
            this.setStatus(MessageManager.formatMessage("info.error_creating_file", type), messageId);
        }
    }

    void setStatus(String msg, long id) {
        if (this.messageBoard != null && !Jalview.isHeadlessMode()) {
            this.messageBoard.setProgressBar(msg, id);
        }
    }

    public static interface ImageWriterI {
        public void exportImage(Graphics var1) throws Exception;
    }
}

