/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.util.JSONUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ParseException;

class EnsemblFeatures
extends EnsemblRestClient {
    private EnsemblSequenceFetcher.EnsemblFeatureType[] featuresWanted = new EnsemblSequenceFetcher.EnsemblFeatureType[]{EnsemblSequenceFetcher.EnsemblFeatureType.cds, EnsemblSequenceFetcher.EnsemblFeatureType.exon, EnsemblSequenceFetcher.EnsemblFeatureType.variation};

    public EnsemblFeatures() {
    }

    public EnsemblFeatures(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL (features)";
    }

    @Override
    public AlignmentI getSequenceRecords(String query) throws IOException {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add(query);
        SequenceI seq = this.parseFeaturesJson(queries);
        if (seq == null) {
            return null;
        }
        return new Alignment(new SequenceI[]{seq});
    }

    private SequenceI parseFeaturesJson(List<String> queries) {
        Sequence seq = new Sequence("Dummy", "");
        try {
            Iterator rvals = (Iterator)this.getJSON(null, queries, -1, 2, null);
            if (rvals == null) {
                return null;
            }
            while (rvals.hasNext()) {
                try {
                    Map obj = (Map)rvals.next();
                    String type = obj.get("feature_type").toString();
                    int start = Integer.parseInt(obj.get("start").toString());
                    int end = Integer.parseInt(obj.get("end").toString());
                    String source = obj.get("source").toString();
                    String strand = obj.get("strand").toString();
                    Object phase = obj.get("phase");
                    String alleles = JSONUtils.arrayToStringList((List)obj.get("alleles"));
                    String clinSig = JSONUtils.arrayToStringList((List)obj.get("clinical_significance"));
                    if ("variation".equals(type)) {
                        type = "sequence_variant";
                    } else if ("CDS".equalsIgnoreCase(type)) {
                        type = "CDS";
                    }
                    String desc = this.getFirstNotNull(obj, "alleles", "external_name", "id");
                    SequenceFeature sf = new SequenceFeature(type, desc, start, end, source);
                    sf.setStrand("1".equals(strand) ? "+" : "-");
                    if (phase != null) {
                        sf.setPhase(phase.toString());
                    }
                    this.setFeatureAttribute(sf, obj, "id");
                    this.setFeatureAttribute(sf, obj, "Parent");
                    this.setFeatureAttribute(sf, obj, "consequence_type");
                    sf.setValue("alleles", alleles);
                    sf.setValue("clinical_significance", clinSig);
                    seq.addSequenceFeature(sf);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
        return seq;
    }

    protected String getFirstNotNull(Map<String, Object> obj, String ... keys) {
        for (String key : keys) {
            String s;
            Object val = obj.get(key);
            if (val == null) continue;
            String string = s = val instanceof List ? JSONUtils.arrayToStringList((List)val) : val.toString();
            if (s.isEmpty()) continue;
            return s;
        }
        return null;
    }

    protected void setFeatureAttribute(SequenceFeature sf, Map<String, Object> obj, String key) {
        Object object = obj.get(key);
        if (object != null) {
            sf.setValue(key, object.toString());
        }
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        StringBuffer urlstring = new StringBuffer(128);
        urlstring.append(this.getDomain()).append("/overlap/id/").append(ids.get(0));
        urlstring.append("?content-type=" + this.getResponseMimeType());
        urlstring.append("&").append("object_type").append("=").append("Gene");
        for (EnsemblSequenceFetcher.EnsemblFeatureType feature : this.featuresWanted) {
            urlstring.append("&feature=").append(feature.name());
        }
        return new URL(urlstring.toString());
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    @Override
    protected String getRequestMimeType() {
        return "application/json";
    }

    @Override
    protected String getResponseMimeType() {
        return "application/json";
    }

    protected AlignmentI getSequenceRecords(String accId, EnsemblSequenceFetcher.EnsemblFeatureType[] features) throws IOException {
        this.featuresWanted = features;
        return this.getSequenceRecords(accId);
    }
}

