/*
 * Decompiled with CFR 0.152.
 */
package ext.vamsas;

import ext.vamsas.MuscleWS;
import ext.vamsas.MuscleWSService;
import ext.vamsas.MuscleWSSoapBindingStub;
import jalview.util.MessageManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class MuscleWSServiceLocator
extends Service
implements MuscleWSService {
    private String MuscleWS_address = "http://anaplog.compbio.dundee.ac.uk:8080/axis/services/MuscleWS";
    private String MuscleWSWSDDServiceName = "MuscleWS";
    private HashSet ports = null;

    public MuscleWSServiceLocator() {
    }

    public MuscleWSServiceLocator(EngineConfiguration config) {
        super(config);
    }

    @Override
    public String getMuscleWSAddress() {
        return this.MuscleWS_address;
    }

    public String getMuscleWSWSDDServiceName() {
        return this.MuscleWSWSDDServiceName;
    }

    public void setMuscleWSWSDDServiceName(String name) {
        this.MuscleWSWSDDServiceName = name;
    }

    @Override
    public MuscleWS getMuscleWS() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.MuscleWS_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getMuscleWS(endpoint);
    }

    @Override
    public MuscleWS getMuscleWS(URL portAddress) throws ServiceException {
        try {
            MuscleWSSoapBindingStub _stub = new MuscleWSSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getMuscleWSWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setMuscleWSEndpointAddress(String address) {
        this.MuscleWS_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (MuscleWS.class.isAssignableFrom(serviceEndpointInterface)) {
                MuscleWSSoapBindingStub _stub = new MuscleWSSoapBindingStub(new URL(this.MuscleWS_address), this);
                _stub.setPortName(this.getMuscleWSWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException(MessageManager.formatMessage("exception.no_stub_implementation_for_interface", new String[]{serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()}));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("MuscleWS".equals(inputPortName)) {
            return this.getMuscleWS();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("vamsas", "MuscleWSService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("vamsas", "MuscleWS"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"MuscleWS".equals(portName)) {
            throw new ServiceException(MessageManager.formatMessage("exception.cannot_set_endpoint_address_unknown_port", new String[]{portName}));
        }
        this.setMuscleWSEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

