/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.engine.client.Executable;
import compbio.runner.conservation.AACon;
import compbio.runner.disorder.Disembl;
import compbio.runner.disorder.GlobPlot;
import compbio.runner.disorder.IUPred;
import compbio.runner.disorder.Jronn;
import compbio.runner.msa.ClustalO;
import compbio.runner.msa.ClustalW;
import compbio.runner.msa.GLprobs;
import compbio.runner.msa.MSAprobs;
import compbio.runner.msa.Mafft;
import compbio.runner.msa.Muscle;
import compbio.runner.msa.Probcons;
import compbio.runner.msa.Tcoffee;
import compbio.runner.structure.RNAalifold;
import compbio.ws.client.Services;
import java.io.File;

public class ServicesUtil {
    public static Services getServiceByRunner(Class<? extends Executable> class1) {
        assert (class1 != null);
        String sname = class1.getSimpleName().toLowerCase();
        for (Services service : Services.values()) {
            if (!service.toString().toLowerCase().contains(sname)) continue;
            return service;
        }
        return null;
    }

    private static Class<? extends Executable<?>> getServiceImpl(Services service) {
        switch (service) {
            case AAConWS: {
                return AACon.class;
            }
            case ClustalOWS: {
                return ClustalO.class;
            }
            case ClustalWS: {
                return ClustalW.class;
            }
            case MafftWS: {
                return Mafft.class;
            }
            case MuscleWS: {
                return Muscle.class;
            }
            case TcoffeeWS: {
                return Tcoffee.class;
            }
            case ProbconsWS: {
                return Probcons.class;
            }
            case MSAprobsWS: {
                return MSAprobs.class;
            }
            case GLprobsWS: {
                return GLprobs.class;
            }
            case DisemblWS: {
                return Disembl.class;
            }
            case GlobPlotWS: {
                return GlobPlot.class;
            }
            case JronnWS: {
                return Jronn.class;
            }
            case IUPredWS: {
                return IUPred.class;
            }
            case RNAalifoldWS: {
                return RNAalifold.class;
            }
        }
        throw new RuntimeException("Unknown web service implementation class for service: " + (Object)((Object)service));
    }

    public static Class<? extends Executable<?>> getRunnerByJobDirectory(File jobdir) {
        Services service = ServicesUtil.getServiceByRunnerName(ServicesUtil.getRunnerNameByJobDirectory(jobdir));
        return ServicesUtil.getServiceImpl(service);
    }

    private static String getRunnerNameByJobDirectory(File jobdir) {
        String name = jobdir.getName().split("#")[0];
        if (name.startsWith("@")) {
            assert ("@".length() == 1);
            name = name.substring(1);
        }
        return name;
    }

    public static Services getServiceByJobDirectory(File jobdir) {
        return ServicesUtil.getServiceByRunnerName(ServicesUtil.getRunnerNameByJobDirectory(jobdir));
    }

    private static Services getServiceByRunnerName(String name) {
        for (Services service : Services.values()) {
            String runnerName = ServicesUtil.getServiceImpl(service).getSimpleName().toLowerCase();
            if (!(name = name.trim().toLowerCase()).startsWith(runnerName)) continue;
            return service;
        }
        return null;
    }
}

