/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.AccessionID;
import org.biojava.nbio.core.sequence.Strand;
import org.biojava.nbio.core.sequence.io.template.SequenceParserInterface;
import org.biojava.nbio.core.sequence.storage.SequenceAsStringHelper;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.ProxySequenceReader;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.sequence.template.SequenceMixin;
import org.biojava.nbio.core.sequence.template.SequenceProxyView;
import org.biojava.nbio.core.sequence.template.SequenceView;

public class SequenceFileProxyLoader<C extends Compound>
implements ProxySequenceReader<C> {
    SequenceParserInterface sequenceParser;
    private CompoundSet<C> compoundSet;
    private List<C> parsedCompounds = new ArrayList<C>();
    File file;
    long sequenceStartIndex = -1L;
    int sequenceLength = -1;

    public SequenceFileProxyLoader(File file, SequenceParserInterface sequenceParser, long sequenceStartIndex, int sequenceLength, CompoundSet<C> compoundSet) throws IOException, CompoundNotFoundException {
        this.sequenceParser = sequenceParser;
        this.file = file;
        this.sequenceStartIndex = sequenceStartIndex;
        this.sequenceLength = sequenceLength;
        this.setCompoundSet(compoundSet);
        this.init();
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    private boolean init() throws IOException, CompoundNotFoundException {
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        br.skip(this.sequenceStartIndex);
        String sequence = this.sequenceParser.getSequence(br, this.sequenceLength);
        this.setContents(sequence);
        br.close();
        return true;
    }

    @Override
    public void setContents(String sequence) throws CompoundNotFoundException {
        String compoundStr;
        this.parsedCompounds.clear();
        for (int i = 0; i < sequence.length(); i += compoundStr.length()) {
            compoundStr = null;
            Object compound = null;
            for (int compoundStrLength = 1; compound == null && compoundStrLength <= this.compoundSet.getMaxSingleCompoundStringLength(); ++compoundStrLength) {
                compoundStr = sequence.substring(i, i + compoundStrLength);
                compound = this.compoundSet.getCompoundForString(compoundStr);
            }
            if (compound == null) {
                throw new CompoundNotFoundException("Compound " + compoundStr + " not found");
            }
            this.parsedCompounds.add(compound);
        }
    }

    @Override
    public int getLength() {
        return this.sequenceLength;
    }

    @Override
    public C getCompoundAt(int position) {
        return (C)((Compound)this.parsedCompounds.get(position - 1));
    }

    @Override
    public int getIndexOf(C compound) {
        return this.parsedCompounds.indexOf(compound) + 1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        return this.parsedCompounds.lastIndexOf(compound) + 1;
    }

    public String toString() {
        return this.getSequenceAsString();
    }

    @Override
    public String getSequenceAsString() {
        return this.getSequenceAsString(1, this.getLength(), Strand.POSITIVE);
    }

    public String getSequenceAsString(Integer bioBegin, Integer bioEnd, Strand strand) {
        SequenceAsStringHelper<C> sequenceAsStringHelper = new SequenceAsStringHelper<C>();
        return sequenceAsStringHelper.getSequenceAsString(this.parsedCompounds, this.compoundSet, bioBegin, bioEnd, strand);
    }

    @Override
    public List<C> getAsList() {
        return this.parsedCompounds;
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioBegin, Integer bioEnd) {
        return new SequenceProxyView(this, bioBegin, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        return this.parsedCompounds.iterator();
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    @Override
    public AccessionID getAccession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }
}

