/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.ext.ensembl.EnsemblGene;
import jalview.ws.dbsources.EmblCdsSource;
import jalview.ws.dbsources.EmblSource;
import jalview.ws.dbsources.Pdb;
import jalview.ws.dbsources.PfamFull;
import jalview.ws.dbsources.PfamSeed;
import jalview.ws.dbsources.RfamSeed;
import jalview.ws.dbsources.Uniprot;
import jalview.ws.seqfetcher.ASequenceFetcher;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.ArrayList;
import java.util.Collections;

public class SequenceFetcher
extends ASequenceFetcher {
    public SequenceFetcher() {
        this.addDBRefSourceImpl(EnsemblGene.class);
        this.addDBRefSourceImpl(EmblSource.class);
        this.addDBRefSourceImpl(EmblCdsSource.class);
        this.addDBRefSourceImpl(Uniprot.class);
        this.addDBRefSourceImpl(Pdb.class);
        this.addDBRefSourceImpl(PfamFull.class);
        this.addDBRefSourceImpl(PfamSeed.class);
        this.addDBRefSourceImpl(RfamSeed.class);
    }

    public String[] getNonAlignmentSources() {
        String[] srcs = this.getSupportedDb();
        ArrayList<String> src = new ArrayList<String>();
        for (int i = 0; i < srcs.length; ++i) {
            boolean accept = true;
            for (DbSourceProxy dbs : this.getSourceProxy(srcs[i])) {
                if (!dbs.isAlignmentSource()) continue;
                accept = false;
                break;
            }
            if (!accept) continue;
            src.add(srcs[i]);
        }
        Collections.sort(src, String.CASE_INSENSITIVE_ORDER);
        return src.toArray(new String[src.size()]);
    }
}

