/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GUserDefinedColours;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeLoader;
import jalview.schemes.ColourSchemes;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.xml.binding.jalview.JalviewUserColours;
import jalview.xml.binding.jalview.ObjectFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class UserDefinedColours
extends GUserDefinedColours
implements ChangeListener {
    private static final Font VERDANA_BOLD_10 = new Font("Verdana", 1, 10);
    public static final String USER_DEFINED_COLOURS = "USER_DEFINED_COLOURS";
    private static final String LAST_DIRECTORY = "LAST_DIRECTORY";
    private static final int MY_FRAME_HEIGHT = 440;
    private static final int MY_FRAME_WIDTH = 810;
    private static final int MY_FRAME_WIDTH_CASE_SENSITIVE = 970;
    AlignmentPanel ap;
    ColourSchemeI oldColourScheme;
    boolean changedButNotSaved;
    JInternalFrame frame;
    List<JButton> upperCaseButtons;
    List<JButton> lowerCaseButtons;

    public UserDefinedColours(AlignmentPanel alignPanel) {
        this();
        this.lcaseColour.setEnabled(false);
        this.ap = alignPanel;
        this.oldColourScheme = alignPanel.av.getGlobalColourScheme();
        if (this.oldColourScheme instanceof UserColourScheme) {
            this.schemeName.setText(this.oldColourScheme.getSchemeName());
            if (((UserColourScheme)this.oldColourScheme).getLowerCaseColours() != null) {
                this.caseSensitive.setSelected(true);
                this.lcaseColour.setEnabled(true);
                this.resetButtonPanel(true);
            } else {
                this.resetButtonPanel(false);
            }
        } else {
            this.resetButtonPanel(false);
        }
        this.showFrame();
    }

    UserDefinedColours() {
        this.selectedButtons = new ArrayList();
    }

    void showFrame() {
        this.colorChooser.getSelectionModel().addChangeListener(this);
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.user_defined_colours"), 810, 440, true);
    }

    void resetButtonPanel(boolean isCaseSensitive) {
        this.buttonPanel.removeAll();
        if (this.upperCaseButtons == null) {
            this.upperCaseButtons = new ArrayList<JButton>();
        }
        for (int i = 0; i < 20; ++i) {
            String label = isCaseSensitive ? ResidueProperties.aa[i] : ResidueProperties.aa2Triplet.get(ResidueProperties.aa[i]).toString();
            JButton button = this.makeButton(label, ResidueProperties.aa[i], this.upperCaseButtons, i);
            this.buttonPanel.add(button);
        }
        this.buttonPanel.add(this.makeButton("B", "B", this.upperCaseButtons, 20));
        this.buttonPanel.add(this.makeButton("Z", "Z", this.upperCaseButtons, 21));
        this.buttonPanel.add(this.makeButton("X", "X", this.upperCaseButtons, 22));
        this.buttonPanel.add(this.makeButton("Gap", "-", this.upperCaseButtons, 23));
        if (!isCaseSensitive) {
            this.gridLayout.setRows(6);
            this.gridLayout.setColumns(4);
        } else {
            this.gridLayout.setRows(7);
            int cols = 7;
            this.gridLayout.setColumns(cols + 1);
            if (this.lowerCaseButtons == null) {
                this.lowerCaseButtons = new ArrayList<JButton>();
            }
            for (int i = 0; i < 20; ++i) {
                int row = i / cols + 1;
                int index = row * cols + i;
                JButton button = this.makeButton(ResidueProperties.aa[i].toLowerCase(Locale.ROOT), ResidueProperties.aa[i].toLowerCase(Locale.ROOT), this.lowerCaseButtons, i);
                this.buttonPanel.add((Component)button, index);
            }
        }
        if (isCaseSensitive) {
            this.buttonPanel.add(this.makeButton("b", "b", this.lowerCaseButtons, 20));
            this.buttonPanel.add(this.makeButton("z", "z", this.lowerCaseButtons, 21));
            this.buttonPanel.add(this.makeButton("x", "x", this.lowerCaseButtons, 22));
        }
        if (this.frame != null) {
            int newWidth = isCaseSensitive ? 970 : 810;
            this.frame.setSize(newWidth, this.frame.getHeight());
        }
        this.buttonPanel.validate();
        this.validate();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        int i;
        JButton button = null;
        Color newColour = this.colorChooser.getColor();
        if (this.lcaseColour.isSelected()) {
            this.selectedButtons.clear();
            for (i = 0; i < this.lowerCaseButtons.size(); ++i) {
                button = this.lowerCaseButtons.get(i);
                button.setBackground(newColour);
                button.setForeground(ColorUtils.brighterThan(button.getBackground()));
            }
        }
        for (i = 0; i < this.selectedButtons.size(); ++i) {
            button = (JButton)this.selectedButtons.get(i);
            button.setBackground(newColour);
            button.setForeground(ColorUtils.brighterThan(newColour));
        }
        this.changedButNotSaved = true;
    }

    public void colourButtonPressed(MouseEvent e) {
        JButton pressed = (JButton)e.getSource();
        if (e.isShiftDown()) {
            int b;
            JButton end = (JButton)e.getSource();
            JButton start = this.selectedButtons.size() > 0 ? (JButton)this.selectedButtons.get(this.selectedButtons.size() - 1) : (JButton)e.getSource();
            int startIndex = 0;
            int endIndex = 0;
            for (b = 0; b < this.buttonPanel.getComponentCount(); ++b) {
                if (this.buttonPanel.getComponent(b) == start) {
                    startIndex = b;
                }
                if (this.buttonPanel.getComponent(b) != end) continue;
                endIndex = b;
            }
            if (startIndex > endIndex) {
                int temp = startIndex;
                startIndex = endIndex;
                endIndex = temp;
            }
            for (b = startIndex; b <= endIndex; ++b) {
                JButton button = (JButton)this.buttonPanel.getComponent(b);
                if (this.selectedButtons.contains(button)) continue;
                button.setForeground(ColorUtils.brighterThan(button.getBackground()));
                this.selectedButtons.add(button);
            }
        } else if (!e.isControlDown()) {
            for (int b = 0; b < this.selectedButtons.size(); ++b) {
                JButton button = (JButton)this.selectedButtons.get(b);
                button.setForeground(ColorUtils.darkerThan(button.getBackground()));
            }
            this.selectedButtons.clear();
            pressed.setForeground(ColorUtils.brighterThan(pressed.getBackground()));
            this.selectedButtons.add(pressed);
        } else if (e.isControlDown()) {
            if (this.selectedButtons.contains(pressed)) {
                pressed.setForeground(ColorUtils.darkerThan(pressed.getBackground()));
                this.selectedButtons.remove(pressed);
            } else {
                pressed.setForeground(ColorUtils.brighterThan(pressed.getBackground()));
                this.selectedButtons.add(pressed);
            }
        }
        if (this.selectedButtons.size() > 0) {
            this.colorChooser.setColor(((JButton)this.selectedButtons.get(0)).getBackground());
        }
    }

    JButton makeButton(String label, String residue, List<JButton> buttons, int buttonIndex) {
        Color col;
        JButton button;
        if (buttonIndex < buttons.size()) {
            button = buttons.get(buttonIndex);
            col = button.getBackground();
        } else {
            button = new JButton();
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    UserDefinedColours.this.colourButtonPressed(e);
                }
            });
            buttons.add(button);
            col = Color.white;
            if (this.oldColourScheme != null && this.oldColourScheme.isSimple()) {
                col = this.oldColourScheme.findColour(residue.charAt(0), 0, null, null, 0.0f);
            }
        }
        if (this.caseSensitive.isSelected()) {
            button.setMargin(new Insets(2, 2, 2, 2));
        } else {
            button.setMargin(new Insets(2, 14, 2, 14));
        }
        button.setOpaque(true);
        button.setBackground(col);
        button.setText(label);
        button.setForeground(ColorUtils.darkerThan(col));
        button.setFont(VERDANA_BOLD_10);
        return button;
    }

    @Override
    protected void okButton_actionPerformed() {
        if (this.isNoSelectionMade()) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.no_colour_selection_in_scheme"), MessageManager.getString("label.no_colour_selection_warn"), 2);
        } else {
            this.applyButton_actionPerformed();
            this.warnIfUnsavedChanges();
            try {
                this.frame.setClosed(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void warnIfUnsavedChanges() {
        if (!Platform.isJS() && this.changedButNotSaved) {
            String name = this.schemeName.getText().trim();
            if (this.oldColourScheme != null && !"".equals(name) && name.equals(this.oldColourScheme.getSchemeName())) {
                String message = MessageManager.formatMessage("label.scheme_changed", name);
                String title = MessageManager.getString("label.save_changes");
                Object[] options = new String[]{title, MessageManager.getString("label.dont_save_changes")};
                String question = JvSwingUtils.wrapTooltip(true, message);
                int response = JvOptionPane.showOptionDialog((Component)Desktop.desktop, question, title, -1, -1, null, options, (Object)options[0]);
                if (response == 0) {
                    this.savebutton_actionPerformed();
                }
                if (this.changedButNotSaved) {
                    this.schemeName.setText("");
                    this.applyButton_actionPerformed();
                }
            }
        }
    }

    protected boolean isNoSelectionMade() {
        boolean noUpperCaseSelected = this.upperCaseButtons == null || this.upperCaseButtons.isEmpty();
        boolean noLowerCaseSelected = this.caseSensitive.isSelected() && (this.lowerCaseButtons == null || this.lowerCaseButtons.isEmpty());
        boolean noSelectionMade = noUpperCaseSelected || noLowerCaseSelected;
        return noSelectionMade;
    }

    @Override
    protected void applyButton_actionPerformed() {
        if (this.isNoSelectionMade()) {
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.no_colour_selection_in_scheme"), MessageManager.getString("label.no_colour_selection_warn"), 2);
        }
        UserColourScheme ucs = this.getSchemeFromButtons();
        this.ap.alignFrame.changeColour(ucs);
    }

    UserColourScheme getSchemeFromButtons() {
        int i;
        Color[] newColours = new Color[24];
        int length = this.upperCaseButtons.size();
        if (length < 24) {
            i = 0;
            for (JButton jButton : this.upperCaseButtons) {
                newColours[i] = jButton.getBackground();
                ++i;
            }
        } else {
            for (i = 0; i < 24; ++i) {
                JButton button = this.upperCaseButtons.get(i);
                newColours[i] = button.getBackground();
            }
        }
        UserColourScheme ucs = new UserColourScheme(newColours);
        ucs.setName(this.schemeName.getText());
        if (this.caseSensitive.isSelected()) {
            newColours = new Color[23];
            length = this.lowerCaseButtons.size();
            if (length < 23) {
                int i2 = 0;
                for (JButton btn : this.lowerCaseButtons) {
                    newColours[i2] = btn.getBackground();
                    ++i2;
                }
            } else {
                for (int i3 = 0; i3 < 23; ++i3) {
                    JButton jButton = this.lowerCaseButtons.get(i3);
                    newColours[i3] = jButton.getBackground();
                }
            }
            ucs.setLowerCaseColours(newColours);
        }
        return ucs;
    }

    @Override
    protected void loadbutton_actionPerformed() {
        this.upperCaseButtons = new ArrayList<JButton>();
        this.lowerCaseButtons = new ArrayList<JButton>();
        JalviewFileChooser chooser = new JalviewFileChooser("jc", "Jalview User Colours");
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.load_colour_scheme"));
        chooser.setToolTipText(MessageManager.getString("action.load"));
        chooser.setResponseHandler(0, () -> {
            JButton button;
            int i;
            File choice = chooser.getSelectedFile();
            Cache.setProperty(LAST_DIRECTORY, choice.getParent());
            UserColourScheme ucs = ColourSchemeLoader.loadColourScheme(choice.getAbsolutePath());
            Color[] colors = ucs.getColours();
            this.schemeName.setText(ucs.getSchemeName());
            if (ucs.getLowerCaseColours() != null) {
                this.caseSensitive.setSelected(true);
                this.lcaseColour.setEnabled(true);
                this.resetButtonPanel(true);
                for (i = 0; i < this.lowerCaseButtons.size(); ++i) {
                    button = this.lowerCaseButtons.get(i);
                    button.setBackground(ucs.getLowerCaseColours()[i]);
                }
            } else {
                this.caseSensitive.setSelected(false);
                this.lcaseColour.setEnabled(false);
                this.resetButtonPanel(false);
            }
            for (i = 0; i < this.upperCaseButtons.size(); ++i) {
                button = this.upperCaseButtons.get(i);
                button.setBackground(colors[i]);
            }
            this.addNewColourScheme(choice.getPath());
        });
        chooser.showOpenDialog(this);
    }

    public static UserColourScheme loadDefaultColours() {
        UserColourScheme ret = null;
        String colours = Cache.getProperty(USER_DEFINED_COLOURS);
        if (colours != null) {
            if (colours.indexOf("|") > -1) {
                colours = colours.substring(0, colours.indexOf("|"));
            }
            ret = ColourSchemeLoader.loadColourScheme(colours);
        }
        if (ret == null) {
            ret = new UserColourScheme("white");
        }
        return ret;
    }

    @Override
    protected void savebutton_actionPerformed() {
        int reply;
        String name = this.schemeName.getText().trim();
        if (name.length() < 1) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.user_colour_scheme_must_have_name"), MessageManager.getString("label.no_name_colour_scheme"), 2);
        }
        if (!Platform.isJS() && ColourSchemes.getInstance().nameExists(name) && (reply = JvOptionPane.showInternalConfirmDialog((Component)Desktop.desktop, MessageManager.formatMessage("label.colour_scheme_exists_overwrite", name, name), MessageManager.getString("label.duplicate_scheme_name"), 0)) != 0) {
            return;
        }
        JalviewFileChooser chooser = new JalviewFileChooser("jc", "Jalview User Colours");
        JalviewFileView fileView = new JalviewFileView();
        chooser.setFileView(fileView);
        chooser.setDialogTitle(MessageManager.getString("label.save_colour_scheme"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            File file = chooser.getSelectedFile();
            UserColourScheme updatedScheme = this.addNewColourScheme(file.getPath());
            this.saveToFile(file);
            this.changedButNotSaved = false;
            if (this.oldColourScheme != null && name.equals(this.oldColourScheme.getSchemeName())) {
                this.oldColourScheme = updatedScheme;
                this.applyButton_actionPerformed();
            }
        }
    }

    protected UserColourScheme addNewColourScheme(String filePath) {
        String defaultColours = Cache.getDefault(USER_DEFINED_COLOURS, filePath);
        if (defaultColours.indexOf(filePath) == -1) {
            if (defaultColours.length() > 0) {
                defaultColours = defaultColours.concat("|");
            }
            defaultColours = defaultColours.concat(filePath);
        }
        Cache.setProperty(USER_DEFINED_COLOURS, defaultColours);
        UserColourScheme ucs = this.getSchemeFromButtons();
        ColourSchemes.getInstance().registerColourScheme(ucs);
        if (this.ap != null) {
            this.ap.alignFrame.buildColourMenu();
        }
        return ucs;
    }

    protected void saveToFile(File toFile) {
        JalviewUserColours ucs = new JalviewUserColours();
        String name = this.schemeName.getText();
        ucs.setSchemeName(name);
        try {
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(toFile), "UTF-8"));
            for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
                JButton button = (JButton)this.buttonPanel.getComponent(i);
                JalviewUserColours.Colour col = new JalviewUserColours.Colour();
                col.setName(button.getText());
                col.setRGB(Format.getHexString(button.getBackground()));
                ucs.getColour().add(col);
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JalviewUserColours.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.marshal(new ObjectFactory().createJalviewUserColours(ucs), (Writer)out);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void cancelButton_actionPerformed() {
        this.ap.alignFrame.changeColour(this.oldColourScheme);
        this.ap.paintAlignment(true, true);
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void caseSensitive_actionPerformed() {
        boolean selected = this.caseSensitive.isSelected();
        this.resetButtonPanel(selected);
        this.lcaseColour.setEnabled(selected);
    }
}

