/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.ensembl.EnsemblSeqProxy;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.io.gff.SequenceOntologyFactory;
import java.util.ArrayList;
import java.util.List;

public class EnsemblCds
extends EnsemblSeqProxy {
    private static final EnsemblSequenceFetcher.EnsemblFeatureType[] FEATURES_TO_FETCH = new EnsemblSequenceFetcher.EnsemblFeatureType[]{EnsemblSequenceFetcher.EnsemblFeatureType.cds, EnsemblSequenceFetcher.EnsemblFeatureType.exon, EnsemblSequenceFetcher.EnsemblFeatureType.variation};

    public EnsemblCds() {
    }

    public EnsemblCds(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL (CDS)";
    }

    @Override
    protected EnsemblSeqProxy.EnsemblSeqType getSourceEnsemblType() {
        return EnsemblSeqProxy.EnsemblSeqType.CDS;
    }

    @Override
    protected EnsemblSequenceFetcher.EnsemblFeatureType[] getFeaturesToFetch() {
        return FEATURES_TO_FETCH;
    }

    @Override
    protected boolean retainFeature(SequenceFeature sf, String accessionId) {
        if (SequenceOntologyFactory.getInstance().isA(sf.getType(), "CDS")) {
            return false;
        }
        return this.featureMayBelong(sf, accessionId);
    }

    @Override
    protected List<SequenceFeature> getIdentifyingFeatures(SequenceI seq, String accId) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        List<SequenceFeature> sfs = seq.getFeatures().getFeaturesByOntology("CDS");
        for (SequenceFeature sf : sfs) {
            String parentFeature = (String)sf.getValue("Parent");
            if (!accId.equals(parentFeature)) continue;
            result.add(sf);
        }
        return result;
    }

    protected List<int[]> getCdsRanges(SequenceI dnaSeq) {
        int len = dnaSeq.getLength();
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        ranges.add(new int[]{1, len});
        return ranges;
    }
}

