/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumnsCursor;
import jalview.datamodel.HiddenCursorPosition;
import jalview.datamodel.RangeElementsIterator;
import jalview.datamodel.RangeIterator;
import jalview.datamodel.StartRegionIterator;
import jalview.datamodel.VisibleContigsIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class HiddenColumns {
    private static final int HASH_MULTIPLIER = 31;
    private static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private HiddenColumnsCursor cursor = new HiddenColumnsCursor();
    private int numColumns = 0;
    private List<int[]> hiddenColumns = new ArrayList<int[]>();

    public HiddenColumns() {
    }

    public HiddenColumns(HiddenColumns copy) {
        this(copy, Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiddenColumns(HiddenColumns copy, int start, int end, int offset) {
        try {
            LOCK.writeLock().lock();
            if (copy != null) {
                this.numColumns = 0;
                Iterator<int[]> it = copy.getBoundedIterator(start, end);
                while (it.hasNext()) {
                    int[] region = it.next();
                    if (region[0] < start || region[1] > end) continue;
                    this.hiddenColumns.add(new int[]{region[0] - offset, region[1] - offset});
                    this.numColumns += region[1] - region[0] + 1;
                }
                this.cursor = new HiddenColumnsCursor(this.hiddenColumns);
            }
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideColumns(int start, int end) {
        try {
            HiddenCursorPosition cursorPos;
            LOCK.writeLock().lock();
            int previndex = 0;
            int prevHiddenCount = 0;
            int regionindex = 0;
            if (!this.hiddenColumns.isEmpty() && (regionindex = (cursorPos = this.cursor.findRegionForColumn(start, false)).getRegionIndex()) > 0) {
                previndex = regionindex - 1;
                int[] prevRegion = this.hiddenColumns.get(previndex);
                prevHiddenCount = cursorPos.getHiddenSoFar() - (prevRegion[1] - prevRegion[0] + 1);
            }
            if (this.hiddenColumns.isEmpty() || start > this.hiddenColumns.get(this.hiddenColumns.size() - 1)[1]) {
                this.hiddenColumns.add(new int[]{start, end});
                this.numColumns += end - start + 1;
            } else {
                boolean added = false;
                if (regionindex > 0) {
                    added = this.insertRangeAtRegion(regionindex - 1, start, end);
                }
                if (!added && regionindex < this.hiddenColumns.size()) {
                    this.insertRangeAtRegion(regionindex, start, end);
                }
            }
            this.cursor = new HiddenColumnsCursor(this.hiddenColumns, previndex, prevHiddenCount);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    private boolean insertRangeAtRegion(int i, int start, int end) {
        boolean added = false;
        int[] region = this.hiddenColumns.get(i);
        if (end < region[0] - 1) {
            this.hiddenColumns.add(i, new int[]{start, end});
            this.numColumns += end - start + 1;
            added = true;
        } else if (end <= region[1]) {
            int oldstart = region[0];
            region[0] = Math.min(region[0], start);
            this.numColumns += oldstart - region[0];
            added = true;
        } else if (start <= region[1] + 1) {
            this.insertRangeAtOverlap(i, start, end, region);
            added = true;
        }
        return added;
    }

    private void insertRangeAtOverlap(int i, int start, int end, int[] region) {
        int[] nextRegion;
        int endi;
        int oldstart = region[0];
        int oldend = region[1];
        region[0] = Math.min(region[0], start);
        region[1] = Math.max(region[1], end);
        this.numColumns += oldstart - region[0];
        for (endi = i; endi < this.hiddenColumns.size() - 1 && (nextRegion = this.hiddenColumns.get(endi + 1))[0] <= end + 1; ++endi) {
            this.numColumns -= nextRegion[1] - nextRegion[0] + 1;
            region[1] = Math.max(nextRegion[1], end);
        }
        this.numColumns += region[1] - oldend;
        this.hiddenColumns.subList(i + 1, endi + 1).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideList(List<int[]> ranges) {
        try {
            LOCK.writeLock().lock();
            for (int[] r : ranges) {
                this.hideColumns(r[0], r[1]);
            }
            this.cursor = new HiddenColumnsCursor(this.hiddenColumns);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revealAllHiddenColumns(ColumnSelection sel) {
        try {
            LOCK.writeLock().lock();
            for (int[] region : this.hiddenColumns) {
                for (int j = region[0]; j < region[1] + 1; ++j) {
                    sel.addElement(j);
                }
            }
            this.hiddenColumns.clear();
            this.cursor = new HiddenColumnsCursor(this.hiddenColumns);
            this.numColumns = 0;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revealHiddenColumns(int start, ColumnSelection sel) {
        try {
            int[] region;
            int regionIndex;
            LOCK.writeLock().lock();
            if (!this.hiddenColumns.isEmpty() && (regionIndex = this.cursor.findRegionForColumn(start, false).getRegionIndex()) != -1 && regionIndex != this.hiddenColumns.size() && start == (region = this.hiddenColumns.get(regionIndex))[0]) {
                for (int j = region[0]; j < region[1] + 1; ++j) {
                    sel.addElement(j);
                }
                int colsToRemove = region[1] - region[0] + 1;
                this.hiddenColumns.remove(regionIndex);
                this.numColumns -= colsToRemove;
            }
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String regionsToString(String delimiter, String between) {
        try {
            LOCK.readLock().lock();
            StringBuilder regionBuilder = new StringBuilder();
            boolean first = true;
            for (int[] range : this.hiddenColumns) {
                if (!first) {
                    regionBuilder.append(delimiter);
                } else {
                    first = false;
                }
                regionBuilder.append(range[0]).append(between).append(range[1]);
            }
            String string = regionBuilder.toString();
            return string;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public int getSize() {
        return this.numColumns;
    }

    public int getNumberOfRegions() {
        try {
            LOCK.readLock().lock();
            int n = this.hiddenColumns.size();
            return n;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        try {
            LOCK.readLock().lock();
            if (!(obj instanceof HiddenColumns)) {
                boolean bl = false;
                return bl;
            }
            HiddenColumns that = (HiddenColumns)obj;
            if (that.hiddenColumns.size() != this.hiddenColumns.size()) {
                boolean bl = false;
                return bl;
            }
            Iterator<int[]> it = this.iterator();
            Iterator<int[]> thatit = that.iterator();
            while (it.hasNext()) {
                if (Arrays.equals(it.next(), thatit.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int visibleToAbsoluteColumn(int column) {
        try {
            LOCK.readLock().lock();
            int result = column;
            if (!this.hiddenColumns.isEmpty()) {
                result += this.cursor.findRegionForColumn(column, true).getHiddenSoFar();
            }
            int n = result;
            return n;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int absoluteToVisibleColumn(int hiddenColumn) {
        try {
            LOCK.readLock().lock();
            int result = hiddenColumn;
            if (!this.hiddenColumns.isEmpty()) {
                int[] region;
                HiddenCursorPosition cursorPos = this.cursor.findRegionForColumn(hiddenColumn, false);
                int index = cursorPos.getRegionIndex();
                int hiddenBeforeCol = cursorPos.getHiddenSoFar();
                result = hiddenColumn - hiddenBeforeCol;
                if (index < this.hiddenColumns.size() && hiddenColumn >= (region = this.hiddenColumns.get(index))[0] && hiddenColumn <= region[1]) {
                    result = region[0] == 0 ? 0 : region[0] - 1 - hiddenBeforeCol;
                }
            }
            int n = result;
            return n;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int offsetByVisibleColumns(int visibleDistance, int startColumn) {
        try {
            LOCK.readLock().lock();
            int start = this.absoluteToVisibleColumn(startColumn);
            int n = this.visibleToAbsoluteColumn(start + visibleDistance);
            return n;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextHiddenBoundary(boolean left, int alPos) {
        try {
            LOCK.readLock().lock();
            if (!this.hiddenColumns.isEmpty()) {
                int index = this.cursor.findRegionForColumn(alPos, false).getRegionIndex();
                if (left && index > 0) {
                    int[] region = this.hiddenColumns.get(index - 1);
                    int n = region[1];
                    return n;
                }
                if (!left && index < this.hiddenColumns.size()) {
                    int[] region = this.hiddenColumns.get(index);
                    if (alPos < region[0]) {
                        int n = region[0];
                        return n;
                    }
                    if (alPos <= region[1] && index + 1 < this.hiddenColumns.size()) {
                        region = this.hiddenColumns.get(index + 1);
                        int n = region[0];
                        return n;
                    }
                }
            }
            int n = alPos;
            return n;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisible(int column) {
        try {
            int[] region;
            int regionindex;
            LOCK.readLock().lock();
            if (!this.hiddenColumns.isEmpty() && (regionindex = this.cursor.findRegionForColumn(column, false).getRegionIndex()) > -1 && regionindex < this.hiddenColumns.size() && column >= (region = this.hiddenColumns.get(regionindex))[0]) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public boolean hasHiddenColumns() {
        try {
            LOCK.readLock().lock();
            boolean bl = !this.hiddenColumns.isEmpty();
            return bl;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public boolean hasMultiHiddenColumnRegions() {
        try {
            LOCK.readLock().lock();
            boolean bl = !this.hiddenColumns.isEmpty() && this.hiddenColumns.size() > 1;
            return bl;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        try {
            LOCK.readLock().lock();
            int hashCode = 1;
            for (int[] hidden : this.hiddenColumns) {
                hashCode = 31 * hashCode + hidden[0];
                hashCode = 31 * hashCode + hidden[1];
            }
            int n = hashCode;
            return n;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public void hideColumns(BitSet inserts) {
        this.hideColumns(inserts, 0, inserts.length() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideColumns(BitSet tohide, int start, int end) {
        try {
            LOCK.writeLock().lock();
            int firstSet = tohide.nextSetBit(start);
            int lastSet = start;
            while (firstSet >= start && lastSet <= end) {
                lastSet = tohide.nextClearBit(firstSet);
                if (lastSet <= end) {
                    this.hideColumns(firstSet, lastSet - 1);
                } else if (firstSet <= end) {
                    this.hideColumns(firstSet, end);
                }
                firstSet = tohide.nextSetBit(lastSet);
            }
            this.cursor = new HiddenColumnsCursor(this.hiddenColumns);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public void clearAndHideColumns(BitSet tohide, int start, int end) {
        this.clearHiddenColumnsInRange(start, end);
        this.hideColumns(tohide, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHiddenColumnsInRange(int start, int end) {
        try {
            LOCK.writeLock().lock();
            if (!this.hiddenColumns.isEmpty()) {
                HiddenCursorPosition pos = this.cursor.findRegionForColumn(start, false);
                int index = pos.getRegionIndex();
                if (index != -1 && index != this.hiddenColumns.size()) {
                    int endi;
                    int[] region = this.hiddenColumns.get(index);
                    if (region[0] < start && region[1] >= start) {
                        this.numColumns -= region[1] - start + 1;
                        region[1] = start - 1;
                        ++index;
                    }
                    for (endi = index; endi < this.hiddenColumns.size(); ++endi) {
                        region = this.hiddenColumns.get(endi);
                        if (region[1] > end) {
                            if (region[0] > end) break;
                            this.numColumns -= end - region[0] + 1;
                            region[0] = end + 1;
                            break;
                        }
                        this.numColumns -= region[1] - region[0] + 1;
                    }
                    this.hiddenColumns.subList(index, endi).clear();
                }
                this.cursor = new HiddenColumnsCursor(this.hiddenColumns);
            }
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void andNot(BitSet updates) {
        try {
            LOCK.writeLock().lock();
            BitSet hiddenBitSet = new BitSet();
            for (int[] range : this.hiddenColumns) {
                hiddenBitSet.set(range[0], range[1] + 1);
            }
            hiddenBitSet.andNot(updates);
            this.hiddenColumns.clear();
            this.hideColumns(hiddenBitSet);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getVisibleStartAndEndIndex(int width) {
        try {
            LOCK.readLock().lock();
            int firstVisible = 0;
            int lastVisible = width - 1;
            if (!this.hiddenColumns.isEmpty()) {
                firstVisible = this.visibleToAbsoluteColumn(0);
                int[] lastregion = this.hiddenColumns.get(this.hiddenColumns.size() - 1);
                if (lastregion[1] == width - 1) {
                    lastVisible = lastregion[0] - 1;
                }
            }
            int[] nArray = new int[]{firstVisible, lastVisible};
            return nArray;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRegionWithEdgeAtRes(int res) {
        try {
            LOCK.readLock().lock();
            int adjres = this.visibleToAbsoluteColumn(res);
            int[] reveal = null;
            if (!this.hiddenColumns.isEmpty()) {
                int regionindex = this.cursor.findRegionForColumn(adjres - 1, false).getRegionIndex();
                if (regionindex < this.hiddenColumns.size() && this.hiddenColumns.get(regionindex)[1] == adjres - 1) {
                    reveal = this.hiddenColumns.get(regionindex);
                } else if (regionindex < this.hiddenColumns.size() && this.hiddenColumns.get(regionindex)[0] == adjres + 1) {
                    reveal = this.hiddenColumns.get(regionindex);
                }
            }
            int[] nArray = reveal;
            return nArray;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public Iterator<int[]> iterator() {
        try {
            LOCK.readLock().lock();
            RangeIterator rangeIterator = new RangeIterator(this.hiddenColumns);
            return rangeIterator;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<int[]> getBoundedIterator(int start, int end) {
        try {
            LOCK.readLock().lock();
            RangeIterator rangeIterator = new RangeIterator(start, end, this.hiddenColumns);
            return rangeIterator;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Integer> getStartRegionIterator(int start, int end) {
        try {
            LOCK.readLock().lock();
            int absoluteStart = this.visibleToAbsoluteColumn(start);
            HiddenCursorPosition pos = this.cursor.findRegionForColumn(absoluteStart - 1, false);
            StartRegionIterator startRegionIterator = new StartRegionIterator(pos, start, end, this.hiddenColumns);
            return startRegionIterator;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Integer> getVisibleColsIterator(int start, int end) {
        try {
            LOCK.readLock().lock();
            RangeElementsIterator rangeElementsIterator = new RangeElementsIterator(new VisibleContigsIterator(start, end + 1, this.hiddenColumns));
            return rangeElementsIterator;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisibleContigsIterator getVisContigsIterator(int start, int end, boolean useVisibleCoords) {
        int adjstart = start;
        int adjend = end;
        if (useVisibleCoords) {
            adjstart = this.visibleToAbsoluteColumn(start);
            adjend = this.visibleToAbsoluteColumn(end);
        }
        try {
            LOCK.readLock().lock();
            VisibleContigsIterator visibleContigsIterator = new VisibleContigsIterator(adjstart, adjend, this.hiddenColumns);
            return visibleContigsIterator;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }
}

