/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.argparser.Arg;
import jalview.bin.argparser.SubVals;

public class ArgValue
implements Comparable<ArgValue> {
    private Arg arg;
    private int argIndex;
    private String value;
    private String givenLinkedId = null;
    private String assignedLinkedId = null;
    private boolean setByWildcardLinkedId = false;
    private Arg.Type type = null;
    private String id;
    private SubVals subVals;

    protected ArgValue(Arg a, SubVals sv, Arg.Type type, String content, int argIndex, boolean setByWildcardLinkedId, String givenLinkedId, String assignedLinkedId) {
        this.arg = a;
        this.value = content;
        this.argIndex = argIndex;
        this.subVals = sv == null ? new SubVals("") : sv;
        this.setType(type);
        this.setByWildcardLinkedId = setByWildcardLinkedId;
        this.givenLinkedId = givenLinkedId;
        this.assignedLinkedId = assignedLinkedId;
    }

    protected ArgValue(Arg a, Arg.Type type, String value, int argIndex, boolean setByWildcardLinkedId, String givenLinkedId, String assignedLinkedId) {
        this.arg = a;
        this.argIndex = argIndex;
        this.subVals = new SubVals(value);
        this.value = this.getSubVals().getContent();
        this.setType(type);
        this.setByWildcardLinkedId = setByWildcardLinkedId;
        this.givenLinkedId = givenLinkedId;
        this.assignedLinkedId = assignedLinkedId;
    }

    protected void setType(Arg.Type t) {
        if (this.getArg().hasOption(Arg.Opt.HASTYPE)) {
            this.type = t;
        }
    }

    public Arg.Type getType() {
        return this.type;
    }

    public Arg getArg() {
        return this.arg;
    }

    public String getValue() {
        return this.value;
    }

    public int getArgIndex() {
        return this.argIndex;
    }

    protected void setId(String i) {
        this.id = i;
    }

    public String getId() {
        return this.id;
    }

    public SubVals getSubVals() {
        return this.subVals;
    }

    public String getSubVal(String key) {
        if (this.subVals == null || !this.subVals.has(key)) {
            return null;
        }
        return this.subVals.get(key);
    }

    protected void putSubVal(String key, String val) {
        this.subVals.put(key, val);
    }

    @Override
    public final int compareTo(ArgValue o) {
        return this.getArgIndex() - o.getArgIndex();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getArg().argString());
        sb.append("=");
        if (!this.getSubVals().getSubValMap().isEmpty()) {
            sb.append(this.getSubVals().toString());
        }
        sb.append("'");
        sb.append(this.getValue());
        sb.append("'");
        return sb.toString();
    }

    public String getGivenLinkedId() {
        return this.givenLinkedId;
    }

    public String getAssignedLinkedId() {
        return this.assignedLinkedId;
    }

    public boolean setByWildcardLinkedId() {
        return this.setByWildcardLinkedId && this.getGivenLinkedId() != null;
    }
}

