/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AlignmentSorter;
import jalview.analysis.AnnotationSorter;
import jalview.analysis.scoremodels.PIDModel;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.AlignViewControllerGuiI;
import jalview.api.AlignViewControllerI;
import jalview.api.AlignViewportI;
import jalview.api.FeatureColourI;
import jalview.api.FeatureRenderer;
import jalview.api.FeatureSettingsControllerI;
import jalview.api.SequenceStructureBinding;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AnnotationColourChooser;
import jalview.appletgui.AnnotationColumnChooser;
import jalview.appletgui.AppletJmol;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.ExtJmol;
import jalview.appletgui.FeatureSettings;
import jalview.appletgui.Finder;
import jalview.appletgui.FontChooser;
import jalview.appletgui.JVDialog;
import jalview.appletgui.OverviewPanel;
import jalview.appletgui.PCAPanel;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.PairwiseAlignPanel;
import jalview.appletgui.RedundancyPanel;
import jalview.appletgui.SeqCanvas;
import jalview.appletgui.SliderPanel;
import jalview.appletgui.SplitFrame;
import jalview.appletgui.TreePanel;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.Console;
import jalview.bin.JalviewLite;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.commands.OrderCommand;
import jalview.commands.RemoveGapColCommand;
import jalview.commands.RemoveGapsCommand;
import jalview.commands.SlideSequencesCommand;
import jalview.commands.TrimRegionCommand;
import jalview.controller.AlignViewController;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AlignmentProperties;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FeaturesFile;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.NewickFile;
import jalview.io.TCoffeeScoreFile;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.PurinePyrimidineColourScheme;
import jalview.schemes.RNAHelicesColour;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TCoffeeColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.ViewportRanges;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import mc_view.AppletPDBViewer;
import org.jmol.viewer.Viewer;

public class AlignFrame
extends EmbmenuFrame
implements ActionListener,
ItemListener,
KeyListener,
AlignViewControllerGuiI {
    public AlignViewControllerI avc;
    public AlignmentPanel alignPanel;
    public AlignViewport viewport;
    int frameWidth = 700;
    int frameHeight = 500;
    String jalviewServletURL;
    private boolean showAutoCalculatedAbove;
    private AnnotationSorter.SequenceAnnotationOrder annotationSortOrder;
    static StringBuffer copiedSequences;
    static HiddenColumns copiedHiddenColumns;
    MenuBar alignFrameMenuBar = new MenuBar();
    Menu fileMenu = new Menu(MessageManager.getString("action.file"));
    MenuItem loadApplication = new MenuItem(MessageManager.getString("label.view_full_application"));
    MenuItem loadTree = new MenuItem(MessageManager.getString("label.load_associated_tree"));
    MenuItem loadAnnotations = new MenuItem(MessageManager.getString("label.load_features_annotations"));
    MenuItem outputFeatures = new MenuItem(MessageManager.getString("label.export_features"));
    MenuItem outputAnnotations = new MenuItem(MessageManager.getString("label.export_annotations"));
    MenuItem closeMenuItem = new MenuItem(MessageManager.getString("action.close"));
    MenuItem selectAllSequenceMenuItem = new MenuItem(MessageManager.getString("action.select_all"));
    MenuItem deselectAllSequenceMenuItem = new MenuItem(MessageManager.getString("action.deselect_all"));
    MenuItem invertSequenceMenuItem = new MenuItem(MessageManager.getString("action.invert_selection"));
    MenuItem remove2LeftMenuItem = new MenuItem();
    MenuItem remove2RightMenuItem = new MenuItem();
    MenuItem removeGappedColumnMenuItem = new MenuItem();
    MenuItem removeAllGapsMenuItem = new MenuItem();
    CheckboxMenuItem viewBoxesMenuItem = new CheckboxMenuItem();
    CheckboxMenuItem viewTextMenuItem = new CheckboxMenuItem();
    MenuItem sortPairwiseMenuItem = new MenuItem();
    MenuItem sortIDMenuItem = new MenuItem();
    MenuItem sortLengthMenuItem = new MenuItem();
    MenuItem sortGroupMenuItem = new MenuItem();
    MenuItem removeRedundancyMenuItem = new MenuItem();
    MenuItem pairwiseAlignmentMenuItem = new MenuItem();
    MenuItem PCAMenuItem = new MenuItem();
    MenuItem averageDistanceTreeMenuItem = new MenuItem();
    MenuItem neighbourTreeMenuItem = new MenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    public Label statusBar = new Label();
    MenuItem clustalColour = new MenuItem();
    MenuItem zappoColour = new MenuItem();
    MenuItem taylorColour = new MenuItem();
    MenuItem hydrophobicityColour = new MenuItem();
    MenuItem helixColour = new MenuItem();
    MenuItem strandColour = new MenuItem();
    MenuItem turnColour = new MenuItem();
    MenuItem buriedColour = new MenuItem();
    MenuItem purinePyrimidineColour = new MenuItem();
    MenuItem RNAHelixColour = new MenuItem();
    MenuItem userDefinedColour = new MenuItem();
    MenuItem PIDColour = new MenuItem();
    MenuItem BLOSUM62Colour = new MenuItem();
    MenuItem tcoffeeColour = new MenuItem();
    MenuItem njTreeBlosumMenuItem = new MenuItem();
    MenuItem avDistanceTreeBlosumMenuItem = new MenuItem();
    CheckboxMenuItem annotationPanelMenuItem = new CheckboxMenuItem();
    CheckboxMenuItem colourTextMenuItem = new CheckboxMenuItem();
    CheckboxMenuItem displayNonconservedMenuItem = new CheckboxMenuItem();
    MenuItem alProperties = new MenuItem(MessageManager.getString("label.alignment_props"));
    MenuItem overviewMenuItem = new MenuItem();
    MenuItem undoMenuItem = new MenuItem();
    MenuItem redoMenuItem = new MenuItem();
    CheckboxMenuItem conservationMenuItem = new CheckboxMenuItem();
    MenuItem noColourmenuItem = new MenuItem();
    CheckboxMenuItem wrapMenuItem = new CheckboxMenuItem();
    CheckboxMenuItem renderGapsMenuItem = new CheckboxMenuItem();
    MenuItem findMenuItem = new MenuItem();
    CheckboxMenuItem abovePIDThreshold = new CheckboxMenuItem();
    MenuItem nucleotideColour = new MenuItem();
    MenuItem deleteGroups = new MenuItem();
    MenuItem grpsFromSelection = new MenuItem();
    MenuItem createGroup = new MenuItem();
    MenuItem unGroup = new MenuItem();
    MenuItem delete = new MenuItem();
    MenuItem copy = new MenuItem();
    MenuItem cut = new MenuItem();
    Menu pasteMenu = new Menu();
    MenuItem pasteNew = new MenuItem();
    MenuItem pasteThis = new MenuItem();
    CheckboxMenuItem applyToAllGroups = new CheckboxMenuItem();
    MenuItem font = new MenuItem();
    CheckboxMenuItem scaleAbove = new CheckboxMenuItem();
    CheckboxMenuItem scaleLeft = new CheckboxMenuItem();
    CheckboxMenuItem scaleRight = new CheckboxMenuItem();
    MenuItem modifyPID = new MenuItem();
    MenuItem modifyConservation = new MenuItem();
    CheckboxMenuItem autoCalculate = null;
    CheckboxMenuItem sortByTree = new CheckboxMenuItem("Sort Alignment With New Tree", true);
    Menu sortByTreeMenu = new Menu();
    MenuItem inputText = new MenuItem();
    MenuItem documentation = new MenuItem();
    MenuItem about = new MenuItem();
    CheckboxMenuItem seqLimits = new CheckboxMenuItem();
    CheckboxMenuItem centreColumnLabelFlag = new CheckboxMenuItem();
    CheckboxMenuItem followMouseOverFlag = new CheckboxMenuItem();
    CheckboxMenuItem showSequenceLogo = new CheckboxMenuItem();
    CheckboxMenuItem applyAutoAnnotationSettings = new CheckboxMenuItem();
    CheckboxMenuItem showConsensusHistogram = new CheckboxMenuItem();
    CheckboxMenuItem showGroupConsensus = new CheckboxMenuItem();
    CheckboxMenuItem showGroupConservation = new CheckboxMenuItem();
    CheckboxMenuItem normSequenceLogo = new CheckboxMenuItem();
    MenuItem featureSettings = new MenuItem();
    CheckboxMenuItem sequenceFeatures = new CheckboxMenuItem();
    MenuItem annotationColour = new MenuItem();
    MenuItem annotationColumnSelection = new MenuItem();
    MenuItem invertColSel = new MenuItem();
    MenuItem showColumns = new MenuItem();
    MenuItem showSeqs = new MenuItem();
    MenuItem hideColumns = new MenuItem();
    MenuItem hideSequences = new MenuItem();
    MenuItem hideAllButSelection = new MenuItem();
    MenuItem hideAllSelection = new MenuItem();
    MenuItem showAllHidden = new MenuItem();
    MenuItem newView = new MenuItem();
    private CheckboxMenuItem showAlignmentAnnotations;
    private CheckboxMenuItem showSequenceAnnotations;
    private CheckboxMenuItem sortAnnBySequence;
    private CheckboxMenuItem sortAnnByLabel;
    private CheckboxMenuItem showAutoFirst;
    private CheckboxMenuItem showAutoLast;
    private SplitFrame splitFrame;
    private Rectangle fs_bounds = null;

    public AlignFrame(AlignmentI al, JalviewLite applet, String title, boolean embedded) {
        this(al, applet, title, embedded, true);
    }

    public AlignFrame(AlignmentI al, JalviewLite applet, String title, boolean embedded, boolean addToDisplay) {
        this(al, null, null, applet, title, embedded, addToDisplay);
    }

    public AlignFrame(AlignmentI al, SequenceI[] hiddenSeqs, HiddenColumns hidden, JalviewLite applet, String title, boolean embedded) {
        this(al, hiddenSeqs, hidden, applet, title, embedded, true);
    }

    public AlignFrame(AlignmentI al, SequenceI[] hiddenSeqs, HiddenColumns hidden, JalviewLite applet, String title, boolean embedded, boolean addToDisplay) {
        String param;
        if (applet != null) {
            this.jalviewServletURL = applet.getParameter("APPLICATION_URL");
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (applet != null) {
            try {
                param = applet.getParameter("windowWidth");
                if (param != null) {
                    int width;
                    this.frameWidth = width = Integer.parseInt(param);
                }
                if ((param = applet.getParameter("windowHeight")) != null) {
                    int height;
                    this.frameHeight = height = Integer.parseInt(param);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.viewport = new AlignViewport(al, applet);
        if (hiddenSeqs != null && hiddenSeqs.length > 0) {
            this.viewport.hideSequence(hiddenSeqs);
        }
        if (hidden != null) {
            this.viewport.getAlignment().setHiddenColumns(hidden);
        }
        this.viewport.setScaleAboveWrapped(this.scaleAbove.getState());
        this.alignPanel = new AlignmentPanel(this, this.viewport);
        this.avc = new AlignViewController(this, this.viewport, this.alignPanel);
        this.viewport.updateConservation(this.alignPanel);
        this.viewport.updateConsensus(this.alignPanel);
        this.displayNonconservedMenuItem.setState(this.viewport.getShowUnconserved());
        this.followMouseOverFlag.setState(this.viewport.isFollowHighlight());
        this.showGroupConsensus.setState(this.viewport.isShowGroupConsensus());
        this.showGroupConservation.setState(this.viewport.isShowGroupConservation());
        this.showConsensusHistogram.setState(this.viewport.isShowConsensusHistogram());
        this.showSequenceLogo.setState(this.viewport.isShowSequenceLogo());
        this.normSequenceLogo.setState(this.viewport.isNormaliseSequenceLogo());
        this.applyToAllGroups.setState(this.viewport.getColourAppliesToAllGroups());
        this.annotationPanelMenuItem.setState(this.viewport.isShowAnnotation());
        this.showAlignmentAnnotations.setEnabled(this.annotationPanelMenuItem.getState());
        this.showSequenceAnnotations.setEnabled(this.annotationPanelMenuItem.getState());
        this.showAlignmentAnnotations.setState(true);
        this.showSequenceAnnotations.setState(false);
        this.seqLimits.setState(this.viewport.getShowJVSuffix());
        if (applet != null) {
            param = applet.getParameter("sortBy");
            if (param != null) {
                if (param.equalsIgnoreCase("Id")) {
                    this.sortIDMenuItem_actionPerformed();
                } else if (param.equalsIgnoreCase("Pairwise Identity")) {
                    this.sortPairwiseMenuItem_actionPerformed();
                } else if (param.equalsIgnoreCase("Length")) {
                    this.sortLengthMenuItem_actionPerformed();
                }
            }
            if ((param = applet.getParameter("wrap")) != null && param.equalsIgnoreCase("true")) {
                this.wrapMenuItem.setState(true);
                this.wrapMenuItem_actionPerformed();
            }
            if ((param = applet.getParameter("centrecolumnlabels")) != null) {
                this.centreColumnLabelFlag.setState(true);
                this.centreColumnLabelFlag_stateChanged();
            }
        }
        if (this.viewport.getAlignment().isNucleotide()) {
            this.conservationMenuItem.setEnabled(false);
            this.clustalColour.setEnabled(false);
            this.BLOSUM62Colour.setEnabled(false);
            this.zappoColour.setEnabled(false);
            this.taylorColour.setEnabled(false);
            this.hydrophobicityColour.setEnabled(false);
            this.helixColour.setEnabled(false);
            this.strandColour.setEnabled(false);
            this.turnColour.setEnabled(false);
            this.buriedColour.setEnabled(false);
            this.viewport.updateStrucConsensus(this.alignPanel);
            if (this.viewport.getAlignment().hasRNAStructure()) {
                this.RNAHelixColour.setEnabled(true);
            } else {
                this.RNAHelixColour.setEnabled(false);
            }
        } else {
            this.RNAHelixColour.setEnabled(false);
            this.purinePyrimidineColour.setEnabled(false);
            this.nucleotideColour.setEnabled(false);
        }
        this.addKeyListener(this);
        this.alignPanel.seqPanel.seqCanvas.addKeyListener(this);
        this.alignPanel.idPanel.idCanvas.addKeyListener(this);
        this.alignPanel.scalePanel.addKeyListener(this);
        this.alignPanel.annotationPanel.addKeyListener(this);
        this.alignPanel.annotationPanelHolder.addKeyListener(this);
        this.alignPanel.annotationSpaceFillerHolder.addKeyListener(this);
        this.alignPanel.alabels.addKeyListener(this);
        this.setAnnotationsVisibility();
        if (addToDisplay) {
            this.addToDisplay(embedded);
        }
    }

    public void addToDisplay(boolean embedded) {
        this.createAlignFrameWindow(embedded);
        this.validate();
        this.alignPanel.adjustAnnotationHeight();
        this.alignPanel.paintAlignment(true, true);
    }

    public AlignViewport getAlignViewport() {
        return this.viewport;
    }

    public SeqCanvas getSeqcanvas() {
        return this.alignPanel.seqPanel.seqCanvas;
    }

    public boolean parseFeaturesFile(String file, DataSourceType type) {
        return this.parseFeaturesFile(file, type, true);
    }

    public boolean parseFeaturesFile(String file, DataSourceType sourceType, boolean autoenabledisplay) {
        boolean featuresFile = false;
        try {
            Map<String, FeatureColourI> colours = this.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().getFeatureColours();
            boolean relaxedIdMatching = this.viewport.applet.getDefaultParameter("relaxedidmatch", false);
            featuresFile = new FeaturesFile(file, sourceType).parse(this.viewport.getAlignment(), colours, true, relaxedIdMatching);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (featuresFile) {
            if (autoenabledisplay) {
                this.viewport.setShowSequenceFeatures(true);
                this.sequenceFeatures.setState(true);
            }
            if (this.alignPanel.seqPanel.seqCanvas.fr != null) {
                this.alignPanel.seqPanel.seqCanvas.fr.findAllFeatures(true);
            }
            if (this.viewport.featureSettings != null) {
                this.viewport.featureSettings.refreshTable();
            }
            this.alignPanel.paintAlignment(true, true);
            this.setStatus(MessageManager.getString("label.successfully_added_features_alignment"));
        }
        return featuresFile;
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        ViewportRanges ranges = this.viewport.getRanges();
        if (this.viewport.cursorMode && (evt.getKeyCode() >= 48 && evt.getKeyCode() <= 57 || evt.getKeyCode() >= 96 && evt.getKeyCode() <= 105) && Character.isDigit(evt.getKeyChar())) {
            this.alignPanel.seqPanel.numberPressed(evt.getKeyChar());
        }
        switch (evt.getKeyCode()) {
            case 27: {
                this.deselectAllSequenceMenuItem_actionPerformed();
                this.alignPanel.alabels.cancelDrag();
                break;
            }
            case 88: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                this.cut_actionPerformed();
                break;
            }
            case 67: {
                if (this.viewport.cursorMode && !evt.isControlDown()) {
                    this.alignPanel.seqPanel.setCursorColumn();
                }
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                this.copy_actionPerformed();
                break;
            }
            case 86: {
                if (!evt.isControlDown()) break;
                this.paste(evt.isShiftDown());
                break;
            }
            case 65: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                this.selectAllSequenceMenuItem_actionPerformed();
                break;
            }
            case 40: {
                if (this.viewport.cursorMode) {
                    this.alignPanel.seqPanel.moveCursor(0, 1);
                    break;
                }
                this.moveSelectedSequences(false);
                break;
            }
            case 38: {
                if (this.viewport.cursorMode) {
                    this.alignPanel.seqPanel.moveCursor(0, -1);
                    break;
                }
                this.moveSelectedSequences(true);
                break;
            }
            case 37: {
                if (evt.isAltDown() || !this.viewport.cursorMode) {
                    this.slideSequences(false, this.alignPanel.seqPanel.getKeyboardNo1());
                    break;
                }
                this.alignPanel.seqPanel.moveCursor(-1, 0);
                break;
            }
            case 39: {
                if (evt.isAltDown() || !this.viewport.cursorMode) {
                    this.slideSequences(true, this.alignPanel.seqPanel.getKeyboardNo1());
                    break;
                }
                this.alignPanel.seqPanel.moveCursor(1, 0);
                break;
            }
            case 32: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.insertGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                break;
            }
            case 8: 
            case 127: {
                if (this.viewport.cursorMode) {
                    this.alignPanel.seqPanel.deleteGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                    break;
                }
                this.cut_actionPerformed();
                this.alignPanel.seqPanel.seqCanvas.repaint();
                break;
            }
            case 83: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setCursorRow();
                break;
            }
            case 80: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setCursorPosition();
                break;
            }
            case 10: 
            case 44: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setCursorRowAndColumn();
                break;
            }
            case 81: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setSelectionAreaAtCursor(true);
                break;
            }
            case 77: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setSelectionAreaAtCursor(false);
                break;
            }
            case 113: {
                this.viewport.cursorMode = !this.viewport.cursorMode;
                this.setStatus(MessageManager.formatMessage("label.keyboard_editing_mode", new String[]{this.viewport.cursorMode ? "on" : "off"}));
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.seqCanvas.cursorX = ranges.getStartRes();
                this.alignPanel.seqPanel.seqCanvas.cursorY = ranges.getStartSeq();
                break;
            }
            case 70: {
                if (!evt.isControlDown()) break;
                this.findMenuItem_actionPerformed();
                break;
            }
            case 72: {
                boolean toggleSeqs = !evt.isControlDown();
                boolean toggleCols = !evt.isShiftDown();
                this.toggleHiddenRegions(toggleSeqs, toggleCols);
                break;
            }
            case 33: {
                ranges.pageUp();
                break;
            }
            case 34: {
                ranges.pageDown();
                break;
            }
            case 90: {
                if (!evt.isControlDown()) break;
                this.undoMenuItem_actionPerformed();
                break;
            }
            case 89: {
                if (!evt.isControlDown()) break;
                this.redoMenuItem_actionPerformed();
                break;
            }
            case 76: {
                if (!evt.isControlDown()) break;
                this.trimAlignment(true);
                break;
            }
            case 82: {
                if (!evt.isControlDown()) break;
                this.trimAlignment(false);
                break;
            }
            case 69: {
                if (!evt.isControlDown()) break;
                if (evt.isShiftDown()) {
                    this.removeAllGapsMenuItem_actionPerformed();
                    break;
                }
                this.removeGappedColumnMenuItem_actionPerformed();
                break;
            }
            case 73: {
                if (!evt.isControlDown()) break;
                if (evt.isAltDown()) {
                    this.invertColSel_actionPerformed();
                    break;
                }
                this.invertSequenceMenuItem_actionPerformed();
                break;
            }
            case 71: {
                if (!evt.isControlDown()) break;
                if (evt.isShiftDown()) {
                    this.unGroup_actionPerformed();
                    break;
                }
                this.createGroup_actionPerformed();
                break;
            }
            case 85: {
                if (!evt.isControlDown()) break;
                this.deleteGroups_actionPerformed();
                break;
            }
            case 84: {
                if (!evt.isControlDown()) break;
                this.newView(null);
            }
        }
        this.alignPanel.paintAlignment(true, true);
    }

    private void toggleHiddenRegions(boolean toggleSeqs, boolean toggleCols) {
        boolean hide = false;
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (!toggleSeqs && !toggleCols && (this.viewport.hasSelectedColumns() || sg != null && sg.getSize() > 0 && sg.getStartRes() <= sg.getEndRes())) {
            if (sg != null) {
                this.invertSequenceMenuItem_actionPerformed();
                sg = this.viewport.getSelectionGroup();
                toggleSeqs = true;
            }
            this.viewport.expandColSelection(sg, true);
            this.invertColSel_actionPerformed();
            toggleCols = true;
        }
        if (toggleSeqs) {
            if (sg != null && sg.getSize() != this.viewport.getAlignment().getHeight()) {
                hide = true;
                this.viewport.hideAllSelectedSeqs();
            } else if (!toggleCols || !this.viewport.hasSelectedColumns()) {
                this.viewport.showAllHiddenSeqs();
            }
        }
        if (toggleCols) {
            if (this.viewport.hasSelectedColumns()) {
                this.viewport.hideSelectedColumns();
                if (!toggleSeqs) {
                    this.viewport.setSelectionGroup(sg);
                }
            } else if (!hide) {
                this.viewport.showAllHiddenColumns();
            }
            this.viewport.sendSelection();
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.displayNonconservedMenuItem) {
            this.displayNonconservedMenuItem_actionPerformed();
        } else if (source == this.colourTextMenuItem) {
            this.colourTextMenuItem_actionPerformed();
        } else if (source == this.wrapMenuItem) {
            this.wrapMenuItem_actionPerformed();
        } else if (source == this.scaleAbove) {
            this.viewport.setScaleAboveWrapped(this.scaleAbove.getState());
        } else if (source == this.scaleLeft) {
            this.viewport.setScaleLeftWrapped(this.scaleLeft.getState());
        } else if (source == this.scaleRight) {
            this.viewport.setScaleRightWrapped(this.scaleRight.getState());
        } else if (source == this.seqLimits) {
            this.seqLimits_itemStateChanged();
        } else if (source == this.viewBoxesMenuItem) {
            this.viewport.setShowBoxes(this.viewBoxesMenuItem.getState());
        } else if (source == this.viewTextMenuItem) {
            this.viewport.setShowText(this.viewTextMenuItem.getState());
        } else if (source == this.renderGapsMenuItem) {
            this.viewport.setRenderGaps(this.renderGapsMenuItem.getState());
        } else if (source == this.annotationPanelMenuItem) {
            boolean showAnnotations = this.annotationPanelMenuItem.getState();
            this.showAlignmentAnnotations.setEnabled(showAnnotations);
            this.showSequenceAnnotations.setEnabled(showAnnotations);
            this.viewport.setShowAnnotation(showAnnotations);
            this.alignPanel.setAnnotationVisible(showAnnotations);
        } else if (source == this.sequenceFeatures) {
            this.viewport.setShowSequenceFeatures(this.sequenceFeatures.getState());
            this.alignPanel.seqPanel.seqCanvas.repaint();
        } else if (source == this.showAlignmentAnnotations) {
            this.setAnnotationsVisibility();
        } else if (source == this.showSequenceAnnotations) {
            this.setAnnotationsVisibility();
        } else if (source == this.sortAnnBySequence) {
            boolean newState = this.sortAnnBySequence.getState();
            this.sortAnnByLabel.setState(false);
            this.setAnnotationSortOrder(newState ? AnnotationSorter.SequenceAnnotationOrder.SEQUENCE_AND_LABEL : AnnotationSorter.SequenceAnnotationOrder.NONE);
            this.setViewportAnnotationOrder();
        } else if (source == this.sortAnnByLabel) {
            boolean newState = this.sortAnnByLabel.getState();
            this.sortAnnBySequence.setState(false);
            this.setAnnotationSortOrder(newState ? AnnotationSorter.SequenceAnnotationOrder.LABEL_AND_SEQUENCE : AnnotationSorter.SequenceAnnotationOrder.NONE);
            this.setViewportAnnotationOrder();
        } else if (source == this.showAutoFirst) {
            this.showAutoLast.setState(!this.showAutoFirst.getState());
            this.setShowAutoCalculatedAbove(this.showAutoFirst.getState());
            this.setViewportAnnotationOrder();
        } else if (source == this.showAutoLast) {
            this.showAutoFirst.setState(!this.showAutoLast.getState());
            this.setShowAutoCalculatedAbove(this.showAutoFirst.getState());
            this.setViewportAnnotationOrder();
        } else if (source == this.conservationMenuItem) {
            this.conservationMenuItem_actionPerformed();
        } else if (source == this.abovePIDThreshold) {
            this.abovePIDThreshold_actionPerformed();
        } else if (source == this.applyToAllGroups) {
            this.viewport.setColourAppliesToAllGroups(this.applyToAllGroups.getState());
        } else if (source == this.autoCalculate) {
            this.viewport.autoCalculateConsensus = this.autoCalculate.getState();
        } else if (source == this.sortByTree) {
            this.viewport.sortByTree = this.sortByTree.getState();
        } else if (source == this.centreColumnLabelFlag) {
            this.centreColumnLabelFlag_stateChanged();
        } else if (source == this.followMouseOverFlag) {
            this.mouseOverFlag_stateChanged();
        } else if (source == this.showGroupConsensus) {
            this.showGroupConsensus_actionPerformed();
        } else if (source == this.showGroupConservation) {
            this.showGroupConservation_actionPerformed();
        } else if (source == this.showSequenceLogo) {
            this.showSequenceLogo_actionPerformed();
        } else if (source == this.normSequenceLogo) {
            this.normSequenceLogo_actionPerformed();
        } else if (source == this.showConsensusHistogram) {
            this.showConsensusHistogram_actionPerformed();
        } else if (source == this.applyAutoAnnotationSettings) {
            this.applyAutoAnnotationSettings_actionPerformed();
        }
        this.alignPanel.paintAlignment(true, true);
    }

    private void setAnnotationsVisibility() {
        boolean showForAlignment = this.showAlignmentAnnotations.getState();
        boolean showForSequences = this.showSequenceAnnotations.getState();
        if (this.alignPanel.getAlignment().getAlignmentAnnotation() != null) {
            for (AlignmentAnnotation aa : this.alignPanel.getAlignment().getAlignmentAnnotation()) {
                boolean visible;
                aa.visible = visible = aa.sequenceRef == null ? showForAlignment : showForSequences;
            }
        }
        this.alignPanel.validateAnnotationDimensions(true);
        this.validate();
        this.repaint();
    }

    private void setAnnotationSortOrder(AnnotationSorter.SequenceAnnotationOrder order) {
        this.annotationSortOrder = order;
    }

    private void setViewportAnnotationOrder() {
        this.alignPanel.av.setSortAnnotationsBy(this.annotationSortOrder);
        this.alignPanel.av.setShowAutocalculatedAbove(this.showAutoCalculatedAbove);
    }

    private void setShowAutoCalculatedAbove(boolean showAbove) {
        this.showAutoCalculatedAbove = showAbove;
    }

    private void mouseOverFlag_stateChanged() {
        this.viewport.setFollowHighlight(this.followMouseOverFlag.getState());
    }

    private void centreColumnLabelFlag_stateChanged() {
        this.viewport.centreColumnLabels = this.centreColumnLabelFlag.getState();
        this.alignPanel.annotationPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.viewport.applet.currentAlignFrame = this;
        Object source = evt.getSource();
        if (source == this.inputText) {
            this.inputText_actionPerformed();
        } else if (source == this.loadTree) {
            this.loadTree_actionPerformed();
        } else if (source == this.loadApplication) {
            this.launchFullApplication();
        } else if (source == this.loadAnnotations) {
            this.loadAnnotations();
        } else if (source == this.outputAnnotations) {
            this.outputAnnotations(true);
        } else if (source == this.outputFeatures) {
            this.outputFeatures(true, "Jalview");
        } else if (source == this.closeMenuItem) {
            this.closeMenuItem_actionPerformed();
        } else if (source == this.copy) {
            this.copy_actionPerformed();
        } else if (source == this.undoMenuItem) {
            this.undoMenuItem_actionPerformed();
        } else if (source == this.redoMenuItem) {
            this.redoMenuItem_actionPerformed();
        } else if (source == this.inputText) {
            this.inputText_actionPerformed();
        } else if (source == this.closeMenuItem) {
            this.closeMenuItem_actionPerformed();
        } else if (source == this.undoMenuItem) {
            this.undoMenuItem_actionPerformed();
        } else if (source == this.redoMenuItem) {
            this.redoMenuItem_actionPerformed();
        } else if (source == this.copy) {
            this.copy_actionPerformed();
        } else if (source == this.pasteNew) {
            this.pasteNew_actionPerformed();
        } else if (source == this.pasteThis) {
            this.pasteThis_actionPerformed();
        } else if (source == this.cut) {
            this.cut_actionPerformed();
        } else if (source == this.delete) {
            this.delete_actionPerformed();
        } else if (source == this.createGroup) {
            this.createGroup_actionPerformed();
        } else if (source == this.unGroup) {
            this.unGroup_actionPerformed();
        } else if (source == this.grpsFromSelection) {
            this.makeGrpsFromSelection_actionPerformed();
        } else if (source == this.deleteGroups) {
            this.deleteGroups_actionPerformed();
        } else if (source == this.selectAllSequenceMenuItem) {
            this.selectAllSequenceMenuItem_actionPerformed();
        } else if (source == this.deselectAllSequenceMenuItem) {
            this.deselectAllSequenceMenuItem_actionPerformed();
        } else if (source == this.invertSequenceMenuItem) {
            this.invertSequenceMenuItem_actionPerformed();
        } else if (source == this.invertColSel) {
            this.viewport.invertColumnSelection();
            this.alignPanel.paintAlignment(false, false);
            this.viewport.sendSelection();
        } else if (source == this.remove2LeftMenuItem) {
            this.trimAlignment(true);
        } else if (source == this.remove2RightMenuItem) {
            this.trimAlignment(false);
        } else if (source == this.removeGappedColumnMenuItem) {
            this.removeGappedColumnMenuItem_actionPerformed();
        } else if (source == this.removeAllGapsMenuItem) {
            this.removeAllGapsMenuItem_actionPerformed();
        } else if (source == this.findMenuItem) {
            this.findMenuItem_actionPerformed();
        } else if (source == this.font) {
            new FontChooser(this.alignPanel);
        } else if (source == this.newView) {
            this.newView(null);
        } else if (source == this.showColumns) {
            this.viewport.showAllHiddenColumns();
            this.alignPanel.paintAlignment(true, true);
            this.viewport.sendSelection();
        } else if (source == this.showSeqs) {
            this.viewport.showAllHiddenSeqs();
            this.alignPanel.paintAlignment(true, true);
        } else if (source == this.hideColumns) {
            this.viewport.hideSelectedColumns();
            this.alignPanel.paintAlignment(true, true);
            this.viewport.sendSelection();
        } else if (source == this.hideSequences && this.viewport.getSelectionGroup() != null) {
            this.viewport.hideAllSelectedSeqs();
            this.alignPanel.paintAlignment(true, true);
        } else if (source == this.hideAllButSelection) {
            this.toggleHiddenRegions(false, false);
            this.alignPanel.paintAlignment(true, true);
            this.viewport.sendSelection();
        } else if (source == this.hideAllSelection) {
            SequenceGroup sg = this.viewport.getSelectionGroup();
            this.viewport.expandColSelection(sg, false);
            this.viewport.hideAllSelectedSeqs();
            this.viewport.hideSelectedColumns();
            this.alignPanel.paintAlignment(true, true);
            this.viewport.sendSelection();
        } else if (source == this.showAllHidden) {
            this.viewport.showAllHiddenColumns();
            this.viewport.showAllHiddenSeqs();
            this.alignPanel.paintAlignment(true, true);
            this.viewport.sendSelection();
        } else if (source == this.showGroupConsensus) {
            this.showGroupConsensus_actionPerformed();
        } else if (source == this.showGroupConservation) {
            this.showGroupConservation_actionPerformed();
        } else if (source == this.showSequenceLogo) {
            this.showSequenceLogo_actionPerformed();
        } else if (source == this.normSequenceLogo) {
            this.normSequenceLogo_actionPerformed();
        } else if (source == this.showConsensusHistogram) {
            this.showConsensusHistogram_actionPerformed();
        } else if (source == this.applyAutoAnnotationSettings) {
            this.applyAutoAnnotationSettings_actionPerformed();
        } else if (source == this.featureSettings) {
            this.showFeatureSettingsUI();
        } else if (source == this.alProperties) {
            StringBuffer contents = new AlignmentProperties(this.viewport.getAlignment()).formatAsString();
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this);
            cap.setText(contents.toString());
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, MessageManager.formatMessage("label.alignment_properties", new String[]{this.getTitle()}), 400, 250);
        } else if (source == this.overviewMenuItem) {
            this.overviewMenuItem_actionPerformed();
        } else if (source == this.noColourmenuItem) {
            this.changeColour(null);
        } else if (source == this.clustalColour) {
            this.abovePIDThreshold.setState(false);
            this.changeColour(new ClustalxColourScheme(this.viewport.getAlignment(), null));
        } else if (source == this.zappoColour) {
            this.changeColour(new ZappoColourScheme());
        } else if (source == this.taylorColour) {
            this.changeColour(new TaylorColourScheme());
        } else if (source == this.hydrophobicityColour) {
            this.changeColour(new HydrophobicColourScheme());
        } else if (source == this.helixColour) {
            this.changeColour(new HelixColourScheme());
        } else if (source == this.strandColour) {
            this.changeColour(new StrandColourScheme());
        } else if (source == this.turnColour) {
            this.changeColour(new TurnColourScheme());
        } else if (source == this.buriedColour) {
            this.changeColour(new BuriedColourScheme());
        } else if (source == this.nucleotideColour) {
            this.changeColour(new NucleotideColourScheme());
        } else if (source == this.purinePyrimidineColour) {
            this.changeColour(new PurinePyrimidineColourScheme());
        } else if (source == this.RNAHelixColour) {
            this.changeColour(new RNAHelicesColour(this.viewport.getAlignment()));
        } else if (source == this.modifyPID) {
            this.modifyPID_actionPerformed();
        } else if (source == this.modifyConservation) {
            this.modifyConservation_actionPerformed();
        } else if (source == this.userDefinedColour) {
            new UserDefinedColours(this.alignPanel, null);
        } else if (source == this.PIDColour) {
            this.changeColour(new PIDColourScheme());
        } else if (source == this.BLOSUM62Colour) {
            this.changeColour(new Blosum62ColourScheme());
        } else if (source == this.tcoffeeColour) {
            this.changeColour(new TCoffeeColourScheme(this.alignPanel.getAlignment()));
        } else if (source == this.annotationColour) {
            new AnnotationColourChooser(this.viewport, this.alignPanel);
        } else if (source == this.annotationColumnSelection) {
            new AnnotationColumnChooser(this.viewport, this.alignPanel);
        } else if (source == this.sortPairwiseMenuItem) {
            this.sortPairwiseMenuItem_actionPerformed();
        } else if (source == this.sortIDMenuItem) {
            this.sortIDMenuItem_actionPerformed();
        } else if (source == this.sortLengthMenuItem) {
            this.sortLengthMenuItem_actionPerformed();
        } else if (source == this.sortGroupMenuItem) {
            this.sortGroupMenuItem_actionPerformed();
        } else if (source == this.removeRedundancyMenuItem) {
            this.removeRedundancyMenuItem_actionPerformed();
        } else if (source == this.pairwiseAlignmentMenuItem) {
            this.pairwiseAlignmentMenuItem_actionPerformed();
        } else if (source == this.PCAMenuItem) {
            this.PCAMenuItem_actionPerformed();
        } else if (source == this.averageDistanceTreeMenuItem) {
            this.averageDistanceTreeMenuItem_actionPerformed();
        } else if (source == this.neighbourTreeMenuItem) {
            this.neighbourTreeMenuItem_actionPerformed();
        } else if (source == this.njTreeBlosumMenuItem) {
            this.njTreeBlosumMenuItem_actionPerformed();
        } else if (source == this.avDistanceTreeBlosumMenuItem) {
            this.avTreeBlosumMenuItem_actionPerformed();
        } else if (source == this.documentation) {
            this.documentation_actionPerformed();
        } else if (source == this.about) {
            this.about_actionPerformed();
        }
    }

    public void inputText_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, MessageManager.getString("label.input_cut_paste"), 500, 500);
    }

    protected void outputText_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, MessageManager.formatMessage("label.alignment_output_command", e.getActionCommand()), 600, 500);
        FileFormatI fileFormat = FileFormats.getInstance().forName(e.getActionCommand());
        cap.setText(new AppletFormatAdapter(this.alignPanel).formatSequences(fileFormat, this.viewport.getAlignment(), this.viewport.getShowJVSuffix()));
    }

    public void loadAnnotations() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        cap.setText(MessageManager.getString("label.paste_features_annotations_Tcoffee_here"));
        cap.setAnnotationImport();
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, MessageManager.getString("action.paste_annotations"), 400, 300);
    }

    public String outputAnnotations(boolean displayTextbox) {
        String annotation = new AnnotationFile().printAnnotationsForView(this.viewport);
        if (displayTextbox) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, MessageManager.getString("label.annotations"), 600, 500);
            cap.setText(annotation);
        }
        return annotation;
    }

    private Map<String, FeatureColourI> getDisplayedFeatureCols() {
        if (this.alignPanel.getFeatureRenderer() != null && this.viewport.getFeaturesDisplayed() != null) {
            return this.alignPanel.getFeatureRenderer().getDisplayedFeatureCols();
        }
        return null;
    }

    private List<String> getDisplayedFeatureGroups() {
        if (this.alignPanel.getFeatureRenderer() != null && this.viewport.getFeaturesDisplayed() != null) {
            return this.alignPanel.getFeatureRenderer().getDisplayedFeatureGroups();
        }
        return null;
    }

    public String outputFeatures(boolean displayTextbox, String format) {
        FeaturesFile formatter = new FeaturesFile();
        String features = format.equalsIgnoreCase("Jalview") ? formatter.printJalviewFormat(this.viewport.getAlignment().getSequencesArray(), this.alignPanel.getFeatureRenderer(), true, false) : formatter.printGffFormat(this.viewport.getAlignment().getSequencesArray(), this.alignPanel.getFeatureRenderer(), true, false);
        if (displayTextbox) {
            boolean frimport = false;
            if (features == null || features.equals("No Features Visible")) {
                features = "# No features visible - paste some and import them here.";
                frimport = true;
            }
            CutAndPasteTransfer cap = new CutAndPasteTransfer(frimport, this);
            if (frimport) {
                cap.setAnnotationImport();
            }
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, MessageManager.getString("label.features"), 600, 500);
            cap.setText(features);
        } else if (features == null) {
            features = "";
        }
        return features;
    }

    void launchFullApplication() {
        StringBuffer url = new StringBuffer(this.jalviewServletURL);
        String firstSep = url.lastIndexOf("?") > url.lastIndexOf("/") ? "&" : "?";
        url.append(firstSep);
        url.append("open=" + this.appendProtocol(this.viewport.applet.getParameter("file")));
        if (this.viewport.applet.getParameter("features") != null) {
            url.append("&features=");
            url.append(this.appendProtocol(this.viewport.applet.getParameter("features")));
        }
        if (this.viewport.applet.getParameter("annotations") != null) {
            url.append("&annotations=");
            url.append(this.appendProtocol(this.viewport.applet.getParameter("annotations")));
        }
        if (this.viewport.applet.getParameter("jnetfile") != null || this.viewport.applet.getParameter("jpredfile") != null) {
            url.append("&annotations=");
            url.append(this.appendProtocol(this.viewport.applet.getParameter("jnetfile") != null ? this.viewport.applet.getParameter("jnetfile") : this.viewport.applet.getParameter("jpredfile")));
        }
        if (this.viewport.applet.getParameter("defaultColour") != null) {
            url.append("&colour=" + this.removeWhiteSpace(this.viewport.applet.getParameter("defaultColour")));
        }
        if (this.viewport.applet.getParameter("userDefinedColour") != null) {
            url.append("&colour=" + this.removeWhiteSpace(this.viewport.applet.getParameter("userDefinedColour")));
        }
        if (this.viewport.applet.getParameter("tree") != null) {
            url.append("&tree=" + this.appendProtocol(this.viewport.applet.getParameter("tree")));
        }
        if (this.viewport.applet.getParameter("treeFile") != null) {
            url.append("&tree=" + this.appendProtocol(this.viewport.applet.getParameter("treeFile")));
        }
        this.showURL(url.toString(), "FULL_APP");
    }

    String removeWhiteSpace(String colour) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < colour.length(); ++i) {
            if (Character.isWhitespace(colour.charAt(i))) {
                sb.append("%20");
                continue;
            }
            sb.append(colour.charAt(i));
        }
        return sb.toString();
    }

    String appendProtocol(String url) {
        try {
            new URL((String)url);
            url = URLEncoder.encode((String)url, "UTF-8");
        }
        catch (MalformedURLException ex) {
            url = this.viewport.applet.getCodeBase() + (String)url;
        }
        catch (UnsupportedEncodingException ex) {
            Console.errPrintln("WARNING = IMPLEMENTATION ERROR - UNSUPPORTED ENCODING EXCEPTION FOR " + (String)url);
            ex.printStackTrace();
        }
        return url;
    }

    public void closeMenuItem_actionPerformed() {
        PaintRefresher.RemoveComponent(this.alignPanel);
        if (this.alignPanel.seqPanel != null && this.alignPanel.seqPanel.seqCanvas != null) {
            PaintRefresher.RemoveComponent(this.alignPanel.seqPanel.seqCanvas);
        }
        if (this.alignPanel.idPanel != null && this.alignPanel.idPanel.idCanvas != null) {
            PaintRefresher.RemoveComponent(this.alignPanel.idPanel.idCanvas);
        }
        if (PaintRefresher.components.size() == 0 && this.viewport.applet == null) {
            System.exit(0);
        }
        this.viewport = null;
        if (this.alignPanel != null && this.alignPanel.overviewPanel != null) {
            this.alignPanel.overviewPanel.dispose();
        }
        this.alignPanel = null;
        this.dispose();
    }

    void updateEditMenuBar() {
        CommandI command;
        if (this.viewport.getHistoryList().size() > 0) {
            this.undoMenuItem.setEnabled(true);
            command = this.viewport.getHistoryList().peek();
            this.undoMenuItem.setLabel(MessageManager.formatMessage("label.undo_command", command.getDescription()));
        } else {
            this.undoMenuItem.setEnabled(false);
            this.undoMenuItem.setLabel(MessageManager.getString("action.undo"));
        }
        if (this.viewport.getRedoList().size() > 0) {
            this.redoMenuItem.setEnabled(true);
            command = this.viewport.getRedoList().peek();
            this.redoMenuItem.setLabel(MessageManager.formatMessage("label.redo_command", command.getDescription()));
        } else {
            this.redoMenuItem.setEnabled(false);
            this.redoMenuItem.setLabel(MessageManager.getString("action.redo"));
        }
    }

    @Override
    public void addHistoryItem(CommandI command) {
        if (command.getSize() > 0) {
            this.viewport.addToHistoryList(command);
            this.viewport.clearRedoList();
            this.updateEditMenuBar();
            this.viewport.updateHiddenColumns();
        }
    }

    protected void undoMenuItem_actionPerformed() {
        if (this.viewport.getHistoryList().isEmpty()) {
            return;
        }
        CommandI command = this.viewport.getHistoryList().pop();
        this.viewport.addToRedoList(command);
        command.undoCommand(null);
        AlignmentViewport originalSource = this.getOriginatingSource(command);
        if (originalSource != this.viewport) {
            System.err.println("Warning: Viewport object mismatch whilst undoing");
        }
        originalSource.updateHiddenColumns();
        this.updateEditMenuBar();
        originalSource.firePropertyChange("alignment", null, originalSource.getAlignment().getSequences());
    }

    protected void redoMenuItem_actionPerformed() {
        if (this.viewport.getRedoList().isEmpty()) {
            return;
        }
        CommandI command = this.viewport.getRedoList().pop();
        this.viewport.addToHistoryList(command);
        command.doCommand(null);
        AlignmentViewport originalSource = this.getOriginatingSource(command);
        if (originalSource != this.viewport) {
            System.err.println("Warning: Viewport object mismatch whilst re-doing");
        }
        originalSource.updateHiddenColumns();
        this.updateEditMenuBar();
        originalSource.firePropertyChange("alignment", null, originalSource.getAlignment().getSequences());
    }

    AlignmentViewport getOriginatingSource(CommandI command) {
        AlignViewport originalSource = null;
        AlignmentI al = null;
        if (command instanceof EditCommand) {
            EditCommand editCommand = (EditCommand)command;
            al = editCommand.getAlignment();
            Vector<Component> comps = PaintRefresher.components.get(this.viewport.getSequenceSetId());
            for (int i = 0; i < comps.size(); ++i) {
                if (!(comps.elementAt(i) instanceof AlignmentPanel) || al != ((AlignmentPanel)comps.elementAt((int)i)).av.getAlignment()) continue;
                originalSource = ((AlignmentPanel)comps.elementAt((int)i)).av;
                break;
            }
        }
        if (originalSource == null) {
            if (al != null) {
                PaintRefresher.validateSequences(al, this.viewport.getAlignment());
            }
            originalSource = this.viewport;
        }
        return originalSource;
    }

    public void moveSelectedSequences(boolean up) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            return;
        }
        this.viewport.getAlignment().moveSelectedSequencesByOne(sg, up ? null : this.viewport.getHiddenRepSequences(), up);
        this.alignPanel.paintAlignment(true, false);
        AlignViewportI complement = this.viewport.getCodingComplement();
        if (complement != null) {
            SequenceGroup mappedSelection = MappingUtils.mapSequenceGroup(sg, this.viewport, complement);
            complement.getAlignment().moveSelectedSequencesByOne(mappedSelection, up ? null : complement.getHiddenRepSequences(), up);
            this.getSplitFrame().getComplement((AlignFrame)this).alignPanel.paintAlignment(true, false);
        }
    }

    synchronized void slideSequences(boolean right, int size) {
        List<Object> sg = new Vector<SequenceI>();
        if (this.viewport.cursorMode) {
            sg.add(this.viewport.getAlignment().getSequenceAt(this.alignPanel.seqPanel.seqCanvas.cursorY));
        } else if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() != this.viewport.getAlignment().getHeight()) {
            sg = this.viewport.getSelectionGroup().getSequences(this.viewport.getHiddenRepSequences());
        }
        if (sg.size() < 1) {
            return;
        }
        Vector<SequenceI> invertGroup = new Vector<SequenceI>();
        for (int i = 0; i < this.viewport.getAlignment().getHeight(); ++i) {
            if (sg.contains(this.viewport.getAlignment().getSequenceAt(i))) continue;
            invertGroup.addElement(this.viewport.getAlignment().getSequenceAt(i));
        }
        SequenceI[] seqs1 = sg.toArray(new SequenceI[sg.size()]);
        SequenceI[] seqs2 = invertGroup.toArray(new SequenceI[invertGroup.size()]);
        for (int i = 0; i < invertGroup.size(); ++i) {
            seqs2[i] = (SequenceI)invertGroup.elementAt(i);
        }
        SlideSequencesCommand ssc = right ? new SlideSequencesCommand("Slide Sequences", seqs2, seqs1, size, this.viewport.getGapCharacter()) : new SlideSequencesCommand("Slide Sequences", seqs1, seqs2, size, this.viewport.getGapCharacter());
        int groupAdjustment = 0;
        if (ssc.getGapsInsertedBegin() && right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.seqPanel.moveCursor(size, 0);
            } else {
                groupAdjustment = size;
            }
        } else if (!ssc.getGapsInsertedBegin() && !right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.seqPanel.moveCursor(-size, 0);
            } else {
                groupAdjustment = -size;
            }
        }
        if (groupAdjustment != 0) {
            this.viewport.getSelectionGroup().setStartRes(this.viewport.getSelectionGroup().getStartRes() + groupAdjustment);
            this.viewport.getSelectionGroup().setEndRes(this.viewport.getSelectionGroup().getEndRes() + groupAdjustment);
        }
        boolean appendHistoryItem = false;
        Deque<CommandI> historyList = this.viewport.getHistoryList();
        if (historyList != null && historyList.size() > 0 && historyList.peek() instanceof SlideSequencesCommand) {
            appendHistoryItem = ssc.appendSlideCommand((SlideSequencesCommand)historyList.peek());
        }
        if (!appendHistoryItem) {
            this.addHistoryItem(ssc);
        }
        this.repaint();
    }

    protected void copy_actionPerformed() {
        if (this.viewport.getSelectionGroup() == null) {
            return;
        }
        SequenceGroup sg = this.viewport.getSelectionGroup();
        copiedSequences = new StringBuffer();
        HashMap<Integer, SequenceI> orderedSeqs = new HashMap<Integer, SequenceI>();
        for (int i = 0; i < sg.getSize(); ++i) {
            SequenceI seq = sg.getSequenceAt(i);
            int index = this.viewport.getAlignment().findIndex(seq);
            orderedSeqs.put(index, seq);
        }
        int index = 0;
        if (this.viewport.hasHiddenColumns() && this.viewport.getSelectionGroup() != null) {
            int hiddenOffset = this.viewport.getSelectionGroup().getStartRes();
            int hiddenCutoff = this.viewport.getSelectionGroup().getEndRes();
            copiedHiddenColumns = new HiddenColumns(this.viewport.getAlignment().getHiddenColumns(), hiddenOffset, hiddenCutoff, hiddenOffset);
        } else {
            copiedHiddenColumns = null;
        }
        for (int i = 0; i < sg.getSize(); ++i) {
            SequenceI seq = null;
            while (seq == null) {
                if (orderedSeqs.containsKey(index)) {
                    seq = (SequenceI)orderedSeqs.get(index);
                    ++index;
                    break;
                }
                ++index;
            }
            int startRes = seq.findPosition(sg.getStartRes());
            int endRes = 0;
            for (int j = 0; j < sg.getEndRes() + 1 && j < seq.getLength(); ++j) {
                char ch = seq.getCharAt(j);
                if (Comparison.isGap(ch)) continue;
                ++endRes;
            }
            if (endRes > 0) {
                endRes += seq.getStart() - 1;
            }
            copiedSequences.append(seq.getName() + "\t" + startRes + "\t" + endRes + "\t" + seq.getSequenceAsString(sg.getStartRes(), sg.getEndRes() + 1) + "\n");
        }
    }

    protected void pasteNew_actionPerformed() {
        this.paste(true);
    }

    protected void pasteThis_actionPerformed() {
        this.paste(false);
    }

    void paste(boolean newAlignment) {
        try {
            if (copiedSequences == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(copiedSequences.toString(), "\t");
            Vector<Sequence> seqs = new Vector<Sequence>();
            while (st.hasMoreElements()) {
                String name = st.nextToken();
                int start = Integer.parseInt(st.nextToken());
                int end = Integer.parseInt(st.nextToken());
                seqs.addElement(new Sequence(name, st.nextToken(), start, end));
            }
            SequenceI[] newSeqs = new SequenceI[seqs.size()];
            for (int i = 0; i < seqs.size(); ++i) {
                newSeqs[i] = (SequenceI)seqs.elementAt(i);
            }
            if (newAlignment) {
                String newtitle = MessageManager.getString("label.copied_sequences");
                newtitle = this.getTitle().startsWith(MessageManager.getString("label.copied_sequences")) ? this.getTitle() : newtitle.concat(MessageManager.formatMessage("label.from_msname", new String[]{this.getTitle()}));
                AlignFrame af = new AlignFrame(new Alignment(newSeqs), this.viewport.applet, newtitle, false);
                af.viewport.setHiddenColumns(copiedHiddenColumns);
                JalviewLite.addFrame(af, newtitle, this.frameWidth, this.frameHeight);
            } else {
                this.addSequences(newSeqs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addSequences(SequenceI[] seqs) {
        for (int i = 0; i < seqs.length; ++i) {
            this.viewport.getAlignment().addSequence(seqs[i]);
        }
        this.addHistoryItem(new EditCommand(MessageManager.getString("label.add_sequences"), EditCommand.Action.PASTE, seqs, 0, this.viewport.getAlignment().getWidth(), this.viewport.getAlignment()));
        this.viewport.getRanges().setEndSeq(this.viewport.getAlignment().getHeight() - 1);
        this.viewport.getAlignment().getWidth();
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    protected void cut_actionPerformed() {
        this.copy_actionPerformed();
        this.delete_actionPerformed();
    }

    protected void delete_actionPerformed() {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            return;
        }
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < sg.getSize(); ++i) {
            SequenceI seq = sg.getSequenceAt(i);
            seqs.addElement(seq);
        }
        if (sg.getSize() == this.viewport.getAlignment().getHeight()) {
            boolean isEntireAlignWidth;
            boolean bl = isEntireAlignWidth = sg.getEndRes() - sg.getStartRes() + 1 == this.viewport.getAlignment().getWidth();
            if (isEntireAlignWidth) {
                String title = MessageManager.getString("label.delete_all");
                Panel infoPanel = new Panel();
                infoPanel.setLayout(new FlowLayout());
                infoPanel.add(new Label(MessageManager.getString("warn.delete_all")));
                JVDialog dialog = new JVDialog(this, title, true, 400, 200);
                dialog.setMainPanel(infoPanel);
                dialog.ok.setLabel(MessageManager.getString("action.ok"));
                dialog.cancel.setLabel(MessageManager.getString("action.cancel"));
                dialog.setVisible(true);
                if (!dialog.accept) {
                    return;
                }
            }
            this.viewport.getColumnSelection().removeElements(sg.getStartRes(), sg.getEndRes() + 1);
        }
        SequenceI[] cut = new SequenceI[seqs.size()];
        for (int i = 0; i < seqs.size(); ++i) {
            cut[i] = (SequenceI)seqs.elementAt(i);
        }
        this.addHistoryItem(new EditCommand(MessageManager.getString("label.cut_sequences"), EditCommand.Action.CUT, cut, sg.getStartRes(), sg.getEndRes() - sg.getStartRes() + 1, this.viewport.getAlignment()));
        this.viewport.setSelectionGroup(null);
        this.viewport.getAlignment().deleteGroup(sg);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        if (this.viewport.getAlignment().getHeight() < 1) {
            this.setVisible(false);
        }
        this.viewport.sendSelection();
    }

    protected void showGroupConsensus_actionPerformed() {
        this.viewport.setShowGroupConsensus(this.showGroupConsensus.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    protected void showGroupConservation_actionPerformed() {
        this.viewport.setShowGroupConservation(this.showGroupConservation.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    protected void showConsensusHistogram_actionPerformed() {
        this.viewport.setShowConsensusHistogram(this.showConsensusHistogram.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    protected void showSequenceLogo_actionPerformed() {
        this.viewport.setShowSequenceLogo(this.showSequenceLogo.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    protected void normSequenceLogo_actionPerformed() {
        this.showSequenceLogo.setState(true);
        this.viewport.setShowSequenceLogo(true);
        this.viewport.setNormaliseSequenceLogo(this.normSequenceLogo.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    protected void applyAutoAnnotationSettings_actionPerformed() {
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    protected void makeGrpsFromSelection_actionPerformed() {
        if (this.avc.makeGroupsFromSelection()) {
            PaintRefresher.Refresh(this, this.viewport.getSequenceSetId());
            this.alignPanel.updateAnnotation();
            this.alignPanel.paintAlignment(true, true);
        }
    }

    protected void createGroup_actionPerformed() {
        this.avc.createGroup();
    }

    protected void unGroup_actionPerformed() {
        if (this.avc.unGroup()) {
            this.alignPanel.alignmentChanged();
        }
    }

    protected void deleteGroups_actionPerformed() {
        if (this.avc.deleteGroups()) {
            this.alignPanel.alignmentChanged();
        }
    }

    public void selectAllSequenceMenuItem_actionPerformed() {
        SequenceGroup sg = new SequenceGroup();
        for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
            sg.addSequence(this.viewport.getAlignment().getSequenceAt(i), false);
        }
        sg.setEndRes(this.viewport.getAlignment().getWidth() - 1);
        this.viewport.setSelectionGroup(sg);
        this.alignPanel.paintAlignment(false, false);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
        this.viewport.sendSelection();
    }

    public void deselectAllSequenceMenuItem_actionPerformed() {
        if (this.viewport.cursorMode) {
            this.alignPanel.seqPanel.keyboardNo1 = null;
            this.alignPanel.seqPanel.keyboardNo2 = null;
        }
        this.viewport.setSelectionGroup(null);
        this.viewport.getColumnSelection().clear();
        this.viewport.setSelectionGroup(null);
        this.alignPanel.idPanel.idCanvas.searchResults = null;
        this.alignPanel.seqPanel.seqCanvas.highlightSearchResults(null);
        this.alignPanel.paintAlignment(false, false);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
        this.viewport.sendSelection();
    }

    public void invertSequenceMenuItem_actionPerformed() {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
            sg.addOrRemove(this.viewport.getAlignment().getSequenceAt(i), false);
        }
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
        this.viewport.sendSelection();
    }

    public void invertColSel_actionPerformed() {
        this.viewport.invertColumnSelection();
        this.alignPanel.paintAlignment(true, false);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
        this.viewport.sendSelection();
    }

    void trimAlignment(boolean trimLeft) {
        AlignmentI al = this.viewport.getAlignment();
        ViewportRanges ranges = this.viewport.getRanges();
        ColumnSelection colSel = this.viewport.getColumnSelection();
        if (!colSel.isEmpty()) {
            TrimRegionCommand trimRegion;
            int column = trimLeft ? colSel.getMin() : colSel.getMax();
            SequenceI[] seqs = this.viewport.getSelectionGroup() != null ? this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.getHiddenRepSequences()) : al.getSequencesArray();
            if (trimLeft) {
                trimRegion = new TrimRegionCommand("Remove Left", true, seqs, column, al);
                ranges.setStartRes(0);
            } else {
                trimRegion = new TrimRegionCommand("Remove Right", false, seqs, column, al);
            }
            this.setStatus(MessageManager.formatMessage("label.removed_columns", new String[]{Integer.valueOf(trimRegion.getSize()).toString()}));
            this.addHistoryItem(trimRegion);
            for (SequenceGroup sg : al.getGroups()) {
                if ((!trimLeft || sg.adjustForRemoveLeft(column)) && (trimLeft || sg.adjustForRemoveRight(column))) continue;
                al.deleteGroup(sg);
            }
            this.viewport.firePropertyChange("alignment", null, al.getSequences());
        }
    }

    public void removeGappedColumnMenuItem_actionPerformed() {
        SequenceI[] seqs;
        AlignmentI al = this.viewport.getAlignment();
        ViewportRanges ranges = this.viewport.getRanges();
        int start = 0;
        int end = ranges.getAbsoluteAlignmentWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.getHiddenRepSequences());
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.getAlignment().getSequencesArray();
        }
        RemoveGapColCommand removeGapCols = new RemoveGapColCommand("Remove Gapped Columns", seqs, start, end, this.viewport.getAlignment());
        this.addHistoryItem(removeGapCols);
        this.setStatus(MessageManager.formatMessage("label.removed_empty_columns", new String[]{Integer.valueOf(removeGapCols.getSize()).toString()}));
        SequenceI seq = al.getSequenceAt(0);
        int startRes = seq.findPosition(ranges.getStartRes());
        ranges.setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, al.getSequences());
    }

    public void removeAllGapsMenuItem_actionPerformed() {
        SequenceI[] seqs;
        AlignmentI al = this.viewport.getAlignment();
        ViewportRanges ranges = this.viewport.getRanges();
        int start = 0;
        int end = ranges.getAbsoluteAlignmentWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.getHiddenRepSequences());
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.getAlignment().getSequencesArray();
        }
        SequenceI seq = al.getSequenceAt(0);
        int startRes = seq.findPosition(ranges.getStartRes());
        this.addHistoryItem(new RemoveGapsCommand("Remove Gaps", seqs, start, end, al));
        ranges.setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, al.getSequences());
    }

    public void findMenuItem_actionPerformed() {
        new Finder(this.alignPanel);
    }

    public AlignFrame newView(String viewtitle) {
        Alignment newal = this.viewport.hasHiddenRows() ? new Alignment(this.viewport.getAlignment().getHiddenSequences().getFullAlignment().getSequencesArray()) : new Alignment(this.viewport.getAlignment().getSequencesArray());
        if (this.viewport.getAlignment().getAlignmentAnnotation() != null) {
            for (int i = 0; i < this.viewport.getAlignment().getAlignmentAnnotation().length; ++i) {
                if (this.viewport.getAlignment().getAlignmentAnnotation()[i].autoCalculated) continue;
                newal.addAnnotation(this.viewport.getAlignment().getAlignmentAnnotation()[i]);
            }
        }
        AlignFrame newaf = new AlignFrame(newal, this.viewport.applet, "", false);
        newaf.viewport.setSequenceSetId(this.alignPanel.av.getSequenceSetId());
        PaintRefresher.Register(this.alignPanel, this.alignPanel.av.getSequenceSetId());
        PaintRefresher.Register(newaf.alignPanel, newaf.alignPanel.av.getSequenceSetId());
        PaintRefresher.Register(newaf.alignPanel.idPanel.idCanvas, newaf.alignPanel.av.getSequenceSetId());
        PaintRefresher.Register(newaf.alignPanel.seqPanel.seqCanvas, newaf.alignPanel.av.getSequenceSetId());
        Vector<Component> comps = PaintRefresher.components.get(this.viewport.getSequenceSetId());
        int viewSize = -1;
        for (int i = 0; i < comps.size(); ++i) {
            if (!(comps.elementAt(i) instanceof AlignmentPanel)) continue;
            ++viewSize;
        }
        Object title = new String(this.getTitle());
        if (viewtitle != null) {
            title = viewtitle + " ( " + (String)title + ")";
        } else {
            if (((String)title).indexOf("(View") > -1) {
                title = ((String)title).substring(0, ((String)title).indexOf("(View"));
            }
            title = (String)title + "(View " + viewSize + ")";
        }
        newaf.setTitle(((String)title).toString());
        newaf.viewport.setHistoryList(this.viewport.getHistoryList());
        newaf.viewport.setRedoList(this.viewport.getRedoList());
        return newaf;
    }

    public String[] getFeatureGroups() {
        FeatureRenderer fr = null;
        if (this.alignPanel != null && (fr = this.alignPanel.getFeatureRenderer()) != null) {
            List<String> gps = fr.getFeatureGroups();
            String[] _gps = gps.toArray(new String[gps.size()]);
            return _gps;
        }
        return null;
    }

    public String[] getFeatureGroupsOfState(boolean visible) {
        FeatureRenderer fr = null;
        if (this.alignPanel != null && (fr = this.alignPanel.getFeatureRenderer()) != null) {
            List<String> gps = fr.getGroups(visible);
            String[] _gps = gps.toArray(new String[gps.size()]);
            return _gps;
        }
        return null;
    }

    public void setFeatureGroupState(String[] groups, boolean state) {
        FeatureRenderer fr = null;
        this.sequenceFeatures.setState(true);
        this.viewport.setShowSequenceFeatures(true);
        if (this.alignPanel != null && (fr = this.alignPanel.getFeatureRenderer()) != null) {
            fr.setGroupVisibility(Arrays.asList(groups), state);
            this.alignPanel.seqPanel.seqCanvas.repaint();
            if (this.alignPanel.overviewPanel != null) {
                this.alignPanel.overviewPanel.updateOverviewImage();
            }
        }
    }

    public void seqLimits_itemStateChanged() {
        this.viewport.setShowJVSuffix(this.seqLimits.getState());
        this.alignPanel.fontChanged();
        this.alignPanel.paintAlignment(true, false);
    }

    protected void colourTextMenuItem_actionPerformed() {
        this.viewport.setColourText(this.colourTextMenuItem.getState());
        this.alignPanel.paintAlignment(false, false);
    }

    protected void displayNonconservedMenuItem_actionPerformed() {
        this.viewport.setShowUnconserved(this.displayNonconservedMenuItem.getState());
        this.alignPanel.paintAlignment(false, false);
    }

    protected void wrapMenuItem_actionPerformed() {
        this.viewport.setWrapAlignment(this.wrapMenuItem.getState());
        this.alignPanel.setWrapAlignment(this.wrapMenuItem.getState());
        this.scaleAbove.setEnabled(this.wrapMenuItem.getState());
        this.scaleLeft.setEnabled(this.wrapMenuItem.getState());
        this.scaleRight.setEnabled(this.wrapMenuItem.getState());
        this.alignPanel.paintAlignment(true, false);
    }

    public void overviewMenuItem_actionPerformed() {
        if (this.alignPanel.overviewPanel != null) {
            return;
        }
        Frame frame = new Frame();
        final OverviewPanel overview = new OverviewPanel(this.alignPanel);
        frame.add(overview);
        JalviewLite.addFrame(frame, MessageManager.formatMessage("label.overview_params", new String[]{this.getTitle()}), overview.getPreferredSize().width, overview.getPreferredSize().height + 50);
        frame.pack();
        final AlignmentPanel ap = this.alignPanel;
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                overview.dispose();
                if (ap != null) {
                    ap.setOverviewPanel(null);
                }
            }
        });
        this.alignPanel.setOverviewPanel(overview);
    }

    @Override
    public void changeColour(ColourSchemeI cs) {
        this.viewport.setGlobalColourScheme(cs);
        this.alignPanel.paintAlignment(true, true);
    }

    protected void modifyPID_actionPerformed() {
        if (this.viewport.getAbovePIDThreshold() && this.viewport.getGlobalColourScheme() != null) {
            SliderPanel.setPIDSliderSource(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
            SliderPanel.showPIDSlider();
        }
    }

    protected void modifyConservation_actionPerformed() {
        if (this.viewport.getConservationSelected() && this.viewport.getGlobalColourScheme() != null) {
            SliderPanel.setConservationSlider(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
            SliderPanel.showConservationSlider();
        }
    }

    protected void conservationMenuItem_actionPerformed() {
        boolean selected = this.conservationMenuItem.getState();
        this.modifyConservation.setEnabled(selected);
        this.viewport.setConservationSelected(selected);
        this.viewport.getResidueShading().setConservationApplied(selected);
        this.changeColour(this.viewport.getGlobalColourScheme());
        if (selected) {
            this.modifyConservation_actionPerformed();
        } else {
            SliderPanel.hideConservationSlider();
        }
    }

    public void abovePIDThreshold_actionPerformed() {
        boolean selected = this.abovePIDThreshold.getState();
        this.modifyPID.setEnabled(selected);
        this.viewport.setAbovePIDThreshold(selected);
        if (!selected) {
            this.viewport.getResidueShading().setThreshold(0, this.viewport.isIgnoreGapsConsensus());
        }
        this.changeColour(this.viewport.getGlobalColourScheme());
        if (selected) {
            this.modifyPID_actionPerformed();
        } else {
            SliderPanel.hidePIDSlider();
        }
    }

    public void sortPairwiseMenuItem_actionPerformed() {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByPID(this.viewport.getAlignment(), this.viewport.getAlignment().getSequenceAt(0));
        this.addHistoryItem(new OrderCommand("Pairwise Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    public void sortIDMenuItem_actionPerformed() {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByID(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("ID Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    public void sortLengthMenuItem_actionPerformed() {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByLength(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("Length Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    public void sortGroupMenuItem_actionPerformed() {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByGroup(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("Group Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    public void removeRedundancyMenuItem_actionPerformed() {
        new RedundancyPanel(this.alignPanel);
    }

    public void pairwiseAlignmentMenuItem_actionPerformed() {
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 1) {
            Frame frame = new Frame();
            frame.add(new PairwiseAlignPanel(this.alignPanel));
            JalviewLite.addFrame(frame, MessageManager.getString("action.pairwise_alignment"), 600, 500);
        }
    }

    public void PCAMenuItem_actionPerformed() {
        if (!this.viewport.getAlignment().isAligned(false)) {
            int Width = this.viewport.getAlignment().getWidth();
            for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
                SequenceI current = this.viewport.getAlignment().getSequenceAt(i);
                if (current.getLength() >= Width) continue;
                current.insertCharAt(Width - 1, this.viewport.getGapCharacter());
            }
            this.alignPanel.paintAlignment(false, false);
        }
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() < 4 && this.viewport.getSelectionGroup().getSize() > 0 || this.viewport.getAlignment().getHeight() < 4) {
            return;
        }
        try {
            new PCAPanel(this.viewport);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void averageDistanceTreeMenuItem_actionPerformed() {
        this.newTreePanel("AV", new PIDModel().getName(), "Average distance tree using PID");
    }

    public void neighbourTreeMenuItem_actionPerformed() {
        this.newTreePanel("NJ", new PIDModel().getName(), "Neighbour joining tree using PID");
    }

    protected void njTreeBlosumMenuItem_actionPerformed() {
        this.newTreePanel("NJ", ScoreModels.getInstance().getBlosum62().getName(), "Neighbour joining tree using BLOSUM62");
    }

    protected void avTreeBlosumMenuItem_actionPerformed() {
        this.newTreePanel("AV", ScoreModels.getInstance().getBlosum62().getName(), "Average distance tree using BLOSUM62");
    }

    void newTreePanel(String type, String pwType, String title) {
        if (!this.viewport.getAlignment().isAligned(false)) {
            int Width = this.viewport.getAlignment().getWidth();
            for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
                SequenceI current = this.viewport.getAlignment().getSequenceAt(i);
                if (current.getLength() >= Width) continue;
                current.insertCharAt(Width - 1, this.viewport.getGapCharacter());
            }
            this.alignPanel.paintAlignment(false, false);
        }
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 1 || this.viewport.getAlignment().getHeight() > 1) {
            TreePanel tp = new TreePanel(this.alignPanel, type, pwType);
            this.addTreeMenuItem(tp, title);
            JalviewLite.addFrame(tp, title, 600, 500);
        }
    }

    void loadTree_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        cap.setText(MessageManager.getString("label.paste_newick_tree_file"));
        cap.setTreeImport();
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, MessageManager.getString("label.paste_newick_file"), 400, 300);
    }

    public void loadTree(NewickFile tree, String treeFile) {
        TreePanel tp = new TreePanel(this.alignPanel, treeFile, MessageManager.getString("label.load_tree_from_file"), tree);
        JalviewLite.addFrame(tp, treeFile, 600, 500);
        this.addTreeMenuItem(tp, treeFile);
    }

    public void sortByTree(TreePanel treePanel, String title) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByTree(this.viewport.getAlignment(), treePanel.getTree());
        this.addHistoryItem(new OrderCommand(MessageManager.formatMessage("label.order_by_params", new String[]{title}), oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    protected void addTreeMenuItem(final TreePanel treePanel, final String title) {
        final MenuItem item = new MenuItem(title);
        this.sortByTreeMenu.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlignFrame.this.sortByTree(treePanel, title);
            }
        });
        treePanel.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (AlignFrame.this.viewport.sortByTree) {
                    AlignFrame.this.sortByTree(treePanel, title);
                }
                super.windowOpened(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                AlignFrame.this.sortByTreeMenu.remove(item);
            }
        });
    }

    public boolean sortBy(AlignmentOrder alorder, String undoname) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        JalviewLite cfr_ignored_0 = this.viewport.applet;
        if (JalviewLite.debug) {
            Console.errPrintln("Sorting " + alorder.getOrder().size() + " in alignment '" + this.getTitle() + "'");
        }
        AlignmentSorter.sortBy(this.viewport.getAlignment(), alorder);
        if (undoname != null) {
            this.addHistoryItem(new OrderCommand(undoname, oldOrder, this.viewport.getAlignment()));
        }
        this.alignPanel.paintAlignment(true, false);
        return true;
    }

    protected void documentation_actionPerformed() {
        this.alignPanel.av.applet.openJalviewHelpUrl();
    }

    protected void about_actionPerformed() {
        Frame frame = new Frame();
        class AboutPanel
        extends Canvas {
            String version;
            String builddate;

            public AboutPanel(String version, String builddate) {
                this.version = version;
                this.builddate = builddate;
            }

            @Override
            public void paint(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
                g.setFont(new Font("Helvetica", 0, 12));
                FontMetrics fm = g.getFontMetrics();
                int fh = fm.getHeight();
                int y = 5;
                int x = 7;
                g.setColor(Color.black);
                g.setFont(new Font("Helvetica", 1, 14));
                g.drawString(MessageManager.formatMessage("label.jalviewLite_release", new String[]{this.version}), x, y += fh);
                g.setFont(new Font("Helvetica", 1, 12));
                g.drawString(MessageManager.formatMessage("label.jaview_build_date", new String[]{this.builddate}), x, y += fh);
                g.setFont(new Font("Helvetica", 0, 12));
                y = (int)((double)y + (double)fh * 1.5);
                g.drawString(MessageManager.getString("label.jalview_authors_1"), x, y);
                g.drawString(MessageManager.getString("label.jalview_authors_2"), x + 50, y += fh + 8);
                g.drawString(MessageManager.getString("label.jalview_dev_managers"), x, y += fh);
                g.drawString(MessageManager.getString("label.jalview_distribution_lists"), x, y += fh);
                g.drawString(MessageManager.getString("label.jalview_please_cite"), x, y += fh + 8);
                g.drawString(MessageManager.getString("label.jalview_cite_1_authors"), x, y += fh);
                g.drawString(MessageManager.getString("label.jalview_cite_1_title"), x, y += fh);
                g.drawString(MessageManager.getString("label.jalview_cite_1_ref"), x, y += fh);
            }
        }
        frame.add(new AboutPanel(JalviewLite.getVersion(), JalviewLite.getBuildDate()));
        JalviewLite.addFrame(frame, MessageManager.getString("label.jalview"), 580, 220);
    }

    public void showURL(String url, String target) {
        if (this.viewport.applet == null) {
            Console.outPrintln("Not running as applet - no browser available.");
        } else {
            this.viewport.applet.showURL(url, target);
        }
    }

    private void jbInit() throws Exception {
        this.setMenuBar(this.alignFrameMenuBar);
        this.inputText.setLabel(MessageManager.getString("label.input_from_textbox"));
        this.inputText.addActionListener(this);
        Menu outputTextboxMenu = new Menu(MessageManager.getString("label.out_to_textbox"));
        for (String ff : FileFormats.getInstance().getWritableFormats(true)) {
            MenuItem item = new MenuItem(ff);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlignFrame.this.outputText_actionPerformed(e);
                }
            });
            outputTextboxMenu.add(item);
        }
        this.closeMenuItem.addActionListener(this);
        this.loadApplication.addActionListener(this);
        this.loadTree.addActionListener(this);
        this.loadAnnotations.addActionListener(this);
        this.outputFeatures.addActionListener(this);
        this.outputAnnotations.addActionListener(this);
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.setLabel(MessageManager.getString("action.undo"));
        this.undoMenuItem.addActionListener(this);
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.setLabel(MessageManager.getString("action.redo"));
        this.redoMenuItem.addActionListener(this);
        this.copy.setLabel(MessageManager.getString("action.copy"));
        this.copy.addActionListener(this);
        this.cut.setLabel(MessageManager.getString("action.cut"));
        this.cut.addActionListener(this);
        this.delete.setLabel(MessageManager.getString("action.delete"));
        this.delete.addActionListener(this);
        this.pasteMenu.setLabel(MessageManager.getString("action.paste"));
        this.pasteNew.setLabel(MessageManager.getString("label.to_new_alignment"));
        this.pasteNew.addActionListener(this);
        this.pasteThis.setLabel(MessageManager.getString("label.to_this_alignment"));
        this.pasteThis.addActionListener(this);
        this.remove2LeftMenuItem.setLabel(MessageManager.getString("action.remove_left"));
        this.remove2LeftMenuItem.addActionListener(this);
        this.remove2RightMenuItem.setLabel(MessageManager.getString("action.remove_right"));
        this.remove2RightMenuItem.addActionListener(this);
        this.removeGappedColumnMenuItem.setLabel(MessageManager.getString("action.remove_empty_columns"));
        this.removeGappedColumnMenuItem.addActionListener(this);
        this.removeAllGapsMenuItem.setLabel(MessageManager.getString("action.remove_all_gaps"));
        this.removeAllGapsMenuItem.addActionListener(this);
        this.removeRedundancyMenuItem.setLabel(MessageManager.getString("action.remove_redundancy"));
        this.removeRedundancyMenuItem.addActionListener(this);
        this.findMenuItem.setLabel(MessageManager.getString("action.find"));
        this.findMenuItem.addActionListener(this);
        this.selectAllSequenceMenuItem.addActionListener(this);
        this.deselectAllSequenceMenuItem.addActionListener(this);
        this.invertSequenceMenuItem.setLabel(MessageManager.getString("action.invert_sequence_selection"));
        this.invertSequenceMenuItem.addActionListener(this);
        this.invertColSel.setLabel(MessageManager.getString("action.invert_column_selection"));
        this.invertColSel.addActionListener(this);
        this.deleteGroups.setLabel(MessageManager.getString("action.undefine_groups"));
        this.deleteGroups.addActionListener(this);
        this.grpsFromSelection.setLabel(MessageManager.getString("action.make_groups_selection"));
        this.grpsFromSelection.addActionListener(this);
        this.createGroup.setLabel(MessageManager.getString("action.create_group"));
        this.createGroup.addActionListener(this);
        this.unGroup.setLabel(MessageManager.getString("action.remove_group"));
        this.unGroup.addActionListener(this);
        this.annotationColumnSelection.setLabel(MessageManager.getString("action.select_by_annotation"));
        this.annotationColumnSelection.addActionListener(this);
        this.newView.setLabel(MessageManager.getString("action.new_view"));
        this.newView.addActionListener(this);
        Menu showMenu = new Menu(MessageManager.getString("action.show"));
        this.showColumns.setLabel(MessageManager.getString("label.all_columns"));
        this.showSeqs.setLabel(MessageManager.getString("label.all_sequences"));
        Menu hideMenu = new Menu(MessageManager.getString("action.hide"));
        this.hideColumns.setLabel(MessageManager.getString("label.selected_columns"));
        this.hideSequences.setLabel(MessageManager.getString("label.selected_sequences"));
        this.hideAllButSelection.setLabel(MessageManager.getString("label.all_but_selected_region"));
        this.hideAllSelection.setLabel(MessageManager.getString("label.selected_region"));
        this.showAllHidden.setLabel(MessageManager.getString("label.all_sequences_columns"));
        this.showColumns.addActionListener(this);
        this.showSeqs.addActionListener(this);
        this.hideColumns.addActionListener(this);
        this.hideSequences.addActionListener(this);
        this.hideAllButSelection.addActionListener(this);
        this.hideAllSelection.addActionListener(this);
        this.showAllHidden.addActionListener(this);
        this.featureSettings.setLabel(MessageManager.getString("action.feature_settings"));
        this.featureSettings.addActionListener(this);
        this.sequenceFeatures.setLabel(MessageManager.getString("label.show_sequence_features"));
        this.sequenceFeatures.addItemListener(this);
        this.sequenceFeatures.setState(false);
        this.followMouseOverFlag.setLabel(MessageManager.getString("label.automatic_scrolling"));
        this.followMouseOverFlag.addItemListener(this);
        this.alProperties.addActionListener(this);
        this.overviewMenuItem.setLabel(MessageManager.getString("label.overview_window"));
        this.overviewMenuItem.addActionListener(this);
        this.annotationPanelMenuItem.setLabel(MessageManager.getString("label.show_annotations"));
        this.annotationPanelMenuItem.addItemListener(this);
        this.showGroupConsensus.setLabel(MessageManager.getString("label.group_consensus"));
        this.showGroupConservation.setLabel(MessageManager.getString("label.group_conservation"));
        this.showConsensusHistogram.setLabel(MessageManager.getString("label.show_consensus_histogram"));
        this.showSequenceLogo.setLabel(MessageManager.getString("label.show_consensus_logo"));
        this.normSequenceLogo.setLabel(MessageManager.getString("label.norm_consensus_logo"));
        this.applyAutoAnnotationSettings.setLabel(MessageManager.getString("label.apply_all_groups"));
        this.applyAutoAnnotationSettings.setState(true);
        Menu autoAnnMenu = new Menu(MessageManager.getString("label.autocalculated_annotation"));
        Menu selectSS = new Menu(MessageManager.getString("label.select_secondary_structure_source"));
        this.showGroupConsensus.addItemListener(this);
        this.showGroupConservation.addItemListener(this);
        this.showConsensusHistogram.addItemListener(this);
        this.showSequenceLogo.addItemListener(this);
        this.normSequenceLogo.addItemListener(this);
        this.applyAutoAnnotationSettings.addItemListener(this);
        this.showAlignmentAnnotations = new CheckboxMenuItem(MessageManager.getString("label.show_all_al_annotations"));
        this.showSequenceAnnotations = new CheckboxMenuItem(MessageManager.getString("label.show_all_seq_annotations"));
        this.sortAnnBySequence = new CheckboxMenuItem(MessageManager.getString("label.sort_annotations_by_sequence"));
        this.sortAnnByLabel = new CheckboxMenuItem(MessageManager.getString("label.sort_annotations_by_label"));
        this.showAutoFirst = new CheckboxMenuItem(MessageManager.getString("label.show_first"));
        this.showAutoFirst.setState(false);
        this.setShowAutoCalculatedAbove(this.showAutoFirst.getState());
        this.showAutoLast = new CheckboxMenuItem(MessageManager.getString("label.show_last"));
        this.showAutoLast.setState(!this.showAutoFirst.getState());
        this.showAlignmentAnnotations.addItemListener(this);
        this.showSequenceAnnotations.addItemListener(this);
        this.sortAnnBySequence.addItemListener(this);
        this.sortAnnByLabel.addItemListener(this);
        this.showAutoFirst.addItemListener(this);
        this.showAutoLast.addItemListener(this);
        this.font.setLabel(MessageManager.getString("action.font"));
        this.font.addActionListener(this);
        this.scaleAbove.setLabel(MessageManager.getString("action.scale_above"));
        this.scaleAbove.setState(true);
        this.scaleAbove.setEnabled(false);
        this.scaleAbove.addItemListener(this);
        this.scaleLeft.setEnabled(false);
        this.scaleLeft.setState(true);
        this.scaleLeft.setLabel(MessageManager.getString("action.scale_left"));
        this.scaleLeft.addItemListener(this);
        this.scaleRight.setEnabled(false);
        this.scaleRight.setState(true);
        this.scaleRight.setLabel(MessageManager.getString("action.scale_right"));
        this.scaleRight.addItemListener(this);
        this.viewBoxesMenuItem.setLabel(MessageManager.getString("action.boxes"));
        this.viewBoxesMenuItem.setState(true);
        this.viewBoxesMenuItem.addItemListener(this);
        this.viewTextMenuItem.setLabel(MessageManager.getString("action.text"));
        this.viewTextMenuItem.setState(true);
        this.viewTextMenuItem.addItemListener(this);
        this.colourTextMenuItem.setLabel(MessageManager.getString("label.colour_text"));
        this.colourTextMenuItem.addItemListener(this);
        this.displayNonconservedMenuItem.setLabel(MessageManager.getString("label.show_non_conserved"));
        this.displayNonconservedMenuItem.addItemListener(this);
        this.wrapMenuItem.setLabel(MessageManager.getString("action.wrap"));
        this.wrapMenuItem.addItemListener(this);
        this.renderGapsMenuItem.setLabel(MessageManager.getString("action.show_gaps"));
        this.renderGapsMenuItem.setState(true);
        this.renderGapsMenuItem.addItemListener(this);
        this.centreColumnLabelFlag.setLabel(MessageManager.getString("label.centre_column_labels"));
        this.centreColumnLabelFlag.addItemListener(this);
        this.seqLimits.setState(true);
        this.seqLimits.setLabel(MessageManager.getString("label.show_sequence_limits"));
        this.seqLimits.addItemListener(this);
        this.applyToAllGroups.setLabel(MessageManager.getString("label.apply_colour_to_all_groups"));
        this.applyToAllGroups.setState(true);
        this.applyToAllGroups.addItemListener(this);
        this.clustalColour.setLabel(MessageManager.getString("label.colourScheme_clustal"));
        this.clustalColour.addActionListener(this);
        this.zappoColour.setLabel(MessageManager.getString("label.colourScheme_zappo"));
        this.zappoColour.addActionListener(this);
        this.taylorColour.setLabel(MessageManager.getString("label.colourScheme_taylor"));
        this.taylorColour.addActionListener(this);
        this.hydrophobicityColour.setLabel(MessageManager.getString("label.colourScheme_hydrophobic"));
        this.hydrophobicityColour.addActionListener(this);
        this.helixColour.setLabel(MessageManager.getString("label.colourScheme_helixpropensity"));
        this.helixColour.addActionListener(this);
        this.strandColour.setLabel(MessageManager.getString("label.colourScheme_strandpropensity"));
        this.strandColour.addActionListener(this);
        this.turnColour.setLabel(MessageManager.getString("label.colourScheme_turnpropensity"));
        this.turnColour.addActionListener(this);
        this.buriedColour.setLabel(MessageManager.getString("label.colourScheme_buriedindex"));
        this.buriedColour.addActionListener(this);
        this.purinePyrimidineColour.setLabel(MessageManager.getString("label.colourScheme_purine/pyrimidine"));
        this.purinePyrimidineColour.addActionListener(this);
        this.RNAHelixColour.setLabel(MessageManager.getString("label.colourScheme_rnahelices"));
        this.RNAHelixColour.addActionListener(this);
        this.userDefinedColour.setLabel(MessageManager.getString("action.user_defined"));
        this.userDefinedColour.addActionListener(this);
        this.PIDColour.setLabel(MessageManager.getString("label.colourScheme_%identity"));
        this.PIDColour.addActionListener(this);
        this.BLOSUM62Colour.setLabel(MessageManager.getString("label.colourScheme_blosum62"));
        this.BLOSUM62Colour.addActionListener(this);
        this.tcoffeeColour.setLabel(MessageManager.getString("label.colourScheme_t-coffeescores"));
        this.tcoffeeColour.setEnabled(false);
        this.tcoffeeColour.addActionListener(this);
        this.conservationMenuItem.setLabel(MessageManager.getString("action.by_conservation"));
        this.conservationMenuItem.addItemListener(this);
        this.noColourmenuItem.setLabel(MessageManager.getString("label.none"));
        this.noColourmenuItem.addActionListener(this);
        this.abovePIDThreshold.setLabel(MessageManager.getString("label.above_identity_threshold"));
        this.abovePIDThreshold.addItemListener(this);
        this.nucleotideColour.setLabel(MessageManager.getString("label.colourScheme_nucleotide"));
        this.nucleotideColour.addActionListener(this);
        this.modifyPID.setLabel(MessageManager.getString("label.modify_identity_threshold"));
        this.modifyPID.setEnabled(this.abovePIDThreshold.getState());
        this.modifyPID.addActionListener(this);
        this.modifyConservation.setLabel(MessageManager.getString("label.modify_conservation_threshold"));
        this.modifyConservation.setEnabled(this.conservationMenuItem.getState());
        this.modifyConservation.addActionListener(this);
        this.annotationColour.setLabel(MessageManager.getString("action.by_annotation"));
        this.annotationColour.addActionListener(this);
        this.sortPairwiseMenuItem.setLabel(MessageManager.getString("action.by_pairwise_id"));
        this.sortPairwiseMenuItem.addActionListener(this);
        this.sortIDMenuItem.setLabel(MessageManager.getString("action.by_id"));
        this.sortIDMenuItem.addActionListener(this);
        this.sortLengthMenuItem.setLabel(MessageManager.getString("action.by_length"));
        this.sortLengthMenuItem.addActionListener(this);
        this.sortGroupMenuItem.setLabel(MessageManager.getString("action.by_group"));
        this.sortGroupMenuItem.addActionListener(this);
        this.pairwiseAlignmentMenuItem.setLabel(MessageManager.getString("action.pairwise_alignment"));
        this.pairwiseAlignmentMenuItem.addActionListener(this);
        this.PCAMenuItem.setLabel(MessageManager.getString("label.principal_component_analysis"));
        this.PCAMenuItem.addActionListener(this);
        this.autoCalculate = new CheckboxMenuItem(MessageManager.getString("label.autocalculate_consensus"), true);
        this.averageDistanceTreeMenuItem.setLabel(MessageManager.getString("label.average_distance_identity"));
        this.averageDistanceTreeMenuItem.addActionListener(this);
        this.neighbourTreeMenuItem.setLabel(MessageManager.getString("label.neighbour_joining_identity"));
        this.neighbourTreeMenuItem.addActionListener(this);
        this.avDistanceTreeBlosumMenuItem.setLabel(MessageManager.getString("label.average_distance_blosum62"));
        this.avDistanceTreeBlosumMenuItem.addActionListener(this);
        this.njTreeBlosumMenuItem.setLabel(MessageManager.getString("label.neighbour_blosum62"));
        this.njTreeBlosumMenuItem.addActionListener(this);
        this.sortByTreeMenu.setLabel(MessageManager.getString("action.by_tree_order"));
        Menu sortMenu = new Menu(MessageManager.getString("action.sort"));
        Menu calculateTreeMenu = new Menu(MessageManager.getString("action.calculate_tree"));
        this.autoCalculate.addItemListener(this);
        this.sortByTree.addItemListener(this);
        Menu helpMenu = new Menu(MessageManager.getString("action.help"));
        this.documentation.setLabel(MessageManager.getString("label.documentation"));
        this.documentation.addActionListener(this);
        this.about.setLabel(MessageManager.getString("label.about"));
        this.about.addActionListener(this);
        this.alignFrameMenuBar.add(this.fileMenu);
        Menu editMenu = new Menu(MessageManager.getString("action.edit"));
        this.alignFrameMenuBar.add(editMenu);
        Menu selectMenu = new Menu(MessageManager.getString("action.select"));
        this.alignFrameMenuBar.add(selectMenu);
        Menu viewMenu = new Menu(MessageManager.getString("action.view"));
        this.alignFrameMenuBar.add(viewMenu);
        Menu annotationsMenu = new Menu(MessageManager.getString("action.annotations"));
        this.alignFrameMenuBar.add(annotationsMenu);
        Menu formatMenu = new Menu(MessageManager.getString("action.format"));
        this.alignFrameMenuBar.add(formatMenu);
        Menu colourMenu = new Menu(MessageManager.getString("action.colour"));
        this.alignFrameMenuBar.add(colourMenu);
        Menu calculateMenu = new Menu(MessageManager.getString("action.calculate"));
        this.alignFrameMenuBar.add(calculateMenu);
        this.alignFrameMenuBar.add(helpMenu);
        this.fileMenu.add(this.inputText);
        this.fileMenu.add(this.loadTree);
        this.fileMenu.add(this.loadAnnotations);
        this.fileMenu.addSeparator();
        this.fileMenu.add(outputTextboxMenu);
        this.fileMenu.add(this.outputFeatures);
        this.fileMenu.add(this.outputAnnotations);
        if (this.jalviewServletURL != null) {
            this.fileMenu.add(this.loadApplication);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMenuItem);
        editMenu.add(this.undoMenuItem);
        editMenu.add(this.redoMenuItem);
        editMenu.add(this.cut);
        editMenu.add(this.copy);
        this.pasteMenu.add(this.pasteNew);
        this.pasteMenu.add(this.pasteThis);
        editMenu.add(this.pasteMenu);
        editMenu.add(this.delete);
        editMenu.addSeparator();
        editMenu.add(this.remove2LeftMenuItem);
        editMenu.add(this.remove2RightMenuItem);
        editMenu.add(this.removeGappedColumnMenuItem);
        editMenu.add(this.removeAllGapsMenuItem);
        editMenu.add(this.removeRedundancyMenuItem);
        selectMenu.add(this.findMenuItem);
        selectMenu.addSeparator();
        selectMenu.add(this.selectAllSequenceMenuItem);
        selectMenu.add(this.deselectAllSequenceMenuItem);
        selectMenu.add(this.invertSequenceMenuItem);
        selectMenu.add(this.invertColSel);
        selectMenu.add(this.createGroup);
        selectMenu.add(this.unGroup);
        selectMenu.add(this.grpsFromSelection);
        selectMenu.add(this.deleteGroups);
        selectMenu.add(this.annotationColumnSelection);
        viewMenu.add(this.newView);
        viewMenu.addSeparator();
        showMenu.add(this.showColumns);
        showMenu.add(this.showSeqs);
        showMenu.add(this.showAllHidden);
        viewMenu.add(showMenu);
        hideMenu.add(this.hideColumns);
        hideMenu.add(this.hideSequences);
        hideMenu.add(this.hideAllSelection);
        hideMenu.add(this.hideAllButSelection);
        viewMenu.add(hideMenu);
        viewMenu.addSeparator();
        viewMenu.add(this.followMouseOverFlag);
        viewMenu.addSeparator();
        viewMenu.add(this.sequenceFeatures);
        viewMenu.add(this.featureSettings);
        viewMenu.addSeparator();
        viewMenu.add(this.alProperties);
        viewMenu.addSeparator();
        viewMenu.add(this.overviewMenuItem);
        annotationsMenu.add(this.annotationPanelMenuItem);
        annotationsMenu.addSeparator();
        annotationsMenu.add(this.showAlignmentAnnotations);
        annotationsMenu.add(this.showSequenceAnnotations);
        annotationsMenu.add(this.sortAnnBySequence);
        annotationsMenu.add(this.sortAnnByLabel);
        annotationsMenu.addSeparator();
        autoAnnMenu.add(this.showAutoFirst);
        autoAnnMenu.add(this.showAutoLast);
        autoAnnMenu.addSeparator();
        autoAnnMenu.add(this.applyAutoAnnotationSettings);
        autoAnnMenu.add(this.showConsensusHistogram);
        autoAnnMenu.add(this.showSequenceLogo);
        autoAnnMenu.add(this.normSequenceLogo);
        autoAnnMenu.addSeparator();
        autoAnnMenu.add(this.showGroupConservation);
        autoAnnMenu.add(this.showGroupConsensus);
        annotationsMenu.add(autoAnnMenu);
        formatMenu.add(this.font);
        formatMenu.add(this.seqLimits);
        formatMenu.add(this.wrapMenuItem);
        formatMenu.add(this.scaleAbove);
        formatMenu.add(this.scaleLeft);
        formatMenu.add(this.scaleRight);
        formatMenu.add(this.viewBoxesMenuItem);
        formatMenu.add(this.viewTextMenuItem);
        formatMenu.add(this.colourTextMenuItem);
        formatMenu.add(this.displayNonconservedMenuItem);
        formatMenu.add(this.renderGapsMenuItem);
        formatMenu.add(this.centreColumnLabelFlag);
        colourMenu.add(this.applyToAllGroups);
        colourMenu.addSeparator();
        colourMenu.add(this.noColourmenuItem);
        colourMenu.add(this.clustalColour);
        colourMenu.add(this.BLOSUM62Colour);
        colourMenu.add(this.PIDColour);
        colourMenu.add(this.zappoColour);
        colourMenu.add(this.taylorColour);
        colourMenu.add(this.hydrophobicityColour);
        colourMenu.add(this.helixColour);
        colourMenu.add(this.strandColour);
        colourMenu.add(this.turnColour);
        colourMenu.add(this.buriedColour);
        colourMenu.add(this.nucleotideColour);
        colourMenu.add(this.purinePyrimidineColour);
        colourMenu.add(this.tcoffeeColour);
        colourMenu.add(this.userDefinedColour);
        colourMenu.addSeparator();
        colourMenu.add(this.conservationMenuItem);
        colourMenu.add(this.modifyConservation);
        colourMenu.add(this.abovePIDThreshold);
        colourMenu.add(this.modifyPID);
        colourMenu.add(this.annotationColour);
        colourMenu.add(this.RNAHelixColour);
        sortMenu.add(this.sortIDMenuItem);
        sortMenu.add(this.sortLengthMenuItem);
        sortMenu.add(this.sortByTreeMenu);
        sortMenu.add(this.sortGroupMenuItem);
        sortMenu.add(this.sortPairwiseMenuItem);
        calculateMenu.add(sortMenu);
        calculateTreeMenu.add(this.averageDistanceTreeMenuItem);
        calculateTreeMenu.add(this.neighbourTreeMenuItem);
        calculateTreeMenu.add(this.avDistanceTreeBlosumMenuItem);
        calculateTreeMenu.add(this.njTreeBlosumMenuItem);
        calculateMenu.add(calculateTreeMenu);
        calculateMenu.addSeparator();
        calculateMenu.add(this.pairwiseAlignmentMenuItem);
        calculateMenu.add(this.PCAMenuItem);
        calculateMenu.add(this.autoCalculate);
        calculateMenu.add(this.sortByTree);
        helpMenu.add(this.documentation);
        helpMenu.add(this.about);
        this.statusBar.setBackground(Color.white);
        this.statusBar.setFont(new Font("Verdana", 0, 11));
        this.setStatus(MessageManager.getString("label.status_bar"));
        this.add((Component)this.statusBar, "South");
    }

    @Override
    public void setStatus(String string) {
        this.statusBar.setText(string);
    }

    public void createAlignFrameWindow(boolean reallyEmbedded) {
        if (reallyEmbedded) {
            this.embedAlignFrameInApplet(this.viewport.applet);
        } else {
            if (this.embedMenuIfNeeded(this.alignPanel)) {
                this.alignPanel.setSize(this.getSize().width, this.getSize().height - this.statusBar.getHeight());
            }
            this.add((Component)this.statusBar, "South");
            this.add((Component)this.alignPanel, "Center");
            JalviewLite.addFrame(this, this.getTitle(), this.frameWidth, this.frameHeight);
        }
    }

    public void embedAlignFrameInApplet(final JalviewLite theApplet) {
        this.fileMenu.remove(this.closeMenuItem);
        this.fileMenu.remove(3);
        this.embeddedMenu = this.makeEmbeddedPopupMenu(this.alignFrameMenuBar, false, false);
        theApplet.setLayout(new BorderLayout());
        theApplet.add((Component)this.embeddedMenu, "North");
        theApplet.add((Component)this.statusBar, "South");
        this.alignPanel.setSize(theApplet.getSize().width, theApplet.getSize().height - this.embeddedMenu.getHeight() - this.statusBar.getHeight());
        theApplet.add((Component)this.alignPanel, "Center");
        final AlignFrame me = this;
        theApplet.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (theApplet.currentAlignFrame == me) {
                    theApplet.currentAlignFrame = null;
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                theApplet.currentAlignFrame = me;
            }
        });
        theApplet.validate();
    }

    public SequenceStructureBinding addStructureViewInstance(Object jmolviewer, String[] sequenceIds) {
        Viewer viewer = null;
        try {
            viewer = (Viewer)jmolviewer;
        }
        catch (ClassCastException ex) {
            Console.errPrintln("Unsupported viewer object :" + jmolviewer.getClass());
        }
        if (viewer == null) {
            Console.errPrintln("Can't use this object as a structure viewer:" + jmolviewer.getClass());
            return null;
        }
        SequenceI[] seqs = null;
        if (sequenceIds == null || sequenceIds.length == 0) {
            seqs = this.viewport.getAlignment().getSequencesArray();
        } else {
            int sid;
            Vector<SequenceI> sqi = new Vector<SequenceI>();
            AlignmentI al = this.viewport.getAlignment();
            for (sid = 0; sid < sequenceIds.length; ++sid) {
                SequenceI sq = al.findName(sequenceIds[sid]);
                if (sq == null) continue;
                sqi.addElement(sq);
            }
            if (sqi.size() > 0) {
                seqs = new SequenceI[sqi.size()];
                int sSize = sqi.size();
                for (sid = 0; sid < sSize; ++sid) {
                    seqs[sid] = (SequenceI)sqi.elementAt(sid);
                }
            } else {
                return null;
            }
        }
        ExtJmol jmv = null;
        if (jmv == null) {
            jmv = new ExtJmol(viewer, this.alignPanel, new SequenceI[][]{seqs});
        }
        return jmv;
    }

    public boolean addPdbFile(String sequenceId, String pdbEntryString, String pdbFile) {
        SequenceI toaddpdb = this.viewport.getAlignment().findName(sequenceId);
        boolean needtoadd = false;
        if (toaddpdb != null) {
            DataSourceType protocol;
            Vector<PDBEntry> pdbe = toaddpdb.getAllPDBEntries();
            PDBEntry pdbentry = null;
            if (pdbe != null && pdbe.size() > 0) {
                int peSize = pdbe.size();
                for (int pe = 0; pe < peSize; ++pe) {
                    pdbentry = pdbe.elementAt(pe);
                    if (pdbentry.getId().equals(pdbEntryString) || pdbentry.getFile().equals(pdbFile)) continue;
                    pdbentry = null;
                }
            }
            if (pdbentry == null) {
                pdbentry = new PDBEntry();
                pdbentry.setId(pdbEntryString);
                pdbentry.setFile(pdbFile);
                needtoadd = true;
            }
            if ((protocol = AppletFormatAdapter.resolveProtocol(pdbFile, FileFormat.PDB)) == null) {
                return false;
            }
            if (needtoadd) {
                pdbentry.setProtocol(protocol);
                toaddpdb.addPDBId(pdbentry);
                this.alignPanel.getStructureSelectionManager().registerPDBEntry(pdbentry);
            }
        }
        return true;
    }

    private Object[] cleanSeqChainArrays(SequenceI[] seqs, String[] chains) {
        if (seqs != null) {
            int i;
            Vector<Object[]> sequences = new Vector<Object[]>();
            for (i = 0; i < seqs.length; ++i) {
                if (seqs[i] == null) continue;
                sequences.addElement(new Object[]{seqs[i], chains != null ? chains[i] : null});
            }
            seqs = new SequenceI[sequences.size()];
            chains = new String[sequences.size()];
            int isize = sequences.size();
            for (i = 0; i < isize; ++i) {
                Object[] oj = (Object[])sequences.elementAt(i);
                seqs[i] = (SequenceI)oj[0];
                chains[i] = (String)oj[1];
            }
        }
        return new Object[]{seqs, chains};
    }

    public void newStructureView(JalviewLite applet, PDBEntry pdb, SequenceI[] seqs, String[] chains, DataSourceType protocol) {
        Object[] sqch = this.cleanSeqChainArrays(seqs, chains);
        seqs = (SequenceI[])sqch[0];
        chains = (String[])sqch[1];
        if (seqs == null || seqs.length == 0) {
            Console.errPrintln("JalviewLite.AlignFrame:newStructureView: No sequence to bind structure to.");
        }
        if (protocol == null) {
            String sourceType = (String)pdb.getProperty("protocol");
            try {
                protocol = DataSourceType.valueOf(sourceType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (protocol == null) {
                Console.errPrintln("Couldn't work out protocol to open structure: " + pdb.getId());
                return;
            }
        }
        if (applet.useXtrnalSviewer) {
            if (StructureSelectionManager.getStructureSelectionManager(applet).setMapping(seqs, chains, pdb.getFile(), protocol, null) == null) {
                Console.errPrintln("Failed to map " + pdb.getFile() + " (" + protocol + ") to any sequences");
            }
            return;
        }
        if (applet.isAlignPdbStructures() && applet.jmolAvailable) {
            AppletJmol ajm = null;
            Vector jmols = applet.getAppletWindow(AppletJmol.class);
            int iSize = jmols.size();
            for (int i = 0; i < iSize; ++i) {
                AppletJmol tajm = (AppletJmol)jmols.elementAt(i);
                if (tajm.ap.alignFrame != this) continue;
                ajm = tajm;
                break;
            }
            if (ajm != null) {
                Console.errPrintln("Incremental adding and aligning structure to existing Jmol view not yet implemented.");
                ajm = null;
            }
        }
        if (applet.jmolAvailable) {
            new AppletJmol(pdb, seqs, chains, this.alignPanel, protocol);
            JalviewLite.lastFrameX += 40;
            JalviewLite.lastFrameY += 40;
        } else {
            new AppletPDBViewer(pdb, seqs, chains, this.alignPanel, protocol);
        }
    }

    public void alignedStructureView(JalviewLite applet, PDBEntry[] pdb, SequenceI[][] seqs, String[][] chains, String[] protocols) {
        Console.errPrintln("Aligned Structure View: Not yet implemented.");
    }

    public void select(SequenceGroup sel, ColumnSelection csel, HiddenColumns hidden) {
        this.alignPanel.seqPanel.selection(sel, csel, hidden, null);
    }

    public void scrollTo(int row, int column) {
        this.alignPanel.seqPanel.scrollTo(row, column);
    }

    public void scrollToRow(int row) {
        this.alignPanel.seqPanel.scrollToRow(row);
    }

    public void scrollToColumn(int column) {
        this.alignPanel.seqPanel.scrollToColumn(column);
    }

    public String getSequenceSetId() {
        return this.viewport.getSequenceSetId();
    }

    public boolean loadScoreFile(String source) throws IOException {
        TCoffeeScoreFile file = new TCoffeeScoreFile(source, AppletFormatAdapter.checkProtocol(source));
        if (!file.isValid()) {
            Console.errPrintln("Problems parsing T-Coffee scores: " + file.getWarningMessage());
            Console.errPrintln("Origin was:\n" + source);
            return false;
        }
        AlignmentI aln = this.viewport.getAlignment();
        if (aln != null && (aln.getHeight() != file.getHeight() || aln.getWidth() != file.getWidth())) {
            Console.errPrintln("The scores matrix does not match the alignment dimensions");
        }
        if (file.annotateAlignment(this.alignPanel.getAlignment(), false)) {
            this.alignPanel.fontChanged();
            this.tcoffeeColour.setEnabled(true);
            this.changeColour(new TCoffeeColourScheme(this.alignPanel.getAlignment()));
            return true;
        }
        Console.errPrintln("Problems resolving T-Coffee scores:");
        if (file.getWarningMessage() != null) {
            Console.errPrintln(file.getWarningMessage());
        }
        return false;
    }

    public SplitFrame getSplitFrame() {
        return this.splitFrame;
    }

    public void setSplitFrame(SplitFrame sf) {
        this.splitFrame = sf;
    }

    @Override
    public void setShowSeqFeatures(boolean b) {
        this.viewport.setShowSequenceFeatures(b);
    }

    @Override
    public void setMenusForViewport() {
    }

    @Override
    public void refreshFeatureUI(boolean enableIfNecessary) {
        if (enableIfNecessary) {
            this.sequenceFeatures.setState(true);
            this.alignPanel.av.setShowSequenceFeatures(true);
        }
    }

    @Override
    public FeatureSettingsControllerI getFeatureSettingsUI() {
        return this.alignPanel.av.featureSettings;
    }

    @Override
    public FeatureSettingsControllerI showFeatureSettingsUI() {
        return new FeatureSettings(this.alignPanel);
    }

    @Override
    public void setFeatureSettingsGeometry(Rectangle bounds) {
        this.fs_bounds = bounds;
    }

    @Override
    public Rectangle getFeatureSettingsGeometry() {
        return this.fs_bounds;
    }
}

