/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.threerings.getdown.Log;
import com.threerings.getdown.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUtil {
    public static long readVersion(File vfile) {
        long fileVersion = -1L;
        try (BufferedReader bin = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(vfile), StandardCharsets.UTF_8));){
            String vstr = bin.readLine();
            if (!StringUtil.isBlank(vstr)) {
                fileVersion = Long.parseLong(vstr);
            }
        }
        catch (Exception e) {
            Log.log.info("Unable to read version file: " + e.getMessage(), new Object[0]);
        }
        return fileVersion;
    }

    public static void writeVersion(File vfile, long version) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(vfile));){
            out.println(version);
        }
        catch (Exception e) {
            Log.log.warning("Unable to write version file: " + e.getMessage(), new Object[0]);
        }
    }

    public static long parseJavaVersion(String versRegex, String versStr) {
        Matcher m = Pattern.compile(versRegex).matcher(versStr);
        if (!m.matches()) {
            return 0L;
        }
        long vers = 0L;
        for (int ii = 1; ii <= m.groupCount(); ++ii) {
            String valstr = m.group(ii);
            int value = valstr == null ? 0 : VersionUtil.parseInt(valstr);
            vers *= 100L;
            vers += (long)value;
        }
        return vers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long readReleaseVersion(File relfile, String versRegex) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(relfile), StandardCharsets.UTF_8));){
            String line = null;
            String relvers = null;
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("JAVA_VERSION=")) continue;
                relvers = line.substring("JAVA_VERSION=".length()).replace('\"', ' ').trim();
            }
            if (relvers == null) {
                Log.log.warning("No JAVA_VERSION line in 'release' file", "file", relfile);
                long l = 0L;
                return l;
            }
            long l = VersionUtil.parseJavaVersion(versRegex, relvers);
            return l;
        }
        catch (Exception e) {
            Log.log.warning("Failed to read version from 'release' file", "file", relfile, e);
            return 0L;
        }
    }

    private static int parseInt(String str) {
        int value = 0;
        int ll = str.length();
        for (int ii = 0; ii < ll; ++ii) {
            char c = str.charAt(ii);
            if (c < '0' || c > '9') continue;
            value *= 10;
            value += c - 48;
        }
        return value;
    }
}

