/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Connection;
import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.applications.templateEditor.MouseControler;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEditor;
import fr.orsay.lri.varna.applications.templateEditor.TemplateEditorPanelUI;
import fr.orsay.lri.varna.applications.templateEditor.UnpairedRegion;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.exceptions.ExceptionXmlLoading;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.undo.UndoManager;

public class TemplatePanel
extends JPanel {
    private static final long serialVersionUID = 3162771335587335679L;
    private ArrayList<GraphicalTemplateElement> _RNAComponents;
    private ArrayList<Connection> _RNAConnections;
    private Hashtable<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Connection> _helixToConnection;
    private TemplateEditorPanelUI _ui;
    private RNATemplate _template;
    private static Color[] BackgroundColors = new Color[]{Color.blue, Color.red, Color.cyan, Color.green, Color.lightGray, Color.magenta, Color.PINK};
    private int _nextBackgroundColor = 0;
    private static double scaleFactorDefault = 0.7;
    private double scaleFactor = scaleFactorDefault;
    private TemplateEditor _editor;
    private GraphicalTemplateElement _selected = null;
    GraphicalTemplateElement.RelativePosition _relpos = GraphicalTemplateElement.RelativePosition.RP_OUTER;
    Point2D.Double _mousePos = new Point2D.Double();
    private static Color[] _colors = new Color[]{Color.gray, Color.pink, Color.cyan, Color.RED, Color.green, Color.orange};
    private static final Color CYCLE_COLOR = Color.red;
    private static final Color NON_EXISTANT_COLOR = Color.gray.brighter();
    private static final Color CONTROL_COLOR = Color.gray.darker();
    private static final Color BACKGROUND_COLOR = Color.white;
    private Stroke _solidStroke;
    private Stroke _dashedStroke;

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public Color nextBackgroundColor() {
        Color color = BackgroundColors[this._nextBackgroundColor++];
        this._nextBackgroundColor %= BackgroundColors.length;
        return new Color(color.getRed(), color.getBlue(), color.getGreen(), 50);
    }

    public TemplatePanel(TemplateEditor templateEditor) {
        this._editor = templateEditor;
        this.init();
    }

    public RNATemplate getTemplate() {
        return this._template;
    }

    List<GraphicalTemplateElement> getRNAComponents() {
        return this._RNAComponents;
    }

    private void init() {
        this._ui = new TemplateEditorPanelUI(this);
        this._RNAComponents = new ArrayList();
        this._RNAConnections = new ArrayList();
        this._helixToConnection = new Hashtable();
        this._template = new RNATemplate();
        this.setBackground(Color.WHITE);
        MouseControler mouseControler = new MouseControler(this, this._ui);
        this.addMouseListener(mouseControler);
        this.addMouseMotionListener(mouseControler);
        this.addMouseWheelListener(mouseControler);
        this._solidStroke = new BasicStroke(1.5f, 1, 1, 3.0f);
        float[] fArray = new float[]{5.0f, 5.0f};
        this._dashedStroke = new BasicStroke(1.5f, 1, 1, 3.0f, fArray, 0.0f);
    }

    public void addUndoableEditListener(UndoManager undoManager) {
        this._ui.addUndoableEditListener(undoManager);
    }

    public TemplateEditorPanelUI getTemplateUI() {
        return this._ui;
    }

    public void flip(Helix helix) {
        helix.toggleFlipped();
    }

    public void addElement(GraphicalTemplateElement graphicalTemplateElement) {
        this._RNAComponents.add(graphicalTemplateElement);
    }

    public void removeElement(GraphicalTemplateElement graphicalTemplateElement) {
        this._RNAComponents.remove(graphicalTemplateElement);
        try {
            this._template.removeElement(graphicalTemplateElement.getTemplateElement());
        }
        catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
            // empty catch block
        }
    }

    public GraphicalTemplateElement getSelected() {
        return this._selected;
    }

    public void setSelected(GraphicalTemplateElement graphicalTemplateElement) {
        this._selected = graphicalTemplateElement;
        if (this._selected instanceof Helix) {
            this._editor.flipButtonEnable();
        } else {
            this._editor.flipButtonDisable();
        }
    }

    public void setSelectedEdge(GraphicalTemplateElement.RelativePosition relativePosition) {
        this._relpos = relativePosition;
    }

    public void unselectEdge(GraphicalTemplateElement.RelativePosition relativePosition) {
        this._relpos = relativePosition;
    }

    public void setPointerPos(Point2D.Double double_) {
        this._mousePos = double_;
    }

    public void Unselect() {
        this._editor.flipButtonDisable();
        this._selected = null;
    }

    public GraphicalTemplateElement getElement(RNATemplate.RNATemplateElement rNATemplateElement) {
        for (GraphicalTemplateElement graphicalTemplateElement : this._RNAComponents) {
            if (rNATemplateElement != graphicalTemplateElement.getTemplateElement()) continue;
            return graphicalTemplateElement;
        }
        return null;
    }

    public GraphicalTemplateElement getElementAt(double d, double d2) {
        return this.getElementAt(d, d2, null);
    }

    public GraphicalTemplateElement getElementAt(double d, double d2, GraphicalTemplateElement graphicalTemplateElement) {
        GraphicalTemplateElement graphicalTemplateElement2 = null;
        for (int i = 0; i < this._RNAComponents.size(); ++i) {
            GraphicalTemplateElement graphicalTemplateElement3 = this._RNAComponents.get(i);
            if (graphicalTemplateElement3.getRelativePosition(d, d2) != GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3 && graphicalTemplateElement3.getRelativePosition(d, d2) != GraphicalTemplateElement.RelativePosition.RP_CONNECT_END5 && graphicalTemplateElement3.getRelativePosition(d, d2) != GraphicalTemplateElement.RelativePosition.RP_CONNECT_START3 && graphicalTemplateElement3.getRelativePosition(d, d2) != GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5 || graphicalTemplateElement == graphicalTemplateElement3) continue;
            graphicalTemplateElement2 = graphicalTemplateElement3;
        }
        if (graphicalTemplateElement2 == null) {
            graphicalTemplateElement2 = this.getElementCloseTo(d, d2, graphicalTemplateElement);
        }
        return graphicalTemplateElement2;
    }

    public GraphicalTemplateElement getElementCloseTo(double d, double d2) {
        return this.getElementCloseTo(d, d2, null);
    }

    public GraphicalTemplateElement getElementCloseTo(double d, double d2, GraphicalTemplateElement graphicalTemplateElement) {
        GraphicalTemplateElement graphicalTemplateElement2 = null;
        for (int i = 0; i < this._RNAComponents.size(); ++i) {
            GraphicalTemplateElement graphicalTemplateElement3 = this._RNAComponents.get(i);
            if (graphicalTemplateElement3.getRelativePosition(d, d2) == GraphicalTemplateElement.RelativePosition.RP_OUTER || graphicalTemplateElement == graphicalTemplateElement3) continue;
            graphicalTemplateElement2 = graphicalTemplateElement3;
        }
        return graphicalTemplateElement2;
    }

    public void addConnection(Connection connection) {
        this._RNAConnections.add(connection);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h1, connection._edge1), connection);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h2, connection._edge2), connection);
        try {
            connection._h1.attach(connection._h2, connection._edge1, connection._edge2);
            connection._h2.attach(connection._h1, connection._edge2, connection._edge1);
        }
        catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
            System.out.println(exceptionInvalidRNATemplate.toString());
        }
    }

    public Connection addConnection(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition, GraphicalTemplateElement graphicalTemplateElement2, GraphicalTemplateElement.RelativePosition relativePosition2) {
        if (graphicalTemplateElement != graphicalTemplateElement2 && this.getPartner(graphicalTemplateElement, relativePosition) == null && this.getPartner(graphicalTemplateElement2, relativePosition2) == null) {
            Connection connection = new Connection(graphicalTemplateElement, relativePosition, graphicalTemplateElement2, relativePosition2);
            this.addConnection(connection);
            return connection;
        }
        return null;
    }

    public void addGraphicalConnection(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition, GraphicalTemplateElement graphicalTemplateElement2, GraphicalTemplateElement.RelativePosition relativePosition2) {
        Connection connection = new Connection(graphicalTemplateElement, relativePosition, graphicalTemplateElement2, relativePosition2);
        this._RNAConnections.add(connection);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h1, connection._edge1), connection);
        this._helixToConnection.put(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h2, connection._edge2), connection);
        connection._h1.graphicalAttach(connection._h2, connection._edge1, connection._edge2);
        connection._h2.graphicalAttach(connection._h1, connection._edge2, connection._edge1);
    }

    public void removeConnection(Connection connection) {
        this._RNAConnections.remove(connection);
        this._helixToConnection.remove(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h1, connection._edge1));
        this._helixToConnection.remove(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h2, connection._edge2));
        System.out.println("[A]" + connection);
        connection._h1.detach(connection._edge1);
    }

    public boolean isInCycle(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition) {
        Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>> stack = new Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>>();
        Hashtable<Couple, Integer> hashtable = new Hashtable<Couple, Integer>();
        stack.add(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(graphicalTemplateElement, relativePosition));
        while (!stack.empty()) {
            Couple couple = (Couple)stack.pop();
            if (hashtable.containsKey(couple)) {
                return true;
            }
            hashtable.put(couple, new Integer(1));
            GraphicalTemplateElement.RelativePosition relativePosition2 = ((GraphicalTemplateElement)couple.first).getConnectedEdge((GraphicalTemplateElement.RelativePosition)((Object)couple.second));
            Couple couple2 = new Couple(couple.first, relativePosition2);
            if (!hashtable.containsKey(couple2)) {
                stack.push(couple2);
                continue;
            }
            Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> couple3 = this.getPartner((GraphicalTemplateElement)couple.first, (GraphicalTemplateElement.RelativePosition)((Object)couple.second));
            if (couple3 == null) continue;
            stack.push(couple3);
        }
        return false;
    }

    public static Color getIndexedColor(int n) {
        return _colors[n % _colors.length];
    }

    public HashMap<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Integer> buildConnectedComponents() {
        HashMap<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Integer> hashMap = new HashMap<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>, Integer>();
        int n = 0;
        for (GraphicalTemplateElement graphicalTemplateElement : this._RNAComponents) {
            for (GraphicalTemplateElement.RelativePosition relativePosition : graphicalTemplateElement.getConnectedEdges()) {
                Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> couple = new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(graphicalTemplateElement, relativePosition);
                if (hashMap.containsKey(couple)) continue;
                Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>> stack = new Stack<Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>>();
                stack.add(couple);
                stack.add(new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(graphicalTemplateElement, graphicalTemplateElement.getConnectedEdge(relativePosition)));
                while (!stack.empty()) {
                    Couple couple2 = (Couple)stack.pop();
                    if (hashMap.containsKey(couple2)) continue;
                    ((GraphicalTemplateElement)couple2.first).setMainColor((GraphicalTemplateElement.RelativePosition)((Object)couple2.second), TemplatePanel.getIndexedColor(n));
                    hashMap.put(couple2, new Integer(n));
                    GraphicalTemplateElement.RelativePosition relativePosition2 = ((GraphicalTemplateElement)couple2.first).getConnectedEdge((GraphicalTemplateElement.RelativePosition)((Object)couple2.second));
                    Couple couple3 = new Couple(couple2.first, relativePosition2);
                    stack.push(couple3);
                    Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> couple4 = this.getPartner((GraphicalTemplateElement)couple2.first, (GraphicalTemplateElement.RelativePosition)((Object)couple2.second));
                    if (couple4 == null) continue;
                    stack.push(couple4);
                }
                ++n;
            }
        }
        return hashMap;
    }

    public boolean isInCycle(Connection connection) {
        return this.isInCycle(connection._h1, connection._edge1);
    }

    public Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> getPartner(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition) {
        Connection connection = this.getConnection(graphicalTemplateElement, relativePosition);
        if (connection != null) {
            if (connection._h1 == graphicalTemplateElement && connection._edge1 == relativePosition) {
                return new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h2, connection._edge2);
            }
            return new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(connection._h1, connection._edge1);
        }
        return null;
    }

    public Connection getConnection(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition) {
        Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> couple = new Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition>(graphicalTemplateElement, relativePosition);
        if (this._helixToConnection.containsKey(couple)) {
            return this._helixToConnection.get(couple);
        }
        return null;
    }

    private boolean isConnected(Helix helix, GraphicalTemplateElement.RelativePosition relativePosition) {
        Couple<GraphicalTemplateElement, GraphicalTemplateElement.RelativePosition> couple = this.getPartner(helix, relativePosition);
        return couple != null;
    }

    private void drawConnections(Graphics2D graphics2D, Connection connection) {
        GraphicalTemplateElement graphicalTemplateElement = connection._h1;
        GraphicalTemplateElement.RelativePosition relativePosition = connection._edge1;
        Point2D.Double double_ = graphicalTemplateElement.getEdgePosition(relativePosition);
        GraphicalTemplateElement graphicalTemplateElement2 = connection._h2;
        GraphicalTemplateElement.RelativePosition relativePosition2 = connection._edge2;
        Point2D.Double double_2 = graphicalTemplateElement2.getEdgePosition(relativePosition2);
        if (this.isInCycle(connection)) {
            graphics2D.setColor(CYCLE_COLOR);
        } else {
            graphics2D.setColor(GraphicalTemplateElement.BACKBONE_COLOR);
        }
        graphics2D.drawLine((int)double_.x, (int)double_.y, (int)double_2.x, (int)double_2.y);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object;
        int n;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.scale(this.scaleFactor, this.scaleFactor);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.removeAll();
        this.buildConnectedComponents();
        if (this._selected != null && this._relpos != GraphicalTemplateElement.RelativePosition.RP_OUTER) {
            Point2D.Double double_ = this._selected.getEdgePosition(this._relpos);
            graphics2D.setStroke(this._solidStroke);
            graphics2D.drawLine((int)this._mousePos.x, (int)this._mousePos.y, (int)double_.x, (int)double_.y);
        }
        for (n = 0; n < this._RNAConnections.size(); ++n) {
            object = this._RNAConnections.get(n);
            this.drawConnections(graphics2D, (Connection)object);
        }
        for (n = 0; n < this._RNAComponents.size(); ++n) {
            object = this._RNAComponents.get(n);
            if (this._selected == object) {
                ((GraphicalTemplateElement)object).draw(graphics2D, true);
                continue;
            }
            ((GraphicalTemplateElement)object).draw(graphics2D, false);
        }
    }

    public Rectangle getBoundingRectange() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this._RNAComponents.size(); ++i) {
            GraphicalTemplateElement graphicalTemplateElement = this._RNAComponents.get(i);
            Polygon polygon = graphicalTemplateElement.getBoundingPolygon();
            Rectangle rectangle = polygon.getBounds();
            n = Math.min(n, rectangle.x);
            n2 = Math.max(n2, rectangle.x + rectangle.width);
            n3 = Math.min(n3, rectangle.y);
            n4 = Math.max(n4, rectangle.y + rectangle.height);
        }
        Rectangle rectangle = new Rectangle();
        rectangle.x = n;
        rectangle.y = n3;
        rectangle.width = n2 - n;
        rectangle.height = n4 - n3;
        return rectangle;
    }

    public void rescale() {
        int n;
        Rectangle rectangle = this.getBoundingRectange();
        if (rectangle.x < 0 || rectangle.y < 0) {
            for (n = 0; n < this._RNAComponents.size(); ++n) {
                GraphicalTemplateElement graphicalTemplateElement = this._RNAComponents.get(n);
                graphicalTemplateElement.translate(rectangle.x < 0 ? (double)(-rectangle.x) : 0.0, rectangle.y < 0 ? (double)(-rectangle.y) : 0.0);
            }
            rectangle = this.getBoundingRectange();
        }
        n = (int)((double)(rectangle.width + 100) * this.scaleFactor);
        int n2 = (int)((double)(rectangle.height + 100) * this.scaleFactor);
        this.setPreferredSize(new Dimension(n, n2));
        this.revalidate();
    }

    public void clearTemplate() {
        this.loadTemplate(new RNATemplate());
    }

    public void loadTemplate(RNATemplate rNATemplate) {
        GraphicalTemplateElement graphicalTemplateElement;
        Object object;
        this._template = rNATemplate;
        this._RNAComponents.clear();
        this._RNAConnections.clear();
        this._helixToConnection.clear();
        HashMap<Object, GraphicalTemplateElement> hashMap = new HashMap<Object, GraphicalTemplateElement>();
        Iterator<Object> iterator = rNATemplate.classicIterator();
        while (iterator.hasNext()) {
            RNATemplate.RNATemplateElement object2 = iterator.next();
            if (object2 instanceof RNATemplate.RNATemplateHelix) {
                object = (RNATemplate.RNATemplateHelix)object2;
                graphicalTemplateElement = new Helix((RNATemplate.RNATemplateHelix)object);
                graphicalTemplateElement.setDominantColor(this.nextBackgroundColor());
                this._RNAComponents.add(graphicalTemplateElement);
                hashMap.put(object, graphicalTemplateElement);
                continue;
            }
            if (!(object2 instanceof RNATemplate.RNATemplateUnpairedSequence)) continue;
            object = (RNATemplate.RNATemplateUnpairedSequence)object2;
            graphicalTemplateElement = new UnpairedRegion((RNATemplate.RNATemplateUnpairedSequence)object);
            graphicalTemplateElement.setDominantColor(this.nextBackgroundColor());
            this._RNAComponents.add(graphicalTemplateElement);
            hashMap.put(object, graphicalTemplateElement);
        }
        for (RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint : rNATemplate.makeEdgeList()) {
            object = edgeEndPoint.getOtherEndPoint();
            graphicalTemplateElement = (GraphicalTemplateElement)hashMap.get(edgeEndPoint.getElement());
            GraphicalTemplateElement graphicalTemplateElement2 = (GraphicalTemplateElement)hashMap.get(((RNATemplate.RNATemplateElement.EdgeEndPoint)object).getElement());
            GraphicalTemplateElement.RelativePosition relativePosition = graphicalTemplateElement.relativePositionFromEdgeEndPointPosition(edgeEndPoint.getPosition());
            GraphicalTemplateElement.RelativePosition relativePosition2 = graphicalTemplateElement2.relativePositionFromEdgeEndPointPosition(((RNATemplate.RNATemplateElement.EdgeEndPoint)object).getPosition());
            this.addGraphicalConnection(graphicalTemplateElement, relativePosition, graphicalTemplateElement2, relativePosition2);
        }
        this.zoomFit();
    }

    public void loadFromXmlFile(File file) {
        try {
            RNATemplate rNATemplate = RNATemplate.fromXMLFile(file);
            this.loadTemplate(rNATemplate);
        }
        catch (ExceptionXmlLoading exceptionXmlLoading) {
            exceptionXmlLoading.printStackTrace();
            JOptionPane.showMessageDialog(this, exceptionXmlLoading.getMessage(), "Template loading error", 0);
        }
    }

    private void zoomFinish() {
        this.rescale();
        this.repaint();
    }

    public void zoomIn() {
        this.scaleFactor *= 1.2;
        this.zoomFinish();
    }

    public void zoomOut() {
        this.scaleFactor /= 1.2;
        this.zoomFinish();
    }

    public void zoomReset() {
        this.scaleFactor = scaleFactorDefault;
        this.zoomFinish();
    }

    public void zoomFit() {
        if (this._RNAComponents.isEmpty()) {
            this.zoomReset();
        } else {
            Rectangle rectangle = this.getBoundingRectange();
            double d = rectangle.width + 100;
            double d2 = rectangle.height + 100;
            this.scaleFactor = 1.0;
            this.scaleFactor = Math.min(this.scaleFactor, (double)this._editor.getJp().getViewport().getSize().width / d);
            this.scaleFactor = Math.min(this.scaleFactor, (double)this._editor.getJp().getViewport().getSize().height / d2);
            this.zoomFinish();
        }
    }

    public void translateView(Point point) {
        int n = this._editor.getJp().getHorizontalScrollBar().getValue() - point.x;
        int n2 = this._editor.getJp().getVerticalScrollBar().getValue() - point.y;
        n = Math.max(0, Math.min(n, this._editor.getJp().getHorizontalScrollBar().getMaximum()));
        n2 = Math.max(0, Math.min(n2, this._editor.getJp().getVerticalScrollBar().getMaximum()));
        this._editor.getJp().getHorizontalScrollBar().setValue(n);
        this._editor.getJp().getVerticalScrollBar().setValue(n2);
    }
}

