/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest;

import jalview.analysis.SeqsetUtils;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.packed.JalviewDataset;
import jalview.ws.AWsJob;
import jalview.ws.rest.AlignmentProcessor;
import jalview.ws.rest.HttpResultSet;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJobThread;
import jalview.ws.rest.RestServiceDescription;
import jalview.ws.rest.params.Alignment;
import jalview.ws.rest.params.SeqGroupIndexVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class RestJob
extends AWsJob {
    RestServiceDescription rsd;
    boolean gotresponse;
    boolean error;
    boolean waiting;
    boolean gotresult;
    Hashtable squniq;
    AlignmentI dsForIO;
    AlignmentOrder inputOrder;
    int[] origviscontig;
    private AlignmentI contextAl = null;
    boolean validInput = false;
    protected String statMessage = null;
    public HttpResultSet resSet;
    private Hashtable<String, Object> inputData = new Hashtable();
    public boolean running = false;
    JalviewDataset context = null;
    protected boolean parsedResults = false;
    protected boolean validJvresults = false;
    Object[] jvresultobj = null;

    public RestJob(int jobNum, RestJobThread restJobThread, AlignmentI _input, int[] viscontigs) {
        this.rsd = restJobThread.restClient.service;
        this.jobnum = jobNum;
        if (viscontigs != null) {
            this.origviscontig = new int[viscontigs.length];
            System.arraycopy(viscontigs, 0, this.origviscontig, 0, viscontigs.length);
        }
        this.squniq = SeqsetUtils.uniquify(_input.getSequencesArray(), true);
        ArrayList<InputType> alinp = new ArrayList<InputType>();
        int paramsWithData = 0;
        for (Map.Entry<String, InputType> prm : this.rsd.inputParams.entrySet()) {
            if (!prm.getValue().isConstant()) {
                if (prm.getValue() instanceof Alignment) {
                    alinp.add(prm.getValue());
                    continue;
                }
                if (prm.getValue() instanceof SeqGroupIndexVector && _input.getGroups() != null && _input.getGroups().size() >= -1 + prm.getValue().min) {
                    alinp.add(prm.getValue());
                    continue;
                }
                this.statMessage = "Not enough groups defined on the alignment - need at least " + prm.getValue().min;
                continue;
            }
            ++paramsWithData;
        }
        if (paramsWithData + alinp.size() == this.rsd.inputParams.size()) {
            this.inputOrder = new AlignmentOrder(_input);
            this.dsForIO = _input.getDataset();
            if (this.dsForIO == null) {
                _input.setDataset(null);
            }
            this.dsForIO = _input.getDataset();
            if (this.contextAl == null) {
                this.contextAl = _input;
            }
            this.setAlignmentForInputs(alinp, _input);
            this.validInput = true;
        } else {
            this.validInput = false;
        }
    }

    @Override
    public boolean hasResults() {
        return this.gotresult && (!this.parsedResults || this.validJvresults);
    }

    @Override
    public boolean hasValidInput() {
        return this.validInput;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isQueued() {
        return this.waiting;
    }

    @Override
    public boolean isFinished() {
        return this.resSet != null;
    }

    @Override
    public boolean isFailed() {
        return this.error;
    }

    @Override
    public boolean isBroken() {
        return this.error;
    }

    @Override
    public boolean isServerError() {
        return this.error;
    }

    @Override
    public boolean hasStatus() {
        return this.statMessage != null;
    }

    @Override
    public String getStatus() {
        return this.statMessage;
    }

    @Override
    public boolean hasResponse() {
        return this.statMessage != null || this.resSet != null;
    }

    @Override
    public void clearResponse() {
    }

    @Override
    public String getState() {
        return "Job is clueless";
    }

    public String getPostUrl() {
        return this.rsd.postUrl;
    }

    public Set<Map.Entry<String, InputType>> getInputParams() {
        return this.rsd.inputParams.entrySet();
    }

    public String getPollUrl() {
        return this.rsd.getDecoratedResultUrl(this.jobId);
    }

    public JalviewDataset newJalviewDataset() {
        if (this.context == null) {
            this.context = new JalviewDataset(this.dsForIO, null, this.squniq, null);
            if (this.contextAl != null) {
                if (this.contextAl.getAlignmentAnnotation() != null) {
                    for (AlignmentAnnotation alan : this.contextAl.getAlignmentAnnotation()) {
                        this.contextAl.deleteAnnotation(alan);
                    }
                }
                if (this.contextAl.getGroups() != null) {
                    this.contextAl.deleteAllGroups();
                }
                this.context.addAlignment(this.contextAl);
            }
        }
        return this.context;
    }

    public SequenceI[] getSequencesForInput(String token, InputType.molType type) throws NoValidInputDataException {
        Object sgdat = this.inputData.get(token);
        if (sgdat == null) {
            throw new NoValidInputDataException("No Sequence vector data bound to input '" + token + "' for service at " + this.rsd.postUrl);
        }
        if (sgdat instanceof AlignmentI) {
            return ((AlignmentI)sgdat).getSequencesArray();
        }
        if (sgdat instanceof SequenceGroup) {
            return ((SequenceGroup)sgdat).getSequencesAsArray(null);
        }
        if (sgdat instanceof Vector && ((Vector)sgdat).size() > 0 && ((Vector)sgdat).get(0) instanceof SequenceI) {
            Object[] sq = new SequenceI[((Vector)sgdat).size()];
            ((Vector)sgdat).copyInto(sq);
            return sq;
        }
        throw new NoValidInputDataException("No Sequence vector data bound to input '" + token + "' for service at " + this.rsd.postUrl);
    }

    public void setAlignmentForInputs(Collection<InputType> itypes, AlignmentI al) {
        for (InputType itype : itypes) {
            if (!this.rsd.inputParams.values().contains(itype)) {
                throw new IllegalArgumentException("InputType " + itype.getClass() + " is not valid for service at " + this.rsd.postUrl);
            }
            if (itype instanceof AlignmentProcessor) {
                ((AlignmentProcessor)((Object)itype)).prepareAlignment(al);
            }
            this.inputData.put(itype.token, al);
        }
    }

    public AlignmentI getAlignmentForInput(String token, InputType.molType type) throws NoValidInputDataException {
        Object al = this.inputData.get(token);
        if (al == null || !(al instanceof AlignmentI)) {
            throw new NoValidInputDataException("No alignment data bound to input '" + token + "' for service at " + this.rsd.postUrl);
        }
        return (AlignmentI)al;
    }

    public boolean hasDataOfType(Class cl) {
        return AlignmentI.class.isAssignableFrom(cl);
    }

    public void parseResultSet() throws Exception, Error {
        if (!this.parsedResults) {
            this.parsedResults = true;
            this.jvresultobj = this.resSet.parseResultSet();
            this.validJvresults = true;
        }
    }

    public boolean isInputContextModified() {
        return this.contextAl != null && this.validJvresults && this.context.getAl().get(0).isModified();
    }

    public boolean isInputUniquified() {
        return false;
    }

    public int[] getOrderMap() {
        SequenceI[] contseq = this.contextAl.getSequencesArray();
        int[] map = new int[contseq.length];
        for (int i = 0; i < contseq.length; ++i) {
            map[i] = this.inputOrder.getOrder().indexOf(contseq[i]);
        }
        return map;
    }
}

