/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import jalview.api.AlignCalcWorkerI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.ws.jws2.AADisorderClient;
import jalview.ws.jws2.AbstractJabaCalcWorker;
import jalview.ws.jws2.Jws2Client;
import jalview.ws.jws2.dm.AAConSettings;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.WsParamSetI;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SequenceAnnotationWSClient
extends Jws2Client {
    public SequenceAnnotationWSClient() {
    }

    public SequenceAnnotationWSClient(Jws2Instance sh, AlignFrame alignFrame, WsParamSetI preset, boolean editParams) {
        super(alignFrame, preset, null);
        this.initSequenceAnnotationWSClient(sh, alignFrame, preset, editParams);
    }

    public void initSequenceAnnotationWSClient(Jws2Instance sh, AlignFrame alignFrame, WsParamSetI preset, boolean editParams) {
        AlignAnalysisUIText aaui = sh.getAlignAnalysisUI();
        if (aaui != null) {
            Class clientClass = aaui.getClient();
            List<AlignCalcWorkerI> clnts = alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(clientClass);
            if (clnts == null || clnts.size() == 0) {
                AbstractJabaCalcWorker worker;
                if (!this.processParams(sh, editParams)) {
                    return;
                }
                try {
                    worker = (AbstractJabaCalcWorker)clientClass.getConstructor(Jws2Instance.class, AlignFrame.class, WsParamSetI.class, List.class).newInstance(sh, alignFrame, this.preset, this.paramset);
                }
                catch (Exception x) {
                    x.printStackTrace();
                    throw new Error(MessageManager.getString("error.implementation_error"), x);
                }
                alignFrame.getViewport().getCalcManager().registerWorker(worker);
                alignFrame.getViewport().getCalcManager().startWorker(worker);
            } else {
                AbstractJabaCalcWorker worker = (AbstractJabaCalcWorker)clnts.get(0);
                if (editParams) {
                    this.paramset = worker.getArguments();
                    preset = worker.getPreset();
                }
                if (!this.processParams(sh, editParams, true)) {
                    return;
                }
                alignFrame.getViewport().getCalcManager().enableWorker(worker);
                worker.updateParameters(this.preset, this.paramset);
            }
        }
        if (sh.action.toLowerCase(Locale.ROOT).contains("disorder")) {
            if (!this.processParams(sh, editParams)) {
                return;
            }
            alignFrame.getViewport().getCalcManager().startWorker(new AADisorderClient(sh, alignFrame, preset, this.paramset));
        }
    }

    public SequenceAnnotationWSClient(AAConSettings fave, AlignFrame alignFrame, boolean b) {
        super(alignFrame, fave.getPreset(), fave.getJobArgset());
        this.initSequenceAnnotationWSClient(fave.getService(), alignFrame, fave.getPreset(), b);
    }

    @Override
    public void attachWSMenuEntry(JMenu wsmenu, final Jws2Instance service, final AlignFrame alignFrame) {
        if (this.registerAAConWSInstance(wsmenu, service, alignFrame)) {
            return;
        }
        boolean hasparams = service.hasParameters();
        String calcName = service.serviceType.substring(0, service.serviceType.length() - 2);
        JMenuItem annotservice = new JMenuItem(MessageManager.formatMessage("label.calcname_with_default_settings", new String[]{calcName}));
        annotservice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SequenceAnnotationWSClient(service, alignFrame, null, false);
            }
        });
        wsmenu.add(annotservice);
        if (hasparams) {
            annotservice = new JMenuItem(MessageManager.getString("label.edit_settings_and_run"));
            annotservice.setToolTipText(MessageManager.getString("label.view_and_change_parameters_before_running_calculation"));
            annotservice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new SequenceAnnotationWSClient(service, alignFrame, null, true);
                }
            });
            wsmenu.add(annotservice);
            List<WsParamSetI> presets = service.getParamStore().getPresets();
            if (presets != null && presets.size() > 0) {
                JMenu presetlist = new JMenu(MessageManager.formatMessage("label.run_with_preset", new String[]{calcName}));
                for (final WsParamSetI preset : presets) {
                    JMenuItem methodR = new JMenuItem(preset.getName());
                    methodR.setToolTipText(JvSwingUtils.wrapTooltip(true, "<strong>" + (preset.isModifiable() ? MessageManager.getString("label.user_preset") : MessageManager.getString("label.service_preset")) + "</strong><br/>" + preset.getDescription()));
                    methodR.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            new SequenceAnnotationWSClient(service, alignFrame, preset, false);
                        }
                    });
                    presetlist.add(methodR);
                }
                wsmenu.add(presetlist);
            }
        } else {
            annotservice = new JMenuItem(MessageManager.getString("label.view_documentation"));
            if (service.docUrl != null) {
                annotservice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Desktop.showUrl(service.docUrl);
                    }
                });
                annotservice.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("label.view_service_doc_url", new String[]{service.docUrl, service.docUrl})));
                wsmenu.add(annotservice);
            }
        }
    }
}

