/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Console;
import jalview.javascript.json.JSON;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Platform {
    private static boolean isJS = false;
    private static Boolean isNoJSMac = null;
    private static Boolean isNoJSWin = null;
    private static Boolean isMac = null;
    private static Boolean isWin = null;
    private static Boolean isLinux = null;
    private static Boolean isHeadless = null;
    private static final int CONSOLEWIDTH;
    private static final String CONSOLEWIDTHPROPERTY = "CONSOLEWIDTH";
    public static final int TIME_RESET = 0;
    public static final int TIME_MARK = 1;
    public static final int TIME_SET = 2;
    public static final int TIME_GET = 3;
    public static long time;
    public static long mark;
    public static long set;
    public static long duration;

    public static boolean isMac() {
        return isMac == null ? (isMac = Boolean.valueOf(System.getProperty("os.name").indexOf("Mac") >= 0)) : isMac;
    }

    public static boolean isWin() {
        return isWin == null ? (isWin = Boolean.valueOf(System.getProperty("os.name").indexOf("Win") >= 0)) : isWin;
    }

    public static boolean isLinux() {
        return isLinux == null ? (isLinux = Boolean.valueOf(System.getProperty("os.name").indexOf("Linux") >= 0)) : isLinux;
    }

    public static boolean isJS() {
        return isJS;
    }

    public static boolean isAMacAndNotJS() {
        return isNoJSMac == null ? (isNoJSMac = Boolean.valueOf(!isJS && Platform.isMac())) : isNoJSMac;
    }

    public static boolean isWindowsAndNotJS() {
        return isNoJSWin == null ? (isNoJSWin = Boolean.valueOf(!isJS && Platform.isWin())) : isNoJSWin;
    }

    public static boolean isHeadless() {
        if (isHeadless == null) {
            isHeadless = "true".equals(System.getProperty("java.awt.headless"));
        }
        return isHeadless;
    }

    public static int getMaxCommandLineLength() {
        return 2046;
    }

    public static String escapeBackslashes(String s) {
        return s == null ? null : s.replace("\\", "\\\\");
    }

    public static boolean isControlDown(MouseEvent e) {
        return Platform.isControlDown(e, Platform.isMac());
    }

    protected static boolean isControlDown(MouseEvent e, boolean aMac) {
        if (!aMac) {
            return e.isControlDown();
        }
        return !e.isPopupTrigger() && (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() & e.getModifiers()) != 0;
    }

    public static boolean isWinRightButton(MouseEvent e) {
        return Platform.isWin() && SwingUtilities.isRightMouseButton(e);
    }

    public static boolean isWinMiddleButton(MouseEvent e) {
        return Platform.isWin() && SwingUtilities.isMiddleMouseButton(e);
    }

    public static boolean allowMnemonics() {
        return !Platform.isMac();
    }

    public static void timeCheck(String msg, int mode) {
        long t = System.currentTimeMillis();
        switch (mode) {
            case 0: {
                time = mark = t;
                if (msg == null) break;
                Console.errPrintln("Platform: timer reset\t\t\t" + msg);
                break;
            }
            case 1: {
                if (set > 0L) {
                    duration += t - set;
                    break;
                }
                if (time == 0L) {
                    time = mark = t;
                }
                if (msg != null) {
                    Console.errPrintln("Platform: timer mark\t" + (float)(t - time) / 1000.0f + "\t" + (float)(t - mark) / 1000.0f + "\t" + msg);
                }
                mark = t;
                break;
            }
            case 2: {
                set = t;
                break;
            }
            case 3: {
                if (msg != null) {
                    Console.errPrintln("Platform: timer dur\t" + (float)(t - time) / 1000.0f + "\t" + (float)duration / 1000.0f + "\t" + msg);
                }
                set = 0L;
            }
        }
    }

    public static void cacheFileData(String path, Object data) {
        if (!Platform.isJS() || data == null) {
            return;
        }
    }

    public static void cacheFileData(File file) {
        byte[] data;
        if (!Platform.isJS() || (data = Platform.getFileBytes(file)) == null) {
            return;
        }
        Platform.cacheFileData(file.toString(), data);
    }

    public static byte[] getFileBytes(File f) {
        return null;
    }

    public static byte[] getFileAsBytes(String fileStr) {
        byte[] bytes = null;
        Platform.cacheFileData(fileStr, bytes);
        return bytes;
    }

    public static String getFileAsString(String url) {
        String ret = null;
        Platform.cacheFileData(url, ret);
        return ret;
    }

    public static boolean setFileBytes(File f, String urlstring) {
        if (!Platform.isJS()) {
            return false;
        }
        byte[] bytes = Platform.getFileAsBytes(urlstring);
        return true;
    }

    public static void addJ2SBinaryType(String ext) {
    }

    public static String encodeURI(String value) {
        return value;
    }

    public static boolean openURL(String url) {
        return Platform.isJS();
    }

    public static String getUniqueAppletID() {
        return null;
    }

    public static void readInfoProperties(String prefix, Properties p) {
        if (!Platform.isJS()) {
            return;
        }
        String id = Platform.getUniqueAppletID();
        String key = "";
        String value = "";
        Console.outPrintln("Platform id=" + id + " reading Info." + key + " = " + value);
        p.put(id + "_" + key, value);
    }

    public static void setAjaxJSON(URL url) {
        if (Platform.isJS()) {
            JSON.setAjax(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseJSON(InputStream response) throws IOException, ParseException {
        if (Platform.isJS()) {
            return JSON.parse(response);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(response, "UTF-8"));
            Object object = new JSONParser().parse(br);
            return object;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Object parseJSON(String json) throws ParseException {
        return Platform.isJS() ? JSON.parse(json) : new JSONParser().parse(json);
    }

    public static Object parseJSON(Reader r) throws IOException, ParseException {
        if (r == null) {
            return null;
        }
        if (!Platform.isJS()) {
            return new JSONParser().parse(r);
        }
        if (r instanceof FileReader) {
            throw new IOException("StringJS does not support FileReader parsing for JSON -- but it could...");
        }
        return JSON.parse(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamToFile(InputStream is, File outFile) throws IOException {
        if (Platform.isJS()) {
            return;
        }
        try (FileOutputStream fio = new FileOutputStream(outFile);){
            int l;
            byte[] bb = new byte[32768];
            while ((l = is.read(bb)) > 0) {
                fio.write(bb, 0, l);
            }
        }
    }

    public static void addJ2SDirectDatabaseCall(String domain) {
        if (Platform.isJS()) {
            Console.outPrintln("Platform adding known access-control-allow-origin * for domain " + domain);
        }
    }

    public static void getURLCommandArguments() {
    }

    public static boolean pathEquals(String path1, String path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        String p1 = path1.replace('\\', '/');
        String p2 = path2.replace('\\', '/');
        return p1.equals(p2);
    }

    public static int consoleWidth() {
        return CONSOLEWIDTH;
    }

    static {
        int cw = 80;
        if (System.getProperty(CONSOLEWIDTHPROPERTY) != null && System.getProperty(CONSOLEWIDTHPROPERTY).length() > 0) {
            try {
                cw = Integer.parseInt(System.getProperty(CONSOLEWIDTHPROPERTY));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        CONSOLEWIDTH = cw;
    }
}

