/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class LinkedIdentityHashSet<E>
extends AbstractSet<E> {
    LinkedHashMap<IdentityWrapper, IdentityWrapper> set = new LinkedHashMap();

    @Override
    public boolean add(E e) {
        IdentityWrapper el = new IdentityWrapper(e, this.set.size());
        return this.putIfAbsent(el, el) == null;
    }

    private IdentityWrapper putIfAbsent(IdentityWrapper key, IdentityWrapper value) {
        IdentityWrapper v = this.set.get(key);
        if (v == null) {
            v = this.set.put(key, value);
        }
        return v;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            final Iterator<IdentityWrapper> se;
            {
                this.se = LinkedIdentityHashSet.this.set.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.se.hasNext();
            }

            @Override
            public E next() {
                return this.se.next().obj;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.set.size();
    }

    public int indexOf(E e) {
        return this.set.get(e).p;
    }

    static class IdentityWrapper {
        Object obj;
        public int p;

        IdentityWrapper(Object obj, int p) {
            this.obj = obj;
            this.p = p;
        }

        public boolean equals(Object obj) {
            return this.obj == ((IdentityWrapper)obj).obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }
    }
}

