/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import java.awt.Color;
import java.util.Map;

public abstract class ResidueColourScheme
implements ColourSchemeI {
    public static final String NONE = "None";
    public static final String USER_DEFINED = "User Defined";
    public static final String USER_DEFINED_MENU = "*User Defined*";
    public static final String ANNOTATION_COLOUR = "Annotation";
    final int[] symbolIndex;
    Color[] colors = null;
    protected boolean ignoreGaps = false;

    public ResidueColourScheme(int[] aaOrnaIndex, Color[] colours) {
        this.symbolIndex = aaOrnaIndex;
        this.colors = colours;
    }

    public ResidueColourScheme(int[] aaOrNaIndex) {
        this.symbolIndex = aaOrNaIndex;
    }

    public ResidueColourScheme() {
        this.symbolIndex = null;
    }

    public Color findColour(char c) {
        Color colour = Color.white;
        if (this.colors != null && this.symbolIndex != null && c < this.symbolIndex.length && this.symbolIndex[c] < this.colors.length) {
            colour = this.colors[this.symbolIndex[c]];
        }
        return colour;
    }

    @Override
    public Color findColour(char c, int j, SequenceI seq, String consensusResidue, float pid) {
        return this.findColour(c, j, seq);
    }

    protected Color findColour(char c, int j, SequenceI seq) {
        return this.findColour(c);
    }

    @Override
    public void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
    }

    @Override
    public boolean isApplicableTo(AnnotatedCollectionI ac) {
        if (!this.isPeptideSpecific() && !this.isNucleotideSpecific()) {
            return true;
        }
        if (ac == null) {
            return true;
        }
        if (ac instanceof SequenceGroup && ac.getContext() == null) {
            return true;
        }
        boolean nucleotide = ac.isNucleotide();
        return nucleotide && this.isNucleotideSpecific() || !nucleotide && this.isPeptideSpecific();
    }

    public boolean isPeptideSpecific() {
        return false;
    }

    public boolean isNucleotideSpecific() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean hasGapColour() {
        return false;
    }
}

