/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.gff;

import jalview.io.gff.SequenceOntologyI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SequenceOntologyLite
implements SequenceOntologyI {
    private final String[][] TERMS = new String[][]{{"gene", "gene"}, {"ncRNA_gene", "gene"}, {"snRNA_gene", "gene"}, {"miRNA_gene", "gene"}, {"lincRNA_gene", "gene"}, {"rRNA_gene", "gene"}, {"transcript", "transcript"}, {"mature_transcript", "transcript"}, {"processed_transcript", "transcript"}, {"aberrant_processed_transcript", "transcript"}, {"ncRNA", "transcript"}, {"snRNA", "transcript"}, {"miRNA", "transcript"}, {"lincRNA", "transcript"}, {"lnc_RNA", "transcript"}, {"rRNA", "transcript"}, {"mRNA", "transcript"}, {"sequence_variant", "sequence_variant"}, {"structural_variant", "sequence_variant"}, {"feature_variant", "sequence_variant"}, {"gene_variant", "sequence_variant"}, {"transcript_variant", "sequence_variant"}, {"NMD_transcript_variant", "sequence_variant"}, {"missense_variant", "sequence_variant"}, {"synonymous_variant", "sequence_variant"}, {"frameshift_variant", "sequence_variant"}, {"5_prime_UTR_variant", "sequence_variant"}, {"3_prime_UTR_variant", "sequence_variant"}, {"stop_gained", "sequence_variant"}, {"stop_lost", "sequence_variant"}, {"inframe_deletion", "sequence_variant"}, {"inframe_insertion", "sequence_variant"}, {"splice_region_variant", "sequence_variant"}, {"exon", "exon"}, {"coding_exon", "exon"}, {"CDS", "CDS"}, {"CDS_predicted", "CDS"}, {"protein_match", "protein_match"}, {"nucleotide_match", "nucleotide_match"}, {"cDNA_match", "nucleotide_match"}, {"polypeptide", "polypeptide"}};
    private Map<String, List<String>> parents;
    private List<String> termsFound = new ArrayList<String>();
    private List<String> termsNotFound = new ArrayList<String>();

    public SequenceOntologyLite() {
        this.loadStaticData();
    }

    private void loadStaticData() {
        this.parents = new HashMap<String, List<String>>();
        for (String[] pair : this.TERMS) {
            List<String> p = this.parents.get(pair[0]);
            if (p == null) {
                p = new ArrayList<String>();
                this.parents.put(pair[0], p);
            }
            p.add(pair[1]);
        }
    }

    @Override
    public boolean isA(String child, String parent) {
        if (child == null || parent == null) {
            return false;
        }
        if (child.equals(parent)) {
            this.termFound(child);
            return true;
        }
        List<String> p = this.parents.get(child);
        if (p == null) {
            this.termNotFound(child);
            return false;
        }
        this.termFound(child);
        return p.contains(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void termFound(String term) {
        if (!this.termsFound.contains(term)) {
            List<String> list = this.termsFound;
            synchronized (list) {
                this.termsFound.add(term);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void termNotFound(String term) {
        List<String> list = this.termsNotFound;
        synchronized (list) {
            if (!this.termsNotFound.contains(term)) {
                this.termsNotFound.add(term);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> termsFound() {
        List<String> list = this.termsFound;
        synchronized (list) {
            Collections.sort(this.termsFound, String.CASE_INSENSITIVE_ORDER);
            return this.termsFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> termsNotFound() {
        List<String> list = this.termsNotFound;
        synchronized (list) {
            Collections.sort(this.termsNotFound, String.CASE_INSENSITIVE_ORDER);
            return this.termsNotFound;
        }
    }
}

