/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import com.stevesoft.pat.Regex;
import jalview.analysis.AlignmentUtils;
import jalview.api.AlignmentViewPanel;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JmolParser;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.service.pdb.PDBFTSRestClient;
import jalview.fts.service.threedbeacons.TDB_FTSData;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AssociatePdbFileWithSeq;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.ProgressBar;
import jalview.gui.StructureViewer;
import jalview.gui.StructureViewerBase;
import jalview.gui.structurechooser.PDBStructureChooserQuerySource;
import jalview.gui.structurechooser.StructureChooserQuerySource;
import jalview.gui.structurechooser.ThreeDBStructureChooserQuerySource;
import jalview.io.DataSourceType;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.FilterOption;
import jalview.jbgui.GStructureChooser;
import jalview.structure.StructureImportSettings;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.StringUtils;
import jalview.ws.DBRefFetcher;
import jalview.ws.datamodel.alphafold.PAEContactMatrix;
import jalview.ws.dbsources.EBIAlfaFold;
import jalview.ws.dbsources.Uniprot;
import jalview.ws.seqfetcher.DbSourceProxy;
import jalview.ws.sifts.SiftsSettings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executors;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class StructureChooser
extends GStructureChooser
implements IProgressIndicator {
    public static final String AUTOSUPERIMPOSE = "AUTOSUPERIMPOSE";
    private static final int THRESHOLD_WARN_UNIPROT_FETCH_NEEDED = 20;
    private SequenceI selectedSequence;
    private SequenceI[] selectedSequences;
    private IProgressIndicator progressIndicator;
    private Collection<FTSData> discoveredStructuresSet;
    private StructureChooserQuerySource data;
    private String selectedPdbFileName;
    private String localPdbPaeMatrixFileName;
    private boolean isValidPBDEntry;
    private boolean cachedPDBExists;
    private Collection<FTSData> lastDiscoveredStructuresSet;
    private boolean canQueryTDB = false;
    private boolean notQueriedTDBYet = true;
    List<SequenceI> seqsWithoutSourceDBRef = null;
    private boolean showChooserGUI = true;
    private boolean dontQueryServices = false;
    private static StructureViewer lastTargetedView = null;
    private FilterOption lastSelected = null;
    private StructureViewer sViewer = null;
    protected int PDB_ID_MIN = 3;
    private IProgressIndicator progressBar;

    @Override
    protected FTSDataColumnPreferences getFTSDocFieldPrefs() {
        return this.data.getDocFieldPrefs();
    }

    public StructureChooser(SequenceI[] selectedSeqs, SequenceI selectedSeq, AlignmentPanel ap) {
        this(selectedSeqs, selectedSeq, ap, true);
    }

    public StructureChooser(SequenceI[] selectedSeqs, SequenceI selectedSeq, AlignmentPanel ap, boolean showGUI) {
        this(selectedSeqs, selectedSeq, ap, showGUI, false);
    }

    public StructureChooser(SequenceI[] selectedSeqs, SequenceI selectedSeq, AlignmentPanel ap, boolean showGUI, boolean dontQueryServices) {
        this.data = StructureChooserQuerySource.getQuerySourceFor(selectedSeqs);
        this.initDialog();
        this.ap = ap;
        this.selectedSequence = selectedSeq;
        this.selectedSequences = selectedSeqs;
        this.progressIndicator = ap == null ? null : ap.alignFrame;
        this.showChooserGUI = showGUI;
        this.dontQueryServices = dontQueryServices;
        this.init();
    }

    private void populateSeqsWithoutSourceDBRef() {
        this.seqsWithoutSourceDBRef = new ArrayList<SequenceI>();
        boolean needCanonical = false;
        for (SequenceI seq : this.selectedSequences) {
            int dbRef;
            if (!seq.isProtein() || (dbRef = ThreeDBStructureChooserQuerySource.checkUniprotRefs(seq.getDBRefs())) >= 0) continue;
            if (dbRef == -1) {
                needCanonical = true;
                this.seqsWithoutSourceDBRef.add(seq);
                continue;
            }
            if (seq.getAllPDBEntries() != null && seq.getAllPDBEntries().size() != 0) continue;
            this.seqsWithoutSourceDBRef.add(seq);
        }
        if (!this.seqsWithoutSourceDBRef.isEmpty()) {
            this.canQueryTDB = true;
            if (needCanonical) {
                this.notQueriedTDBYet = true;
            }
        }
    }

    protected void init() {
        if (!Jalview.isHeadlessMode()) {
            this.progressBar = new ProgressBar(this.statusPanel, this.statusBar);
        }
        this.chk_superpose.setSelected(Cache.getDefault(AUTOSUPERIMPOSE, true));
        this.btn_queryTDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StructureChooser.this.promptForTDBFetch(false);
            }
        });
        if (!this.dontQueryServices) {
            Executors.defaultThreadFactory().newThread(new Runnable(){

                @Override
                public void run() {
                    StructureChooser.this.populateSeqsWithoutSourceDBRef();
                    StructureChooser.this.initialStructureDiscovery();
                }
            }).start();
        } else {
            Console.debug("Structure chooser not querying services to discover metadata.");
        }
    }

    private void initialStructureDiscovery() {
        this.data = StructureChooserQuerySource.getQuerySourceFor(this.selectedSequences);
        this.populateFilterComboBox(true, this.cachedPDBExists);
        long startTime = System.currentTimeMillis();
        this.updateProgressIndicator(MessageManager.getString("status.loading_cached_pdb_entries"), startTime);
        this.loadLocalCachedPDBEntries();
        this.updateProgressIndicator(null, startTime);
        this.updateProgressIndicator(MessageManager.getString("status.searching_for_pdb_structures"), startTime);
        this.fetchStructuresMetaData();
        this.populateFilterComboBox(this.isStructuresDiscovered(), this.cachedPDBExists);
        this.discoverStructureViews();
        this.updateProgressIndicator(null, startTime);
        this.mainFrame.setVisible(this.showChooserGUI);
        this.updateCurrentView();
    }

    public void promptForTDBFetch(boolean ignoreGui) {
        final long progressId = System.currentTimeMillis();
        final Runnable strucDiscovery = new Runnable(){

            @Override
            public void run() {
                StructureChooser.this.mainFrame.setEnabled(false);
                StructureChooser.this.cmb_filterOption.setEnabled(false);
                StructureChooser.this.progressBar.setProgressBar(MessageManager.getString("status.searching_3d_beacons"), progressId);
                StructureChooser.this.btn_queryTDB.setEnabled(false);
                StructureChooser.this.populateSeqsWithoutSourceDBRef();
                StructureChooser.access$302(StructureChooser.this, null);
                StructureChooser.this.lastSelected = (FilterOption)StructureChooser.this.cmb_filterOption.getSelectedItem();
                StructureChooser.this.cmb_filterOption.setSelectedItem(null);
                StructureChooser.this.cachedPDBExists = false;
                StructureChooser.this.initialStructureDiscovery();
                if (!StructureChooser.this.isStructuresDiscovered()) {
                    StructureChooser.this.progressBar.setProgressBar(MessageManager.getString("status.no_structures_discovered_from_3d_beacons"), progressId);
                    StructureChooser.this.btn_queryTDB.setToolTipText(MessageManager.getString("status.no_structures_discovered_from_3d_beacons"));
                    StructureChooser.this.btn_queryTDB.setEnabled(false);
                    StructureChooser.this.pnl_queryTDB.setVisible(false);
                } else {
                    StructureChooser.this.cmb_filterOption.setSelectedIndex(0);
                    StructureChooser.this.btn_queryTDB.setVisible(false);
                    StructureChooser.this.pnl_queryTDB.setVisible(false);
                    StructureChooser.this.progressBar.setProgressBar(null, progressId);
                }
                StructureChooser.this.mainFrame.setEnabled(true);
                StructureChooser.this.cmb_filterOption.setEnabled(true);
            }
        };
        DBRefFetcher.FetchFinishedListenerI afterDbRefFetch = new DBRefFetcher.FetchFinishedListenerI(){

            @Override
            public void finished() {
                StructureChooser.this.notQueriedTDBYet = false;
                Executors.defaultThreadFactory().newThread(strucDiscovery).start();
            }
        };
        Runnable discoverCanonicalDBrefs = () -> {
            this.btn_queryTDB.setEnabled(false);
            this.populateSeqsWithoutSourceDBRef();
            int y = this.seqsWithoutSourceDBRef.size();
            if (y > 0) {
                SequenceI[] seqWithoutSrcDBRef = this.seqsWithoutSourceDBRef.toArray(new SequenceI[y]);
                DBRefFetcher dbRefFetcher = new DBRefFetcher(seqWithoutSrcDBRef, this.progressBar, new DbSourceProxy[]{new Uniprot()}, null, false);
                dbRefFetcher.addListener(afterDbRefFetch);
                dbRefFetcher.fetchDBRefs(true);
            } else {
                afterDbRefFetch.finished();
            }
        };
        Runnable revertview = () -> {
            if (this.lastSelected != null) {
                this.cmb_filterOption.setSelectedItem(this.lastSelected);
            }
        };
        int threshold = Cache.getDefault("UNIPROT_AUTOFETCH_THRESHOLD", 20);
        Console.debug("Using Uniprot fetch threshold of " + threshold);
        if (ignoreGui || this.seqsWithoutSourceDBRef.size() < threshold) {
            Executors.newSingleThreadExecutor().submit(discoverCanonicalDBrefs);
            return;
        }
        StructureChooser thisSC = this;
        JvOptionPane.newOptionDialog(thisSC.getFrame()).setResponseHandler(0, discoverCanonicalDBrefs).setResponseHandler(2, revertview).setResponseHandler(1, revertview).showDialog(MessageManager.formatMessage("label.fetch_references_for_3dbeacons", this.seqsWithoutSourceDBRef.size()), MessageManager.getString("label.3dbeacons"), 0, -1, null, new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")}, MessageManager.getString("action.ok"), false);
    }

    private void discoverStructureViews() {
        if (Desktop.instance != null) {
            this.targetView.removeAllItems();
            if (lastTargetedView != null && !lastTargetedView.isVisible()) {
                lastTargetedView = null;
            }
            int linkedViewsAt = 0;
            for (StructureViewerBase view : Desktop.instance.getStructureViewers(null, null)) {
                StructureViewer viewHandler;
                StructureViewer structureViewer = viewHandler = lastTargetedView != null && StructureChooser.lastTargetedView.sview == view ? lastTargetedView : StructureViewer.reconfigure(view);
                if (view.isLinkedWith(this.ap)) {
                    this.targetView.insertItemAt(viewHandler, linkedViewsAt++);
                    continue;
                }
                this.targetView.addItem(viewHandler);
            }
            this.targetView.setVisible(false);
            if (this.targetView.getItemCount() > 0) {
                this.targetView.setVisible(true);
                if (lastTargetedView != null) {
                    this.targetView.setSelectedItem(lastTargetedView);
                } else {
                    this.targetView.setSelectedIndex(0);
                }
            }
            this.btn_add.setVisible(this.targetView.isVisible());
        }
    }

    protected void updateProgressIndicator(String message, long id) {
        if (this.progressIndicator != null) {
            this.progressIndicator.setProgressBar(message, id);
        }
    }

    void fetchStructuresMetaData() {
        long startTime = System.currentTimeMillis();
        Collection<FTSDataColumnI> wantedFields = this.data.getDocFieldPrefs().getStructureSummaryFields();
        this.discoveredStructuresSet = new LinkedHashSet<FTSData>();
        HashSet<String> errors = new HashSet<String>();
        FilterOption selectedFilterOpt = (FilterOption)this.cmb_filterOption.getSelectedItem();
        for (SequenceI seq : this.selectedSequences) {
            FTSRestResponse resultList;
            block10: {
                try {
                    resultList = this.data.fetchStructuresMetaData(seq, wantedFields, selectedFilterOpt, !this.chk_invertFilter.isSelected());
                    if (resultList == null) {
                    }
                    break block10;
                }
                catch (Exception e) {
                    Console.printStackTrace(e);
                    errors.add(e.getMessage());
                }
                continue;
            }
            if (resultList.getSearchSummary() == null || resultList.getSearchSummary().isEmpty()) continue;
            this.discoveredStructuresSet.addAll(resultList.getSearchSummary());
        }
        int noOfStructuresFound = 0;
        String totalTime = System.currentTimeMillis() - startTime + " milli secs";
        if (this.discoveredStructuresSet != null && !this.discoveredStructuresSet.isEmpty()) {
            this.getResultTable().setModel(this.data.getTableModel(this.discoveredStructuresSet));
            noOfStructuresFound = this.discoveredStructuresSet.size();
            this.lastDiscoveredStructuresSet = this.discoveredStructuresSet;
            this.mainFrame.setTitle(MessageManager.formatMessage("label.structure_chooser_no_of_structures", noOfStructuresFound, totalTime));
        } else {
            this.mainFrame.setTitle(MessageManager.getString("label.structure_chooser_manual_association"));
            if (errors.size() > 0) {
                StringBuilder errorMsg = new StringBuilder();
                for (String error : errors) {
                    errorMsg.append(error).append("\n");
                }
                if (!Jalview.isHeadlessMode()) {
                    JvOptionPane.showMessageDialog((Component)this, errorMsg.toString(), MessageManager.getString("label.pdb_web-service_error"), 0);
                } else {
                    Console.error(MessageManager.getString("label.pdb_web-service_error"));
                    Console.debug(errorMsg.toString());
                }
            }
        }
    }

    protected void loadLocalCachedPDBEntries() {
        ArrayList<CachedPDB> entries = new ArrayList<CachedPDB>();
        for (SequenceI seq : this.selectedSequences) {
            if (seq.getDatasetSequence() == null || seq.getDatasetSequence().getAllPDBEntries() == null) continue;
            for (PDBEntry pdbEntry : seq.getDatasetSequence().getAllPDBEntries()) {
                if (pdbEntry.getFile() == null) continue;
                entries.add(new CachedPDB(seq, pdbEntry));
            }
        }
        this.cachedPDBExists = !entries.isEmpty();
        PDBEntryTableModel tableModelx = new PDBEntryTableModel(entries);
        this.tbl_local_pdb.setModel(tableModelx);
    }

    void filterResultSet(final String fieldToFilterBy) {
        Thread filterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                StructureChooser.this.lbl_loading.setVisible(true);
                Collection<FTSDataColumnI> wantedFields = StructureChooser.this.data.getDocFieldPrefs().getStructureSummaryFields();
                HashSet<FTSData> filteredResponse = new HashSet<FTSData>();
                HashSet<String> errors = new HashSet<String>();
                for (SequenceI seq : StructureChooser.this.selectedSequences) {
                    FTSRestResponse resultList;
                    try {
                        resultList = StructureChooser.this.data.selectFirstRankedQuery(seq, StructureChooser.this.discoveredStructuresSet, wantedFields, fieldToFilterBy, !StructureChooser.this.chk_invertFilter.isSelected());
                    }
                    catch (Exception e) {
                        Console.debugPrintStackTrace(e);
                        errors.add(e.getMessage());
                        continue;
                    }
                    if (resultList.getSearchSummary() == null || resultList.getSearchSummary().isEmpty()) continue;
                    filteredResponse.addAll(resultList.getSearchSummary());
                }
                String totalTime = System.currentTimeMillis() - startTime + " milli secs";
                if (!filteredResponse.isEmpty()) {
                    int filterResponseCount = filteredResponse.size();
                    LinkedHashSet<FTSData> reorderedStructuresSet = new LinkedHashSet<FTSData>();
                    reorderedStructuresSet.addAll(filteredResponse);
                    reorderedStructuresSet.addAll(StructureChooser.this.discoveredStructuresSet);
                    StructureChooser.this.getResultTable().setModel(StructureChooser.this.data.getTableModel(reorderedStructuresSet));
                    FTSRestResponse.configureTableColumn(StructureChooser.this.getResultTable(), wantedFields, tempUserPrefs);
                    StructureChooser.this.getResultTable().getColumn("Ref Sequence").setPreferredWidth(120);
                    StructureChooser.this.getResultTable().getColumn("Ref Sequence").setMinWidth(100);
                    StructureChooser.this.getResultTable().getColumn("Ref Sequence").setMaxWidth(200);
                    StructureChooser.this.getResultTable().addRowSelectionInterval(0, filterResponseCount - 1);
                    StructureChooser.this.mainFrame.setTitle(MessageManager.formatMessage("label.structure_chooser_filter_time", totalTime));
                } else {
                    StructureChooser.this.mainFrame.setTitle(MessageManager.formatMessage("label.structure_chooser_filter_time", totalTime));
                    if (errors.size() > 0) {
                        StringBuilder errorMsg = new StringBuilder();
                        for (String error : errors) {
                            errorMsg.append(error).append("\n");
                        }
                        JvOptionPane.showMessageDialog(null, errorMsg.toString(), MessageManager.getString("label.pdb_web-service_error"), 0);
                    }
                }
                StructureChooser.this.lbl_loading.setVisible(false);
                StructureChooser.this.validateSelections();
            }
        });
        filterThread.start();
    }

    @Override
    protected void pdbFromFile_actionPerformed() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.formatMessage("label.select_pdb_file_for", this.selectedSequence.getDisplayId(false)));
        chooser.setToolTipText(MessageManager.formatMessage("label.load_pdb_file_associate_with_sequence", this.selectedSequence.getDisplayId(false)));
        int value = chooser.showOpenDialog(null);
        if (value == 0) {
            this.selectedPdbFileName = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", this.selectedPdbFileName);
            boolean guessTFType = this.localPdbPaeMatrixFileName == null;
            this.localPdbPaeMatrixFileName = this.guessPAEFilename();
            boolean bl = this.localPdbPaeMatrixFileName != null;
            Regex alphaFold = JmolParser.getNewAlphafoldValidator();
            if ((guessTFType |= bl) && alphaFold.search(new File(this.selectedPdbFileName).getName()) && !this.tempFacAsChanged) {
                this.combo_tempFacAs.setSelectedItem((Object)StructureImportSettings.TFType.PLDDT);
            }
            this.validateSelections();
        }
    }

    @Override
    protected void paeMatrixFile_actionPerformed() {
        File pdbFile = new File(this.selectedPdbFileName);
        String setFile = Cache.getProperty("LAST_DIRECTORY");
        if (this.localPdbPaeMatrixFileName != null) {
            File paeFile = new File(this.localPdbPaeMatrixFileName);
            if (paeFile.exists()) {
                setFile = paeFile.getAbsolutePath();
            } else if (paeFile.getParentFile().exists()) {
                setFile = paeFile.getParentFile().getAbsolutePath();
            }
        } else {
            String guess = this.guessPAEFilename();
            if (guess != null) {
                setFile = guess;
            }
        }
        JalviewFileChooser chooser = new JalviewFileChooser(setFile);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.formatMessage("label.select_pae_matrix_file_for", pdbFile.getName()));
        chooser.setToolTipText(MessageManager.formatMessage("label.load_pae_matrix_file_associate_with_structure", pdbFile.getName()));
        int value = chooser.showOpenDialog(null);
        if (value == 0) {
            String fileName = chooser.getSelectedFile().getPath();
            try {
                PAEContactMatrix.validateContactMatrixFile(fileName);
            }
            catch (Exception thr) {
                JvOptionPane.showInternalMessageDialog((Component)this, MessageManager.formatMessage("label.couldnt_load_file", fileName) + "<br>" + thr.getLocalizedMessage(), MessageManager.getString("label.error_loading_file"), 2);
                Console.error("Couldn't import " + fileName + " as a PAE matrix", thr);
                return;
            }
            this.localPdbPaeMatrixFileName = fileName;
            Cache.setProperty("LAST_DIRECTORY", this.localPdbPaeMatrixFileName);
        }
        this.validateAssociationFromFile();
    }

    private String guessPAEFilename() {
        if (this.selectedPdbFileName.toLowerCase(Locale.ROOT).endsWith(".pdb") || this.selectedPdbFileName.toLowerCase(Locale.ROOT).endsWith(".cif")) {
            String jsonExt = this.selectedPdbFileName.substring(0, this.selectedPdbFileName.length() - 4) + ".json";
            String guessFile1 = StringUtils.replaceLast(jsonExt, "model", "predicted_aligned_error");
            String guessFile2 = StringUtils.replaceLast(jsonExt, ".json", "_scores.json");
            if (new File(guessFile1).exists()) {
                return guessFile1;
            }
            if (new File(jsonExt).exists()) {
                return jsonExt;
            }
            if (new File(guessFile2).exists()) {
                return guessFile2;
            }
        }
        return null;
    }

    protected void populateFilterComboBox(boolean haveData, boolean cachedPDBExist) {
        this.populateFilterComboBox(haveData, cachedPDBExist, null);
    }

    protected void populateFilterComboBox(boolean haveData, boolean cachedPDBExist, FilterOption lastSel) {
        this.cmb_filterOption.removeItemListener(this);
        int selSet = -1;
        this.cmb_filterOption.removeAllItems();
        if (haveData) {
            List<FilterOption> filters = this.data.getAvailableFilterOptions("VIEWS_FILTER");
            this.data.updateAvailableFilterOptions("VIEWS_FILTER", filters, this.lastDiscoveredStructuresSet);
            int p = 0;
            for (FilterOption filter : filters) {
                if (lastSel != null && filter.equals(lastSel)) {
                    selSet = p;
                }
                ++p;
                this.cmb_filterOption.addItem(filter);
            }
        }
        this.cmb_filterOption.addItem(new FilterOption(MessageManager.getString("label.enter_pdb_id"), "-", "VIEWS_ENTER_ID", false, null));
        this.cmb_filterOption.addItem(new FilterOption(MessageManager.getString("label.from_file"), "-", "VIEWS_FROM_FILE", false, null));
        if (this.canQueryTDB && this.notQueriedTDBYet) {
            this.btn_queryTDB.setVisible(true);
            this.pnl_queryTDB.setVisible(true);
        }
        if (cachedPDBExist) {
            FilterOption cachedOption = new FilterOption(MessageManager.getString("label.cached_structures"), "-", "VIEWS_LOCAL_PDB", false, null);
            this.cmb_filterOption.addItem(cachedOption);
            if (selSet == -1) {
                this.cmb_filterOption.setSelectedItem(cachedOption);
            }
        }
        if (selSet > -1) {
            this.cmb_filterOption.setSelectedIndex(selSet);
        }
        this.cmb_filterOption.addItemListener(this);
    }

    protected void updateCurrentView() {
        FilterOption selectedFilterOpt = (FilterOption)this.cmb_filterOption.getSelectedItem();
        if (this.lastSelected == selectedFilterOpt) {
            return;
        }
        this.lastSelected = selectedFilterOpt;
        this.layout_switchableViews.show(this.pnl_switchableViews, selectedFilterOpt.getView());
        String filterTitle = this.mainFrame.getTitle();
        this.mainFrame.setTitle(this.frameTitle);
        this.chk_invertFilter.setVisible(false);
        if (selectedFilterOpt.getView() == "VIEWS_FILTER") {
            this.mainFrame.setTitle(filterTitle);
            this.chk_invertFilter.setVisible(selectedFilterOpt.getQuerySource() instanceof PDBStructureChooserQuerySource);
            if (this.data != selectedFilterOpt.getQuerySource() || this.data.needsRefetch(selectedFilterOpt)) {
                this.data = selectedFilterOpt.getQuerySource();
                this.tabRefresh();
                return;
            }
            this.filterResultSet(selectedFilterOpt.getValue());
        } else if (selectedFilterOpt.getView() == "VIEWS_ENTER_ID" || selectedFilterOpt.getView() == "VIEWS_FROM_FILE") {
            this.mainFrame.setTitle(MessageManager.getString("label.structure_chooser_manual_association"));
            this.idInputAssSeqPanel.loadCmbAssSeq();
            this.fileChooserAssSeqPanel.loadCmbAssSeq();
        }
        this.validateSelections();
    }

    @Override
    protected void validateSelections() {
        FilterOption selectedFilterOpt = (FilterOption)this.cmb_filterOption.getSelectedItem();
        this.btn_add.setEnabled(false);
        String currentView = selectedFilterOpt.getView();
        int selectedCount = 0;
        if (currentView == "VIEWS_FILTER") {
            selectedCount = this.getResultTable().getSelectedRows().length;
            if (selectedCount > 0) {
                this.btn_add.setEnabled(true);
            }
        } else if (currentView == "VIEWS_LOCAL_PDB") {
            selectedCount = this.tbl_local_pdb.getSelectedRows().length;
            if (selectedCount > 0) {
                this.btn_add.setEnabled(true);
            }
        } else if (currentView == "VIEWS_ENTER_ID") {
            this.validateAssociationEnterPdb();
        } else if (currentView == "VIEWS_FROM_FILE") {
            this.validateAssociationFromFile();
        }
        this.btn_newView.setEnabled(this.btn_add.isEnabled());
        this.chk_superpose.setEnabled(selectedCount > 1 || this.targetView.getItemCount() > 0);
    }

    @Override
    protected boolean showPopupFor(int selectedRow, final int x, final int y) {
        FilterOption selectedFilterOpt = (FilterOption)this.cmb_filterOption.getSelectedItem();
        String currentView = selectedFilterOpt.getView();
        if (currentView == "VIEWS_FILTER" && this.data instanceof ThreeDBStructureChooserQuerySource) {
            TDB_FTSData row = ((ThreeDBStructureChooserQuerySource)this.data).getFTSDataFor(this.getResultTable(), selectedRow, this.discoveredStructuresSet);
            final String pageUrl = row.getModelViewUrl();
            final JPopupMenu popup = new JPopupMenu("3D Beacons");
            JMenuItem viewUrl = new JMenuItem("View model web page");
            if (pageUrl == null || "".equals(pageUrl.trim())) {
                viewUrl.setEnabled(false);
                viewUrl.setText("No model page available.");
            }
            viewUrl.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Desktop.showUrl(pageUrl);
                }
            });
            popup.add(viewUrl);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popup.show(StructureChooser.this.getResultTable(), x, y);
                }
            });
            return true;
        }
        return false;
    }

    protected void validateAssociationEnterPdb() {
        GStructureChooser.AssociateSeqOptions assSeqOpt = (GStructureChooser.AssociateSeqOptions)this.idInputAssSeqPanel.getCmb_assSeq().getSelectedItem();
        this.lbl_pdbManualFetchStatus.setIcon(this.errorImage);
        this.lbl_pdbManualFetchStatus.setToolTipText("");
        if (this.txt_search.getText().length() > 0) {
            this.lbl_pdbManualFetchStatus.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("info.no_pdb_entry_found_for", this.txt_search.getText())));
        }
        if (this.errorWarning.length() > 0) {
            this.lbl_pdbManualFetchStatus.setIcon(this.warningImage);
            this.lbl_pdbManualFetchStatus.setToolTipText(JvSwingUtils.wrapTooltip(true, this.errorWarning.toString()));
        }
        if (this.selectedSequences.length == 1 || !assSeqOpt.getName().equalsIgnoreCase("-Select Associated Seq-")) {
            this.txt_search.setEnabled(true);
            if (this.isValidPBDEntry) {
                this.btn_add.setEnabled(true);
                this.lbl_pdbManualFetchStatus.setToolTipText("");
                this.lbl_pdbManualFetchStatus.setIcon(this.goodImage);
            }
        } else {
            this.txt_search.setEnabled(false);
            this.lbl_pdbManualFetchStatus.setIcon(this.errorImage);
        }
    }

    protected void validateAssociationFromFile() {
        GStructureChooser.AssociateSeqOptions assSeqOpt = (GStructureChooser.AssociateSeqOptions)this.fileChooserAssSeqPanel.getCmb_assSeq().getSelectedItem();
        String pdbFileString = "";
        String pdbFileTooltip = "";
        if (this.selectedSequences.length == 1 || assSeqOpt != null && !assSeqOpt.getName().equalsIgnoreCase("-Select Associated Seq-")) {
            this.btn_pdbFromFile.setEnabled(true);
            if (this.selectedPdbFileName != null && this.selectedPdbFileName.length() > 0) {
                this.btn_add.setEnabled(true);
                pdbFileString = new File(this.selectedPdbFileName).getName();
                pdbFileTooltip = new File(this.selectedPdbFileName).getAbsolutePath();
                this.setPdbOptionsEnabled(true);
            } else {
                pdbFileString = MessageManager.getString("label.none");
                pdbFileTooltip = MessageManager.getString("label.nothing_selected");
                this.setPdbOptionsEnabled(false);
            }
        } else {
            this.btn_pdbFromFile.setEnabled(false);
            this.setPdbOptionsEnabled(false);
            pdbFileString = MessageManager.getString("label.none");
            pdbFileTooltip = MessageManager.getString("label.nothing_selected");
        }
        this.lbl_pdbFile.setText(pdbFileString);
        this.lbl_pdbFile.setToolTipText(pdbFileTooltip);
        String paeFileString = "";
        String paeFileTooltip = "";
        if (this.localPdbPaeMatrixFileName != null && this.localPdbPaeMatrixFileName.length() > 0) {
            paeFileString = new File(this.localPdbPaeMatrixFileName).getName();
            paeFileTooltip = new File(this.localPdbPaeMatrixFileName).getAbsolutePath();
        } else {
            paeFileString = MessageManager.getString("label.none");
            paeFileTooltip = MessageManager.getString("label.nothing_selected");
        }
        this.lbl_paeFile.setText(paeFileString);
        this.lbl_paeFile.setToolTipText(paeFileTooltip);
    }

    @Override
    protected void cmbAssSeqStateChanged() {
        this.validateSelections();
    }

    @Override
    protected void stateChanged(ItemEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.updateCurrentView();
        } else if (e.getStateChange() == 1) {
            this.updateCurrentView();
        }
    }

    public boolean selectStructure(String ... pdbids) {
        JTable restable;
        boolean found = false;
        FilterOption selectedFilterOpt = (FilterOption)this.cmb_filterOption.getSelectedItem();
        String currentView = selectedFilterOpt.getView();
        JTable jTable = currentView == "VIEWS_FILTER" ? this.getResultTable() : (restable = currentView == "VIEWS_LOCAL_PDB" ? this.tbl_local_pdb : null);
        if (restable == null) {
            return false;
        }
        int pdbIdColIndex = restable.getColumn("PDB Id").getModelIndex();
        for (int r = 0; r < restable.getRowCount(); ++r) {
            for (int p = 0; p < pdbids.length; ++p) {
                if (!String.valueOf(restable.getValueAt(r, pdbIdColIndex)).equalsIgnoreCase(pdbids[p])) continue;
                restable.setRowSelectionInterval(r, r);
                found = true;
            }
        }
        return found;
    }

    @Override
    protected void newView_ActionPerformed() {
        this.targetView.setSelectedItem(null);
        this.showStructures(false);
    }

    @Override
    protected void add_ActionPerformed() {
        this.showStructures(false);
    }

    public void showStructures(boolean waitUntilFinished) {
        final StructureSelectionManager ssm = this.ap.getStructureSelectionManager();
        final int preferredHeight = this.pnl_filter.getHeight();
        this.btn_add.setEnabled(false);
        this.btn_newView.setEnabled(false);
        this.btn_cancel.setEnabled(false);
        this.actionsPanel.setEnabled(false);
        final String progress = MessageManager.getString("label.working_ellipsis");
        this.setProgressBar(progress, progress.hashCode());
        Runnable viewStruc = new Runnable(){

            @Override
            public void run() {
                JTable restable;
                FilterOption selectedFilterOpt = (FilterOption)StructureChooser.this.cmb_filterOption.getSelectedItem();
                String currentView = selectedFilterOpt.getView();
                JTable jTable = restable = currentView == "VIEWS_FILTER" ? StructureChooser.this.getResultTable() : StructureChooser.this.tbl_local_pdb;
                if (currentView == "VIEWS_FILTER") {
                    int[] selectedRows = restable.getSelectedRows();
                    PDBEntry[] pdbEntriesToView = new PDBEntry[selectedRows.length];
                    ArrayList<SequenceI> selectedSeqsToView = new ArrayList<SequenceI>();
                    pdbEntriesToView = StructureChooser.this.data.collectSelectedRows(restable, selectedRows, selectedSeqsToView);
                    SequenceI[] selectedSeqs = selectedSeqsToView.toArray(new SequenceI[selectedSeqsToView.size()]);
                    StructureChooser.this.sViewer = StructureChooser.this.launchStructureViewer(ssm, pdbEntriesToView, StructureChooser.this.ap, selectedSeqs);
                } else if (currentView == "VIEWS_LOCAL_PDB") {
                    int[] selectedRows = StructureChooser.this.tbl_local_pdb.getSelectedRows();
                    PDBEntry[] pdbEntriesToView = new PDBEntry[selectedRows.length];
                    int count = 0;
                    int pdbIdColIndex = StructureChooser.this.tbl_local_pdb.getColumn("PDB Id").getModelIndex();
                    int refSeqColIndex = StructureChooser.this.tbl_local_pdb.getColumn("Ref Sequence").getModelIndex();
                    ArrayList<SequenceI> selectedSeqsToView = new ArrayList<SequenceI>();
                    for (int row : selectedRows) {
                        PDBEntry pdbEntry = ((PDBEntryTableModel)StructureChooser.this.tbl_local_pdb.getModel()).getPDBEntryAt(row).getPdbEntry();
                        pdbEntriesToView[count++] = pdbEntry;
                        SequenceI selectedSeq = (SequenceI)StructureChooser.this.tbl_local_pdb.getValueAt(row, refSeqColIndex);
                        selectedSeqsToView.add(selectedSeq);
                    }
                    SequenceI[] selectedSeqs = selectedSeqsToView.toArray(new SequenceI[selectedSeqsToView.size()]);
                    StructureChooser.this.sViewer = StructureChooser.this.launchStructureViewer(ssm, pdbEntriesToView, StructureChooser.this.ap, selectedSeqs);
                } else if (currentView == "VIEWS_ENTER_ID") {
                    String pdbIdStr;
                    PDBEntry pdbEntry;
                    SequenceI userSelectedSeq = ((GStructureChooser.AssociateSeqOptions)StructureChooser.this.idInputAssSeqPanel.getCmb_assSeq().getSelectedItem()).getSequence();
                    if (userSelectedSeq != null) {
                        StructureChooser.this.selectedSequence = userSelectedSeq;
                    }
                    if ((pdbEntry = StructureChooser.this.selectedSequence.getPDBEntry(pdbIdStr = StructureChooser.this.txt_search.getText())) == null) {
                        pdbEntry = new PDBEntry();
                        if (pdbIdStr.split(":").length > 1) {
                            pdbEntry.setId(pdbIdStr.split(":")[0]);
                            pdbEntry.setChainCode(pdbIdStr.split(":")[1].toUpperCase(Locale.ROOT));
                        } else {
                            pdbEntry.setId(pdbIdStr);
                        }
                        pdbEntry.setType(PDBEntry.Type.PDB);
                        StructureChooser.this.selectedSequence.getDatasetSequence().addPDBId(pdbEntry);
                    }
                    PDBEntry[] pdbEntriesToView = new PDBEntry[]{pdbEntry};
                    StructureChooser.this.sViewer = StructureChooser.this.launchStructureViewer(ssm, pdbEntriesToView, StructureChooser.this.ap, new SequenceI[]{StructureChooser.this.selectedSequence});
                } else if (currentView == "VIEWS_FROM_FILE") {
                    StructureChooser sc = StructureChooser.this;
                    StructureImportSettings.TFType tft = (StructureImportSettings.TFType)((Object)sc.combo_tempFacAs.getSelectedItem());
                    String paeFilename = sc.localPdbPaeMatrixFileName;
                    GStructureChooser.AssociateSeqOptions assSeqOpt = (GStructureChooser.AssociateSeqOptions)StructureChooser.this.fileChooserAssSeqPanel.getCmb_assSeq().getSelectedItem();
                    SequenceI userSelectedSeq = assSeqOpt.getSequence();
                    if (userSelectedSeq != null) {
                        StructureChooser.this.selectedSequence = userSelectedSeq;
                    }
                    String pdbFilename = StructureChooser.this.selectedPdbFileName;
                    AlignmentPanel alignmentPanel = StructureChooser.this.ap;
                    SequenceI sequenceI = StructureChooser.this.selectedSequence;
                    StructureChooser.this.getTargetedStructureViewer(ssm);
                    StructureChooser.openStructureFileForSequence(ssm, sc, alignmentPanel, sequenceI, true, pdbFilename, tft, paeFilename, false, true, false, StructureViewer.getViewerType());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StructureChooser.this.setProgressBar("Complete.", progress.hashCode());
                        StructureChooser.this.closeAction(preferredHeight);
                        StructureChooser.this.mainFrame.dispose();
                    }
                });
            }
        };
        Thread runner = new Thread(viewStruc);
        runner.start();
        if (waitUntilFinished) {
            while (this.sViewer == null ? runner.isAlive() : this.sViewer.sview == null || !this.sViewer.sview.hasMapping()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    StructureViewer getTargetedStructureViewer(StructureSelectionManager ssm) {
        Object sv = this.targetView.getSelectedItem();
        return sv == null ? new StructureViewer(ssm) : (StructureViewer)sv;
    }

    private StructureViewer launchStructureViewer(StructureSelectionManager ssm, PDBEntry[] pdbEntriesToView, AlignmentPanel alignPanel, SequenceI[] sequences) {
        return this.launchStructureViewer(ssm, pdbEntriesToView, alignPanel, sequences, null);
    }

    public StructureViewer launchStructureViewer(StructureSelectionManager ssm, PDBEntry[] pdbEntriesToView, AlignmentPanel alignPanel, SequenceI[] sequences, StructureViewer.ViewerType viewerType) {
        return this.launchStructureViewer(ssm, pdbEntriesToView, alignPanel, sequences, viewerType, this.chk_superpose.isSelected());
    }

    public StructureViewer launchStructureViewer(StructureSelectionManager ssm, PDBEntry[] pdbEntriesToView, AlignmentPanel alignPanel, SequenceI[] sequences, StructureViewer.ViewerType viewerType, boolean thisSuperimpose) {
        long progressId = sequences.hashCode();
        this.setProgressBar(MessageManager.getString("status.launching_3d_structure_viewer"), progressId);
        StructureViewer theViewer = this.getTargetedStructureViewer(ssm);
        theViewer.setSuperpose(thisSuperimpose);
        if (Jalview.isHeadlessMode()) {
            theViewer.setAsync(false);
        }
        Cache.setProperty(AUTOSUPERIMPOSE, Boolean.valueOf(thisSuperimpose).toString());
        this.setProgressBar(null, progressId);
        if (SiftsSettings.isMapWithSifts()) {
            ArrayList<SequenceI> seqsWithoutSourceDBRef = new ArrayList<SequenceI>();
            int p = 0;
            for (SequenceI seq : sequences) {
                StructureMapping[] smm;
                PDBEntry pdbe;
                if ((pdbe = pdbEntriesToView[p++]) != null && pdbe.getFile() != null && (smm = ssm.getMapping(pdbe.getFile())) != null && smm.length > 0) {
                    for (StructureMapping sm : smm) {
                        if (sm.getSequence() != seq) continue;
                    }
                }
                if (!seq.getPrimaryDBRefs().isEmpty()) continue;
                seqsWithoutSourceDBRef.add(seq);
            }
            if (!seqsWithoutSourceDBRef.isEmpty()) {
                int y = seqsWithoutSourceDBRef.size();
                this.setProgressBar(MessageManager.formatMessage("status.fetching_dbrefs_for_sequences_without_valid_refs", y), progressId);
                SequenceI[] seqWithoutSrcDBRef = seqsWithoutSourceDBRef.toArray(new SequenceI[y]);
                DBRefFetcher dbRefFetcher = new DBRefFetcher(seqWithoutSrcDBRef);
                dbRefFetcher.fetchDBRefs(true);
                this.setProgressBar("Fetch complete.", progressId);
            }
        }
        if (pdbEntriesToView.length > 1) {
            this.setProgressBar(MessageManager.getString("status.fetching_3d_structures_for_selected_entries"), progressId);
            theViewer.viewStructures(pdbEntriesToView, sequences, alignPanel, viewerType);
        } else {
            this.setProgressBar(MessageManager.formatMessage("status.fetching_3d_structures_for", pdbEntriesToView[0].getId()), progressId);
            theViewer.viewStructures(pdbEntriesToView[0], sequences, alignPanel, viewerType);
        }
        this.setProgressBar(null, progressId);
        lastTargetedView = theViewer;
        return theViewer;
    }

    @Override
    protected void populateCmbAssociateSeqOptions(JComboBox<GStructureChooser.AssociateSeqOptions> cmb_assSeq, JLabel lbl_associateSeq) {
        cmb_assSeq.removeAllItems();
        cmb_assSeq.addItem(new GStructureChooser.AssociateSeqOptions("-Select Associated Seq-", null));
        lbl_associateSeq.setVisible(false);
        if (this.selectedSequences.length > 1) {
            for (SequenceI seq : this.selectedSequences) {
                cmb_assSeq.addItem(new GStructureChooser.AssociateSeqOptions(seq));
            }
        } else {
            String seqName = this.selectedSequence.getDisplayId(false);
            seqName = seqName.length() <= 40 ? seqName : seqName.substring(0, 39);
            lbl_associateSeq.setText(seqName);
            lbl_associateSeq.setVisible(true);
            cmb_assSeq.setVisible(false);
        }
    }

    protected boolean isStructuresDiscovered() {
        return this.discoveredStructuresSet != null && !this.discoveredStructuresSet.isEmpty();
    }

    @Override
    protected void txt_search_ActionPerformed() {
        final String text = this.txt_search.getText().trim();
        if (text.length() >= this.PDB_ID_MIN) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StructureChooser.this.errorWarning.setLength(0);
                    StructureChooser.this.isValidPBDEntry = false;
                    if (text.length() > 0) {
                        FTSRestResponse resultList;
                        String searchTerm = text.toLowerCase(Locale.ROOT);
                        searchTerm = searchTerm.split(":")[0];
                        ArrayList<FTSDataColumnI> wantedFields = new ArrayList<FTSDataColumnI>();
                        FTSRestRequest pdbRequest = new FTSRestRequest();
                        pdbRequest.setAllowEmptySeq(false);
                        pdbRequest.setResponseSize(1);
                        pdbRequest.setFieldToSearchBy("(pdb_id:");
                        pdbRequest.setWantedFields(wantedFields);
                        pdbRequest.setSearchTerm(searchTerm + ")");
                        pdbRequest.setAssociatedSequence(StructureChooser.this.selectedSequence);
                        FTSRestClientI pdbRestClient = PDBFTSRestClient.getInstance();
                        wantedFields.add(pdbRestClient.getPrimaryKeyColumn());
                        try {
                            resultList = pdbRestClient.executeRequest(pdbRequest);
                        }
                        catch (Exception e) {
                            StructureChooser.this.errorWarning.append(e.getMessage());
                            return;
                        }
                        finally {
                            StructureChooser.this.validateSelections();
                        }
                        if (resultList.getSearchSummary() != null && resultList.getSearchSummary().size() > 0) {
                            StructureChooser.this.isValidPBDEntry = true;
                        }
                    }
                    StructureChooser.this.validateSelections();
                }
            }.start();
        }
    }

    @Override
    protected void tabRefresh() {
        if (this.selectedSequences != null) {
            this.lbl_loading.setVisible(true);
            Thread refreshThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    StructureChooser.this.fetchStructuresMetaData();
                    StructureChooser.this.filterResultSet(((FilterOption)StructureChooser.this.cmb_filterOption.getSelectedItem()).getValue());
                    StructureChooser.this.lbl_loading.setVisible(false);
                }
            });
            refreshThread.start();
        }
    }

    @Override
    public void setProgressBar(String message, long id) {
        if (!Platform.isHeadless() && this.progressBar != null) {
            this.progressBar.setProgressBar(message, id);
        }
    }

    @Override
    public void registerHandler(long id, IProgressIndicatorHandler handler) {
        if (this.progressBar != null) {
            this.progressBar.registerHandler(id, handler);
        }
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBar == null ? false : this.progressBar.operationInProgress();
    }

    public JalviewStructureDisplayI getOpenedStructureViewer() {
        return this.sViewer == null ? null : this.sViewer.sview;
    }

    @Override
    protected void setFTSDocFieldPrefs(FTSDataColumnPreferences newPrefs) {
        this.data.setDocFieldPrefs(newPrefs);
    }

    public boolean isDialogVisible() {
        return this.mainFrame != null && this.data != null && this.cmb_filterOption != null && this.mainFrame.isVisible() && this.cmb_filterOption.getSelectedItem() != null;
    }

    public boolean isCanQueryTDB() {
        return this.canQueryTDB;
    }

    public boolean isNotQueriedTDBYet() {
        return this.notQueriedTDBYet;
    }

    public static void openStructureFileForSequence(StructureSelectionManager ssm, StructureChooser sc, AlignmentPanel ap, SequenceI seq, boolean prompt, String sFilename, StructureImportSettings.TFType tft, String paeFilename, boolean doXferSettings) {
        StructureChooser.openStructureFileForSequence(ssm, sc, ap, seq, prompt, sFilename, tft, paeFilename, false, true, doXferSettings, null);
    }

    public static StructureViewer openStructureFileForSequence(StructureSelectionManager ssm, StructureChooser sc, AlignmentPanel ap, SequenceI seq, boolean prompt, String sFilename, StructureImportSettings.TFType tft, String paeFilename, boolean forceHeadless, boolean showRefAnnotations, boolean doXferSettings, StructureViewer.ViewerType viewerType) {
        return StructureChooser.openStructureForASequence(ssm, sc, ap, seq, prompt, sFilename, DataSourceType.FILE, tft, paeFilename, forceHeadless, showRefAnnotations, doXferSettings, viewerType);
    }

    public static StructureViewer openStructureForASequence(StructureSelectionManager ssm, StructureChooser sc, AlignmentPanel ap, SequenceI seq, boolean prompt, String strucDloc, DataSourceType strucDsource, StructureImportSettings.TFType tft, String paeFileSource, boolean forceHeadless, boolean showRefAnnotations, boolean doXferSettings, StructureViewer.ViewerType viewerType) {
        StructureViewer sv = null;
        boolean headless = forceHeadless;
        if (sc == null) {
            prompt = false;
            sc = new StructureChooser(new SequenceI[]{seq}, seq, ap, false, true);
        }
        if (ssm == null) {
            ssm = ap.getStructureSelectionManager();
            StructureSelectionManager.doConfigureStructurePrefs(ssm);
        }
        String paeFilename = null;
        if (paeFileSource != null) {
            if (strucDsource == null || strucDsource.equals((Object)DataSourceType.FILE)) {
                paeFilename = paeFileSource;
            } else if (DataSourceType.URL.equals((Object)strucDsource)) {
                try {
                    File tfile = EBIAlfaFold.fetchAPAE_from(null, paeFileSource);
                    paeFilename = tfile.getAbsolutePath();
                }
                catch (IOException ex) {
                    Console.error("Couldn't retrieve PAE file from URL " + paeFileSource, ex);
                }
            } else {
                Console.warn("Can't handle PAE data location type " + strucDsource + " for given structure " + strucDloc);
            }
        }
        PDBEntry fileEntry = new AssociatePdbFileWithSeq().associatePdbWithSeq(strucDloc, strucDsource != null ? strucDsource : DataSourceType.FILE, seq, prompt, Desktop.instance, tft, paeFilename, doXferSettings);
        if (!headless && viewerType != null) {
            sv = sc.launchStructureViewer(ssm, new PDBEntry[]{fileEntry}, ap, new SequenceI[]{seq}, viewerType);
            sv.getJalviewStructureDisplay().raiseViewer();
        }
        sc.mainFrame.dispose();
        if (showRefAnnotations) {
            StructureChooser.showReferenceAnnotationsForSequence(ap.alignFrame, seq);
        }
        return sv;
    }

    public static void showReferenceAnnotationsForSequence(AlignFrame af, SequenceI sequence) {
        AlignViewport av = af.getCurrentView();
        AlignmentI al = av.getAlignment();
        ArrayList<SequenceI> forSequences = new ArrayList<SequenceI>();
        forSequences.add(sequence);
        LinkedHashMap<SequenceI, List<AlignmentAnnotation>> candidates = new LinkedHashMap<SequenceI, List<AlignmentAnnotation>>();
        AlignmentUtils.findAddableReferenceAnnotations(forSequences, null, candidates, al);
        SequenceGroup selectionGroup = av.getSelectionGroup();
        AlignmentUtils.addReferenceAnnotations(candidates, al, selectionGroup);
        for (AlignmentViewPanel alignmentViewPanel : af.getAlignPanels()) {
            alignmentViewPanel.adjustAnnotationHeight();
        }
    }

    @Override
    public JProgressBar getProgressBar(long id) {
        return this.progressBar.getProgressBar(id);
    }

    @Override
    public String getMessage(long id) {
        return this.progressIndicator.getMessage(id);
    }

    @Override
    public void setProgressBarMessage(long id, String message) {
        this.progressIndicator.setProgressBarMessage(id, message);
    }

    static /* synthetic */ FTSDataColumnI[] access$302(StructureChooser x0, FTSDataColumnI[] x1) {
        x0.previousWantedFields = x1;
        return x1;
    }

    private class CachedPDB {
        private SequenceI sequence;
        private PDBEntry pdbEntry;

        public CachedPDB(SequenceI sequence, PDBEntry pdbEntry) {
            this.sequence = sequence;
            this.pdbEntry = pdbEntry;
        }

        public String getQualifiedId() {
            if (this.pdbEntry.hasProvider()) {
                return this.pdbEntry.getProvider() + ":" + this.pdbEntry.getId();
            }
            return this.pdbEntry.toString();
        }

        public SequenceI getSequence() {
            return this.sequence;
        }

        public PDBEntry getPdbEntry() {
            return this.pdbEntry;
        }
    }

    public class PDBEntryTableModel
    extends AbstractTableModel {
        String[] columns = new String[]{"Ref Sequence", "PDB Id", "Chain", "Type", "File"};
        private List<CachedPDB> pdbEntries;

        public PDBEntryTableModel(List<CachedPDB> pdbEntries) {
            this.pdbEntries = new ArrayList<CachedPDB>(pdbEntries);
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.pdbEntries.size();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = "??";
            CachedPDB entry = this.pdbEntries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value = entry.getSequence();
                    break;
                }
                case 1: {
                    value = entry.getQualifiedId();
                    break;
                }
                case 2: {
                    value = entry.getPdbEntry().getChainCode() == null ? "_" : entry.getPdbEntry().getChainCode();
                    break;
                }
                case 3: {
                    value = entry.getPdbEntry().getType();
                    break;
                }
                case 4: {
                    value = entry.getPdbEntry().getFile();
                }
            }
            return value;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? SequenceI.class : PDBEntry.class;
        }

        public CachedPDB getPDBEntryAt(int row) {
            return this.pdbEntries.get(row);
        }
    }
}

