/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.util.MessageManager;
import java.awt.Component;
import java.text.DateFormat;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import org.robsite.jswingreader.model.Item;
import org.robsite.jswingreader.ui.Main;

class ItemsRenderer
extends DefaultListCellRenderer {
    private static final Icon _icon = new ImageIcon(Main.class.getResource("image/ComposeMail16.gif"));

    ItemsRenderer() {
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        component.setIcon(_icon);
        if (value instanceof Item) {
            Item item = (Item)value;
            if (item.getPublishDate() != null) {
                component.setText(MessageManager.formatMessage("label.blog_item_published_on_date", new String[]{DateFormat.getDateInstance(1, MessageManager.getLocale()).format(item.getPublishDate()).toString(), item.getTitle()}));
            }
            component.setToolTipText(item.getLink());
            if (!item.isRead()) {
                component.setFont(component.getFont().deriveFont(1));
            } else {
                component.setFont(component.getFont().deriveFont(0));
            }
        }
        return component;
    }
}

