/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import ext.vamsas.ServiceHandle;
import jalview.analysis.AlignmentAnnotationUtils;
import jalview.analysis.AlignmentSorter;
import jalview.analysis.AlignmentUtils;
import jalview.analysis.AnnotationSorter;
import jalview.analysis.CrossRef;
import jalview.analysis.Dna;
import jalview.analysis.GeneticCodeI;
import jalview.analysis.ParseProperties;
import jalview.analysis.SequenceIdMatcher;
import jalview.api.AlignViewControllerGuiI;
import jalview.api.AlignViewControllerI;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureSettingsControllerI;
import jalview.api.FeatureSettingsModelI;
import jalview.api.SplitContainerI;
import jalview.api.ViewStyleI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.commands.OrderCommand;
import jalview.commands.RemoveGapColCommand;
import jalview.commands.RemoveGapsCommand;
import jalview.commands.SlideSequencesCommand;
import jalview.commands.TrimRegionCommand;
import jalview.controller.AlignViewController;
import jalview.datamodel.AlignExportSettingsAdapter;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentExportData;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignExportOptions;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationColourChooser;
import jalview.gui.AnnotationColumnChooser;
import jalview.gui.AnnotationExporter;
import jalview.gui.AssociatePdbFileWithSeq;
import jalview.gui.CalculationChooser;
import jalview.gui.ColourMenuHelper;
import jalview.gui.CrossRefAction;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.FeatureSettings;
import jalview.gui.Finder;
import jalview.gui.FontChooser;
import jalview.gui.Help;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.gui.OverviewPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.PairwiseAlignPanel;
import jalview.gui.PrintThread;
import jalview.gui.ProgressBar;
import jalview.gui.RedundancyPanel;
import jalview.gui.SequenceFetcher;
import jalview.gui.SliderPanel;
import jalview.gui.SplitFrame;
import jalview.gui.TextColourChooser;
import jalview.gui.TreePanel;
import jalview.gui.UserDefinedColours;
import jalview.gui.ViewSelectionMenu;
import jalview.io.AlignmentProperties;
import jalview.io.AnnotationFile;
import jalview.io.BackupFiles;
import jalview.io.BioJsHTMLOutput;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.FileParse;
import jalview.io.FormatAdapter;
import jalview.io.HtmlSvgOutput;
import jalview.io.IdentifyFile;
import jalview.io.JPredFile;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.JnetAnnotationMaker;
import jalview.io.NewickFile;
import jalview.io.ScoreMatrixFile;
import jalview.io.TCoffeeScoreFile;
import jalview.io.exceptions.ImageOutputException;
import jalview.io.vcf.VCFLoader;
import jalview.jbgui.GAlignFrame;
import jalview.project.Jalview2XML;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemes;
import jalview.schemes.TCoffeeColourScheme;
import jalview.util.Constants;
import jalview.util.HttpUtils;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.imagemaker.BitmapImageSizing;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.ViewportRanges;
import jalview.ws.DBRefFetcher;
import jalview.ws.jws1.Discoverer;
import jalview.ws.jws1.WS1Client;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.rest.RestClient;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class AlignFrame
extends GAlignFrame
implements DropTargetListener,
IProgressIndicator,
AlignViewControllerGuiI,
ColourMenuHelper.ColourChangeListener {
    public static final int DEFAULT_WIDTH = 700;
    public static final int DEFAULT_HEIGHT = 500;
    public AlignmentPanel alignPanel;
    AlignViewport viewport;
    public AlignViewControllerI avc;
    List<AlignmentPanel> alignPanels = new ArrayList<AlignmentPanel>();
    FileFormatI currentFileFormat = null;
    String fileName = null;
    File fileObject;
    private IProgressIndicator progressBar;
    boolean lastSaveSuccessful = false;
    FileFormatI lastFormatSaved;
    String lastFilenameSaved;
    private static FileFormatI globalLastFormatSaved = null;
    public FeatureSettings featureSettings;
    protected int _annotationScoreVectorHash;
    private boolean buildingMenu = false;
    private Rectangle lastFeatureSettingsBounds = null;
    private JPanel glassPane = null;
    private Component savedRootGlassPane = this.getRootPane().getGlassPane();

    public AlignFrame(AlignmentI al, int width, int height) {
        this(al, null, width, height);
    }

    public AlignFrame(AlignmentI al, int width, int height, String sequenceSetId) {
        this(al, null, width, height, sequenceSetId);
    }

    public AlignFrame(AlignmentI al, int width, int height, String sequenceSetId, String viewId) {
        this(al, null, width, height, sequenceSetId, viewId);
    }

    public AlignFrame(AlignmentI al, HiddenColumns hiddenColumns, int width, int height) {
        this(al, hiddenColumns, width, height, null);
    }

    public AlignFrame(AlignmentI al, HiddenColumns hiddenColumns, int width, int height, String sequenceSetId) {
        this(al, hiddenColumns, width, height, sequenceSetId, null);
    }

    public AlignFrame(AlignmentI al, HiddenColumns hiddenColumns, int width, int height, String sequenceSetId, String viewId) {
        this.setSize(width, height);
        if (al.getDataset() == null) {
            al.setDataset(null);
        }
        this.viewport = new AlignViewport(al, hiddenColumns, sequenceSetId, viewId);
        this.alignPanel = new AlignmentPanel(this, this.viewport);
        this.addAlignmentPanel(this.alignPanel, true);
        this.init();
    }

    public AlignFrame(AlignmentI al, SequenceI[] hiddenSeqs, HiddenColumns hiddenColumns, int width, int height) {
        this.setSize(width, height);
        if (al.getDataset() == null) {
            al.setDataset(null);
        }
        this.viewport = new AlignViewport(al, hiddenColumns);
        if (hiddenSeqs != null && hiddenSeqs.length > 0) {
            this.viewport.hideSequence(hiddenSeqs);
        }
        this.alignPanel = new AlignmentPanel(this, this.viewport);
        this.addAlignmentPanel(this.alignPanel, true);
        this.init();
    }

    public AlignFrame(AlignmentPanel ap) {
        this.viewport = ap.av;
        this.alignPanel = ap;
        this.addAlignmentPanel(ap, false);
        this.init();
    }

    void init() {
        String sortby;
        this.setFrameIcon(null);
        if (!Jalview.isHeadlessMode()) {
            this.progressBar = new ProgressBar(this.statusPanel, this.statusBar);
        }
        this.avc = new AlignViewController(this, this.viewport, this.alignPanel);
        if (this.viewport.getAlignmentConservationAnnotation() == null) {
            this.conservationMenuItem.setEnabled(false);
            this.modifyConservation.setEnabled(false);
        }
        if ((sortby = Cache.getDefault("SORT_ALIGNMENT", "No sort")).equals("Id")) {
            this.sortIDMenuItem_actionPerformed(null);
        } else if (sortby.equals("Pairwise Identity")) {
            this.sortPairwiseMenuItem_actionPerformed(null);
        }
        this.alignPanel.av.setShowAutocalculatedAbove(this.isShowAutoCalculatedAbove());
        this.setMenusFromViewport(this.viewport);
        this.buildSortByAnnotationScoresMenu();
        this.calculateTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlignFrame.this.openTreePcaDialog();
            }
        });
        this.buildColourMenu();
        if (Desktop.desktop != null) {
            this.setDropTarget(new DropTarget(this, this));
            if (!Platform.isJS()) {
                this.addServiceListeners();
            }
            this.setGUINucleotide();
        }
        if (this.viewport.getWrapAlignment()) {
            this.wrapMenuItem_actionPerformed(null);
        }
        if (Cache.getDefault("SHOW_OVERVIEW", false)) {
            this.overviewMenuItem_actionPerformed(null);
        }
        this.addKeyListener();
        final ArrayList<AlignmentViewPanel> selviews = new ArrayList<AlignmentViewPanel>();
        final ArrayList origview = new ArrayList();
        String menuLabel = MessageManager.getString("label.copy_format_from");
        ViewSelectionMenu vsel = new ViewSelectionMenu(menuLabel, new ViewSelectionMenu.ViewSetProvider(){

            @Override
            public AlignmentPanel[] getAllAlignmentPanels() {
                origview.clear();
                origview.add(AlignFrame.this.alignPanel);
                ArrayList<AlignmentPanel> aps = new ArrayList<AlignmentPanel>(Arrays.asList(Desktop.getAlignmentPanels(null)));
                aps.remove(AlignFrame.this.alignPanel);
                return aps.toArray(new AlignmentPanel[aps.size()]);
            }
        }, selviews, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (origview.size() > 0) {
                    boolean fromSplitFrame;
                    AlignmentPanel ap = (AlignmentPanel)origview.get(0);
                    ViewStyleI vs = ((AlignmentViewPanel)selviews.get(0)).getAlignViewport().getViewStyle();
                    boolean bl = fromSplitFrame = ((AlignmentViewPanel)selviews.get(0)).getAlignViewport().getCodingComplement() != null;
                    if (!fromSplitFrame) {
                        vs.setScaleProteinAsCdna(ap.getAlignViewport().getViewStyle().isScaleProteinAsCdna());
                    }
                    ap.getAlignViewport().setViewStyle(vs);
                    AlignViewportI complement = ap.getAlignViewport().getCodingComplement();
                    if (complement != null && vs.isScaleProteinAsCdna()) {
                        AlignFrame af = Desktop.getAlignFrameFor(complement);
                        ((SplitFrame)af.getSplitViewContainer()).adjustLayout();
                        af.setMenusForViewport();
                    }
                    ap.updateLayout();
                    ap.setSelected(true);
                    ap.alignFrame.setMenusForViewport();
                }
            }
        });
        if (Cache.getDefault("VERSION", "DEVELOPMENT").toLowerCase(Locale.ROOT).indexOf("devel") > -1 || Cache.getDefault("VERSION", "DEVELOPMENT").toLowerCase(Locale.ROOT).indexOf("test") > -1) {
            this.formatMenu.add(vsel);
        }
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Jalview.getInstance().setCurrentAlignFrame(AlignFrame.this);
            }
        });
    }

    public void setFileName(String file, FileFormatI format) {
        this.fileName = file;
        this.setFileFormat(format);
        this.reload.setEnabled(true);
    }

    public void setFileObject(File file) {
        this.fileObject = file;
    }

    void addKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (AlignFrame.this.viewport.cursorMode && (evt.getKeyCode() >= 48 && evt.getKeyCode() <= 57 || evt.getKeyCode() >= 96 && evt.getKeyCode() <= 105) && Character.isDigit(evt.getKeyChar())) {
                    AlignFrame.this.alignPanel.getSeqPanel().numberPressed(evt.getKeyChar());
                }
                switch (evt.getKeyCode()) {
                    case 27: {
                        AlignFrame.this.deselectAllSequenceMenuItem_actionPerformed(null);
                        break;
                    }
                    case 40: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.moveSelectedSequences(false);
                        }
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().moveCursor(0, 1, evt.isShiftDown());
                        break;
                    }
                    case 38: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.moveSelectedSequences(true);
                        }
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().moveCursor(0, -1, evt.isShiftDown());
                        break;
                    }
                    case 37: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.slideSequences(false, AlignFrame.this.alignPanel.getSeqPanel().getKeyboardNo1());
                            break;
                        }
                        AlignFrame.this.alignPanel.getSeqPanel().moveCursor(-1, 0, evt.isShiftDown());
                        break;
                    }
                    case 39: {
                        if (evt.isAltDown() || !AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.slideSequences(true, AlignFrame.this.alignPanel.getSeqPanel().getKeyboardNo1());
                            break;
                        }
                        AlignFrame.this.alignPanel.getSeqPanel().moveCursor(1, 0, evt.isShiftDown());
                        break;
                    }
                    case 32: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().insertGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                        break;
                    }
                    case 8: 
                    case 127: {
                        if (!AlignFrame.this.viewport.cursorMode) {
                            AlignFrame.this.cut_actionPerformed();
                            break;
                        }
                        AlignFrame.this.alignPanel.getSeqPanel().deleteGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                        break;
                    }
                    case 83: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().setCursorRow();
                        break;
                    }
                    case 67: {
                        if (!AlignFrame.this.viewport.cursorMode || evt.isControlDown()) break;
                        AlignFrame.this.alignPanel.getSeqPanel().setCursorColumn();
                        break;
                    }
                    case 80: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().setCursorPosition();
                        break;
                    }
                    case 10: 
                    case 44: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().setCursorRowAndColumn();
                        break;
                    }
                    case 81: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().setSelectionAreaAtCursor(true);
                        break;
                    }
                    case 77: {
                        if (!AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.alignPanel.getSeqPanel().setSelectionAreaAtCursor(false);
                        break;
                    }
                    case 113: {
                        AlignFrame.this.viewport.cursorMode = !AlignFrame.this.viewport.cursorMode;
                        AlignFrame.this.setStatus(MessageManager.formatMessage("label.keyboard_editing_mode", new String[]{AlignFrame.this.viewport.cursorMode ? "on" : "off"}));
                        if (AlignFrame.this.viewport.cursorMode) {
                            ViewportRanges ranges = AlignFrame.this.viewport.getRanges();
                            AlignFrame.this.alignPanel.getSeqPanel().seqCanvas.cursorX = ranges.getStartRes();
                            AlignFrame.this.alignPanel.getSeqPanel().seqCanvas.cursorY = ranges.getStartSeq();
                        }
                        AlignFrame.this.alignPanel.getSeqPanel().seqCanvas.repaint();
                        break;
                    }
                    case 112: {
                        try {
                            Help.showHelpWindow();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        break;
                    }
                    case 72: {
                        boolean toggleSeqs = !evt.isControlDown();
                        boolean toggleCols = !evt.isShiftDown();
                        AlignFrame.this.toggleHiddenRegions(toggleSeqs, toggleCols);
                        break;
                    }
                    case 66: {
                        boolean toggleSel = evt.isControlDown() || evt.isMetaDown();
                        boolean modifyExisting = true;
                        boolean invertHighlighted = evt.isAltDown();
                        AlignFrame.this.avc.markHighlightedColumns(invertHighlighted, modifyExisting, toggleSel);
                        break;
                    }
                    case 33: {
                        AlignFrame.this.viewport.getRanges().pageUp();
                        break;
                    }
                    case 34: {
                        AlignFrame.this.viewport.getRanges().pageDown();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                switch (evt.getKeyCode()) {
                    case 37: {
                        if (!evt.isAltDown() && AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.viewport.firePropertyChange("alignment", null, AlignFrame.this.viewport.getAlignment().getSequences());
                        break;
                    }
                    case 39: {
                        if (!evt.isAltDown() && AlignFrame.this.viewport.cursorMode) break;
                        AlignFrame.this.viewport.firePropertyChange("alignment", null, AlignFrame.this.viewport.getAlignment().getSequences());
                    }
                }
            }
        });
    }

    public void addAlignmentPanel(AlignmentPanel ap, boolean newPanel) {
        ap.alignFrame = this;
        this.avc = new AlignViewController(this, this.viewport, this.alignPanel);
        this.alignPanels.add(ap);
        PaintRefresher.Register(ap, ap.av.getSequenceSetId());
        int aSize = this.alignPanels.size();
        this.tabbedPane.setVisible(aSize > 1 || ap.av.getViewName() != null);
        if (aSize == 1 && ap.av.getViewName() == null) {
            this.getContentPane().add((Component)ap, "Center");
        } else {
            if (aSize == 2) {
                this.setInitialTabVisible();
            }
            this.expandViews.setEnabled(true);
            this.gatherViews.setEnabled(true);
            this.tabbedPane.addTab(ap.av.getViewName(), ap);
            ap.setVisible(false);
        }
        if (newPanel) {
            if (ap.av.isPadGaps()) {
                ap.av.getAlignment().padGaps();
            }
            ap.av.updateConservation(ap);
            ap.av.updateConsensus(ap);
            ap.av.updateSecondaryStructureConsensus(ap);
            ap.av.updateStrucConsensus(ap);
        }
    }

    public void setInitialTabVisible() {
        this.expandViews.setEnabled(true);
        this.gatherViews.setEnabled(true);
        this.tabbedPane.setVisible(true);
        AlignmentPanel first = this.alignPanels.get(0);
        this.tabbedPane.addTab(first.av.getViewName(), first);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
    }

    public AlignViewport getViewport() {
        return this.viewport;
    }

    private void addServiceListeners() {
        final PropertyChangeListener thisListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Console.errPrintln("Rebuild WS Menu for service change");
                        AlignFrame.this.BuildWebServiceMenu();
                    }
                });
            }
        };
        Desktop.instance.addJalviewPropertyChangeListener("services", thisListener);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                Desktop.instance.removeJalviewPropertyChangeListener("services", thisListener);
                AlignFrame.this.closeMenuItem_actionPerformed(true);
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                AlignFrame.this.BuildWebServiceMenu();
            }
        }).start();
    }

    public void setGUINucleotide() {
        AlignmentI al = this.getViewport().getAlignment();
        boolean nucleotide = al.isNucleotide();
        this.loadVcf.setVisible(nucleotide);
        this.showTranslation.setVisible(nucleotide);
        this.showReverse.setVisible(nucleotide);
        this.showReverseComplement.setVisible(nucleotide);
        this.conservationMenuItem.setEnabled(!nucleotide);
        this.modifyConservation.setEnabled(!nucleotide && this.conservationMenuItem.isSelected());
        this.byConsensusSecondaryStructureMenuItem.setEnabled(!nucleotide);
        this.modifyConsensusSecondaryStructureThreshold.setEnabled(!nucleotide && this.byConsensusSecondaryStructureMenuItem.isSelected());
        this.showGroupConservation.setEnabled(!nucleotide);
        this.showComplementMenuItem.setText(nucleotide ? MessageManager.getString("label.protein") : MessageManager.getString("label.nucleotide"));
    }

    @Override
    public void setMenusForViewport() {
        this.setMenusFromViewport(this.viewport);
    }

    public void setMenusFromViewport(AlignViewport av) {
        this.padGapsMenuitem.setSelected(av.isPadGaps());
        this.colourTextMenuItem.setSelected(av.isShowColourText());
        this.abovePIDThreshold.setSelected(av.getAbovePIDThreshold());
        this.modifyPID.setEnabled(this.abovePIDThreshold.isSelected());
        this.conservationMenuItem.setSelected(av.getConservationSelected());
        this.modifyConservation.setEnabled(this.conservationMenuItem.isSelected());
        this.byConsensusSecondaryStructureMenuItem.setSelected(av.getByConsensusSecondaryStructureSelected());
        this.modifyConsensusSecondaryStructureThreshold.setEnabled(this.byConsensusSecondaryStructureMenuItem.isSelected());
        this.seqLimits.setSelected(av.getShowJVSuffix());
        this.idRightAlign.setSelected(av.isRightAlignIds());
        this.centreColumnLabelsMenuItem.setState(av.isCentreColumnLabels());
        this.renderGapsMenuItem.setSelected(av.isRenderGaps());
        this.wrapMenuItem.setSelected(av.getWrapAlignment());
        this.scaleAbove.setVisible(av.getWrapAlignment());
        this.scaleLeft.setVisible(av.getWrapAlignment());
        this.scaleRight.setVisible(av.getWrapAlignment());
        this.annotationPanelMenuItem.setState(av.isShowAnnotation());
        this.showAllSeqAnnotations.setEnabled(this.annotationPanelMenuItem.getState());
        this.hideAllSeqAnnotations.setEnabled(this.annotationPanelMenuItem.getState());
        this.showAllAlAnnotations.setEnabled(this.annotationPanelMenuItem.getState());
        this.hideAllAlAnnotations.setEnabled(this.annotationPanelMenuItem.getState());
        this.viewBoxesMenuItem.setSelected(av.getShowBoxes());
        this.viewTextMenuItem.setSelected(av.getShowText());
        this.showNonconservedMenuItem.setSelected(av.getShowUnconserved());
        this.showGroupConsensus.setSelected(av.isShowGroupConsensus());
        this.showGroupSSConsensus.setSelected(av.isShowGroupSSConsensus());
        this.showStrucProvider.setSelected(av.isShowStructureProvider());
        this.showGroupConservation.setSelected(av.isShowGroupConservation());
        this.showConsensusHistogram.setSelected(av.isShowConsensusHistogram());
        this.showSequenceLogo.setSelected(av.isShowSequenceLogo());
        this.normaliseSequenceLogo.setSelected(av.isNormaliseSequenceLogo());
        ColourMenuHelper.setColourSelected(this.colourMenu, av.getGlobalColourScheme());
        this.showSeqFeatures.setSelected(av.isShowSequenceFeatures());
        this.hiddenMarkers.setState(av.getShowHiddenMarkers());
        this.applyToAllGroups.setState(av.getColourAppliesToAllGroups());
        this.showNpFeatsMenuitem.setSelected(av.isShowNPFeats());
        this.showDbRefsMenuitem.setSelected(av.isShowDBRefs());
        this.autoCalculate.setSelected(av.autoCalculateConsensus);
        this.sortByTree.setSelected(av.sortByTree);
        this.listenToViewSelections.setSelected(av.followSelection);
        this.showProducts.setEnabled(this.canShowProducts());
        this.setGroovyEnabled(Desktop.getGroovyConsole() != null);
        this.updateEditMenuBar();
    }

    public void setGroovyEnabled(boolean b) {
        this.runGroovy.setEnabled(b);
    }

    @Override
    public void setProgressBar(String message, long id) {
        if (!Platform.isHeadless() && this.progressBar != null) {
            this.progressBar.setProgressBar(message, id);
        }
    }

    @Override
    public JProgressBar getProgressBar(long id) {
        if (this.progressBar != null) {
            return this.progressBar.getProgressBar(id);
        }
        return null;
    }

    @Override
    public String getMessage(long id) {
        return this.progressBar.getMessage(id);
    }

    @Override
    public void setProgressBarMessage(long id, String message) {
        this.progressBar.setProgressBarMessage(id, message);
    }

    @Override
    public void registerHandler(long id, IProgressIndicatorHandler handler) {
        if (this.progressBar != null) {
            this.progressBar.registerHandler(id, handler);
        }
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBar == null ? false : this.progressBar.operationInProgress();
    }

    @Override
    public void setStatus(String text) {
        this.statusBar.setText(text == null || text.isEmpty() ? " " : text);
    }

    public String getVersion() {
        return Cache.getProperty("VERSION");
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer();
    }

    @Override
    public void fetchSequence_actionPerformed() {
        new SequenceFetcher(this);
    }

    @Override
    public void addFromFile_actionPerformed(ActionEvent e) {
        Desktop.instance.inputLocalFileMenuItem_actionPerformed(this.viewport);
    }

    @Override
    public void reload_actionPerformed(ActionEvent e) {
        if (this.fileName != null) {
            if (FileFormat.Jalview.equals(this.currentFileFormat)) {
                JInternalFrame[] frames = Desktop.desktop.getAllFrames();
                for (int i = 0; i < frames.length; ++i) {
                    if (!(frames[i] instanceof AlignFrame) || frames[i] == this || ((AlignFrame)frames[i]).fileName == null || !((AlignFrame)frames[i]).fileName.equals(this.fileName)) continue;
                    try {
                        frames[i].setSelected(true);
                        Desktop.instance.closeAssociatedWindows();
                        continue;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                Desktop.instance.closeAssociatedWindows();
                FileLoader loader = new FileLoader();
                DataSourceType protocol = HttpUtils.startsWithHttpOrHttps(this.fileName) ? DataSourceType.URL : DataSourceType.FILE;
                loader.LoadFile(this.viewport, this.fileName, protocol, this.currentFileFormat);
            } else {
                Rectangle bounds = this.getBounds();
                FileLoader loader = new FileLoader();
                AlignFrame newframe = null;
                if (this.fileObject == null) {
                    DataSourceType protocol = HttpUtils.startsWithHttpOrHttps(this.fileName) ? DataSourceType.URL : DataSourceType.FILE;
                    newframe = loader.LoadFileWaitTillLoaded(this.fileName, protocol, this.currentFileFormat);
                } else {
                    newframe = loader.LoadFileWaitTillLoaded(this.fileObject, DataSourceType.FILE, this.currentFileFormat);
                }
                newframe.setBounds(bounds);
                if (this.featureSettings != null && this.featureSettings.isShowing()) {
                    final Rectangle fspos = this.featureSettings.frame.getBounds();
                    newframe.featureSettings_actionPerformed(null);
                    final FeatureSettings nfs = newframe.featureSettings;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            nfs.frame.setBounds(fspos);
                        }
                    });
                    this.featureSettings.close();
                    this.featureSettings = null;
                }
                this.closeMenuItem_actionPerformed(true);
            }
        }
    }

    @Override
    public void addFromText_actionPerformed(ActionEvent e) {
        Desktop.instance.inputTextboxMenuItem_actionPerformed(this.viewport.getAlignPanel());
    }

    @Override
    public void addFromURL_actionPerformed(ActionEvent e) {
        Desktop.instance.inputURLMenuItem_actionPerformed(this.viewport);
    }

    @Override
    public void save_actionPerformed(ActionEvent e) {
        if (this.fileName == null || this.currentFileFormat == null || HttpUtils.startsWithHttpOrHttps(this.fileName)) {
            this.saveAs_actionPerformed();
        } else {
            this.saveAlignment(this.fileName, this.currentFileFormat);
        }
    }

    @Override
    public void saveAs_actionPerformed() {
        JalviewFileChooser chooser = JalviewFileChooser.forWrite(Cache.getProperty("LAST_DIRECTORY"), this.currentFileFormat == null ? null : this.currentFileFormat.getName(), true);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_alignment_to_file"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(this);
        if (value != 0) {
            return;
        }
        this.currentFileFormat = chooser.getSelectedFormat();
        while (this.currentFileFormat == null) {
            JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.select_file_format_before_saving"), MessageManager.getString("label.file_format_not_specified"), 2);
            value = chooser.showSaveDialog(this);
            if (value != 0) {
                return;
            }
            this.currentFileFormat = chooser.getSelectedFormat();
        }
        this.fileName = chooser.getSelectedFile().getPath();
        Cache.setProperty("DEFAULT_FILE_FORMAT", this.currentFileFormat.getName());
        Cache.setProperty("LAST_DIRECTORY", this.fileName);
        this.saveAlignment(this.fileName, this.currentFileFormat);
    }

    public static void setLastAlignmentSavedFormat(FileFormatI f) {
        globalLastFormatSaved = f;
    }

    public static FileFormatI getLastAlignmentSavedFormat() {
        return globalLastFormatSaved;
    }

    public boolean isSaveAlignmentSuccessful() {
        if (!this.lastSaveSuccessful) {
            if (!Platform.isHeadless()) {
                JvOptionPane.showInternalMessageDialog((Component)this, MessageManager.formatMessage("label.couldnt_save_file", this.lastFilenameSaved), MessageManager.getString("label.error_saving_file"), 2);
            } else {
                Console.error(MessageManager.formatMessage("label.couldnt_save_file", this.lastFilenameSaved));
            }
        } else {
            this.setStatus(MessageManager.formatMessage("label.successfully_saved_to_file_in_format", this.lastFilenameSaved, this.lastFormatSaved));
        }
        return this.lastSaveSuccessful;
    }

    public void saveAlignment(String file, FileFormatI format) {
        this.saveAlignment(file, format, false, false);
    }

    public void saveAlignment(String file, FileFormatI format, boolean stdout, boolean forceBackup) {
        this.lastSaveSuccessful = true;
        if (!stdout) {
            this.lastFilenameSaved = file;
        }
        this.lastFormatSaved = format;
        globalLastFormatSaved = format;
        if (FileFormat.Jalview.equals(format)) {
            String shortName = this.title;
            if (shortName.indexOf(File.separatorChar) > -1) {
                shortName = shortName.substring(shortName.lastIndexOf(File.separatorChar) + 1);
            }
            this.lastSaveSuccessful = new Jalview2XML().saveAlignment(this, file, shortName);
            Console.debug("lastSaveSuccessful=" + this.lastSaveSuccessful);
            if (this.lastSaveSuccessful) {
                this.getViewport().setSavedUpToDate(true);
            }
            this.statusBar.setText(MessageManager.formatMessage("label.successfully_saved_to_file_in_format", file, format));
            return;
        }
        AlignExportSettingsAdapter options = new AlignExportSettingsAdapter(false);
        Runnable cancelAction = () -> {
            this.lastSaveSuccessful = false;
        };
        Runnable outputAction = () -> {
            AlignmentExportData exportData = this.viewport.getAlignExportData(options);
            String output = new FormatAdapter(this.alignPanel, options).formatSequences(format, exportData.getAlignment(), exportData.getOmitHidden(), exportData.getStartEndPostions(), this.viewport.getAlignment().getHiddenColumns());
            if (output == null) {
                this.lastSaveSuccessful = false;
            } else {
                boolean doBackup = forceBackup || BackupFiles.getEnabled() && !stdout;
                BackupFiles backupfiles = null;
                if (doBackup) {
                    Console.trace("ALIGNFRAME making backupfiles object for " + file);
                    backupfiles = new BackupFiles(file);
                }
                try {
                    PrintWriter out;
                    String tempFilePath = doBackup ? backupfiles.getTempFilePath() : file;
                    Console.trace("ALIGNFRAME setting PrintWriter");
                    PrintWriter printWriter = out = stdout ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter(new FileWriter(tempFilePath));
                    if (backupfiles != null) {
                        Console.trace("ALIGNFRAME about to write to temp file " + backupfiles.getTempFilePath());
                    }
                    out.print(output);
                    out.flush();
                    if (!stdout) {
                        Console.trace("ALIGNFRAME about to close file");
                        out.close();
                        Console.trace("ALIGNFRAME closed file");
                    }
                    this.setTitle(stdout ? "STDOUT" : file);
                    if (stdout) {
                        this.statusBar.setText(MessageManager.formatMessage("label.successfully_printed_to_stdout_in_format", format.getName()));
                    } else {
                        this.statusBar.setText(MessageManager.formatMessage("label.successfully_saved_to_file_in_format", this.fileName, format.getName()));
                    }
                    this.lastSaveSuccessful = true;
                }
                catch (IOException e) {
                    this.lastSaveSuccessful = false;
                    Console.error("ALIGNFRAME Something happened writing the temp file");
                    Console.error(e.getMessage());
                    Console.debug(Cache.getStackTraceString(e));
                }
                catch (Exception ex) {
                    this.lastSaveSuccessful = false;
                    Console.error("ALIGNFRAME Something unexpected happened writing the temp file");
                    Console.error(ex.getMessage());
                    Console.debug(Cache.getStackTraceString(ex));
                }
                if (doBackup) {
                    backupfiles.setWriteSuccess(this.lastSaveSuccessful);
                    Console.debug("ALIGNFRAME writing temp file was " + (this.lastSaveSuccessful ? "" : "NOT ") + "successful");
                    Console.trace("ALIGNFRAME about to rollBackupsAndRenameTempFile");
                    this.lastSaveSuccessful = backupfiles.rollBackupsAndRenameTempFile();
                    Console.debug("ALIGNFRAME performed rollBackupsAndRenameTempFile " + (this.lastSaveSuccessful ? "" : "un") + "successfully");
                }
                Console.debug("lastSaveSuccessful=" + this.lastSaveSuccessful);
                if (this.lastSaveSuccessful) {
                    this.getViewport().setSavedUpToDate(true);
                }
            }
        };
        if (AlignExportOptions.isNeeded(this.viewport, format)) {
            AlignExportOptions choices = new AlignExportOptions(this.alignPanel.getAlignViewport(), format, options);
            choices.setResponseAction(0, outputAction);
            choices.setResponseAction(1, cancelAction);
            choices.showDialog();
        } else {
            try {
                outputAction.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void outputText_actionPerformed(String fileFormatName) {
        FileFormatI fileFormat = FileFormats.getInstance().forName(fileFormatName);
        AlignExportSettingsAdapter options = new AlignExportSettingsAdapter(false);
        Runnable outputAction = () -> {
            AlignmentExportData exportData = this.viewport.getAlignExportData(options);
            CutAndPasteTransfer cap = new CutAndPasteTransfer();
            cap.setForInput(null);
            try {
                FileFormatI format = fileFormat;
                cap.setText(new FormatAdapter(this.alignPanel, options).formatSequences(format, exportData.getAlignment(), exportData.getOmitHidden(), exportData.getStartEndPostions(), this.viewport.getAlignment().getHiddenColumns()));
                Desktop.addInternalFrame(cap, MessageManager.formatMessage("label.alignment_output_command", fileFormat.getName()), 600, 500);
            }
            catch (OutOfMemoryError oom) {
                new OOMWarning("Outputting alignment as " + fileFormat.getName(), oom);
                cap.dispose();
            }
        };
        if (AlignExportOptions.isNeeded(this.viewport, fileFormat)) {
            AlignExportOptions choices = new AlignExportOptions(this.alignPanel.getAlignViewport(), fileFormat, options);
            choices.setResponseAction(0, outputAction);
            choices.showDialog();
        } else {
            try {
                outputAction.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void htmlMenuItem_actionPerformed(ActionEvent e) {
        HtmlSvgOutput htmlSVG = new HtmlSvgOutput(this.alignPanel);
        try {
            htmlSVG.exportHTML(null);
        }
        catch (ImageOutputException imageOutputException) {
            // empty catch block
        }
    }

    @Override
    public void bioJSMenuItem_actionPerformed(ActionEvent e) {
        BioJsHTMLOutput bjs = new BioJsHTMLOutput(this.alignPanel);
        try {
            bjs.exportHTML(null);
        }
        catch (ImageOutputException imageOutputException) {
            // empty catch block
        }
    }

    public void createImageMap(File file, String image) {
        try {
            this.alignPanel.makePNGImageMap(file, image);
        }
        catch (ImageOutputException imageOutputException) {
            // empty catch block
        }
    }

    @Override
    public void createPNG_actionPerformed(ActionEvent e) {
        try {
            this.createPNG(null);
        }
        catch (ImageOutputException imageOutputException) {
            // empty catch block
        }
    }

    @Override
    public void createEPS_actionPerformed(ActionEvent e) {
        try {
            this.createEPS(null);
        }
        catch (ImageOutputException imageOutputException) {
            // empty catch block
        }
    }

    @Override
    public void createSVG_actionPerformed(ActionEvent e) {
        try {
            this.createSVG(null);
        }
        catch (ImageOutputException imageOutputException) {
            // empty catch block
        }
    }

    public void createPNG(File f) throws ImageOutputException {
        this.createPNG(f, null, BitmapImageSizing.defaultBitmapImageSizing());
    }

    public void createPNG(File f, String renderer, BitmapImageSizing userBis) throws ImageOutputException {
        this.alignPanel.makeAlignmentImage(ImageMaker.TYPE.PNG, f, renderer, userBis);
    }

    public void createEPS(File f) throws ImageOutputException {
        this.createEPS(f, null);
    }

    public void createEPS(File f, String renderer) throws ImageOutputException {
        this.alignPanel.makeAlignmentImage(ImageMaker.TYPE.EPS, f, renderer);
    }

    public void createSVG(File f) throws ImageOutputException {
        this.createSVG(f, null);
    }

    public void createSVG(File f, String renderer) throws ImageOutputException {
        this.alignPanel.makeAlignmentImage(ImageMaker.TYPE.SVG, f, renderer);
    }

    @Override
    public void pageSetup_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        PrintThread.pf = printJob.pageDialog(printJob.defaultPage());
    }

    @Override
    public void printMenuItem_actionPerformed(ActionEvent e) {
        PrintThread thread = new PrintThread(this.alignPanel);
        thread.start();
    }

    @Override
    public void exportFeatures_actionPerformed(ActionEvent e) {
        new AnnotationExporter(this.alignPanel).exportFeatures();
    }

    @Override
    public void exportAnnotations_actionPerformed(ActionEvent e) {
        new AnnotationExporter(this.alignPanel).exportAnnotations();
    }

    @Override
    public void associatedData_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        String tooltip = MessageManager.getString("label.load_jalview_annotations");
        chooser.setDialogTitle(tooltip);
        chooser.setToolTipText(tooltip);
        chooser.setResponseHandler(0, () -> {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", choice);
            this.loadJalviewDataFile(chooser.getSelectedFile(), null, null, null);
        });
        chooser.showOpenDialog(this);
    }

    @Override
    public void closeMenuItem_actionPerformed(boolean closeAllTabs) {
        if (this.alignPanels != null && this.alignPanels.size() < 2) {
            closeAllTabs = true;
        }
        Desktop.closeModal(this);
        try {
            if (this.alignPanels != null) {
                if (closeAllTabs) {
                    if (this.isClosed()) {
                        for (int i = 0; i < this.alignPanels.size(); ++i) {
                            AlignmentPanel ap = this.alignPanels.get(i);
                            ap.closePanel();
                        }
                    }
                } else {
                    this.closeView(this.alignPanel);
                }
            }
            if (closeAllTabs) {
                if (this.featureSettings != null && this.featureSettings.isOpen()) {
                    this.featureSettings.close();
                    this.featureSettings = null;
                }
                this.setClosed(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void closeView(AlignmentPanel panelToClose) {
        int index = this.tabbedPane.getSelectedIndex();
        int closedindex = this.tabbedPane.indexOfComponent(panelToClose);
        this.alignPanels.remove(panelToClose);
        panelToClose.closePanel();
        panelToClose = null;
        this.tabbedPane.removeTabAt(closedindex);
        this.tabbedPane.validate();
        if (index > closedindex || index == this.tabbedPane.getTabCount()) {
            --index;
        }
        this.tabSelectionChanged(index);
    }

    void updateEditMenuBar() {
        CommandI command;
        if (this.viewport.getHistoryList().size() > 0) {
            this.undoMenuItem.setEnabled(true);
            command = this.viewport.getHistoryList().peek();
            this.undoMenuItem.setText(MessageManager.formatMessage("label.undo_command", command.getDescription()));
        } else {
            this.undoMenuItem.setEnabled(false);
            this.undoMenuItem.setText(MessageManager.getString("action.undo"));
        }
        if (this.viewport.getRedoList().size() > 0) {
            this.redoMenuItem.setEnabled(true);
            command = this.viewport.getRedoList().peek();
            this.redoMenuItem.setText(MessageManager.formatMessage("label.redo_command", command.getDescription()));
        } else {
            this.redoMenuItem.setEnabled(false);
            this.redoMenuItem.setText(MessageManager.getString("action.redo"));
        }
    }

    @Override
    public void addHistoryItem(CommandI command) {
        if (command.getSize() > 0) {
            this.viewport.addToHistoryList(command);
            this.viewport.clearRedoList();
            this.updateEditMenuBar();
            this.viewport.updateHiddenColumns();
        }
    }

    public AlignmentI[] getViewAlignments() {
        if (this.alignPanels != null) {
            AlignmentI[] als = new AlignmentI[this.alignPanels.size()];
            int i = 0;
            for (AlignmentPanel ap : this.alignPanels) {
                als[i++] = ap.av.getAlignment();
            }
            return als;
        }
        if (this.viewport != null) {
            return new AlignmentI[]{this.viewport.getAlignment()};
        }
        return null;
    }

    @Override
    protected void undoMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.getHistoryList().isEmpty()) {
            return;
        }
        CommandI command = this.viewport.getHistoryList().pop();
        this.viewport.addToRedoList(command);
        command.undoCommand(this.getViewAlignments());
        AlignmentViewport originalSource = this.getOriginatingSource(command);
        this.updateEditMenuBar();
        if (originalSource != null) {
            if (originalSource != this.viewport) {
                Console.warn("Implementation worry: mismatch of viewport origin for undo");
            }
            originalSource.updateHiddenColumns();
            originalSource.firePropertyChange("alignment", null, originalSource.getAlignment().getSequences());
        }
    }

    @Override
    protected void redoMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.getRedoList().size() < 1) {
            return;
        }
        CommandI command = this.viewport.getRedoList().pop();
        this.viewport.addToHistoryList(command);
        command.doCommand(this.getViewAlignments());
        AlignmentViewport originalSource = this.getOriginatingSource(command);
        this.updateEditMenuBar();
        if (originalSource != null) {
            if (originalSource != this.viewport) {
                Console.warn("Implementation worry: mismatch of viewport origin for redo");
            }
            originalSource.updateHiddenColumns();
            originalSource.firePropertyChange("alignment", null, originalSource.getAlignment().getSequences());
        }
    }

    AlignmentViewport getOriginatingSource(CommandI command) {
        AlignViewport originalSource = null;
        AlignmentI al = null;
        if (command instanceof EditCommand) {
            EditCommand editCommand = (EditCommand)command;
            al = editCommand.getAlignment();
            List<Component> comps = PaintRefresher.components.get(this.viewport.getSequenceSetId());
            for (Component comp : comps) {
                if (!(comp instanceof AlignmentPanel) || al != ((AlignmentPanel)comp).av.getAlignment()) continue;
                originalSource = ((AlignmentPanel)comp).av;
                break;
            }
        }
        if (originalSource == null) {
            if (al != null) {
                PaintRefresher.validateSequences(al, this.viewport.getAlignment());
            }
            originalSource = this.viewport;
        }
        return originalSource;
    }

    public void moveSelectedSequences(boolean up) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            if (this.viewport.cursorMode) {
                sg = new SequenceGroup();
                sg.addSequence(this.viewport.getAlignment().getSequenceAt(this.alignPanel.getSeqPanel().seqCanvas.cursorY), false);
            } else {
                return;
            }
        }
        if (sg.getSize() < 1) {
            return;
        }
        this.viewport.getAlignment().moveSelectedSequencesByOne(sg, this.viewport.getHiddenRepSequences(), up);
        this.alignPanel.paintAlignment(true, false);
    }

    synchronized void slideSequences(boolean right, int size) {
        boolean inSplitFrame;
        List<Object> sg = new ArrayList<SequenceI>();
        if (this.viewport.cursorMode) {
            sg.add(this.viewport.getAlignment().getSequenceAt(this.alignPanel.getSeqPanel().seqCanvas.cursorY));
        } else if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() != this.viewport.getAlignment().getHeight()) {
            sg = this.viewport.getSelectionGroup().getSequences(this.viewport.getHiddenRepSequences());
        }
        if (sg.size() < 1) {
            return;
        }
        ArrayList<SequenceI> invertGroup = new ArrayList<SequenceI>();
        for (SequenceI seq : this.viewport.getAlignment().getSequences()) {
            if (sg.contains(seq)) continue;
            invertGroup.add(seq);
        }
        SequenceI[] seqs1 = sg.toArray(new SequenceI[0]);
        SequenceI[] seqs2 = new SequenceI[invertGroup.size()];
        for (int i = 0; i < invertGroup.size(); ++i) {
            seqs2[i] = (SequenceI)invertGroup.get(i);
        }
        SlideSequencesCommand ssc = right ? new SlideSequencesCommand("Slide Sequences", seqs2, seqs1, size, this.viewport.getGapCharacter()) : new SlideSequencesCommand("Slide Sequences", seqs1, seqs2, size, this.viewport.getGapCharacter());
        int groupAdjustment = 0;
        if (ssc.getGapsInsertedBegin() && right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.getSeqPanel().moveCursor(size, 0);
            } else {
                groupAdjustment = size;
            }
        } else if (!ssc.getGapsInsertedBegin() && !right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.getSeqPanel().moveCursor(-size, 0);
            } else {
                groupAdjustment = -size;
            }
        }
        if (groupAdjustment != 0) {
            this.viewport.getSelectionGroup().setStartRes(this.viewport.getSelectionGroup().getStartRes() + groupAdjustment);
            this.viewport.getSelectionGroup().setEndRes(this.viewport.getSelectionGroup().getEndRes() + groupAdjustment);
        }
        boolean appendHistoryItem = false;
        Deque<CommandI> historyList = this.viewport.getHistoryList();
        boolean bl = inSplitFrame = this.getSplitViewContainer() != null;
        if (!inSplitFrame && historyList != null && historyList.size() > 0 && historyList.peek() instanceof SlideSequencesCommand) {
            appendHistoryItem = ssc.appendSlideCommand((SlideSequencesCommand)historyList.peek());
        }
        if (!appendHistoryItem) {
            this.addHistoryItem(ssc);
        }
        this.repaint();
    }

    @Override
    protected void copy_actionPerformed() {
        if (this.viewport.getSelectionGroup() == null) {
            return;
        }
        SequenceI[] seqs = this.viewport.getSelectionAsNewSequence();
        String[] omitHidden = null;
        if (this.viewport.hasHiddenColumns()) {
            omitHidden = this.viewport.getViewAsString(true);
        }
        String output = new FormatAdapter().formatSequences((FileFormatI)FileFormat.Fasta, seqs, omitHidden, null);
        StringSelection ss = new StringSelection(output);
        try {
            Desktop.internalCopy = true;
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(""), null);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, Desktop.instance);
        }
        catch (OutOfMemoryError er) {
            new OOMWarning("copying region", er);
            return;
        }
        HiddenColumns hiddenColumns = null;
        if (this.viewport.hasHiddenColumns()) {
            int hiddenOffset = this.viewport.getSelectionGroup().getStartRes();
            int hiddenCutoff = this.viewport.getSelectionGroup().getEndRes();
            hiddenColumns = new HiddenColumns(this.viewport.getAlignment().getHiddenColumns(), hiddenOffset, hiddenCutoff, hiddenOffset);
        }
        Desktop.jalviewClipboard = new Object[]{seqs, this.viewport.getAlignment().getDataset(), hiddenColumns};
        this.setStatus(MessageManager.formatMessage("label.copied_sequences_to_clipboard", Integer.valueOf(seqs.length).toString()));
    }

    @Override
    protected void pasteNew_actionPerformed(ActionEvent e) {
        this.paste(true);
    }

    @Override
    protected void pasteThis_actionPerformed(ActionEvent e) {
        this.paste(false);
    }

    void paste(boolean newAlignment) {
        boolean externalPaste = true;
        try {
            SequenceI[] sequences;
            FileFormatI format;
            String str;
            Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = c.getContents(this);
            if (contents == null) {
                return;
            }
            try {
                str = (String)contents.getTransferData(DataFlavor.stringFlavor);
                if (str.length() < 1) {
                    return;
                }
                format = new IdentifyFile().identify(str, DataSourceType.PASTE);
            }
            catch (OutOfMemoryError er) {
                new OOMWarning("Out of memory pasting sequences!!", er);
                return;
            }
            boolean annotationAdded = false;
            AlignmentI alignment = null;
            if (Desktop.jalviewClipboard != null) {
                SequenceI[] newseq = (SequenceI[])Desktop.jalviewClipboard[0];
                sequences = new SequenceI[newseq.length];
                for (int i = 0; i < newseq.length; ++i) {
                    sequences[i] = new Sequence(newseq[i]);
                }
                alignment = new Alignment(sequences);
                externalPaste = false;
            } else {
                alignment = new FormatAdapter().readFile(str, DataSourceType.PASTE, format);
                sequences = alignment.getSequencesArray();
            }
            int alwidth = 0;
            ArrayList<Integer> newGraphGroups = new ArrayList<Integer>();
            int fgroup = -1;
            if (newAlignment) {
                if (Desktop.jalviewClipboard != null) {
                    alignment.setDataset((Alignment)Desktop.jalviewClipboard[1]);
                } else {
                    alignment.setDataset(null);
                }
                alwidth = alignment.getWidth() + 1;
            } else {
                AlignmentI pastedal = alignment;
                alignment = this.viewport.getAlignment();
                alwidth = alignment.getWidth() + 1;
                boolean importDs = Desktop.jalviewClipboard != null && Desktop.jalviewClipboard[1] != alignment.getDataset();
                Vector<SequenceI> newDs = importDs ? new Vector<SequenceI>() : null;
                for (int i = 0; i < sequences.length; ++i) {
                    if (importDs) {
                        newDs.addElement(null);
                    }
                    SequenceI ds = sequences[i].getDatasetSequence();
                    if (importDs && ds != null) {
                        if (!newDs.contains(ds)) {
                            newDs.setElementAt(ds, i);
                            ds = new Sequence(ds);
                            sequences[i].setDatasetSequence(ds);
                        } else {
                            ds = sequences[newDs.indexOf(ds)].getDatasetSequence();
                        }
                    } else {
                        sequences[i] = sequences[i].deriveSequence();
                        alignment.getDataset().addSequence(sequences[i].getDatasetSequence());
                    }
                    alignment.addSequence(sequences[i]);
                }
                if (newDs != null) {
                    newDs.clear();
                }
                if (alignment.getAlignmentAnnotation() != null) {
                    for (AlignmentAnnotation alan : alignment.getAlignmentAnnotation()) {
                        if (alan.graphGroup <= fgroup) continue;
                        fgroup = alan.graphGroup;
                    }
                }
                if (pastedal.getAlignmentAnnotation() != null) {
                    AlignmentAnnotation[] alann = pastedal.getAlignmentAnnotation();
                    for (int i = 0; i < alann.length; ++i) {
                        annotationAdded = true;
                        if (alann[i].sequenceRef != null || alann[i].autoCalculated) continue;
                        AlignmentAnnotation newann = new AlignmentAnnotation(alann[i]);
                        if (newann.graphGroup > -1) {
                            if (newGraphGroups.size() <= newann.graphGroup || newGraphGroups.get(newann.graphGroup) == null) {
                                for (int q = newGraphGroups.size(); q <= newann.graphGroup; ++q) {
                                    newGraphGroups.add(q, null);
                                }
                                newGraphGroups.set(newann.graphGroup, ++fgroup);
                            }
                            newann.graphGroup = (Integer)newGraphGroups.get(newann.graphGroup);
                        }
                        newann.padAnnotation(alwidth);
                        alignment.addAnnotation(newann);
                    }
                }
            }
            if (!newAlignment) {
                this.addHistoryItem(new EditCommand(MessageManager.getString("label.add_sequences"), EditCommand.Action.PASTE, sequences, 0, alignment.getWidth(), alignment));
            }
            for (int i = 0; i < sequences.length; ++i) {
                if (sequences[i].getAnnotation() == null) continue;
                for (int a = 0; a < sequences[i].getAnnotation().length; ++a) {
                    annotationAdded = true;
                    AlignmentAnnotation newann = sequences[i].getAnnotation()[a];
                    newann.adjustForAlignment();
                    newann.padAnnotation(alwidth);
                    if (newann.graphGroup > -1 && newann.graphGroup > -1) {
                        if (newGraphGroups.size() <= newann.graphGroup || newGraphGroups.get(newann.graphGroup) == null) {
                            for (int q = newGraphGroups.size(); q <= newann.graphGroup; ++q) {
                                newGraphGroups.add(q, null);
                            }
                            newGraphGroups.set(newann.graphGroup, ++fgroup);
                        }
                        newann.graphGroup = (Integer)newGraphGroups.get(newann.graphGroup);
                    }
                    alignment.addAnnotation(sequences[i].getAnnotation()[a]);
                    ContactMatrixI cm = sequences[i].getContactMatrixFor(sequences[i].getAnnotation()[a]);
                    if (cm != null) {
                        alignment.addContactListFor(sequences[i].getAnnotation()[a], cm);
                    }
                    alignment.setAnnotationIndex(sequences[i].getAnnotation()[a], a);
                }
            }
            if (!newAlignment) {
                this.viewport.getRanges().setEndSeq(alignment.getHeight() - 1);
                if (annotationAdded) {
                    AlignmentI[] alview = this.getViewAlignments();
                    for (int i = 0; i < sequences.length; ++i) {
                        AlignmentAnnotation[] sann = sequences[i].getAnnotation();
                        if (sann == null) continue;
                        for (int avnum = 0; avnum < alview.length; ++avnum) {
                            if (alview[avnum] == alignment) continue;
                            int avwidth = alview[avnum].getWidth() + 1;
                            for (int a = 0; a < sann.length; ++a) {
                                AlignmentAnnotation newann = new AlignmentAnnotation(sann[a]);
                                sequences[i].addAlignmentAnnotation(newann);
                                newann.padAnnotation(avwidth);
                                alview[avnum].addAnnotation(newann);
                                alview[avnum].setAnnotationIndex(newann, a);
                            }
                        }
                    }
                    this.buildSortByAnnotationScoresMenu();
                }
                this.viewport.firePropertyChange("alignment", null, alignment.getSequences());
                if (this.alignPanels != null) {
                    for (AlignmentPanel ap : this.alignPanels) {
                        ap.validateAnnotationDimensions(false);
                    }
                } else {
                    this.alignPanel.validateAnnotationDimensions(false);
                }
            } else {
                AlignFrame af = new AlignFrame(alignment, 700, 500);
                String newtitle = new String("Copied sequences");
                if (Desktop.jalviewClipboard != null && Desktop.jalviewClipboard[2] != null) {
                    HiddenColumns hc = (HiddenColumns)Desktop.jalviewClipboard[2];
                    af.viewport.setHiddenColumns(hc);
                }
                af.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer().transferSettings(this.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer());
                newtitle = !externalPaste ? (this.title.startsWith("Copied sequences") ? this.title : newtitle.concat("- from " + this.title)) : new String("Pasted sequences");
                Desktop.addInternalFrame(af, newtitle, 700, 500);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Console.outPrintln("Exception whilst pasting: " + ex);
        }
    }

    @Override
    protected void expand_newalign(ActionEvent e) {
        try {
            AlignmentI alignment = AlignmentUtils.expandContext(this.getViewport().getAlignment(), -1);
            AlignFrame af = new AlignFrame(alignment, 700, 500);
            String newtitle = new String("Flanking alignment");
            if (Desktop.jalviewClipboard != null && Desktop.jalviewClipboard[2] != null) {
                HiddenColumns hc = (HiddenColumns)Desktop.jalviewClipboard[2];
                af.viewport.setHiddenColumns(hc);
            }
            af.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer().transferSettings(this.alignPanel.getSeqPanel().seqCanvas.getFeatureRenderer());
            newtitle = this.title.startsWith("Copied sequences") ? this.title : newtitle.concat("- from " + this.title);
            Desktop.addInternalFrame(af, newtitle, 700, 500);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Console.outPrintln("Exception whilst pasting: " + ex);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("Viewing flanking region of alignment", oom);
        }
    }

    @Override
    protected void cut_actionPerformed() {
        this.copy_actionPerformed();
        this.delete_actionPerformed();
    }

    @Override
    protected void delete_actionPerformed() {
        boolean wholeWidth;
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            return;
        }
        Runnable okAction = () -> {
            SequenceI[] cut = sg.getSequences().toArray(new SequenceI[sg.getSize()]);
            this.addHistoryItem(new EditCommand(MessageManager.getString("label.cut_sequences"), EditCommand.Action.CUT, cut, sg.getStartRes(), sg.getEndRes() - sg.getStartRes() + 1, this.viewport.getAlignment()));
            this.viewport.setSelectionGroup(null);
            this.viewport.sendSelection();
            this.viewport.getAlignment().deleteGroup(sg);
            this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
            if (this.viewport.getAlignment().getHeight() < 1) {
                try {
                    this.setClosed(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        boolean wholeHeight = sg.getSize() == this.viewport.getAlignment().getHeight();
        boolean bl = wholeWidth = sg.getEndRes() - sg.getStartRes() + 1 == this.viewport.getAlignment().getWidth();
        if (wholeHeight && wholeWidth) {
            JvOptionPane dialog = JvOptionPane.newOptionDialog(Desktop.desktop);
            dialog.setResponseHandler(0, okAction);
            Object[] options = new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")};
            dialog.showDialog(MessageManager.getString("warn.delete_all"), MessageManager.getString("label.delete_all"), -1, -1, null, options, options[0]);
        } else {
            try {
                okAction.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void deleteGroups_actionPerformed(ActionEvent e) {
        if (this.avc.deleteGroups()) {
            PaintRefresher.Refresh(this, this.viewport.getSequenceSetId());
            this.alignPanel.updateAnnotation();
            this.alignPanel.paintAlignment(true, true);
        }
    }

    @Override
    public void selectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
        SequenceGroup sg = new SequenceGroup(this.viewport.getAlignment().getSequences());
        sg.setEndRes(this.viewport.getAlignment().getWidth() - 1);
        this.viewport.setSelectionGroup(sg);
        this.viewport.isSelectionGroupChanged(true);
        this.viewport.sendSelection();
        this.alignPanel.paintAlignment(false, false);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
    }

    @Override
    public void deselectAllSequenceMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.cursorMode) {
            this.alignPanel.getSeqPanel().keyboardNo1 = null;
            this.alignPanel.getSeqPanel().keyboardNo2 = null;
        }
        this.viewport.setSelectionGroup(null);
        this.viewport.getColumnSelection().clear();
        this.viewport.setSearchResults(null);
        this.alignPanel.getIdPanel().getIdCanvas().searchResults = null;
        this.alignPanel.paintAlignment(false, false);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
        this.viewport.sendSelection();
    }

    @Override
    public void invertSequenceMenuItem_actionPerformed(ActionEvent e) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            this.selectAllSequenceMenuItem_actionPerformed(null);
            return;
        }
        for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
            sg.addOrRemove(this.viewport.getAlignment().getSequenceAt(i), false);
        }
        this.alignPanel.paintAlignment(true, false);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
        this.viewport.sendSelection();
    }

    @Override
    public void invertColSel_actionPerformed(ActionEvent e) {
        this.viewport.invertColumnSelection();
        this.alignPanel.paintAlignment(true, false);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
        this.viewport.sendSelection();
    }

    @Override
    public void remove2LeftMenuItem_actionPerformed(ActionEvent e) {
        this.trimAlignment(true);
    }

    @Override
    public void remove2RightMenuItem_actionPerformed(ActionEvent e) {
        this.trimAlignment(false);
    }

    void trimAlignment(boolean trimLeft) {
        ColumnSelection colSel = this.viewport.getColumnSelection();
        if (!colSel.isEmpty()) {
            TrimRegionCommand trimRegion;
            int column = trimLeft ? colSel.getMin() : colSel.getMax();
            SequenceI[] seqs = this.viewport.getSelectionGroup() != null ? this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.getHiddenRepSequences()) : this.viewport.getAlignment().getSequencesArray();
            if (trimLeft) {
                trimRegion = new TrimRegionCommand("Remove Left", true, seqs, column, this.viewport.getAlignment());
                this.viewport.getRanges().setStartRes(0);
            } else {
                trimRegion = new TrimRegionCommand("Remove Right", false, seqs, column, this.viewport.getAlignment());
            }
            this.setStatus(MessageManager.formatMessage("label.removed_columns", new String[]{Integer.valueOf(trimRegion.getSize()).toString()}));
            this.addHistoryItem(trimRegion);
            for (SequenceGroup sg : this.viewport.getAlignment().getGroups()) {
                if ((!trimLeft || sg.adjustForRemoveLeft(column)) && (trimLeft || sg.adjustForRemoveRight(column))) continue;
                this.viewport.getAlignment().deleteGroup(sg);
            }
            this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        }
    }

    @Override
    public void removeGappedColumnMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] seqs;
        int start = 0;
        int end = this.viewport.getAlignment().getWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.getHiddenRepSequences());
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.getAlignment().getSequencesArray();
        }
        RemoveGapColCommand removeGapCols = new RemoveGapColCommand("Remove Gapped Columns", seqs, start, end, this.viewport.getAlignment());
        this.addHistoryItem(removeGapCols);
        this.setStatus(MessageManager.formatMessage("label.removed_empty_columns", Integer.valueOf(removeGapCols.getSize()).toString()));
        SequenceI seq = this.viewport.getAlignment().getSequenceAt(0);
        ViewportRanges ranges = this.viewport.getRanges();
        int startRes = seq.findPosition(ranges.getStartRes());
        ranges.setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    @Override
    public void removeAllGapsMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] seqs;
        int start = 0;
        int end = this.viewport.getAlignment().getWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.getHiddenRepSequences());
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.getAlignment().getSequencesArray();
        }
        SequenceI seq = this.viewport.getAlignment().getSequenceAt(0);
        int startRes = seq.findPosition(this.viewport.getRanges().getStartRes());
        this.addHistoryItem(new RemoveGapsCommand("Remove Gaps", seqs, start, end, this.viewport.getAlignment()));
        this.viewport.getRanges().setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    @Override
    public void padGapsMenuitem_actionPerformed(ActionEvent e) {
        this.viewport.setPadGaps(this.padGapsMenuitem.isSelected());
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    @Override
    public void findMenuItem_actionPerformed(ActionEvent e) {
        new Finder(this.alignPanel, false, null);
    }

    @Override
    public void newView_actionPerformed(ActionEvent e) {
        this.newView(null, true);
    }

    public AlignmentPanel newView(String viewTitle, boolean copyAnnotation) {
        AlignmentPanel newap = new Jalview2XML().copyAlignPanel(this.alignPanel);
        if (!copyAnnotation) {
            newap.av.getAlignment().deleteAllGroups();
            newap.av.getAlignment().deleteAllAnnotations(false);
        }
        newap.av.setGatherViewsHere(false);
        if (this.viewport.getViewName() == null) {
            this.viewport.setViewName(MessageManager.getString("label.view_name_original"));
        }
        newap.av.setHistoryList(this.viewport.getHistoryList());
        newap.av.setRedoList(this.viewport.getRedoList());
        newap.av.setColourAppliesToAllGroups(this.viewport.getColourAppliesToAllGroups());
        newap.av.replaceMappings(this.viewport.getAlignment());
        if (newap.av.initComplementConsensus()) {
            newap.refresh(true);
        }
        newap.av.setViewName(this.getNewViewName(viewTitle));
        this.addAlignmentPanel(newap, true);
        newap.alignmentChanged();
        if (this.alignPanels.size() == 2) {
            this.viewport.setGatherViewsHere(true);
        }
        this.tabbedPane.setSelectedIndex(this.tabbedPane.getTabCount() - 1);
        return newap;
    }

    protected String getNewViewName(String viewTitle) {
        int index = Desktop.getViewCount(this.viewport.getSequenceSetId());
        boolean addFirstIndex = false;
        if (viewTitle == null || viewTitle.trim().length() == 0) {
            viewTitle = MessageManager.getString("action.view");
            addFirstIndex = true;
        } else {
            index = 1;
        }
        String newViewName = viewTitle + (String)(addFirstIndex ? " " + index : "");
        List<Component> comps = PaintRefresher.components.get(this.viewport.getSequenceSetId());
        List<String> existingNames = this.getExistingViewNames(comps);
        while (existingNames.contains(newViewName)) {
            newViewName = viewTitle + " " + ++index;
        }
        return newViewName;
    }

    protected List<String> getExistingViewNames(List<Component> comps) {
        ArrayList<String> existingNames = new ArrayList<String>();
        for (Component comp : comps) {
            if (!(comp instanceof AlignmentPanel)) continue;
            AlignmentPanel ap = (AlignmentPanel)comp;
            if (existingNames.contains(ap.av.getViewName())) continue;
            existingNames.add(ap.av.getViewName());
        }
        return existingNames;
    }

    @Override
    public void expandViews_actionPerformed(ActionEvent e) {
        Desktop.explodeViews(this);
    }

    @Override
    public void gatherViews_actionPerformed(ActionEvent e) {
        Desktop.instance.gatherViews(this);
    }

    @Override
    public void font_actionPerformed(ActionEvent e) {
        new FontChooser(this.alignPanel);
    }

    @Override
    protected void seqLimit_actionPerformed(ActionEvent e) {
        this.viewport.setShowJVSuffix(this.seqLimits.isSelected());
        this.alignPanel.getIdPanel().getIdCanvas().setPreferredSize(this.alignPanel.calculateIdWidth());
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    public void idRightAlign_actionPerformed(ActionEvent e) {
        this.viewport.setRightAlignIds(this.idRightAlign.isSelected());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    public void centreColumnLabels_actionPerformed(ActionEvent e) {
        this.viewport.setCentreColumnLabels(this.centreColumnLabelsMenuItem.getState());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    protected void followHighlight_actionPerformed() {
        boolean state = this.followHighlightMenuItem.getState();
        this.viewport.setFollowHighlight(state);
        if (state) {
            this.alignPanel.scrollToPosition(this.viewport.getSearchResults());
        }
    }

    @Override
    protected void colourTextMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setColourText(this.colourTextMenuItem.isSelected());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    public void wrapMenuItem_actionPerformed(ActionEvent e) {
        this.setWrapFormat(this.wrapMenuItem.isSelected(), false);
    }

    public void setWrapFormat(boolean b, boolean setMenuItem) {
        this.scaleAbove.setVisible(b);
        this.scaleLeft.setVisible(b);
        this.scaleRight.setVisible(b);
        this.viewport.setWrapAlignment(b);
        this.alignPanel.updateLayout();
        if (setMenuItem) {
            this.wrapMenuItem.setSelected(b);
        }
    }

    @Override
    public void showAllSeqs_actionPerformed(ActionEvent e) {
        this.viewport.showAllHiddenSeqs();
    }

    @Override
    public void showAllColumns_actionPerformed(ActionEvent e) {
        this.viewport.showAllHiddenColumns();
        this.alignPanel.paintAlignment(true, true);
        this.viewport.sendSelection();
    }

    @Override
    public void hideSelSequences_actionPerformed(ActionEvent e) {
        this.viewport.hideAllSelectedSeqs();
    }

    protected void toggleHiddenRegions(boolean toggleSeqs, boolean toggleCols) {
        boolean hide = false;
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (!toggleSeqs && !toggleCols && (this.viewport.hasSelectedColumns() || sg != null && sg.getSize() > 0 && sg.getStartRes() <= sg.getEndRes())) {
            if (sg != null) {
                this.invertSequenceMenuItem_actionPerformed(null);
                sg = this.viewport.getSelectionGroup();
                toggleSeqs = true;
            }
            this.viewport.expandColSelection(sg, true);
            this.invertColSel_actionPerformed(null);
            toggleCols = true;
        }
        if (toggleSeqs) {
            if (sg != null && sg.getSize() != this.viewport.getAlignment().getHeight()) {
                this.hideSelSequences_actionPerformed(null);
                hide = true;
            } else if (!toggleCols || !this.viewport.hasSelectedColumns()) {
                this.showAllSeqs_actionPerformed(null);
            }
        }
        if (toggleCols) {
            if (this.viewport.hasSelectedColumns()) {
                this.hideSelColumns_actionPerformed(null);
                if (!toggleSeqs) {
                    this.viewport.setSelectionGroup(sg);
                }
            } else if (!hide) {
                this.showAllColumns_actionPerformed(null);
            }
        }
    }

    @Override
    public void hideAllButSelection_actionPerformed(ActionEvent e) {
        this.toggleHiddenRegions(false, false);
        this.viewport.sendSelection();
    }

    @Override
    public void hideAllSelection_actionPerformed(ActionEvent e) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        this.viewport.expandColSelection(sg, false);
        this.viewport.hideAllSelectedSeqs();
        this.viewport.hideSelectedColumns();
        this.alignPanel.updateLayout();
        this.alignPanel.paintAlignment(true, true);
        this.viewport.sendSelection();
    }

    @Override
    public void showAllhidden_actionPerformed(ActionEvent e) {
        this.viewport.showAllHiddenColumns();
        this.viewport.showAllHiddenSeqs();
        this.alignPanel.paintAlignment(true, true);
        this.viewport.sendSelection();
    }

    @Override
    public void hideSelColumns_actionPerformed(ActionEvent e) {
        this.viewport.hideSelectedColumns();
        this.alignPanel.updateLayout();
        this.alignPanel.paintAlignment(true, true);
        this.viewport.sendSelection();
    }

    @Override
    public void hiddenMarkers_actionPerformed(ActionEvent e) {
        this.viewport.setShowHiddenMarkers(this.hiddenMarkers.isSelected());
        this.repaint();
    }

    @Override
    protected void scaleAbove_actionPerformed(ActionEvent e) {
        this.viewport.setScaleAboveWrapped(this.scaleAbove.isSelected());
        this.alignPanel.updateLayout();
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    protected void scaleLeft_actionPerformed(ActionEvent e) {
        this.viewport.setScaleLeftWrapped(this.scaleLeft.isSelected());
        this.alignPanel.updateLayout();
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    protected void scaleRight_actionPerformed(ActionEvent e) {
        this.viewport.setScaleRightWrapped(this.scaleRight.isSelected());
        this.alignPanel.updateLayout();
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    public void viewBoxesMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setShowBoxes(this.viewBoxesMenuItem.isSelected());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    public void viewTextMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setShowText(this.viewTextMenuItem.isSelected());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    protected void renderGapsMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setRenderGaps(this.renderGapsMenuItem.isSelected());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    public FeatureSettingsControllerI getFeatureSettingsUI() {
        return this.featureSettings;
    }

    @Override
    public void featureSettings_actionPerformed(ActionEvent e) {
        this.showFeatureSettingsUI();
    }

    @Override
    public FeatureSettingsControllerI showFeatureSettingsUI() {
        if (this.featureSettings != null) {
            this.featureSettings.closeOldSettings();
            this.featureSettings = null;
        }
        if (!this.showSeqFeatures.isSelected()) {
            this.showSeqFeatures.setSelected(true);
            this.showSeqFeatures_actionPerformed(null);
        }
        this.featureSettings = new FeatureSettings(this);
        return this.featureSettings;
    }

    @Override
    public void showSeqFeatures_actionPerformed(ActionEvent evt) {
        this.viewport.setShowSequenceFeatures(this.showSeqFeatures.isSelected());
        this.alignPanel.paintAlignment(true, true);
    }

    @Override
    public void annotationPanelMenuItem_actionPerformed(ActionEvent e) {
        boolean setVisible = this.annotationPanelMenuItem.isSelected();
        this.viewport.setShowAnnotation(setVisible);
        this.showAllSeqAnnotations.setEnabled(setVisible);
        this.hideAllSeqAnnotations.setEnabled(setVisible);
        this.showAllAlAnnotations.setEnabled(setVisible);
        this.hideAllAlAnnotations.setEnabled(setVisible);
        this.alignPanel.updateLayout();
    }

    @Override
    public void alignmentProperties() {
        JComponent pane;
        StringBuffer contents = new AlignmentProperties(this.viewport.getAlignment()).formatAsHtml();
        String content = MessageManager.formatMessage("label.html_content", contents.toString());
        contents = null;
        if (Platform.isJS()) {
            JLabel textLabel = new JLabel();
            textLabel.setText(content);
            textLabel.setBackground(Color.WHITE);
            pane = new JPanel(new BorderLayout());
            ((JPanel)pane).setOpaque(true);
            pane.setBackground(Color.WHITE);
            ((JPanel)pane).add((Component)textLabel, "North");
        } else {
            JEditorPane editPane = new JEditorPane("text/html", "");
            editPane.setEditable(false);
            editPane.setText(content);
            pane = editPane;
        }
        JInternalFrame frame = new JInternalFrame();
        frame.setFrameIcon(null);
        frame.getContentPane().add(new JScrollPane(pane));
        Desktop.addInternalFrame(frame, MessageManager.formatMessage("label.alignment_properties", this.getTitle()), 500, 400);
    }

    @Override
    public void overviewMenuItem_actionPerformed(ActionEvent e) {
        boolean showHiddenRegions = Cache.getDefault("SHOW_OV_HIDDEN_AT_START", false);
        this.openOverviewPanel(showHiddenRegions);
    }

    public OverviewPanel openOverviewPanel(boolean showHidden) {
        if (this.alignPanel.overviewPanel != null) {
            return this.alignPanel.overviewPanel;
        }
        JInternalFrame frame = new JInternalFrame();
        frame.setFrameIcon(null);
        final OverviewPanel overview = new OverviewPanel(this.alignPanel, frame, showHidden);
        frame.setContentPane(overview);
        this.alignPanel.setOverviewPanel(overview);
        this.alignPanel.setOverviewTitle(this);
        Desktop.addInternalFrame(frame, overview.getTitle(), true, frame.getWidth(), frame.getHeight(), true, true);
        frame.pack();
        frame.setLayer(JLayeredPane.PALETTE_LAYER);
        final AlignmentPanel thePanel = this.alignPanel;
        frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                overview.dispose();
                thePanel.setOverviewPanel(null);
            }
        });
        if (this.getKeyListeners().length > 0) {
            frame.addKeyListener(this.getKeyListeners()[0]);
        }
        return overview;
    }

    @Override
    public void textColour_actionPerformed() {
        new TextColourChooser().chooseColour(this.alignPanel, null);
    }

    @Override
    public void annotationColour_actionPerformed() {
        new AnnotationColourChooser(this.viewport, this.alignPanel);
    }

    @Override
    public void annotationColumn_actionPerformed(ActionEvent e) {
        new AnnotationColumnChooser(this.viewport, this.alignPanel);
    }

    @Override
    public void applyToAllGroups_actionPerformed(boolean selected) {
        this.viewport.setColourAppliesToAllGroups(selected);
    }

    @Override
    public void changeColour_actionPerformed(String name) {
        if ("*User Defined*".equals(name)) {
            new UserDefinedColours(this.alignPanel);
            return;
        }
        ColourSchemeI cs = ColourSchemes.getInstance().getColourScheme(name, this.viewport, this.viewport.getAlignment(), this.viewport.getHiddenRepSequences());
        this.changeColour(cs);
    }

    @Override
    public void changeColour(ColourSchemeI cs) {
        ColourMenuHelper.setColourSelected(this.colourMenu, cs);
        this.viewport.setGlobalColourScheme(cs);
        this.alignPanel.paintAlignment(true, true);
    }

    @Override
    protected void modifyPID_actionPerformed() {
        SliderPanel.setPIDSliderSource(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
        SliderPanel.showPIDSlider();
    }

    @Override
    protected void modifyConservation_actionPerformed() {
        SliderPanel.setConservationSlider(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
        SliderPanel.showConservationSlider();
    }

    @Override
    protected void modifyConsensusSecondaryStructureThreshold_actionPerformed() {
        SliderPanel.setConsensusSecondaryStructureSlider(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
        SliderPanel.showConsensusSecondaryStructureSlider();
    }

    @Override
    public void conservationMenuItem_actionPerformed(boolean selected) {
        this.modifyConservation.setEnabled(selected);
        this.viewport.setConservationSelected(selected);
        this.viewport.getResidueShading().setConservationApplied(selected);
        this.changeColour(this.viewport.getGlobalColourScheme());
        if (selected) {
            this.modifyConservation_actionPerformed();
        } else {
            SliderPanel.hideConservationSlider();
        }
    }

    @Override
    public void colourByConsensusSecondaryStructureMenuItem_actionPerformed(boolean selected) {
        this.modifyConsensusSecondaryStructureThreshold.setEnabled(selected);
        this.viewport.setByConsensusSecondaryStructureSelected(selected);
        this.viewport.getResidueShading().setConsensusSecondaryStructureColouring(selected);
        this.changeColour(this.viewport.getGlobalColourScheme());
        if (selected) {
            this.modifyConsensusSecondaryStructureThreshold_actionPerformed();
        } else {
            SliderPanel.hideConsensusSecondaryStructureSlider();
        }
    }

    @Override
    public void abovePIDThreshold_actionPerformed(boolean selected) {
        this.modifyPID.setEnabled(selected);
        this.viewport.setAbovePIDThreshold(selected);
        if (!selected) {
            this.viewport.getResidueShading().setThreshold(0, this.viewport.isIgnoreGapsConsensus());
        }
        this.changeColour(this.viewport.getGlobalColourScheme());
        if (selected) {
            this.modifyPID_actionPerformed();
        } else {
            SliderPanel.hidePIDSlider();
        }
    }

    @Override
    public void sortPairwiseMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByPID(this.viewport.getAlignment(), this.viewport.getAlignment().getSequenceAt(0));
        this.addHistoryItem(new OrderCommand("Pairwise Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    public void sortIDMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByID(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("ID Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    protected void sortDescriptionMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByDescription(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("Description Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    public void sortLengthMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByLength(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("Length Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    public void sortGroupMenuItem_actionPerformed(ActionEvent e) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByGroup(this.viewport.getAlignment());
        this.addHistoryItem(new OrderCommand("Group Sort", oldOrder, this.viewport.getAlignment()));
        this.alignPanel.paintAlignment(true, false);
    }

    @Override
    public void removeRedundancyMenuItem_actionPerformed(ActionEvent e) {
        new RedundancyPanel(this.alignPanel, this);
    }

    @Override
    public void pairwiseAlignmentMenuItem_actionPerformed(ActionEvent e) {
        if (this.viewport.getSelectionGroup() == null || this.viewport.getSelectionGroup().getSize() < 2) {
            JvOptionPane.showInternalMessageDialog((Component)this, MessageManager.getString("label.you_must_select_least_two_sequences"), MessageManager.getString("label.invalid_selection"), 2);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JInternalFrame frame = new JInternalFrame();
                    frame.setFrameIcon(null);
                    frame.setContentPane(new PairwiseAlignPanel(AlignFrame.this.viewport));
                    Desktop.addInternalFrame(frame, MessageManager.getString("action.pairwise_alignment"), 600, 500);
                }
            }).start();
        }
    }

    @Override
    public void autoCalculate_actionPerformed(ActionEvent e) {
        this.viewport.autoCalculateConsensus = this.autoCalculate.isSelected();
        if (this.viewport.autoCalculateConsensus) {
            this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        }
    }

    @Override
    public void sortByTreeOption_actionPerformed(ActionEvent e) {
        this.viewport.sortByTree = this.sortByTree.isSelected();
    }

    @Override
    protected void listenToViewSelections_actionPerformed(ActionEvent e) {
        this.viewport.followSelection = this.listenToViewSelections.isSelected();
    }

    void newTreePanel(String type, String modelName, SimilarityParamsI options) {
        String frameTitle = "";
        boolean onSelection = false;
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 0) {
            SequenceGroup sg = this.viewport.getSelectionGroup();
            for (SequenceI _s : sg.getSequences()) {
                if (_s.getLength() >= sg.getEndRes()) continue;
                JvOptionPane.showMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.selected_region_to_tree_may_only_contain_residues_or_gaps"), MessageManager.getString("label.sequences_selection_not_aligned"), 2);
                return;
            }
            onSelection = true;
        } else if (this.viewport.getAlignment().getHeight() < 2) {
            return;
        }
        TreePanel tp = new TreePanel(this.alignPanel, type, modelName, options);
        frameTitle = this.formCalculationTitle(tp.getPanelTitle(), onSelection, this.title);
        Desktop.addInternalFrame(tp, frameTitle, 600, 500);
    }

    public String formCalculationTitle(String panelTitle, boolean onSelection, String title) {
        Object frameTitle = panelTitle;
        frameTitle = (String)frameTitle + (onSelection ? " on region" : "");
        frameTitle = (String)frameTitle + " from ";
        if (this.viewport.getViewName() != null) {
            frameTitle = (String)frameTitle + this.viewport.getViewName() + " of ";
        }
        frameTitle = (String)frameTitle + title;
        return frameTitle;
    }

    public void addSortByOrderMenuItem(String title, final AlignmentOrder order) {
        JMenuItem item = new JMenuItem(MessageManager.formatMessage("action.by_title_param", title));
        this.sort.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceI[] oldOrder = AlignFrame.this.viewport.getAlignment().getSequencesArray();
                AlignmentSorter.sortBy(AlignFrame.this.viewport.getAlignment(), order);
                AlignFrame.this.addHistoryItem(new OrderCommand(order.getName(), oldOrder, AlignFrame.this.viewport.getAlignment()));
                AlignFrame.this.alignPanel.paintAlignment(true, false);
            }
        });
    }

    public void addSortByAnnotScoreMenuItem(JMenu sort, final String scoreLabel) {
        JMenuItem item = new JMenuItem(scoreLabel);
        sort.add(item);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceI[] oldOrder = AlignFrame.this.viewport.getAlignment().getSequencesArray();
                AlignmentSorter.sortByAnnotationScore(scoreLabel, AlignFrame.this.viewport.getAlignment());
                AlignFrame.this.addHistoryItem(new OrderCommand("Sort by " + scoreLabel, oldOrder, AlignFrame.this.viewport.getAlignment()));
                AlignFrame.this.alignPanel.paintAlignment(true, false);
            }
        });
    }

    @Override
    public void buildSortByAnnotationScoresMenu() {
        if (this.viewport.getAlignment().getAlignmentAnnotation() == null) {
            return;
        }
        if (this.viewport.getAlignment().getAlignmentAnnotation().hashCode() != this._annotationScoreVectorHash) {
            this.sortByAnnotScore.removeAll();
            Hashtable<String, String> scoreSorts = new Hashtable<String, String>();
            for (SequenceI sqa : this.viewport.getAlignment().getSequences()) {
                AlignmentAnnotation[] aann = sqa.getAnnotation();
                for (int i = 0; aann != null && i < aann.length; ++i) {
                    if (!aann[i].hasScore() || aann[i].sequenceRef == null) continue;
                    scoreSorts.put(aann[i].label, aann[i].label);
                }
            }
            Enumeration labels = scoreSorts.keys();
            while (labels.hasMoreElements()) {
                this.addSortByAnnotScoreMenuItem(this.sortByAnnotScore, (String)labels.nextElement());
            }
            this.sortByAnnotScore.setVisible(scoreSorts.size() > 0);
            scoreSorts.clear();
            this._annotationScoreVectorHash = this.viewport.getAlignment().getAlignmentAnnotation().hashCode();
        }
    }

    @Override
    public void buildTreeSortMenu() {
        this.sortByTreeMenu.removeAll();
        List<Component> comps = PaintRefresher.components.get(this.viewport.getSequenceSetId());
        ArrayList<TreePanel> treePanels = new ArrayList<TreePanel>();
        ArrayList<TreePanel> annotTreePanels = new ArrayList<TreePanel>();
        for (Component comp : comps) {
            if (!(comp instanceof TreePanel)) continue;
            treePanels.add((TreePanel)comp);
            if (!((TreePanel)comp).isAnnotationBased()) continue;
            annotTreePanels.add((TreePanel)comp);
        }
        if (treePanels.size() < 1) {
            this.sortByTreeMenu.setVisible(false);
            return;
        }
        this.sortByTreeMenu.setVisible(true);
        for (final TreePanel tp : treePanels) {
            JMenuItem item = new JMenuItem(tp.getTitle());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tp.sortByTree_actionPerformed();
                    AlignFrame.this.addHistoryItem(tp.sortAlignmentIn(AlignFrame.this.alignPanel));
                }
            });
            this.sortByTreeMenu.add(item);
        }
    }

    @Override
    public void buildSortAnnotationByTreeMenu() {
        this.sortAnnotationByTreeMenu.removeAll();
        List<Component> comps = PaintRefresher.components.get(this.viewport.getSequenceSetId());
        ArrayList<TreePanel> annotTreePanels = new ArrayList<TreePanel>();
        for (Component comp : comps) {
            if (!(comp instanceof TreePanel) || !((TreePanel)comp).isAnnotationBased()) continue;
            annotTreePanels.add((TreePanel)comp);
        }
        if (annotTreePanels.size() < 1) {
            this.sortAnnotationByTreeMenu.setVisible(false);
            return;
        }
        this.sortAnnotationByTreeMenu.setVisible(true);
        for (final TreePanel tp : annotTreePanels) {
            JMenuItem item = new JMenuItem(tp.getTitle());
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AlignFrame.this.sortAnnByLabel.setSelected(false);
                    AlignFrame.this.sortAnnBySequence.setSelected(false);
                    AlignFrame.this.setAnnotationSortOrder(AnnotationSorter.SequenceAnnotationOrder.NONE);
                    tp.sortAnnotationByTree_actionPerformed();
                }
            });
            this.sortAnnotationByTreeMenu.add(item);
        }
    }

    public boolean sortBy(AlignmentOrder alorder, String undoname) {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortBy(this.viewport.getAlignment(), alorder);
        if (undoname != null) {
            this.addHistoryItem(new OrderCommand(undoname, oldOrder, this.viewport.getAlignment()));
        }
        this.alignPanel.paintAlignment(true, false);
        return true;
    }

    public AlignmentView gatherSequencesForAlignment() {
        AlignmentView msa = null;
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 1) {
            msa = this.viewport.getAlignmentView(true);
        } else if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() == 1) {
            int option = JvOptionPane.showConfirmDialog(this, MessageManager.getString("warn.oneseq_msainput_selection"), MessageManager.getString("label.invalid_selection"), 2);
            if (option == 0) {
                msa = this.viewport.getAlignmentView(false);
            }
        } else {
            msa = this.viewport.getAlignmentView(false);
        }
        return msa;
    }

    public AlignmentView gatherSeqOrMsaForSecStrPrediction() {
        AlignmentView seqs = null;
        seqs = this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 0 ? this.viewport.getAlignmentView(true) : this.viewport.getAlignmentView(false);
        if (!this.viewport.getAlignment().isAligned(false)) {
            seqs.setSequences(new SeqCigar[]{seqs.getSequences()[0]});
        }
        return seqs;
    }

    @Override
    protected void loadTreeMenuItem_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.select_newick_like_tree_file"));
        chooser.setToolTipText(MessageManager.getString("label.load_tree_file"));
        chooser.setResponseHandler(0, () -> {
            String filePath = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", filePath);
            NewickFile fin = null;
            try {
                fin = new NewickFile(new FileParse(chooser.getSelectedFile(), DataSourceType.FILE));
                this.viewport.setCurrentTree(this.showNewickTree(fin, filePath).getTree());
            }
            catch (Exception ex) {
                JvOptionPane.showMessageDialog((Component)Desktop.desktop, ex.getMessage(), MessageManager.getString("label.problem_reading_tree_file"), 2);
                ex.printStackTrace();
            }
            if (fin != null && fin.hasWarningMessage()) {
                JvOptionPane.showMessageDialog((Component)Desktop.desktop, fin.getWarningMessage(), MessageManager.getString("label.possible_problem_with_tree_file"), 2);
            }
        });
        chooser.showOpenDialog(this);
    }

    public TreePanel showNewickTree(NewickFile nf, String treeTitle) {
        return this.showNewickTree(nf, treeTitle, 600, 500, 4, 5);
    }

    public TreePanel showNewickTree(NewickFile nf, String treeTitle, int w, int h, int x, int y) {
        return this.showNewickTree(nf, treeTitle, null, w, h, x, y);
    }

    public TreePanel showNewickTree(NewickFile nf, String treeTitle, AlignmentView input, int w, int h, int x, int y) {
        TreePanel tp = null;
        try {
            nf.parse();
            if (nf.getTree() != null) {
                tp = new TreePanel(this.alignPanel, nf, treeTitle, input);
                AlignFrame.layoutTreePanel(tp, treeTitle, w, h, x, y);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tp;
    }

    public TreePanel showNewickTreeForAnnotation(NewickFile nf, Map<String, AlignmentAnnotation> annotationIds, String treeTitle, AlignmentView input, int w, int h, int x, int y) {
        TreePanel tp = null;
        try {
            nf.parse();
            if (nf.getTree() != null) {
                tp = TreePanel.newTreeForAnnotations(this.alignPanel, nf, annotationIds, treeTitle, input);
                AlignFrame.layoutTreePanel(tp, treeTitle, w, h, x, y);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tp;
    }

    public static void layoutTreePanel(TreePanel tp, String title, int w, int h, int x, int y) {
        tp.setSize(w, h);
        if (x > 0 && y > 0) {
            tp.setLocation(x, y);
        }
        Desktop.addInternalFrame(tp, title, w, h);
    }

    public void showContactMapTree(AlignmentAnnotation aa, ContactMatrixI cm) {
        int x = 4;
        int y = 5;
        int w = 400;
        int h = 500;
        try {
            NewickFile fin = new NewickFile(new FileParse(cm.getNewick(), DataSourceType.PASTE));
            String title = aa.label + " " + cm.getTreeMethod() + " tree" + (String)(aa.sequenceRef != null ? " for " + aa.sequenceRef.getDisplayId(false) : "");
            this.showColumnWiseTree(fin, aa, title, w, h, x, y);
        }
        catch (Throwable xx) {
            Console.error("Unexpected exception showing tree for contact matrix", xx);
        }
    }

    public TreePanel showColumnWiseTree(NewickFile nf, AlignmentAnnotation aa, String treeTitle, int w, int h, int x, int y) {
        try {
            nf.parse();
            if (nf.getTree() == null) {
                return null;
            }
            TreePanel tp = new TreePanel(this.alignPanel, nf, aa, treeTitle);
            tp.setSize(w, h);
            if (x > 0 && y > 0) {
                tp.setLocation(x, y);
            }
            tp.setLayer(JLayeredPane.PALETTE_LAYER);
            Desktop.addInternalFrame(tp, treeTitle, w, h);
            return tp;
        }
        catch (Throwable xx) {
            Console.error("Unexpected exception showing tree for contact matrix", xx);
            return null;
        }
    }

    public void BuildWebServiceMenu() {
        while (this.buildingMenu) {
            try {
                Console.errPrintln("Waiting for building menu to finish.");
                Thread.sleep(10L);
            }
            catch (Exception exception) {}
        }
        final AlignFrame me = this;
        this.buildingMenu = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                final ArrayList<JMenuItem> legacyItems = new ArrayList<JMenuItem>();
                try {
                    Vector<ServiceHandle> secstrpr;
                    final Vector<JMenu> wsmenu = new Vector<JMenu>();
                    AlignFrame af = me;
                    JMenu msawsmenu = new JMenu("Alignment");
                    JMenu secstrmenu = new JMenu("Secondary Structure Prediction");
                    JMenu seqsrchmenu = new JMenu("Sequence Database Search");
                    JMenu analymenu = new JMenu("Analysis");
                    JMenu dismenu = new JMenu("Protein Disorder");
                    if (Discoverer.services != null && Discoverer.services.size() > 0 && (secstrpr = Discoverer.services.get("SecStrPred")) != null) {
                        int j = secstrpr.size();
                        for (int i = 0; i < j; ++i) {
                            ServiceHandle sh = secstrpr.get(i);
                            WS1Client impl = Discoverer.getServiceClient(sh);
                            int p = secstrmenu.getItemCount();
                            impl.attachWSMenuEntry(secstrmenu, me);
                            int q = secstrmenu.getItemCount();
                            for (int litm = p; litm < q; ++litm) {
                                legacyItems.add(secstrmenu.getItem(litm));
                            }
                        }
                    }
                    wsmenu.add(msawsmenu);
                    wsmenu.add(secstrmenu);
                    wsmenu.add(dismenu);
                    wsmenu.add(analymenu);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AlignFrame.this.webService.removeAll();
                                if (wsmenu.size() > 0) {
                                    int j = wsmenu.size();
                                    for (int i = 0; i < j; ++i) {
                                        AlignFrame.this.webService.add((JMenuItem)wsmenu.get(i));
                                    }
                                } else {
                                    AlignFrame.this.webService.add(me.webServiceNoServices);
                                }
                                Jws2Discoverer jws2servs = Jws2Discoverer.getDiscoverer();
                                if (jws2servs != null) {
                                    if (jws2servs.hasServices()) {
                                        jws2servs.attachWSMenuEntry(AlignFrame.this.webService, me);
                                        for (Jws2Instance sv : jws2servs.getServices()) {
                                            if (!sv.description.toLowerCase(Locale.ROOT).contains("jpred")) continue;
                                            for (JMenuItem jmi : legacyItems) {
                                                jmi.setVisible(false);
                                            }
                                        }
                                    }
                                    if (jws2servs.isRunning()) {
                                        JMenuItem tm = new JMenuItem("Still discovering JABA Services");
                                        tm.setEnabled(false);
                                        AlignFrame.this.webService.add(tm);
                                    } else if (!Cache.getDefault("SHOW_JWS2_SERVICES", true)) {
                                        JMenuItem enableJws2 = new JMenuItem("Discover Web Services");
                                        enableJws2.setToolTipText("Select to start JABA Web Service discovery (or enable option in Web Service preferences)");
                                        enableJws2.setEnabled(true);
                                        enableJws2.addActionListener(new ActionListener(){

                                            @Override
                                            public void actionPerformed(ActionEvent e) {
                                                Desktop.instance.startServiceDiscovery(false, true);
                                            }
                                        });
                                        AlignFrame.this.webService.add(enableJws2);
                                    }
                                }
                                AlignFrame.this.build_urlServiceMenu(me.webService);
                                AlignFrame.this.build_fetchdbmenu(AlignFrame.this.webService);
                                for (JMenu item : wsmenu) {
                                    if (item.getItemCount() == 0) {
                                        item.setEnabled(false);
                                        continue;
                                    }
                                    item.setEnabled(true);
                                }
                            }
                            catch (Exception e) {
                                Console.debug("Exception during web service menu building process.", e);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AlignFrame.this.buildingMenu = false;
            }
        }).start();
    }

    protected void build_urlServiceMenu(JMenu webService) {
        for (RestClient client : RestClient.getRestClients()) {
            client.attachWSMenuEntry(JvSwingUtils.findOrCreateMenu(webService, client.getAction()), this);
        }
    }

    public boolean canShowProducts() {
        SequenceI[] seqs = this.viewport.getAlignment().getSequencesArray();
        AlignmentI dataset = this.viewport.getAlignment().getDataset();
        this.showProducts.removeAll();
        final boolean dna = this.viewport.getAlignment().isNucleotide();
        if (seqs == null || seqs.length == 0) {
            return false;
        }
        boolean showp = false;
        try {
            List<String> ptypes = new CrossRef(seqs, dataset).findXrefSourcesForSequences(dna);
            for (final String source : ptypes) {
                showp = true;
                final AlignFrame af = this;
                JMenuItem xtype = new JMenuItem(source);
                xtype.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AlignFrame.this.showProductsFor(af.viewport.getSequenceSelection(), dna, source);
                    }
                });
                this.showProducts.add(xtype);
            }
            this.showProducts.setVisible(showp);
            this.showProducts.setEnabled(showp);
        }
        catch (Exception e) {
            Console.warn("canShowProducts threw an exception - please report to help@jalview.org", e);
            return false;
        }
        return showp;
    }

    protected void showProductsFor(SequenceI[] sel, boolean _odna, String source) {
        new Thread(CrossRefAction.getHandlerFor(sel, _odna, source, this)).start();
    }

    @Override
    public void showTranslation_actionPerformed(GeneticCodeI codeTable) {
        AlignmentI al = null;
        try {
            Dna dna = new Dna(this.viewport, this.viewport.getViewAsVisibleContigs(true));
            al = dna.translateCdna(codeTable);
        }
        catch (Exception ex) {
            Console.error("Exception during translation. Please report this !", ex);
            String msg = MessageManager.getString("label.error_when_translating_sequences_submit_bug_report");
            String errorTitle = MessageManager.getString("label.implementation_error") + MessageManager.getString("label.translation_failed");
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, msg, errorTitle, 0);
            return;
        }
        if (al == null || al.getHeight() == 0) {
            String msg = MessageManager.getString("label.select_at_least_three_bases_in_at_least_one_sequence_to_cDNA_translation");
            String errorTitle = MessageManager.getString("label.translation_failed");
            JvOptionPane.showMessageDialog((Component)Desktop.desktop, msg, errorTitle, 2);
        } else {
            AlignFrame af = new AlignFrame(al, 700, 500);
            af.setFileFormat(this.currentFileFormat);
            String newTitle = MessageManager.formatMessage("label.translation_of_params", this.getTitle(), codeTable.getId());
            af.setTitle(newTitle);
            if (Cache.getDefault("ENABLE_SPLIT_FRAME", true)) {
                SequenceI[] seqs = this.viewport.getSelectionAsNewSequence();
                this.viewport.openSplitFrame(af, new Alignment(seqs));
            } else {
                Desktop.addInternalFrame(af, newTitle, 700, 500);
            }
        }
    }

    public void setFileFormat(FileFormatI format) {
        this.currentFileFormat = format;
    }

    public boolean parseFeaturesFile(Object file, DataSourceType sourceType) {
        return this.avc.parseFeaturesFile(file, sourceType, Cache.getDefault("RELAXEDSEQIDMATCHING", false));
    }

    @Override
    public void refreshFeatureUI(boolean enableIfNecessary) {
        if (enableIfNecessary) {
            this.viewport.setShowSequenceFeatures(true);
            this.showSeqFeatures.setSelected(true);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        evt.acceptDrop(3);
        Transferable t = evt.getTransferable();
        final AlignFrame thisaf = this;
        final ArrayList<Object> files = new ArrayList<Object>();
        ArrayList<DataSourceType> protocols = new ArrayList<DataSourceType>();
        try {
            Desktop.transferFromDropTarget(files, protocols, evt, t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (files != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        SequenceIdMatcher idm = new SequenceIdMatcher(AlignFrame.this.viewport.getAlignment().getSequencesArray());
                        ArrayList<Object[]> filesmatched = new ArrayList<Object[]>();
                        ArrayList<Object[]> filesnotmatched = new ArrayList<Object[]>();
                        for (int i = 0; i < files.size(); ++i) {
                            DataSourceType protocol;
                            Object file = files.get(i);
                            String fileName = file.toString();
                            String pdbfn = "";
                            DataSourceType dataSourceType = protocol = file instanceof File ? DataSourceType.FILE : FormatAdapter.checkProtocol(fileName);
                            if (protocol == DataSourceType.FILE) {
                                File fl;
                                if (file instanceof File) {
                                    fl = (File)file;
                                    Platform.cacheFileData(fl);
                                } else {
                                    fl = new File(fileName);
                                }
                                pdbfn = fl.getName();
                            } else if (protocol == DataSourceType.URL) {
                                URL url = new URL(fileName);
                                pdbfn = url.getFile();
                            }
                            if (pdbfn.length() <= 0) continue;
                            SequenceI[] mtch = idm.findAllIdMatches(pdbfn);
                            int l = 0;
                            int c = pdbfn.indexOf(".");
                            while (mtch == null && c != -1) {
                                while ((c = pdbfn.indexOf(".", l = c)) > l) {
                                }
                                if (l > -1) {
                                    pdbfn = pdbfn.substring(0, l);
                                }
                                mtch = idm.findAllIdMatches(pdbfn);
                            }
                            FileFormatI type = null;
                            if (mtch != null) {
                                try {
                                    type = new IdentifyFile().identify(file, protocol);
                                }
                                catch (Exception ex) {
                                    type = null;
                                }
                                if (type != null && type.isStructureFile()) {
                                    filesmatched.add(new Object[]{file, protocol, mtch});
                                    continue;
                                }
                            }
                            filesnotmatched.add(new Object[]{file, protocol, type});
                        }
                        int assocfiles = 0;
                        if (filesmatched.size() > 0) {
                            boolean autoAssociate = Cache.getDefault("AUTOASSOCIATE_PDBANDSEQS", false);
                            if (!autoAssociate) {
                                String ttl;
                                String msg = MessageManager.formatMessage("label.automatically_associate_structure_files_with_sequences_same_name", Integer.valueOf(filesmatched.size()).toString());
                                int choice = JvOptionPane.showConfirmDialog(thisaf, msg, ttl = MessageManager.getString("label.automatically_associate_structure_files_by_name"), 0);
                                boolean bl = autoAssociate = choice == 0;
                            }
                            if (autoAssociate) {
                                for (Object[] fm : filesmatched) {
                                    for (SequenceI toassoc : (SequenceI[])fm[2]) {
                                        PDBEntry pe = new AssociatePdbFileWithSeq().associatePdbWithSeq(fm[0].toString(), (DataSourceType)((Object)fm[1]), toassoc, false, Desktop.instance);
                                        if (pe == null) continue;
                                        Console.errPrintln("Associated file : " + fm[0].toString() + " with " + toassoc.getDisplayId(true));
                                        ++assocfiles;
                                    }
                                    AlignFrame.this.alignPanel.paintAlignment(true, false);
                                }
                            } else {
                                for (Object[] o : filesmatched) {
                                    filesnotmatched.add(new Object[]{o[0], o[1]});
                                }
                            }
                        }
                        if (filesnotmatched.size() > 0) {
                            if (assocfiles > 0 && (Cache.getDefault("AUTOASSOCIATE_PDBANDSEQS_IGNOREOTHERS", false) || JvOptionPane.showConfirmDialog(thisaf, "<html>" + MessageManager.formatMessage("label.ignore_unmatched_dropped_files_info", Integer.valueOf(filesnotmatched.size()).toString()) + "</html>", MessageManager.getString("label.ignore_unmatched_dropped_files"), 0) == 0)) {
                                return;
                            }
                            for (Object[] fn : filesnotmatched) {
                                AlignFrame.this.loadJalviewDataFile(fn[0], (DataSourceType)((Object)fn[1]), (FileFormatI)fn[2], null);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void loadJalviewDataFile(Object file, DataSourceType sourceType, FileFormatI format, SequenceI assocSeq) {
        try {
            if (sourceType == null) {
                sourceType = FormatAdapter.checkProtocol(file);
            }
            boolean isAnnotation = format == null || FileFormat.Pfam.equals(format) ? new AnnotationFile().annotateAlignmentView(this.viewport, file, sourceType) : false;
            if (!(isAnnotation |= new IdentifyFile().identify(file, sourceType, true) == FileFormat.JalviewAnnotation)) {
                TCoffeeScoreFile tcf = null;
                try {
                    tcf = new TCoffeeScoreFile(file, sourceType);
                    if (tcf.isValid()) {
                        if (tcf.annotateAlignment(this.viewport.getAlignment(), true)) {
                            this.buildColourMenu();
                            this.changeColour(new TCoffeeColourScheme(this.viewport.getAlignment()));
                            isAnnotation = true;
                            this.setStatus(MessageManager.getString("label.successfully_pasted_tcoffee_scores_to_alignment"));
                        } else {
                            JvOptionPane.showMessageDialog((Component)Desktop.desktop, tcf.getWarningMessage() == null ? MessageManager.getString("label.check_file_matches_sequence_ids_alignment") : tcf.getWarningMessage(), MessageManager.getString("label.problem_reading_tcoffee_score_file"), 2);
                        }
                    } else {
                        tcf = null;
                    }
                }
                catch (Exception x) {
                    Console.debug("Exception when processing data source as T-COFFEE score file", x);
                    tcf = null;
                }
                if (tcf == null) {
                    if (format == null) {
                        format = new IdentifyFile().identify(file, sourceType);
                    }
                    if (FileFormat.FeatureSettings == format) {
                        if (this.featureSettings != null) {
                            this.featureSettings.load(file, sourceType);
                        } else {
                            FeatureSettings.loadFeatureSettingsFile(this.getFeatureRenderer(), this.fileObject, sourceType);
                        }
                    } else if (FileFormat.ScoreMatrix == format) {
                        ScoreMatrixFile sm = new ScoreMatrixFile(new FileParse(file, sourceType));
                        sm.parse();
                        this.setStatus(MessageManager.formatMessage("label.successfully_loaded_matrix", sm.getMatrixName()));
                    } else if (FileFormat.Jnet.equals(format)) {
                        JPredFile predictions = new JPredFile(file, sourceType);
                        new JnetAnnotationMaker();
                        JnetAnnotationMaker.add_annotation(predictions, this.viewport.getAlignment(), 0, false);
                        this.viewport.getAlignment().setupJPredAlignment();
                        isAnnotation = true;
                    } else if (FileFormat.Features.equals(format)) {
                        if (this.parseFeaturesFile(file, sourceType)) {
                            SplitFrame splitFrame = (SplitFrame)this.getSplitViewContainer();
                            if (splitFrame != null) {
                                splitFrame.repaint();
                            } else {
                                this.alignPanel.paintAlignment(true, true);
                            }
                        }
                    } else {
                        new FileLoader().LoadFile(this.viewport, file, sourceType, format);
                    }
                }
            }
            if (isAnnotation) {
                this.alignPanel.adjustAnnotationHeight();
                this.viewport.updateSequenceIdColours();
                this.viewport.updateAnnotationColours();
                this.buildSortByAnnotationScoresMenu();
                this.alignPanel.paintAlignment(true, true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (OutOfMemoryError oom) {
            try {
                System.gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new OOMWarning("loading data " + (String)(sourceType != null ? (sourceType == DataSourceType.PASTE ? "from clipboard." : "using " + sourceType + " from " + file) : ".") + (String)(format != null ? "(parsing as '" + format + "' file)" : ""), oom, Desktop.desktop);
        }
    }

    @Override
    public void tabSelectionChanged(int index) {
        if (index > -1) {
            this.alignPanel.setOverviewTitle(this);
            this.alignPanel = this.alignPanels.get(index);
            this.alignPanel.setOverviewTitle(this);
            this.viewport = this.alignPanel.av;
            this.avc.setViewportAndAlignmentPanel(this.viewport, this.alignPanel);
            this.setMenusFromViewport(this.viewport);
            if (this.featureSettings != null && this.featureSettings.isOpen() && this.featureSettings.fr.getViewport() != this.viewport) {
                if (this.viewport.isShowSequenceFeatures()) {
                    this.showFeatureSettingsUI();
                } else {
                    this.featureSettings.close();
                }
            }
        }
        if (this.viewport.getConservationSelected()) {
            SliderPanel.setConservationSlider(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
        } else {
            SliderPanel.hideConservationSlider();
        }
        if (this.viewport.getByConsensusSecondaryStructureSelected()) {
            SliderPanel.setConsensusSecondaryStructureSlider(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
        } else {
            SliderPanel.hideConsensusSecondaryStructureSlider();
        }
        if (this.viewport.getAbovePIDThreshold()) {
            SliderPanel.setPIDSliderSource(this.alignPanel, this.viewport.getResidueShading(), this.alignPanel.getViewName());
        } else {
            SliderPanel.hidePIDSlider();
        }
        AlignViewportI peer = this.viewport.getCodingComplement();
        if (peer != null) {
            AlignFrame linkedAlignFrame = ((AlignViewport)peer).getAlignPanel().alignFrame;
            if (linkedAlignFrame.tabbedPane.getTabCount() > index) {
                linkedAlignFrame.tabbedPane.setSelectedIndex(index);
            }
        }
    }

    @Override
    public void tabbedPane_mousePressed(MouseEvent e) {
        String ttl;
        String msg;
        String reply;
        if (e.isPopupTrigger() && (reply = JvOptionPane.showInputDialog(msg = MessageManager.getString("label.enter_view_name"), ttl = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex()))) != null) {
            this.viewport.setViewName(reply);
            this.tabbedPane.setTitleAt(this.tabbedPane.getSelectedIndex(), reply);
        }
    }

    public AlignViewport getCurrentView() {
        return this.viewport;
    }

    @Override
    protected void extractScores_actionPerformed(ActionEvent e) {
        ParseProperties pp = new ParseProperties(this.viewport.getAlignment());
        if (pp.getScoresFromDescription("description column", "score in description column ", "\\W*([-+eE0-9.]+)", true) > 0) {
            this.buildSortByAnnotationScoresMenu();
        }
    }

    @Override
    protected void showDbRefs_actionPerformed(ActionEvent e) {
        this.viewport.setShowDBRefs(this.showDbRefsMenuitem.isSelected());
    }

    @Override
    protected void showNpFeats_actionPerformed(ActionEvent e) {
        this.viewport.setShowNPFeats(this.showNpFeatsMenuitem.isSelected());
    }

    public boolean closeView(AlignViewportI av) {
        if (this.viewport == av) {
            this.closeMenuItem_actionPerformed(false);
            return true;
        }
        Component[] comp = this.tabbedPane.getComponents();
        for (int i = 0; comp != null && i < comp.length; ++i) {
            if (!(comp[i] instanceof AlignmentPanel) || ((AlignmentPanel)comp[i]).av != av) continue;
            this.closeView((AlignmentPanel)comp[i]);
            return true;
        }
        return false;
    }

    protected void build_fetchdbmenu(JMenu webService) {
        final JMenu rfetch = new JMenu(MessageManager.getString("action.fetch_db_references"));
        rfetch.setToolTipText(MessageManager.getString("label.retrieve_parse_sequence_database_records_alignment_or_selected_sequences"));
        webService.add(rfetch);
        final JCheckBoxMenuItem trimrs = new JCheckBoxMenuItem(MessageManager.getString("option.trim_retrieved_seqs"));
        trimrs.setToolTipText(MessageManager.getString("label.trim_retrieved_sequences"));
        trimrs.setSelected(Cache.getDefault("TRIM_FETCHED_DATASET_SEQS", true));
        trimrs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                trimrs.setSelected(trimrs.isSelected());
                Cache.setProperty("TRIM_FETCHED_DATASET_SEQS", Boolean.valueOf(trimrs.isSelected()).toString());
            }
        });
        rfetch.add(trimrs);
        JMenuItem fetchr = new JMenuItem(MessageManager.getString("label.standard_databases"));
        fetchr.setToolTipText(MessageManager.getString("label.fetch_embl_uniprot"));
        fetchr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean isNucleotide = AlignFrame.this.alignPanel.alignFrame.getViewport().getAlignment().isNucleotide();
                        final DBRefFetcher dbRefFetcher = new DBRefFetcher(AlignFrame.this.alignPanel.av.getSequenceSelection(), AlignFrame.this.alignPanel.alignFrame, null, AlignFrame.this.alignPanel.alignFrame.featureSettings, isNucleotide);
                        dbRefFetcher.addListener(new DBRefFetcher.FetchFinishedListenerI(){

                            @Override
                            public void finished() {
                                for (FeatureSettingsModelI srcSettings : dbRefFetcher.getFeatureSettingsModels()) {
                                    AlignFrame.this.alignPanel.av.mergeFeaturesStyle(srcSettings);
                                }
                                AlignFrame.this.setMenusForViewport();
                            }
                        });
                        dbRefFetcher.fetchDBRefs(false);
                    }
                }).start();
            }
        });
        rfetch.add(fetchr);
        new Thread(new Runnable(){

            @Override
            public void run() {
                final jalview.ws.SequenceFetcher sf = SequenceFetcher.getSequenceFetcherSingleton();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String[] dbclasses = sf.getNonAlignmentSources();
                        JMenu dfetch = new JMenu();
                        JMenu ifetch = new JMenu();
                        JMenuItem fetchr = null;
                        int comp = 0;
                        int icomp = 0;
                        int mcomp = 15;
                        String mname = null;
                        int dbi = 0;
                        for (String dbclass : dbclasses) {
                            DbSourceProxy src;
                            DbSourceProxy[] dassource;
                            List<DbSourceProxy> otherdb = sf.getSourceProxy(dbclass);
                            if (otherdb == null || otherdb.size() < 1) continue;
                            if (mname == null) {
                                mname = "From " + dbclass;
                            }
                            if (otherdb.size() == 1) {
                                dassource = otherdb.toArray(new DbSourceProxy[0]);
                                src = otherdb.get(0);
                                fetchr = new JMenuItem(src.getDbSource());
                                fetchr.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        new Thread(new Runnable(){

                                            @Override
                                            public void run() {
                                                boolean isNucleotide = AlignFrame.this.alignPanel.alignFrame.getViewport().getAlignment().isNucleotide();
                                                DBRefFetcher dbRefFetcher = new DBRefFetcher(AlignFrame.this.alignPanel.av.getSequenceSelection(), AlignFrame.this.alignPanel.alignFrame, dassource, AlignFrame.this.alignPanel.alignFrame.featureSettings, isNucleotide);
                                                dbRefFetcher.addListener(new DBRefFetcher.FetchFinishedListenerI(){

                                                    @Override
                                                    public void finished() {
                                                        FeatureSettingsModelI srcSettings = dassource[0].getFeatureColourScheme();
                                                        AlignFrame.this.alignPanel.av.mergeFeaturesStyle(srcSettings);
                                                        AlignFrame.this.setMenusForViewport();
                                                    }
                                                });
                                                dbRefFetcher.fetchDBRefs(false);
                                            }
                                        }).start();
                                    }
                                });
                                fetchr.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("label.fetch_retrieve_from", src.getDbName())));
                                dfetch.add(fetchr);
                                ++comp;
                            } else {
                                dassource = otherdb.toArray(new DbSourceProxy[0]);
                                src = otherdb.get(0);
                                fetchr = new JMenuItem(MessageManager.formatMessage("label.fetch_all_param", src.getDbSource()));
                                fetchr.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        new Thread(new Runnable(){

                                            @Override
                                            public void run() {
                                                boolean isNucleotide = AlignFrame.this.alignPanel.alignFrame.getViewport().getAlignment().isNucleotide();
                                                DBRefFetcher dbRefFetcher = new DBRefFetcher(AlignFrame.this.alignPanel.av.getSequenceSelection(), AlignFrame.this.alignPanel.alignFrame, dassource, AlignFrame.this.alignPanel.alignFrame.featureSettings, isNucleotide);
                                                dbRefFetcher.addListener(new DBRefFetcher.FetchFinishedListenerI(){

                                                    @Override
                                                    public void finished() {
                                                        AlignFrame.this.setMenusForViewport();
                                                    }
                                                });
                                                dbRefFetcher.fetchDBRefs(false);
                                            }
                                        }).start();
                                    }
                                });
                                fetchr.setToolTipText(JvSwingUtils.wrapTooltip(true, MessageManager.formatMessage("label.fetch_retrieve_from_all_sources", Integer.valueOf(otherdb.size()).toString(), src.getDbSource(), src.getDbName())));
                                dfetch.add(fetchr);
                                ++comp;
                                ifetch = new JMenu(MessageManager.formatMessage("label.source_from_db_source", src.getDbSource()));
                                icomp = 0;
                                String imname = null;
                                int i = 0;
                                for (DbSourceProxy sproxy : otherdb) {
                                    String msname;
                                    String dbname = sproxy.getDbName();
                                    String sname = dbname.length() > 5 ? dbname.substring(0, 5) + "..." : dbname;
                                    String string = msname = dbname.length() > 10 ? dbname.substring(0, 10) + "..." : dbname;
                                    if (imname == null) {
                                        imname = MessageManager.formatMessage("label.from_msname", sname);
                                    }
                                    fetchr = new JMenuItem(msname);
                                    final DbSourceProxy[] dassrc = new DbSourceProxy[]{sproxy};
                                    fetchr.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            new Thread(new Runnable(){

                                                @Override
                                                public void run() {
                                                    boolean isNucleotide = AlignFrame.this.alignPanel.alignFrame.getViewport().getAlignment().isNucleotide();
                                                    DBRefFetcher dbRefFetcher = new DBRefFetcher(AlignFrame.this.alignPanel.av.getSequenceSelection(), AlignFrame.this.alignPanel.alignFrame, dassrc, AlignFrame.this.alignPanel.alignFrame.featureSettings, isNucleotide);
                                                    dbRefFetcher.addListener(new DBRefFetcher.FetchFinishedListenerI(){

                                                        @Override
                                                        public void finished() {
                                                            AlignFrame.this.setMenusForViewport();
                                                        }
                                                    });
                                                    dbRefFetcher.fetchDBRefs(false);
                                                }
                                            }).start();
                                        }
                                    });
                                    fetchr.setToolTipText("<html>" + MessageManager.formatMessage("label.fetch_retrieve_from", dbname));
                                    ifetch.add(fetchr);
                                    if (++icomp < mcomp && ++i != otherdb.size()) continue;
                                    ifetch.setText(MessageManager.formatMessage("label.source_to_target", imname, sname));
                                    dfetch.add(ifetch);
                                    ifetch = new JMenu();
                                    imname = null;
                                    icomp = 0;
                                    ++comp;
                                }
                            }
                            if (comp < mcomp && ++dbi < dbclasses.length) continue;
                            dfetch.setText(MessageManager.formatMessage("label.source_to_target", mname, dbclass));
                            rfetch.add(dfetch);
                            dfetch = new JMenu();
                            mname = null;
                            comp = 0;
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    protected void justifyLeftMenuItem_actionPerformed(ActionEvent e) {
        this.avc.justify_Region(true);
    }

    @Override
    protected void justifyRightMenuItem_actionPerformed(ActionEvent e) {
        this.avc.justify_Region(false);
    }

    @Override
    public void setShowSeqFeatures(boolean b) {
        this.showSeqFeatures.setSelected(b);
        this.viewport.setShowSequenceFeatures(b);
    }

    @Override
    protected void showUnconservedMenuItem_actionPerformed(ActionEvent e) {
        this.viewport.setShowUnconserved(this.showNonconservedMenuItem.getState());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    protected void showStructureProvider_actionPerformed(ActionEvent e) {
        this.viewport.setShowStructureProvider(this.showStrucProvider.getState());
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    protected void updateShowSecondaryStructureMenu(JMenu showSS, ButtonGroup ssButtonGroup) {
        List<Object> ssSources = new ArrayList();
        AlignmentAnnotation[] anns = this.alignPanel.getAlignment().getAlignmentAnnotation();
        Map<String, JCheckBoxMenuItem> checkboxMap = this.getCheckboxesInMenu(showSS);
        ssSources = AlignmentUtils.extractSSSourceInAlignmentAnnotation(anns);
        if (ssSources == null) {
            showSS.removeAll();
            ssButtonGroup.clearSelection();
            return;
        }
        List<String> selectedCheckBoxes = this.getSelectedOptions(checkboxMap);
        for (String string : ssSources) {
            if (checkboxMap.get(string) != null) continue;
            JCheckBoxMenuItem checkBox = new JCheckBoxMenuItem(string);
            checkBox.setSelected(false);
            checkBox.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.showOrHideSecondaryStructureForSource(ssSource, true);
                } else {
                    this.showOrHideSecondaryStructureForSource(ssSource, false);
                }
            });
            showSS.add(checkBox);
        }
        for (String string : checkboxMap.keySet()) {
            if (!ssSources.contains(string)) {
                showSS.remove(checkboxMap.get(string));
                checkboxMap.remove(string);
                selectedCheckBoxes.remove(string);
            }
            if (selectedCheckBoxes.contains(string)) {
                checkboxMap.get(string).setSelected(true);
            } else {
                checkboxMap.get(string).setSelected(false);
            }
            ssButtonGroup.clearSelection();
        }
    }

    private List<String> getSelectedOptions(Map<String, JCheckBoxMenuItem> checkboxMap) {
        ArrayList<String> selectedOptions = new ArrayList<String>();
        for (String key : checkboxMap.keySet()) {
            JCheckBoxMenuItem checkbox = checkboxMap.get(key);
            if (!checkbox.isSelected()) continue;
            selectedOptions.add(key);
        }
        return selectedOptions;
    }

    private Map<String, JCheckBoxMenuItem> getCheckboxesInMenu(JMenu menu) {
        HashMap<String, JCheckBoxMenuItem> checkboxMap = new HashMap<String, JCheckBoxMenuItem>();
        for (Component component : menu.getMenuComponents()) {
            if (!(component instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem checkbox = (JCheckBoxMenuItem)component;
            checkboxMap.put(checkbox.getText(), checkbox);
        }
        return checkboxMap;
    }

    @Override
    protected void showOrHideSecondaryStructureForSource(String ssSourceSelection, boolean visible) {
        AlignmentAnnotation[] annotations;
        String _noneOption = MessageManager.getString("option.ss_providers_none");
        boolean nonOption = ssSourceSelection != null && ssSourceSelection.equals(_noneOption);
        String allOption = MessageManager.getString("option.ss_providers_all");
        for (AlignmentAnnotation aa : annotations = this.alignPanel.getAlignment().getAlignmentAnnotation()) {
            if (aa.groupRef != null) continue;
            boolean isSSConsensus = aa.label.startsWith(MessageManager.getString("label.ssconsensus_label"));
            boolean matchesSSSourceSelection = aa.description.startsWith(ssSourceSelection);
            if (isSSConsensus && (matchesSSSourceSelection || nonOption)) {
                if (ssSourceSelection.equals(allOption)) {
                    aa.visible = true;
                    break;
                }
                if (!aa.description.startsWith(allOption)) {
                    aa.visible = visible;
                }
            }
            for (String label : Constants.SECONDARY_STRUCTURE_LABELS.keySet()) {
                if (!label.equals(aa.label)) continue;
                String ssSource = AlignmentAnnotationUtils.extractSSSourceFromAnnotationDescription(aa);
                if (!nonOption && (ssSource == null || !ssSource.equals(ssSourceSelection))) continue;
                aa.visible = visible;
            }
        }
        PaintRefresher.Refresh(this, this.viewport.getSequenceSetId());
        this.alignPanel.updateAnnotation();
        this.alignPanel.paintAlignment(true, true);
    }

    @Override
    protected void showSSConsensus_actionPerformed(ActionEvent e) {
        this.viewport.setShowSSConsensus(this.showSSConsensus.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void showGroupConsensus_actionPerformed(ActionEvent e) {
        this.viewport.setShowGroupConsensus(this.showGroupConsensus.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void showGroupSSConsensus_actionPerformed(ActionEvent e) {
        this.viewport.setShowGroupSSConsensus(this.showGroupSSConsensus.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void showGroupConservation_actionPerformed(ActionEvent e) {
        this.viewport.setShowGroupConservation(this.showGroupConservation.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void showConsensusHistogram_actionPerformed(ActionEvent e) {
        this.viewport.setShowConsensusHistogram(this.showConsensusHistogram.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void showSequenceLogo_actionPerformed(ActionEvent e) {
        this.viewport.setShowSequenceLogo(this.showSequenceLogo.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void normaliseSequenceLogo_actionPerformed(ActionEvent e) {
        this.showSequenceLogo.setState(true);
        this.viewport.setShowSequenceLogo(true);
        this.viewport.setNormaliseSequenceLogo(this.normaliseSequenceLogo.getState());
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void applyAutoAnnotationSettings_actionPerformed(ActionEvent e) {
        this.alignPanel.updateAnnotation(this.applyAutoAnnotationSettings.getState());
    }

    @Override
    protected void makeGrpsFromSelection_actionPerformed(ActionEvent e) {
        if (this.avc.makeGroupsFromSelection()) {
            PaintRefresher.Refresh(this, this.viewport.getSequenceSetId());
            this.alignPanel.updateAnnotation();
            this.alignPanel.paintAlignment(true, this.viewport.needToUpdateStructureViews());
        }
    }

    public void clearAlignmentSeqRep() {
        if (this.viewport.getAlignment().hasSeqrep()) {
            this.viewport.getAlignment().setSeqrep(null);
            PaintRefresher.Refresh(this, this.viewport.getSequenceSetId());
            this.alignPanel.updateAnnotation();
            this.alignPanel.paintAlignment(true, true);
        }
    }

    @Override
    protected void createGroup_actionPerformed(ActionEvent e) {
        if (this.avc.createGroup()) {
            if (this.applyAutoAnnotationSettings.isSelected()) {
                this.alignPanel.updateAnnotation(true, false);
            }
            this.alignPanel.alignmentChanged();
        }
    }

    @Override
    protected void unGroup_actionPerformed(ActionEvent e) {
        if (this.avc.unGroup()) {
            this.alignPanel.alignmentChanged();
        }
    }

    public void setDisplayedView(AlignmentPanel alignmentPanel) {
        if (!this.viewport.getSequenceSetId().equals(alignmentPanel.av.getSequenceSetId())) {
            throw new Error(MessageManager.getString("error.implementation_error_cannot_show_view_alignment_frame"));
        }
        if (this.tabbedPane != null && this.tabbedPane.getTabCount() > 0 && this.alignPanels.indexOf(alignmentPanel) != this.tabbedPane.getSelectedIndex()) {
            this.tabbedPane.setSelectedIndex(this.alignPanels.indexOf(alignmentPanel));
        }
    }

    @Override
    public void setAnnotationsVisibility(boolean visible, boolean forSequences, boolean forAlignment) {
        AlignmentAnnotation[] anns = this.alignPanel.getAlignment().getAlignmentAnnotation();
        if (anns == null) {
            return;
        }
        for (AlignmentAnnotation aa : anns) {
            boolean apply;
            if (aa.annotations == null) continue;
            boolean bl = apply = aa.sequenceRef == null && forAlignment || aa.sequenceRef != null && forSequences;
            if (!apply) continue;
            aa.visible = visible;
        }
        this.alignPanel.validateAnnotationDimensions(true);
        this.alignPanel.fontChanged();
        this.alignPanel.alignmentChanged();
    }

    @Override
    protected void sortAnnotations_actionPerformed() {
        this.alignPanel.av.setSortAnnotationsBy(this.getAnnotationSortOrder());
        this.alignPanel.av.setShowAutocalculatedAbove(this.isShowAutoCalculatedAbove());
        this.alignPanel.paintAlignment(false, false);
    }

    public List<? extends AlignmentViewPanel> getAlignPanels() {
        return this.alignPanels;
    }

    protected void viewAsCdna_actionPerformed() {
        AlignmentI alignment = this.getViewport().getAlignment();
        List<AlignedCodonFrame> mappings = alignment.getCodonFrames();
        if (mappings == null) {
            return;
        }
        ArrayList<Sequence> cdnaSeqs = new ArrayList<Sequence>();
        for (SequenceI aaSeq : alignment.getSequences()) {
            for (AlignedCodonFrame acf : mappings) {
                SequenceI dnaSeq = acf.getDnaForAaSeq(aaSeq.getDatasetSequence());
                if (dnaSeq == null) continue;
                Sequence newSeq = new Sequence(dnaSeq);
                newSeq.setDatasetSequence(dnaSeq);
                cdnaSeqs.add(newSeq);
            }
        }
        if (cdnaSeqs.size() == 0) {
            return;
        }
        Alignment cdna = new Alignment(cdnaSeqs.toArray(new SequenceI[cdnaSeqs.size()]));
        AlignFrame alignFrame = new AlignFrame(cdna, 700, 500);
        cdna.alignAs(alignment);
        String newtitle = "cDNA " + MessageManager.getString("label.for") + " " + this.title;
        Desktop.addInternalFrame(alignFrame, newtitle, 700, 500);
    }

    @Override
    protected void showComplement_actionPerformed(boolean show) {
        SplitContainerI sf = this.getSplitViewContainer();
        if (sf != null) {
            sf.setComplementVisible(this, show);
        }
    }

    @Override
    protected void showReverse_actionPerformed(boolean complement) {
        AlignmentI al = null;
        try {
            Dna dna = new Dna(this.viewport, this.viewport.getViewAsVisibleContigs(true));
            al = dna.reverseCdna(complement);
            this.viewport.addAlignment(al, "");
            this.addHistoryItem(new EditCommand(MessageManager.getString("label.add_sequences"), EditCommand.Action.PASTE, al.getSequencesArray(), 0, al.getWidth(), this.viewport.getAlignment()));
        }
        catch (Exception ex) {
            Console.errPrintln(ex.getMessage());
            return;
        }
    }

    @Override
    protected void runGroovy_actionPerformed() {
        Jalview.getInstance().setCurrentAlignFrame(this);
        groovy.console.ui.Console console = Desktop.getGroovyConsole();
        if (console != null) {
            try {
                console.setVariable("currentAlFrame", (Object)this);
                console.runScript();
            }
            catch (Exception ex) {
                Console.errPrintln(ex.toString());
                JvOptionPane.showInternalMessageDialog((Component)Desktop.desktop, MessageManager.getString("label.couldnt_run_groovy_script"), MessageManager.getString("label.groovy_support_failed"), 0);
            }
        } else {
            Console.errPrintln("Can't run Groovy script as console not found");
        }
    }

    public boolean hideFeatureColumns(String featureType, boolean columnsContaining) {
        boolean notForHiding = this.avc.markColumnsContainingFeatures(columnsContaining, false, false, featureType);
        if (notForHiding && this.avc.markColumnsContainingFeatures(!columnsContaining, false, false, featureType)) {
            this.getViewport().hideSelectedColumns();
            return true;
        }
        return false;
    }

    @Override
    protected void selectHighlightedColumns_actionPerformed(ActionEvent actionEvent) {
        this.avc.markHighlightedColumns((actionEvent.getModifiers() & 8) != 0, true, (actionEvent.getModifiers() & 6) != 0);
    }

    @Override
    protected void copyHighlightedColumns_actionPerformed(ActionEvent actionEvent) {
        this.avc.copyHighlightedRegionsToClipboard();
    }

    public void buildColourMenu() {
        this.colourMenu.removeAll();
        this.colourMenu.add(this.applyToAllGroups);
        this.colourMenu.add(this.textColour);
        this.colourMenu.addSeparator();
        ButtonGroup bg = ColourMenuHelper.addMenuItems(this.colourMenu, this, this.viewport.getAlignment(), false);
        this.colourMenu.add(this.annotationColour);
        bg.add(this.annotationColour);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.conservationMenuItem);
        this.colourMenu.add(this.modifyConservation);
        this.colourMenu.add(this.byConsensusSecondaryStructureMenuItem);
        this.colourMenu.add(this.modifyConsensusSecondaryStructureThreshold);
        this.colourMenu.add(this.abovePIDThreshold);
        this.colourMenu.add(this.modifyPID);
        ColourSchemeI colourScheme = this.viewport.getGlobalColourScheme();
        ColourMenuHelper.setColourSelected(this.colourMenu, colourScheme);
    }

    protected void openTreePcaDialog() {
        if (this.alignPanel.getCalculationDialog() == null) {
            new CalculationChooser(this);
        }
    }

    @Override
    protected void loadVcf_actionPerformed() {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.load_vcf_file"));
        chooser.setToolTipText(MessageManager.getString("label.load_vcf_file"));
        AlignFrame us = this;
        chooser.setResponseHandler(0, () -> {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", choice);
            SequenceI[] seqs = this.viewport.getAlignment().getSequencesArray();
            new VCFLoader(choice).loadVCF(seqs, us);
        });
        chooser.showOpenDialog(null);
    }

    @Override
    public void setFeatureSettingsGeometry(Rectangle bounds) {
        this.lastFeatureSettingsBounds = bounds;
    }

    @Override
    public Rectangle getFeatureSettingsGeometry() {
        return this.lastFeatureSettingsBounds;
    }

    public void showOrHideAnnotations(boolean showSSAnnotations, boolean showAnnotations, boolean hideTFrows) {
        this.setAnnotationsVisibility(showSSAnnotations, true, false);
        this.setAnnotationsVisibility(showAnnotations, false, true);
        if (hideTFrows) {
            ArrayList<String> hideThese = new ArrayList<String>();
            hideThese.add("Temperature Factor");
            hideThese.add("Alphafold Reliability");
            AlignmentUtils.showOrHideSequenceAnnotations(this.getCurrentView().getAlignment(), hideThese, null, false, false);
        }
    }

    public void disableInput(final boolean greyPanel, boolean coverStatusPanel) {
        final int myHeight = coverStatusPanel ? this.getRootPane().getHeight() : this.getRootPane().getHeight() - this.getStatusPanel().getHeight();
        final int myWidth = this.getRootPane().getWidth();
        if (this.glassPane == null) {
            JPanel glass = greyPanel ? new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    if (greyPanel) {
                        g.setColor(new Color(0, 0, 0, 48));
                        g.fillRect(0, 0, myWidth, myHeight);
                    }
                }
            } : new JPanel();
            glass.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    e.consume();
                }
            });
            glass.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    e.consume();
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    e.consume();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    e.consume();
                }
            });
            glass.setOpaque(false);
            this.glassPane = glass;
        } else {
            this.glassPane.setSize(myWidth, myHeight);
        }
        JRootPane root = this.getRootPane();
        this.savedRootGlassPane = root.getGlassPane();
        root.setGlassPane(this.glassPane);
        this.savedRootGlassPane.setVisible(false);
        this.glassPane.setVisible(true);
    }

    public void enableInput() {
        this.getRootPane().setGlassPane(this.savedRootGlassPane);
        this.savedRootGlassPane.setVisible(true);
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
    }
}

