/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.alphafold;

import jalview.bin.Console;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.core.FTSRestRequest;
import jalview.util.DBRefUtils;
import jalview.util.HttpUtils;
import jalview.ws.dbsources.EBIAlfaFold;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class AlphafoldRestClient {
    public static List<FTSData> getFTSData(FTSRestRequest request) {
        ArrayList<FTSData> records = new ArrayList<FTSData>();
        String primaryKey = null;
        Collection<FTSDataColumnI> diplayFields = request.getWantedFields();
        SequenceI associatedSeq = request.getAssociatedSequence();
        for (DBRefEntry upref : DBRefUtils.selectRefs(associatedSeq.getPrimaryDBRefs(), new String[]{"UNIPROT"})) {
            String alphaFoldId;
            block10: {
                alphaFoldId = "AF-" + upref.getAccessionId() + "-F1";
                try {
                    String urls = EBIAlfaFold.getAlphaFoldCifDownloadUrl(alphaFoldId, null);
                    URL url = new URL(urls);
                    if (!HttpUtils.checkUrlAvailable(url, 50)) {
                    }
                    break block10;
                }
                catch (Exception mfe) {
                    Console.debug("Exception accessing urls", mfe);
                }
                continue;
            }
            int colCounter = 0;
            Object[] summaryRowData = new Object[associatedSeq != null ? diplayFields.size() + 1 : diplayFields.size()];
            if (associatedSeq != null) {
                SequenceI associatedSequence = associatedSeq;
                summaryRowData[0] = associatedSequence;
                colCounter = 1;
            }
            for (FTSDataColumnI field : diplayFields) {
                String fieldData = "alphafold";
                if (field.isPrimaryKeyColumn()) {
                    primaryKey = alphaFoldId;
                    summaryRowData[colCounter++] = alphaFoldId;
                    continue;
                }
                if (fieldData == null || fieldData.isEmpty()) {
                    summaryRowData[colCounter++] = null;
                    continue;
                }
                try {
                    summaryRowData[colCounter++] = field.getDataType().getDataTypeClass() == Integer.class ? Integer.valueOf(1) : (field.getDataType().getDataTypeClass() == Double.class ? Double.valueOf(1.3131313) : "AlphaFold clarity");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Console.outPrintln("offending value:" + fieldData);
                }
            }
            final String primaryKey1 = primaryKey;
            final Object[] summaryRowData1 = summaryRowData;
            records.add(new FTSData(){

                @Override
                public Object[] getSummaryData() {
                    return summaryRowData1;
                }

                @Override
                public Object getPrimaryKey() {
                    return primaryKey1;
                }

                public String toString() {
                    StringBuilder summaryFieldValues = new StringBuilder();
                    for (Object summaryField : summaryRowData1) {
                        summaryFieldValues.append(summaryField == null ? " " : summaryField.toString()).append("\t");
                    }
                    return summaryFieldValues.toString();
                }

                public int hashCode() {
                    return Objects.hash(primaryKey1, this.toString());
                }

                public boolean equals(Object that) {
                    return this.toString().equals(that.toString());
                }
            });
        }
        return records;
    }
}

