/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.jmol;

import com.stevesoft.pat.Regex;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.datamodel.annotations.AlphaFoldAnnotationRowBuilder;
import jalview.datamodel.annotations.AnnotationRowBuilder;
import jalview.datamodel.annotations.QMEANDISCORowBuilder;
import jalview.ext.jmol.JalviewJmolBinding;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.StructureFile;
import jalview.schemes.ResidueProperties;
import jalview.structure.StructureImportSettings;
import jalview.util.Format;
import jalview.util.MessageManager;
import jalview.ws.dbsources.EBIAlfaFold;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import mc_view.Atom;
import mc_view.PDBChain;
import mc_view.Residue;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.c.CBK;
import org.jmol.c.STR;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.Viewer;

public class JmolParser
extends StructureFile
implements JmolStatusListener {
    Viewer viewer = null;
    PDBEntry.Type jmolFiletype = null;
    String lastConsoleEcho = "";
    String lastConsoleMessage = "";
    int lastScriptTermination = -1;
    String lastScriptMessage = "";

    public JmolParser(boolean immediate, Object inFile, DataSourceType sourceType) throws IOException {
        super(immediate, inFile, sourceType);
    }

    public JmolParser(Object inFile, DataSourceType sourceType) throws IOException {
        this(inFile, sourceType, null);
    }

    public JmolParser(Object inFile, DataSourceType sourceType, StructureImportSettings.TFType tempfacType) throws IOException {
        super(inFile, sourceType, tempfacType);
    }

    public JmolParser(FileParse fp, boolean doXferSettings) throws IOException {
        super(fp, doXferSettings);
    }

    public JmolParser(FileParse fp) throws IOException {
        super(fp);
    }

    public JmolParser() {
    }

    @Override
    public void parse() throws IOException {
        this.parse(true);
    }

    @Override
    public void parse(boolean doXferSettings) throws IOException {
        this.setChains(new Vector<PDBChain>());
        Viewer jmolModel = this.getJmolData();
        jmolModel.openReader(this.getDataName(), this.getDataName(), (Object)this.getReader());
        this.waitForScript(jmolModel);
        if (jmolModel.ms.mc > 0) {
            this.setStructureFileType(this.getDataName().toLowerCase(Locale.ROOT).endsWith(".cif") ? PDBEntry.Type.MMCIF.toString() : "PDB");
            this.transformJmolModelToJalview(jmolModel.ms, doXferSettings);
        }
    }

    private Viewer getJmolData() {
        if (this.viewer == null) {
            try {
                this.viewer = JalviewJmolBinding.getJmolData(this);
                this.viewer.setBooleanProperty("defaultStructureDSSP", true);
            }
            catch (ClassCastException x) {
                throw new Error(MessageManager.formatMessage("error.jmol_version_not_compatible_with_jalview_version", new String[]{JmolViewer.getJmolVersion()}), x);
            }
        }
        return this.viewer;
    }

    public static Regex getNewAlphafoldValidator() {
        Regex validator = new Regex("(AF-[A-Z]+[0-9]+[A-Z0-9]+-F1)");
        validator.setIgnoreCase(true);
        return validator;
    }

    public boolean updateFileType(String jmolIdentifiedFileType) {
        if (jmolIdentifiedFileType == null || jmolIdentifiedFileType.trim().equals("")) {
            return false;
        }
        if ("mmcif".equalsIgnoreCase(jmolIdentifiedFileType)) {
            this.jmolFiletype = PDBEntry.Type.MMCIF;
            return true;
        }
        if ("pdb".equalsIgnoreCase(jmolIdentifiedFileType)) {
            this.jmolFiletype = PDBEntry.Type.PDB;
            return true;
        }
        return false;
    }

    public void transformJmolModelToJalview(ModelSet ms, boolean localDoXferSettings) throws IOException {
        block21: {
            try {
                Regex alphaFold = JmolParser.getNewAlphafoldValidator();
                String lastID = "";
                ArrayList<SequenceI> rna = new ArrayList<SequenceI>();
                ArrayList<SequenceI> prot = new ArrayList<SequenceI>();
                String pdbId = (String)ms.getInfo(0, "title");
                boolean isMMCIF = false;
                String jmolFileType_String = (String)ms.getInfo(0, "fileType");
                if (this.updateFileType(jmolFileType_String)) {
                    this.setStructureFileType(this.jmolFiletype.toString());
                }
                isMMCIF = PDBEntry.Type.MMCIF.equals((Object)this.jmolFiletype);
                if (pdbId == null) {
                    this.setId(this.safeName(this.getDataName()));
                    this.setPDBIdAvailable(false);
                } else {
                    this.setId(pdbId);
                    this.setPDBIdAvailable(true);
                    this.setAlphafoldModel(alphaFold.search(pdbId) && isMMCIF);
                }
                List<Atom> significantAtoms = this.convertSignificantAtoms(ms);
                for (Atom tmpatom : significantAtoms) {
                    if (tmpatom.resNumIns.trim().equals(lastID)) continue;
                    PDBChain tmpchain = this.findChain(tmpatom.chain);
                    if (tmpchain != null) {
                        tmpchain.atoms.addElement(tmpatom);
                    } else {
                        AnnotationRowBuilder builder = null;
                        if (this.isAlphafoldModel() || this.getTemperatureFactorType() == StructureImportSettings.TFType.PLDDT) {
                            builder = new AlphaFoldAnnotationRowBuilder();
                        }
                        if (this.getTemperatureFactorType() == StructureImportSettings.TFType.QMEANDISCO) {
                            builder = new QMEANDISCORowBuilder();
                        }
                        tmpchain = new PDBChain(this.getId(), tmpatom.chain, builder);
                        this.getChains().add(tmpchain);
                        tmpchain.atoms.addElement(tmpatom);
                    }
                    lastID = tmpatom.resNumIns.trim();
                }
                if (this.isParseImmediately() && localDoXferSettings) {
                    this.xferSettings();
                }
                this.makeResidueList();
                this.makeCaBondList();
                for (PDBChain chain : this.getChains()) {
                    SequenceI chainseq = this.postProcessChain(chain);
                    if (JmolParser.isRNA(chainseq)) {
                        rna.add(chainseq);
                    } else {
                        prot.add(chainseq);
                    }
                    if (!this.predictSecondaryStructure) continue;
                    this.createAnnotation(chainseq, chain, ms.at);
                }
                if (this.isAlphafoldModel() && !this.hasPAEMatrix()) {
                    try {
                        Console.info("Retrieving PAE for " + pdbId);
                        File paeFile = EBIAlfaFold.fetchAlphaFoldPAE(pdbId, null);
                        this.setPAEMatrix(paeFile.getAbsolutePath());
                    }
                    catch (Throwable t) {
                        Console.error("Couldn't get the pAE for " + pdbId, t);
                    }
                }
                if (!this.hasPAEMatrix()) break block21;
                try {
                    Alignment al = new Alignment(prot.toArray(new SequenceI[0]));
                    EBIAlfaFold.addAlphaFoldPAE(al, new File(this.getPAEMatrix()), 0, null, false, false, null);
                    if (al.getAlignmentAnnotation() != null) {
                        for (AlignmentAnnotation alann : al.getAlignmentAnnotation()) {
                            this.annotations.add(alann);
                        }
                    }
                }
                catch (Throwable ff) {
                    Console.error("Couldn't import PAE Matrix from " + this.getPAEMatrix(), ff);
                    this.warningMessage = this.warningMessage + "Couldn't import PAE Matrix" + this.getNewlineString() + ff.getLocalizedMessage() + this.getNewlineString();
                }
            }
            catch (OutOfMemoryError er) {
                Console.outPrintln("OUT OF MEMORY LOADING TRANSFORMING JMOL MODEL TO JALVIEW MODEL");
                throw new IOException(MessageManager.getString("exception.outofmemory_loading_mmcif_file"));
            }
        }
    }

    private List<Atom> convertSignificantAtoms(ModelSet ms) {
        ArrayList<Atom> significantAtoms = new ArrayList<Atom>();
        HashMap<String, org.jmol.modelset.Atom> chainTerMap = new HashMap<String, org.jmol.modelset.Atom>();
        org.jmol.modelset.Atom prevAtom = null;
        for (org.jmol.modelset.Atom atom : ms.at) {
            if (!atom.getAtomName().equalsIgnoreCase("CA") && !atom.getAtomName().equalsIgnoreCase("P") || !this.atomValidated(atom, prevAtom, chainTerMap)) continue;
            Atom curAtom = new Atom(atom.x, atom.y, atom.z);
            curAtom.atomIndex = atom.getIndex();
            curAtom.chain = atom.getChainIDStr();
            curAtom.insCode = (char)(atom.group.getInsertionCode() == '\u0000' ? 32 : (int)atom.group.getInsertionCode());
            curAtom.name = atom.getAtomName();
            curAtom.number = atom.getAtomNumber();
            curAtom.resName = atom.getGroup3(true);
            curAtom.resNumber = atom.getResno();
            curAtom.occupancy = ms.occupancies != null ? ms.occupancies[atom.getIndex()] : Float.valueOf(atom.getOccupancy100()).floatValue();
            String fmt = new Format("%4i").form(curAtom.resNumber);
            curAtom.resNumIns = fmt + curAtom.insCode;
            curAtom.tfactor = (float)atom.getBfactor100() / 100.0f;
            curAtom.type = 0;
            if (!significantAtoms.contains(curAtom)) {
                significantAtoms.add(curAtom);
            }
            prevAtom = atom;
        }
        return significantAtoms;
    }

    private boolean atomValidated(org.jmol.modelset.Atom curAtom, org.jmol.modelset.Atom prevAtom, HashMap<String, org.jmol.modelset.Atom> chainTerMap) {
        if (chainTerMap == null || prevAtom == null) {
            return true;
        }
        String curAtomChId = curAtom.getChainIDStr();
        String prevAtomChId = prevAtom.getChainIDStr();
        if (!prevAtomChId.equals(curAtomChId)) {
            if (!chainTerMap.containsKey(prevAtomChId)) {
                chainTerMap.put(prevAtomChId, prevAtom);
            }
            if (chainTerMap.containsKey(curAtomChId)) {
                if (curAtom.getResno() < chainTerMap.get(curAtomChId).getResno()) {
                    return false;
                }
                if (curAtom.getResno() - chainTerMap.get(curAtomChId).getResno() < 5) {
                    chainTerMap.put(curAtomChId, curAtom);
                    return true;
                }
                return false;
            }
        } else if (chainTerMap.containsKey(curAtomChId)) {
            if (curAtom.getResno() < chainTerMap.get(curAtomChId).getResno()) {
                return false;
            }
            if (curAtom.getResno() - chainTerMap.get(curAtomChId).getResno() < 5) {
                chainTerMap.put(curAtomChId, curAtom);
                return true;
            }
            return false;
        }
        return !curAtom.isHetero() || curAtom.getResno() - prevAtom.getResno() <= 2;
    }

    private void createAnnotation(SequenceI sequence, PDBChain chain, org.jmol.modelset.Atom[] jmolAtoms) {
        char[] secstr = new char[sequence.getLength()];
        char[] secstrcode = new char[sequence.getLength()];
        if (chain.residues.size() != sequence.getLength()) {
            return;
        }
        int annotIndex = 0;
        for (Residue residue : chain.residues) {
            Atom repAtom = residue.getAtoms().get(0);
            STR proteinStructureSubType = jmolAtoms[repAtom.atomIndex].group.getProteinStructureSubType();
            this.setSecondaryStructure(proteinStructureSubType, annotIndex, secstr, secstrcode);
            ++annotIndex;
        }
        this.addSecondaryStructureAnnotation(chain.pdbid, sequence, secstr, secstrcode, chain.id, sequence.getStart());
    }

    protected void addSecondaryStructureAnnotation(String modelTitle, SequenceI sq, char[] secstr, char[] secstrcode, String chainId, int firstResNum) {
        int length = sq.getLength();
        boolean ssFound = false;
        Annotation[] asecstr = new Annotation[length + (firstResNum - sq.getStart())];
        for (int p = 0; p < length; ++p) {
            if (secstr[p] < 'A' || secstr[p] > 'z') continue;
            try {
                asecstr[p] = new Annotation(null, null, secstrcode[p], Float.NaN);
                ssFound = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ssFound) {
            Object mt = modelTitle == null ? this.getDataName() : modelTitle;
            mt = (String)mt + chainId;
            AlignmentAnnotation ann = new AlignmentAnnotation("Secondary Structure", "Secondary Structure for " + (String)mt, asecstr);
            ann.belowAlignment = true;
            ann.visible = true;
            ann.autoCalculated = false;
            ann.setCalcId(this.getClass().getName());
            ann.adjustForAlignment();
            ann.validateRangeAndDisplay();
            if (modelTitle != null) {
                ann.setProperty("PDBID", modelTitle);
            }
            if (chainId != null) {
                ann.setProperty("CHAINID", chainId);
            }
            this.annotations.add(ann);
            sq.addAlignmentAnnotation(ann);
        }
    }

    private void waitForScript(Viewer jmd) {
        while (jmd.isScriptExecuting()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void setSecondaryStructure(STR proteinStructureSubType, int pos, char[] secstr, char[] secstrcode) {
        switch (proteinStructureSubType) {
            case HELIX310: {
                secstr[pos] = 51;
                break;
            }
            case HELIX: 
            case HELIXALPHA: {
                secstr[pos] = 72;
                break;
            }
            case HELIXPI: {
                secstr[pos] = 80;
                break;
            }
            case SHEET: {
                secstr[pos] = 69;
                break;
            }
            default: {
                secstr[pos] = '\u0000';
            }
        }
        switch (proteinStructureSubType) {
            case HELIX310: 
            case HELIX: 
            case HELIXALPHA: 
            case HELIXPI: {
                secstrcode[pos] = 72;
                break;
            }
            case SHEET: {
                secstrcode[pos] = 69;
                break;
            }
            default: {
                secstrcode[pos] = '\u0000';
            }
        }
    }

    protected void replaceNonCanonicalResidue(String threeLetterCode, char[] seq, int pos) {
        String canonical = ResidueProperties.getCanonicalAminoAcid(threeLetterCode);
        if (canonical != null && !canonical.equalsIgnoreCase(threeLetterCode)) {
            seq[pos] = ResidueProperties.getSingleCharacterCode(canonical);
        }
    }

    @Override
    public String print(SequenceI[] seqs, boolean jvSuffix) {
        return null;
    }

    public void setCallbackFunction(String callbackType, String callbackFunction) {
    }

    public void notifyCallback(CBK cbType, Object[] data) {
        String strInfo = data == null || data[1] == null ? null : data[1].toString();
        switch (cbType) {
            case ECHO: {
                this.sendConsoleEcho(strInfo);
                break;
            }
            case SCRIPT: {
                this.notifyScriptTermination((String)data[2], (Integer)data[3]);
                break;
            }
            case MEASURE: {
                String mystatus = (String)data[3];
                if (mystatus.indexOf("Picked") >= 0 || mystatus.indexOf("Sequence") >= 0) {
                    this.sendConsoleMessage(strInfo);
                    break;
                }
                if (mystatus.indexOf("Completed") < 0) break;
                this.sendConsoleEcho(strInfo.substring(strInfo.lastIndexOf(",") + 2, strInfo.length() - 1));
                break;
            }
            case MESSAGE: {
                this.sendConsoleMessage(data == null ? null : strInfo);
                break;
            }
            case PICK: {
                this.sendConsoleMessage(strInfo);
                break;
            }
        }
    }

    private void sendConsoleEcho(String string) {
        this.lastConsoleEcho = this.lastConsoleEcho + string;
        this.lastConsoleEcho = this.lastConsoleEcho + "\n";
    }

    private void sendConsoleMessage(String string) {
        this.lastConsoleMessage = this.lastConsoleMessage + string;
        this.lastConsoleMessage = this.lastConsoleMessage + "\n";
    }

    private void notifyScriptTermination(String string, int intValue) {
        this.lastScriptMessage = this.lastScriptMessage + string;
        this.lastScriptMessage = this.lastScriptMessage + "\n";
        this.lastScriptTermination = intValue;
    }

    public boolean notifyEnabled(CBK callbackPick) {
        switch (callbackPick) {
            case ECHO: 
            case SCRIPT: 
            case MESSAGE: 
            case LOADSTRUCT: 
            case ERROR: {
                return true;
            }
        }
        return false;
    }

    public String eval(String strEval) {
        return null;
    }

    public float[][] functionXY(String functionName, int x, int y) {
        return null;
    }

    public float[][][] functionXYZ(String functionName, int nx, int ny, int nz) {
        return null;
    }

    public String createImage(String fileName, String imageType, Object text_or_bytes, int quality) {
        return null;
    }

    public Map<String, Object> getRegistryInfo() {
        return null;
    }

    public void showUrl(String url) {
    }

    public int[] resizeInnerPanel(String data) {
        return null;
    }

    public Map<String, Object> getJSpecViewProperty(String arg0) {
        return null;
    }

    public boolean isPredictSecondaryStructure() {
        return this.predictSecondaryStructure;
    }

    public void setPredictSecondaryStructure(boolean predictSecondaryStructure) {
        this.predictSecondaryStructure = predictSecondaryStructure;
    }

    public boolean isVisibleChainAnnotation() {
        return this.visibleChainAnnotation;
    }

    public void setVisibleChainAnnotation(boolean visibleChainAnnotation) {
        this.visibleChainAnnotation = visibleChainAnnotation;
    }
}

