/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.Console;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgParser;
import jalview.util.FileUtils;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BootstrapArgs {
    private Map<Arg, List<Map.Entry<Arg.Type, String>>> bootstrapArgMap = new HashMap<Arg, List<Map.Entry<Arg.Type, String>>>();
    private Set<File> argFiles = new HashSet<File>();
    private Set<Arg.Opt> argsOptions = new HashSet<Arg.Opt>();
    private Set<Arg.Type> argsTypes = new HashSet<Arg.Type>();
    private boolean outputToStdout = false;

    public static BootstrapArgs getBootstrapArgs(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        return new BootstrapArgs(argList);
    }

    public static BootstrapArgs getBootstrapArgs(List<String> args) {
        return new BootstrapArgs(args);
    }

    private BootstrapArgs(List<String> args) {
        this.parse(args, null);
    }

    /*
     * WARNING - void declaration
     */
    private void parse(List<String> args, File inArgFile) {
        if (args == null) {
            return;
        }
        if (inArgFile != null) {
            if (this.argFiles.contains(inArgFile)) {
                Console.errPrintln("Looped argfiles detected: '" + inArgFile.getPath() + "'");
                return;
            }
            this.argFiles.add(inArgFile);
        }
        for (int i = 0; i < args.size(); ++i) {
            Arg a;
            Object potentialArgName;
            Arg arg;
            int dashPos;
            String arg2 = args.get(i);
            if (!arg2.startsWith("--")) continue;
            String argName = null;
            Object val = null;
            Arg.Type type = null;
            argName = arg2.substring("--".length());
            int equalPos = argName.indexOf(61);
            if (equalPos > -1) {
                val = argName.substring(equalPos + 1);
                argName = argName.substring(0, equalPos);
            }
            if (argName.startsWith("no") && ArgParser.argMap.containsKey(argName.substring("no".length()))) {
                val = "false";
                argName = argName.substring("no".length());
            }
            if ((dashPos = argName.indexOf("-")) > -1 && (arg = ArgParser.argMap.get(potentialArgName = argName.substring(0, dashPos))) != null && arg.hasOption(Arg.Opt.HASTYPE)) {
                String typeName = argName.substring(dashPos + 1);
                try {
                    type = Arg.Type.valueOf(typeName.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException e) {
                    type = Arg.Type.INVALID;
                }
                argName = argName.substring(0, dashPos);
            }
            if (!ArgParser.argMap.containsKey(argName)) {
                potentialArgName = EnumSet.allOf(Arg.class).iterator();
                while (potentialArgName.hasNext()) {
                    Arg arg3 = (Arg)((Object)potentialArgName.next());
                    if (!arg3.hasOption(Arg.Opt.PREFIXKEV) || argName == null || !argName.startsWith(arg3.getName()) || val == null) continue;
                    val = argName.substring(arg3.getName().length()) + "=" + (String)val;
                    argName = argName.substring(0, arg3.getName().length());
                    break;
                }
            }
            if ((a = ArgParser.argMap.get(argName)) != null) {
                for (Arg.Opt opt : a.getOptions()) {
                    if (this.argsOptions.contains((Object)opt)) continue;
                    this.argsOptions.add(opt);
                }
                for (Arg.Type t : a.getTypes()) {
                    if (this.argsTypes.contains((Object)t)) continue;
                    this.argsTypes.add(t);
                }
            }
            if (a == null || !a.hasOption(Arg.Opt.BOOTSTRAP)) {
                if (a == null || !a.hasOption(Arg.Opt.OUTPUTFILE) || !a.hasOption(Arg.Opt.STDOUT)) continue;
                if (val == null && i + 1 < args.size()) {
                    val = args.get(i + 1);
                }
                if (((String)val).startsWith("[") && ((String)val).indexOf(93) > 0) {
                    val = ((String)val).substring(((String)val).indexOf(93) + 1);
                }
                if (!"-".equals(val)) continue;
                this.outputToStdout = true;
                continue;
            }
            if (a.hasOption(Arg.Opt.STRING)) {
                void var11_20;
                Object var11_16 = null;
                if (equalPos == -1) {
                    List<String> list = ArgParser.getShellGlobbedFilenameValues(a, args, i + 1);
                } else if (a.hasOption(Arg.Opt.GLOB)) {
                    List<String> list = FileUtils.getFilenamesFromGlob((String)val);
                } else {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(val);
                }
                this.addAll(a, type, (List<String>)var11_20);
                if (a != Arg.ARGFILE) continue;
                for (String filename : var11_20) {
                    File argFile = new File(filename);
                    this.parse(ArgParser.readArgFile(argFile), argFile);
                }
                continue;
            }
            if (val == null) {
                val = "true";
            }
            this.add(a, type, (String)val);
        }
        if (inArgFile != null) {
            this.argFiles.remove(inArgFile);
        }
    }

    public boolean contains(Arg a) {
        return this.bootstrapArgMap.containsKey((Object)a);
    }

    public boolean containsType(Arg.Type t) {
        for (List<Map.Entry<Arg.Type, String>> l : this.bootstrapArgMap.values()) {
            for (Map.Entry<Arg.Type, String> e : l) {
                if (e.getKey() != t) continue;
                return true;
            }
        }
        return false;
    }

    public List<Arg> getArgsOfType(Arg.Type t) {
        return this.getArgsOfType(t, new Arg.Opt[0]);
    }

    public List<Arg> getArgsOfType(Arg.Type t, Arg.Opt ... opts) {
        ArrayList<Arg> args = new ArrayList<Arg>();
        for (Arg a : this.bootstrapArgMap.keySet()) {
            List<Map.Entry<Arg.Type, String>> l;
            if (!a.hasAllOptions(opts) || !(l = this.bootstrapArgMap.get((Object)a)).stream().anyMatch(e -> e.getKey() == t)) continue;
            args.add(a);
        }
        return args;
    }

    public List<Map.Entry<Arg.Type, String>> getList(Arg a) {
        return this.bootstrapArgMap.get((Object)a);
    }

    public List<String> getValueList(Arg a) {
        return this.bootstrapArgMap.get((Object)a).stream().map(e -> (String)e.getValue()).collect(Collectors.toList());
    }

    private List<Map.Entry<Arg.Type, String>> getOrCreateList(Arg a) {
        List<Map.Entry<Arg.Type, String>> l = this.getList(a);
        if (l == null) {
            l = new ArrayList<Map.Entry<Arg.Type, String>>();
            this.putList(a, l);
        }
        return l;
    }

    private void putList(Arg a, List<Map.Entry<Arg.Type, String>> l) {
        this.bootstrapArgMap.put(a, l);
    }

    private void add(Arg a, Arg.Type t, String s) {
        List<Map.Entry<Arg.Type, String>> l = this.getOrCreateList(a);
        if (a.hasOption(Arg.Opt.MULTIVALUE) || l.size() == 0) {
            l.add(BootstrapArgs.entry(t, s));
        }
    }

    private void addAll(Arg a, Arg.Type t, List<String> al) {
        List<Map.Entry<Arg.Type, String>> l = this.getOrCreateList(a);
        if (a.hasOption(Arg.Opt.MULTIVALUE)) {
            for (String s : al) {
                l.add(BootstrapArgs.entry(t, s));
            }
        } else if (l.size() == 0 && al.size() > 0) {
            l.add(BootstrapArgs.entry(t, al.get(0)));
        }
    }

    private static Map.Entry<Arg.Type, String> entry(Arg.Type t, String s) {
        return new AbstractMap.SimpleEntry<Arg.Type, String>(t, s);
    }

    public String getValue(Arg a) {
        if (!this.bootstrapArgMap.containsKey((Object)a)) {
            return null;
        }
        List<Map.Entry<Arg.Type, String>> aL = this.bootstrapArgMap.get((Object)a);
        return aL == null || aL.size() == 0 ? null : aL.get(0).getValue();
    }

    public boolean getBoolean(Arg a, boolean d) {
        if (!this.bootstrapArgMap.containsKey((Object)a)) {
            return d;
        }
        return Boolean.parseBoolean(this.getValue(a));
    }

    public boolean getBoolean(Arg a) {
        if (!a.hasOption(Arg.Opt.BOOLEAN) && !a.hasOption(Arg.Opt.UNARY)) {
            return false;
        }
        if (this.bootstrapArgMap.containsKey((Object)a)) {
            return Boolean.parseBoolean(this.getValue(a));
        }
        return a.getDefaultBoolValue();
    }

    public boolean argsHaveOption(Arg.Opt opt) {
        return this.argsOptions.contains((Object)opt);
    }

    public boolean argsHaveType(Arg.Type type) {
        return this.argsTypes.contains((Object)type);
    }

    public boolean isHeadless() {
        boolean isHeadless = false;
        if (this.argsHaveType(Arg.Type.HELP)) {
            isHeadless = true;
        } else if (this.contains(Arg.VERSION)) {
            isHeadless = true;
        } else if (this.contains(Arg.GUI)) {
            isHeadless = !this.getBoolean(Arg.GUI);
        } else if (this.contains(Arg.HEADLESS)) {
            isHeadless = this.getBoolean(Arg.HEADLESS);
        } else if (this.argsHaveOption(Arg.Opt.OUTPUTFILE)) {
            isHeadless = true;
        }
        return isHeadless;
    }

    public boolean outputToStdout() {
        return this.outputToStdout;
    }
}

