/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.ViewStyleI;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.EmbmenuFrame;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentI;
import jalview.structure.StructureSelectionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;

public class SplitFrame
extends EmbmenuFrame {
    private static final long serialVersionUID = 1L;
    private AlignFrame topFrame;
    private AlignFrame bottomFrame;
    private Panel outermost;

    public SplitFrame(AlignFrame af1, AlignFrame af2) {
        boolean af1IsNucleotide = af1.viewport.getAlignment().isNucleotide();
        this.topFrame = af1IsNucleotide ? af1 : af2;
        this.bottomFrame = this.topFrame == af1 ? af2 : af1;
        this.init();
    }

    public void init() {
        AlignViewport cdna;
        this.constructSplit();
        AlignViewport topViewport = this.topFrame.viewport;
        AlignViewport bottomViewport = this.bottomFrame.viewport;
        AlignmentI topAlignment = topViewport.getAlignment();
        AlignmentI bottomAlignment = bottomViewport.getAlignment();
        AlignViewport alignViewport = topAlignment.isNucleotide() ? topViewport : (cdna = bottomAlignment.isNucleotide() ? bottomViewport : null);
        AlignViewport protein = !topAlignment.isNucleotide() ? topViewport : (!bottomAlignment.isNucleotide() ? bottomViewport : null);
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(topViewport.applet);
        ssm.registerMappings(protein.getAlignment().getCodonFrames());
        topViewport.setCodingComplement(bottomViewport);
        ssm.addCommandListener(cdna);
        ssm.addCommandListener(protein);
        protein.initComplementConsensus();
        AlignmentPanel ap = topAlignment.isNucleotide() ? this.bottomFrame.alignPanel : this.topFrame.alignPanel;
        protein.updateConsensus(ap);
        this.adjustLayout();
    }

    protected void constructSplit() {
        this.setMenuBar(null);
        this.outermost = new Panel(new GridLayout(2, 1));
        Panel topPanel = new Panel();
        Panel bottomPanel = new Panel();
        this.outermost.add(topPanel);
        this.outermost.add(bottomPanel);
        this.addAlignFrameComponents(this.topFrame, topPanel);
        this.addAlignFrameComponents(this.bottomFrame, bottomPanel);
    }

    protected void adjustLayout() {
        Dimension d;
        int w2;
        int w3;
        AlignViewport cdna = this.topFrame.getAlignViewport().getAlignment().isNucleotide() ? this.topFrame.viewport : this.bottomFrame.viewport;
        AlignViewport protein = cdna == this.topFrame.viewport ? this.bottomFrame.viewport : this.topFrame.viewport;
        int w1 = this.topFrame.alignPanel.idPanel.idCanvas.getWidth();
        if (w1 != (w3 = Math.max(w1, w2 = this.bottomFrame.alignPanel.idPanel.idCanvas.getWidth()))) {
            d = this.topFrame.alignPanel.idPanel.idCanvas.getSize();
            this.topFrame.alignPanel.idPanel.idCanvas.setSize(new Dimension(w3, d.height));
        }
        if (w2 != w3) {
            d = this.bottomFrame.alignPanel.idPanel.idCanvas.getSize();
            this.bottomFrame.alignPanel.idPanel.idCanvas.setSize(new Dimension(w3, d.height));
        }
        if (protein != null && cdna != null) {
            ViewStyleI vs = protein.getViewStyle();
            int scale = vs.isScaleProteinAsCdna() ? 3 : 1;
            vs.setCharWidth(scale * cdna.getViewStyle().getCharWidth());
            protein.setViewStyle(vs);
        }
    }

    private void addAlignFrameComponents(AlignFrame af, Panel panel) {
        panel.setLayout(new BorderLayout());
        Panel menuPanel = af.makeEmbeddedPopupMenu(af.getMenuBar(), true, false);
        panel.add((Component)menuPanel, "North");
        panel.add((Component)af.statusBar, "South");
        panel.add((Component)af.alignPanel, "Center");
        af.setSplitFrame(this);
    }

    public void addToDisplay(boolean embedded, JalviewLite applet) {
        this.createSplitFrameWindow(embedded, applet);
        this.validate();
        this.topFrame.alignPanel.adjustAnnotationHeight();
        this.topFrame.alignPanel.paintAlignment(true, true);
        this.bottomFrame.alignPanel.adjustAnnotationHeight();
        this.bottomFrame.alignPanel.paintAlignment(true, true);
    }

    protected void createSplitFrameWindow(boolean embed, JalviewLite applet) {
        if (embed) {
            applet.add(this.outermost);
            applet.validate();
        } else {
            this.add(this.outermost);
            int width = Math.max(this.topFrame.frameWidth, this.bottomFrame.frameWidth);
            int height = this.topFrame.frameHeight + this.bottomFrame.frameHeight;
            JalviewLite.addFrame(this, this.getTitle(), width, height);
        }
    }

    public AlignFrame getComplement(AlignFrame af) {
        if (this.topFrame == af) {
            return this.bottomFrame;
        }
        if (this.bottomFrame == af) {
            return this.topFrame;
        }
        return null;
    }
}

